/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.deploy.yarn.security;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.UndeclaredThrowableException;
import java.security.PrivilegedExceptionAction;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.spark.SparkConf;
import org.apache.spark.deploy.yarn.security.ServiceCredentialProvider;
import org.apache.spark.deploy.yarn.security.ServiceCredentialProvider$class;
import org.apache.spark.internal.Logging;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.reflect.api.JavaUniverse;
import scala.reflect.runtime.package$;
import scala.runtime.BoxedUnit;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u000154Q!\u0001\u0002\u0001\u00059\u0011a\u0003S5wK\u000e\u0013X\rZ3oi&\fG\u000e\u0015:pm&$WM\u001d\u0006\u0003\u0007\u0011\t\u0001b]3dkJLG/\u001f\u0006\u0003\u000b\u0019\tA!_1s]*\u0011q\u0001C\u0001\u0007I\u0016\u0004Hn\\=\u000b\u0005%Q\u0011!B:qCJ\\'BA\u0006\r\u0003\u0019\t\u0007/Y2iK*\tQ\"A\u0002pe\u001e\u001cB\u0001A\b\u00163A\u0011\u0001cE\u0007\u0002#)\t!#A\u0003tG\u0006d\u0017-\u0003\u0002\u0015#\t1\u0011I\\=SK\u001a\u0004\"AF\f\u000e\u0003\tI!\u0001\u0007\u0002\u00033M+'O^5dK\u000e\u0013X\rZ3oi&\fG\u000e\u0015:pm&$WM\u001d\t\u00035ui\u0011a\u0007\u0006\u00039!\t\u0001\"\u001b8uKJt\u0017\r\\\u0005\u0003=m\u0011q\u0001T8hO&tw\rC\u0003!\u0001\u0011\u0005!%\u0001\u0004=S:LGOP\u0002\u0001)\u0005\u0019\u0003C\u0001\f\u0001\u0011\u0015)\u0003\u0001\"\u0011'\u0003-\u0019XM\u001d<jG\u0016t\u0015-\\3\u0016\u0003\u001d\u0002\"\u0001K\u0016\u000f\u0005AI\u0013B\u0001\u0016\u0012\u0003\u0019\u0001&/\u001a3fM&\u0011A&\f\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005)\n\u0002\"B\u0018\u0001\t\u0013\u0001\u0014\u0001\u00035jm\u0016\u001cuN\u001c4\u0015\u0005EJ\u0004C\u0001\u001a8\u001b\u0005\u0019$B\u0001\u001b6\u0003\u0011\u0019wN\u001c4\u000b\u0005YR\u0011A\u00025bI>|\u0007/\u0003\u00029g\ti1i\u001c8gS\u001e,(/\u0019;j_:DQA\u000f\u0018A\u0002E\n!\u0002[1e_>\u00048i\u001c8g\u0011\u0015a\u0004\u0001\"\u0011>\u0003M\u0019'/\u001a3f]RL\u0017\r\\:SKF,\u0018N]3e)\tq\u0014\t\u0005\u0002\u0011\u007f%\u0011\u0001)\u0005\u0002\b\u0005>|G.Z1o\u0011\u0015Q4\b1\u00012\u0011\u0015\u0019\u0005\u0001\"\u0011E\u0003Ey'\r^1j]\u000e\u0013X\rZ3oi&\fGn\u001d\u000b\u0005\u000b.c%\u000bE\u0002\u0011\r\"K!aR\t\u0003\r=\u0003H/[8o!\t\u0001\u0012*\u0003\u0002K#\t!Aj\u001c8h\u0011\u0015Q$\t1\u00012\u0011\u0015i%\t1\u0001O\u0003%\u0019\b/\u0019:l\u0007>tg\r\u0005\u0002P!6\t\u0001\"\u0003\u0002R\u0011\tI1\u000b]1sW\u000e{gN\u001a\u0005\u0006'\n\u0003\r\u0001V\u0001\u0006GJ,Gm\u001d\t\u0003+^k\u0011A\u0016\u0006\u0003\u0007UJ!\u0001\u0017,\u0003\u0017\r\u0013X\rZ3oi&\fGn\u001d\u0005\u00065\u0002!IaW\u0001\rI>\f5OU3bYV\u001bXM]\u000b\u00039~#\"!\u00185\u0011\u0005y{F\u0002\u0001\u0003\u0006Af\u0013\r!\u0019\u0002\u0002)F\u0011!-\u001a\t\u0003!\rL!\u0001Z\t\u0003\u000f9{G\u000f[5oOB\u0011\u0001CZ\u0005\u0003OF\u00111!\u00118z\u0011\u0019I\u0017\f\"a\u0001U\u0006\u0011aM\u001c\t\u0004!-l\u0016B\u00017\u0012\u0005!a$-\u001f8b[\u0016t\u0004")
public class HiveCredentialProvider
implements ServiceCredentialProvider,
Logging {
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter);
    }

    @Override
    public String serviceName() {
        return "hive";
    }

    private Configuration hiveConf(Configuration hadoopConf) {
        Configuration configuration;
        try {
            JavaUniverse.JavaMirror mirror = package$.MODULE$.universe().runtimeMirror(Utils$.MODULE$.getContextOrSparkClassLoader());
            Class<?> hiveConfClass = mirror.classLoader().loadClass("org.apache.hadoop.hive.conf.HiveConf");
            Constructor<?> ctor = hiveConfClass.getDeclaredConstructor(Configuration.class, Object.class.getClass());
            configuration = (Configuration)ctor.newInstance(hadoopConf, hiveConfClass);
        }
        catch (Throwable throwable) {
            Configuration configuration2;
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (option.isEmpty()) {
                throw throwable;
            }
            Throwable e = (Throwable)option.get();
            this.logDebug((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Fail to create Hive Configuration";
                }
            }, e);
            configuration = configuration2 = hadoopConf;
        }
        return configuration;
    }

    @Override
    public boolean credentialsRequired(Configuration hadoopConf) {
        return UserGroupInformation.isSecurityEnabled() && new StringOps(Predef$.MODULE$.augmentString(this.hiveConf(hadoopConf).getTrimmed("hive.metastore.uris", ""))).nonEmpty();
    }

    @Override
    public Option<Object> obtainCredentials(Configuration hadoopConf, SparkConf sparkConf, Credentials creds) {
        Configuration conf = this.hiveConf(hadoopConf);
        String principalKey = "hive.metastore.kerberos.principal";
        String principal = conf.getTrimmed(principalKey, "");
        Predef$.MODULE$.require(new StringOps(Predef$.MODULE$.augmentString(principal)).nonEmpty(), (Function0)new Serializable(this, principalKey){
            public static final long serialVersionUID = 0L;
            private final String principalKey$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Hive principal ", " undefined"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.principalKey$1}));
            }
            {
                this.principalKey$1 = principalKey$1;
            }
        });
        String metastoreUri = conf.getTrimmed("hive.metastore.uris", "");
        Predef$.MODULE$.require(new StringOps(Predef$.MODULE$.augmentString(metastoreUri)).nonEmpty(), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Hive metastore uri undefined";
            }
        });
        UserGroupInformation currentUser = UserGroupInformation.getCurrentUser();
        this.logDebug((Function0<String>)new Serializable(this, principal, metastoreUri, currentUser){
            public static final long serialVersionUID = 0L;
            private final String principal$1;
            private final String metastoreUri$1;
            private final UserGroupInformation currentUser$1;

            public final String apply() {
                return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Getting Hive delegation token for ", " against "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.currentUser$1.getUserName()}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " at ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.principal$1, this.metastoreUri$1}))).toString();
            }
            {
                this.principal$1 = principal$1;
                this.metastoreUri$1 = metastoreUri$1;
                this.currentUser$1 = currentUser$1;
            }
        });
        JavaUniverse.JavaMirror mirror = package$.MODULE$.universe().runtimeMirror(Utils$.MODULE$.getContextOrSparkClassLoader());
        Class<?> hiveClass = mirror.classLoader().loadClass("org.apache.hadoop.hive.ql.metadata.Hive");
        Class<?> hiveConfClass = mirror.classLoader().loadClass("org.apache.hadoop.hive.conf.HiveConf");
        Method closeCurrent = hiveClass.getMethod("closeCurrent", new Class[0]);
        try {
            Object object;
            try {
                Method getDelegationToken = hiveClass.getMethod("getDelegationToken", String.class, String.class);
                Method getHive = hiveClass.getMethod("get", hiveConfClass);
                object = this.doAsRealUser((Function0)new Serializable(this, creds, conf, principal, currentUser, getDelegationToken, getHive){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ HiveCredentialProvider $outer;
                    private final Credentials creds$1;
                    private final Configuration conf$1;
                    private final String principal$1;
                    private final UserGroupInformation currentUser$1;
                    private final Method getDelegationToken$1;
                    private final Method getHive$1;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        Object hive = this.getHive$1.invoke(null, this.conf$1);
                        String tokenStr = (String)this.getDelegationToken$1.invoke(hive, this.currentUser$1.getUserName(), this.principal$1);
                        Token hive2Token = new Token();
                        hive2Token.decodeFromUrlString(tokenStr);
                        this.$outer.logInfo((Function0<String>)new Serializable(this, hive2Token){
                            public static final long serialVersionUID = 0L;
                            private final Token hive2Token$1;

                            public final String apply() {
                                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Get Token from hive metastore: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.hive2Token$1.toString()}));
                            }
                            {
                                this.hive2Token$1 = hive2Token$1;
                            }
                        });
                        this.creds$1.addToken(new Text("hive.server2.delegation.token"), hive2Token);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.creds$1 = creds$1;
                        this.conf$1 = conf$1;
                        this.principal$1 = principal$1;
                        this.currentUser$1 = currentUser$1;
                        this.getDelegationToken$1 = getDelegationToken$1;
                        this.getHive$1 = getHive$1;
                    }
                });
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                Option option = NonFatal$.MODULE$.unapply(throwable2);
                if (option.isEmpty()) {
                    throw throwable;
                }
                Throwable e = (Throwable)option.get();
                this.logDebug((Function0<String>)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ HiveCredentialProvider $outer;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Fail to get token from service ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.serviceName()}));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }, e);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                object = BoxedUnit.UNIT;
            }
        }
        catch (Throwable throwable) {
            Utils$.MODULE$.tryLogNonFatalError((Function0)new Serializable(this, closeCurrent){
                public static final long serialVersionUID = 0L;
                private final Method closeCurrent$1;

                public final void apply() {
                    this.apply$mcV$sp();
                }

                public void apply$mcV$sp() {
                    this.closeCurrent$1.invoke(null, new Object[0]);
                }
                {
                    this.closeCurrent$1 = closeCurrent$1;
                }
            });
            throw throwable;
        }
        Utils$.MODULE$.tryLogNonFatalError((Function0)new /* invalid duplicate definition of identical inner class */);
        return None$.MODULE$;
    }

    private <T> T doAsRealUser(Function0<T> fn) {
        UserGroupInformation currentUser = UserGroupInformation.getCurrentUser();
        UserGroupInformation realUser = (UserGroupInformation)Option$.MODULE$.apply((Object)currentUser.getRealUser()).getOrElse((Function0)new Serializable(this, currentUser){
            public static final long serialVersionUID = 0L;
            private final UserGroupInformation currentUser$2;

            public final UserGroupInformation apply() {
                return this.currentUser$2;
            }
            {
                this.currentUser$2 = currentUser$2;
            }
        });
        try {
            return (T)realUser.doAs(new PrivilegedExceptionAction<T>(this, fn){
                private final Function0 fn$1;

                public T run() {
                    return (T)this.fn$1.apply();
                }
                {
                    this.fn$1 = fn$1;
                }
            });
        }
        catch (UndeclaredThrowableException undeclaredThrowableException) {
            throw (Throwable)Option$.MODULE$.apply((Object)undeclaredThrowableException.getCause()).getOrElse((Function0)new Serializable(this, undeclaredThrowableException){
                public static final long serialVersionUID = 0L;
                private final UndeclaredThrowableException e$1;

                public final UndeclaredThrowableException apply() {
                    return this.e$1;
                }
                {
                    this.e$1 = e$1;
                }
            });
        }
    }

    public HiveCredentialProvider() {
        ServiceCredentialProvider$class.$init$(this);
        Logging.class.$init$((Logging)this);
    }
}

