/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.deploy.yarn;

import org.apache.hadoop.yarn.client.api.AMRMClient;
import org.apache.spark.SparkConf;
import org.apache.spark.deploy.yarn.FailureTracker;
import org.apache.spark.deploy.yarn.config.package$;
import org.apache.spark.internal.Logging;
import org.apache.spark.scheduler.BlacklistTracker$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function2;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.GenTraversableOnce;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.Set;
import scala.collection.mutable.HashMap;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005\u001de!B\u0001\u0003\u0001\u0019a!!H-be:\fE\u000e\\8dCR|'O\u00117bG.d\u0017n\u001d;Ue\u0006\u001c7.\u001a:\u000b\u0005\r!\u0011\u0001B=be:T!!\u0002\u0004\u0002\r\u0011,\u0007\u000f\\8z\u0015\t9\u0001\"A\u0003ta\u0006\u00148N\u0003\u0002\n\u0015\u00051\u0011\r]1dQ\u0016T\u0011aC\u0001\u0004_J<7c\u0001\u0001\u000e'A\u0011a\"E\u0007\u0002\u001f)\t\u0001#A\u0003tG\u0006d\u0017-\u0003\u0002\u0013\u001f\t1\u0011I\\=SK\u001a\u0004\"\u0001F\f\u000e\u0003UQ!A\u0006\u0004\u0002\u0011%tG/\u001a:oC2L!\u0001G\u000b\u0003\u000f1{wmZ5oO\"A!\u0004\u0001B\u0001B\u0003%A$A\u0005ta\u0006\u00148nQ8oM\u000e\u0001\u0001CA\u000f\u001f\u001b\u00051\u0011BA\u0010\u0007\u0005%\u0019\u0006/\u0019:l\u0007>tg\r\u0003\u0005\"\u0001\t\u0005\t\u0015!\u0003#\u0003!\tWn\u00117jK:$\bcA\u0012,[5\tAE\u0003\u0002&M\u0005\u0019\u0011\r]5\u000b\u0005\u001dB\u0013AB2mS\u0016tGO\u0003\u0002\u0004S)\u0011!\u0006C\u0001\u0007Q\u0006$wn\u001c9\n\u00051\"#AC!N%6\u001bE.[3oiB\u0011a\u0006\u0011\b\u0003_yr!\u0001M\u001f\u000f\u0005EbdB\u0001\u001a<\u001d\t\u0019$H\u0004\u00025s9\u0011Q\u0007O\u0007\u0002m)\u0011qgG\u0001\u0007yI|w\u000e\u001e \n\u0003-I!!\u0003\u0006\n\u0005)B\u0011BA\u0002*\u0013\t9\u0003&\u0003\u0002&M%\u0011q\bJ\u0001\u000b\u00036\u0013Vj\u00117jK:$\u0018BA!C\u0005A\u0019uN\u001c;bS:,'OU3rk\u0016\u001cHO\u0003\u0002@I!AA\t\u0001B\u0001B\u0003%Q)\u0001\bgC&dWO]3Ue\u0006\u001c7.\u001a:\u0011\u0005\u0019;U\"\u0001\u0002\n\u0005!\u0013!A\u0004$bS2,(/\u001a+sC\u000e\\WM\u001d\u0005\u0006\u0015\u0002!\taS\u0001\u0007y%t\u0017\u000e\u001e \u0015\t1kej\u0014\t\u0003\r\u0002AQAG%A\u0002qAQ!I%A\u0002\tBQ\u0001R%A\u0002\u0015Cq!\u0015\u0001C\u0002\u0013%!+\u0001\fcY\u0006\u001c7\u000e\\5tiRKW.Z8vi6KG\u000e\\5t+\u0005\u0019\u0006C\u0001\bU\u0013\t)vB\u0001\u0003M_:<\u0007BB,\u0001A\u0003%1+A\fcY\u0006\u001c7\u000e\\5tiRKW.Z8vi6KG\u000e\\5tA!9\u0011\f\u0001b\u0001\n\u0013Q\u0016A\u00067bk:\u001c\u0007N\u00117bG.d\u0017n\u001d;F]\u0006\u0014G.\u001a3\u0016\u0003m\u0003\"A\u0004/\n\u0005u{!a\u0002\"p_2,\u0017M\u001c\u0005\u0007?\u0002\u0001\u000b\u0011B.\u0002/1\fWO\\2i\u00052\f7m\u001b7jgR,e.\u00192mK\u0012\u0004\u0003bB1\u0001\u0005\u0004%IAY\u0001\u0013[\u0006Dh)Y5mkJ,7\u000fU3s\u0011>\u001cH/F\u0001d!\tqA-\u0003\u0002f\u001f\t\u0019\u0011J\u001c;\t\r\u001d\u0004\u0001\u0015!\u0003d\u0003Mi\u0017\r\u001f$bS2,(/Z:QKJDun\u001d;!\u0011\u001dI\u0007A1A\u0005\n)\f!#\u00197m_\u000e\fGo\u001c:CY\u0006\u001c7\u000e\\5tiV\t1\u000e\u0005\u0003mcN\u001cV\"A7\u000b\u00059|\u0017aB7vi\u0006\u0014G.\u001a\u0006\u0003a>\t!bY8mY\u0016\u001cG/[8o\u0013\t\u0011XNA\u0004ICNDW*\u00199\u0011\u0005Q<hB\u0001\bv\u0013\t1x\"\u0001\u0004Qe\u0016$WMZ\u0005\u0003qf\u0014aa\u0015;sS:<'B\u0001<\u0010\u0011\u0019Y\b\u0001)A\u0005W\u0006\u0019\u0012\r\u001c7pG\u0006$xN\u001d\"mC\u000e\\G.[:uA!9Q\u0010\u0001a\u0001\n\u0013q\u0018aG2veJ,g\u000e\u001e\"mC\u000e\\G.[:uK\u0012L\u0016M\u001d8O_\u0012,7/F\u0001\u0000!\u0015\t\t!a\u0002t\u001b\t\t\u0019AC\u0002\u0002\u0006=\f\u0011\"[7nkR\f'\r\\3\n\t\u0005%\u00111\u0001\u0002\u0004'\u0016$\b\"CA\u0007\u0001\u0001\u0007I\u0011BA\b\u0003}\u0019WO\u001d:f]R\u0014E.Y2lY&\u001cH/\u001a3ZCJtgj\u001c3fg~#S-\u001d\u000b\u0005\u0003#\t9\u0002E\u0002\u000f\u0003'I1!!\u0006\u0010\u0005\u0011)f.\u001b;\t\u0013\u0005e\u00111BA\u0001\u0002\u0004y\u0018a\u0001=%c!9\u0011Q\u0004\u0001!B\u0013y\u0018\u0001H2veJ,g\u000e\u001e\"mC\u000e\\G.[:uK\u0012L\u0016M\u001d8O_\u0012,7\u000f\t\u0005\t\u0003C\u0001\u0001\u0019!C\u0005}\u0006\u00112o\u00195fIVdWM\u001d\"mC\u000e\\G.[:u\u0011%\t)\u0003\u0001a\u0001\n\u0013\t9#\u0001\ftG\",G-\u001e7fe\nc\u0017mY6mSN$x\fJ3r)\u0011\t\t\"!\u000b\t\u0013\u0005e\u00111EA\u0001\u0002\u0004y\bbBA\u0017\u0001\u0001\u0006Ka`\u0001\u0014g\u000eDW\rZ;mKJ\u0014E.Y2lY&\u001cH\u000f\t\u0005\t\u0003c\u0001\u0001\u0019!C\u0005E\u0006ya.^7DYV\u001cH/\u001a:O_\u0012,7\u000fC\u0005\u00026\u0001\u0001\r\u0011\"\u0003\u00028\u0005\u0019b.^7DYV\u001cH/\u001a:O_\u0012,7o\u0018\u0013fcR!\u0011\u0011CA\u001d\u0011%\tI\"a\r\u0002\u0002\u0003\u00071\rC\u0004\u0002>\u0001\u0001\u000b\u0015B2\u0002!9,Xn\u00117vgR,'OT8eKN\u0004\u0003bBA!\u0001\u0011\u0005\u00111I\u0001\u0013g\u0016$h*^7DYV\u001cH/\u001a:O_\u0012,7\u000f\u0006\u0003\u0002\u0012\u0005\u0015\u0003bBA\u0019\u0003\u007f\u0001\ra\u0019\u0005\b\u0003\u0013\u0002A\u0011AA&\u0003}A\u0017M\u001c3mKJ+7o\\;sG\u0016\fE\u000e\\8dCRLwN\u001c$bS2,(/\u001a\u000b\u0005\u0003#\ti\u0005\u0003\u0005\u0002P\u0005\u001d\u0003\u0019AA)\u0003\u001dAwn\u001d;PaR\u0004BADA*g&\u0019\u0011QK\b\u0003\r=\u0003H/[8o\u0011\u001d\tI\u0006\u0001C\u0005\u00037\n\u0001%\u001e9eCR,\u0017\t\u001c7pG\u0006$\u0018n\u001c8CY\u0006\u001c7\u000e\\5ti\u0016$gj\u001c3fgR!\u0011\u0011CA/\u0011\u001d\ty&a\u0016A\u0002M\f\u0001\u0002[8ti:\fW.\u001a\u0005\b\u0003G\u0002A\u0011AA3\u0003q\u0019X\r^*dQ\u0016$W\u000f\\3s\u00052\f7m\u001b7jgR,GMT8eKN$B!!\u0005\u0002h!A\u0011\u0011NA1\u0001\u0004\tY'A\u0012tG\",G-\u001e7fe\nc\u0017mY6mSN$X\r\u001a(pI\u0016\u001cx+\u001b;i\u000bb\u0004\u0018N]=\u0011\tQ\fig]\u0005\u0004\u0003\u0013I\bBBA9\u0001\u0011\u0005!,\u0001\u000bjg\u0006cGNT8eK\nc\u0017mY6mSN$X\r\u001a\u0005\b\u0003k\u0002A\u0011BA<\u0003]\u0011XM\u001a:fg\"\u0014E.Y2lY&\u001cH/\u001a3O_\u0012,7\u000f\u0006\u0002\u0002\u0012!9\u00111\u0010\u0001\u0005\n\u0005u\u0014AI:z]\u000eD'o\u001c8ju\u0016\u0014E.Y2lY&\u001cH/\u001a3O_\u0012,w+\u001b;i3\u0006\u0014h\u000e\u0006\u0003\u0002\u0012\u0005}\u0004\u0002CAA\u0003s\u0002\r!a\u001b\u0002!9|G-Z:U_\nc\u0017mY6mSN$\bbBAC\u0001\u0011%\u0011qO\u0001\"e\u0016lwN^3FqBL'/\u001a3ZCJt'\t\\1dW2L7\u000f^3e\u001d>$Wm\u001d")
public class YarnAllocatorBlacklistTracker
implements Logging {
    private final AMRMClient<AMRMClient.ContainerRequest> amClient;
    private final FailureTracker failureTracker;
    private final long blacklistTimeoutMillis;
    private final boolean launchBlacklistEnabled;
    private final int maxFailuresPerHost;
    private final HashMap<String, Object> allocatorBlacklist;
    private Set<String> currentBlacklistedYarnNodes;
    private Set<String> schedulerBlacklist;
    private int numClusterNodes;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.class.initializeLogIfNecessary$default$2((Logging)this);
    }

    private long blacklistTimeoutMillis() {
        return this.blacklistTimeoutMillis;
    }

    private boolean launchBlacklistEnabled() {
        return this.launchBlacklistEnabled;
    }

    private int maxFailuresPerHost() {
        return this.maxFailuresPerHost;
    }

    private HashMap<String, Object> allocatorBlacklist() {
        return this.allocatorBlacklist;
    }

    private Set<String> currentBlacklistedYarnNodes() {
        return this.currentBlacklistedYarnNodes;
    }

    private void currentBlacklistedYarnNodes_$eq(Set<String> x$1) {
        this.currentBlacklistedYarnNodes = x$1;
    }

    private Set<String> schedulerBlacklist() {
        return this.schedulerBlacklist;
    }

    private void schedulerBlacklist_$eq(Set<String> x$1) {
        this.schedulerBlacklist = x$1;
    }

    private int numClusterNodes() {
        return this.numClusterNodes;
    }

    private void numClusterNodes_$eq(int x$1) {
        this.numClusterNodes = x$1;
    }

    public void setNumClusterNodes(int numClusterNodes) {
        this.numClusterNodes_$eq(numClusterNodes);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void handleResourceAllocationFailure(Option<String> hostOpt) {
        Option<String> option = hostOpt;
        if (option instanceof Some) {
            Some some = (Some)option;
            String hostname = (String)some.x();
            if (this.launchBlacklistEnabled()) {
                BoxedUnit boxedUnit;
                if (this.schedulerBlacklist().contains((Object)hostname) || this.allocatorBlacklist().contains((Object)hostname)) {
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    this.failureTracker.registerFailureOnHost(hostname);
                    this.updateAllocationBlacklistedNodes(hostname);
                    boxedUnit = BoxedUnit.UNIT;
                }
                BoxedUnit boxedUnit2 = boxedUnit;
                return;
            }
        }
        this.failureTracker.registerExecutorFailure();
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    private void updateAllocationBlacklistedNodes(String hostname) {
        int failuresOnHost = this.failureTracker.numFailuresOnHost(hostname);
        if (failuresOnHost > this.maxFailuresPerHost()) {
            this.logInfo((Function0<String>)new Serializable(this, hostname, failuresOnHost){
                public static final long serialVersionUID = 0L;
                private final String hostname$2;
                private final int failuresOnHost$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"blacklisting ", " as YARN allocation failed ", " times"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.hostname$2, BoxesRunTime.boxToInteger((int)this.failuresOnHost$1)}));
                }
                {
                    this.hostname$2 = hostname$2;
                    this.failuresOnHost$1 = failuresOnHost$1;
                }
            });
            this.allocatorBlacklist().put((Object)hostname, (Object)BoxesRunTime.boxToLong((long)(this.failureTracker.clock().getTimeMillis() + this.blacklistTimeoutMillis())));
            this.refreshBlacklistedNodes();
        }
    }

    public void setSchedulerBlacklistedNodes(Set<String> schedulerBlacklistedNodesWithExpiry) {
        this.schedulerBlacklist_$eq(schedulerBlacklistedNodesWithExpiry);
        this.refreshBlacklistedNodes();
    }

    public boolean isAllNodeBlacklisted() {
        return this.currentBlacklistedYarnNodes().size() >= this.numClusterNodes();
    }

    private void refreshBlacklistedNodes() {
        this.removeExpiredYarnBlacklistedNodes();
        Set allBlacklistedNodes = (Set)this.schedulerBlacklist().$plus$plus((GenTraversableOnce)this.allocatorBlacklist().keySet());
        this.synchronizeBlacklistedNodeWithYarn((Set<String>)allBlacklistedNodes);
    }

    private void synchronizeBlacklistedNodeWithYarn(Set<String> nodesToBlacklist) {
        List additions = (List)((TraversableOnce)nodesToBlacklist.$minus$minus(this.currentBlacklistedYarnNodes())).toList().sorted((Ordering)Ordering.String$.MODULE$);
        List removals = (List)((TraversableOnce)this.currentBlacklistedYarnNodes().$minus$minus(nodesToBlacklist)).toList().sorted((Ordering)Ordering.String$.MODULE$);
        if (additions.nonEmpty()) {
            this.logInfo((Function0<String>)new Serializable(this, additions){
                public static final long serialVersionUID = 0L;
                private final List additions$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"adding nodes to YARN application master's blacklist: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.additions$1}));
                }
                {
                    this.additions$1 = additions$1;
                }
            });
        }
        if (removals.nonEmpty()) {
            this.logInfo((Function0<String>)new Serializable(this, removals){
                public static final long serialVersionUID = 0L;
                private final List removals$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"removing nodes from YARN application master's blacklist: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.removals$1}));
                }
                {
                    this.removals$1 = removals$1;
                }
            });
        }
        this.amClient.updateBlacklist((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)additions).asJava(), (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)removals).asJava());
        this.currentBlacklistedYarnNodes_$eq(nodesToBlacklist);
    }

    private void removeExpiredYarnBlacklistedNodes() {
        long now = this.failureTracker.clock().getTimeMillis();
        this.allocatorBlacklist().retain((Function2)new Serializable(this, now){
            public static final long serialVersionUID = 0L;
            private final long now$1;

            public final boolean apply(String x$1, long expiryTime) {
                return expiryTime > this.now$1;
            }
            {
                this.now$1 = now$1;
            }
        });
    }

    public YarnAllocatorBlacklistTracker(SparkConf sparkConf, AMRMClient<AMRMClient.ContainerRequest> amClient, FailureTracker failureTracker) {
        this.amClient = amClient;
        this.failureTracker = failureTracker;
        Logging.class.$init$((Logging)this);
        this.blacklistTimeoutMillis = BlacklistTracker$.MODULE$.getBlacklistTimeout(sparkConf);
        this.launchBlacklistEnabled = BoxesRunTime.unboxToBoolean((Object)sparkConf.get(package$.MODULE$.YARN_EXECUTOR_LAUNCH_BLACKLIST_ENABLED()));
        this.maxFailuresPerHost = BoxesRunTime.unboxToInt((Object)sparkConf.get(org.apache.spark.internal.config.package$.MODULE$.MAX_FAILED_EXEC_PER_NODE()));
        this.allocatorBlacklist = new HashMap();
        this.currentBlacklistedYarnNodes = Predef$.MODULE$.Set().empty();
        this.schedulerBlacklist = Predef$.MODULE$.Set().empty();
        this.numClusterNodes = Integer.MAX_VALUE;
    }
}

