/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.deploy.yarn;

import java.io.Serializable;
import java.net.URI;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.yarn.api.records.LocalResource;
import org.apache.hadoop.yarn.api.records.LocalResourceType;
import org.apache.hadoop.yarn.api.records.LocalResourceVisibility;
import org.apache.hadoop.yarn.util.ConverterUtils;
import org.apache.hadoop.yarn.util.Records;
import org.apache.spark.SparkConf;
import org.apache.spark.deploy.yarn.CacheEntry;
import org.apache.spark.deploy.yarn.config.package$;
import org.apache.spark.internal.Logging;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.collection.mutable.Map;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005}d!B\u0001\u0003\u0001\u0019a!!H\"mS\u0016tG\u000fR5tiJL'-\u001e;fI\u000e\u000b7\r[3NC:\fw-\u001a:\u000b\u0005\r!\u0011\u0001B=be:T!!\u0002\u0004\u0002\r\u0011,\u0007\u000f\\8z\u0015\t9\u0001\"A\u0003ta\u0006\u00148N\u0003\u0002\n\u0015\u00051\u0011\r]1dQ\u0016T\u0011aC\u0001\u0004_J<7c\u0001\u0001\u000e'A\u0011a\"E\u0007\u0002\u001f)\t\u0001#A\u0003tG\u0006d\u0017-\u0003\u0002\u0013\u001f\t1\u0011I\\=SK\u001a\u0004\"\u0001F\f\u000e\u0003UQ!A\u0006\u0004\u0002\u0011%tG/\u001a:oC2L!\u0001G\u000b\u0003\u000f1{wmZ5oO\")!\u0004\u0001C\u00019\u00051A(\u001b8jiz\u001a\u0001\u0001F\u0001\u001e!\tq\u0002!D\u0001\u0003\u0011\u001d\u0001\u0003A1A\u0005\n\u0005\n\u0001\u0003Z5ti\u000e\u000b7\r[3F]R\u0014\u0018.Z:\u0016\u0003\t\u00022a\t\u0015+\u001b\u0005!#BA\u0013'\u0003\u001diW\u000f^1cY\u0016T!aJ\b\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0002*I\tQA*[:u\u0005V4g-\u001a:\u0011\u0005yY\u0013B\u0001\u0017\u0003\u0005)\u0019\u0015m\u00195f\u000b:$(/\u001f\u0005\u0007]\u0001\u0001\u000b\u0011\u0002\u0012\u0002#\u0011L7\u000f^\"bG\",WI\u001c;sS\u0016\u001c\b\u0005C\u00031\u0001\u0011\u0005\u0011'A\u0006bI\u0012\u0014Vm]8ve\u000e,G#\u0003\u001a6}\u0015S5\r\u001b6{!\tq1'\u0003\u00025\u001f\t!QK\\5u\u0011\u00151t\u00061\u00018\u0003\t17\u000f\u0005\u00029y5\t\u0011H\u0003\u00027u)\u00111\bC\u0001\u0007Q\u0006$wn\u001c9\n\u0005uJ$A\u0003$jY\u0016\u001c\u0016p\u001d;f[\")qh\fa\u0001\u0001\u0006!1m\u001c8g!\t\t5)D\u0001C\u0015\ty$(\u0003\u0002E\u0005\ni1i\u001c8gS\u001e,(/\u0019;j_:DQAR\u0018A\u0002\u001d\u000b\u0001\u0002Z3tiB\u000bG\u000f\u001b\t\u0003q!K!!S\u001d\u0003\tA\u000bG\u000f\u001b\u0005\u0006\u0017>\u0002\r\u0001T\u0001\u000fY>\u001c\u0017\r\u001c*fg>,(oY3t!\u0011\u0019Sj\u0014.\n\u00059##a\u0002%bg\"l\u0015\r\u001d\t\u0003!^s!!U+\u0011\u0005I{Q\"A*\u000b\u0005Q[\u0012A\u0002\u001fs_>$h(\u0003\u0002W\u001f\u00051\u0001K]3eK\u001aL!\u0001W-\u0003\rM#(/\u001b8h\u0015\t1v\u0002\u0005\u0002\\C6\tAL\u0003\u0002^=\u00069!/Z2pe\u0012\u001c(BA0a\u0003\r\t\u0007/\u001b\u0006\u0003\u0007iJ!A\u0019/\u0003\u001b1{7-\u00197SKN|WO]2f\u0011\u0015!w\u00061\u0001f\u00031\u0011Xm]8ve\u000e,G+\u001f9f!\tYf-\u0003\u0002h9\n\tBj\\2bYJ+7o\\;sG\u0016$\u0016\u0010]3\t\u000b%|\u0003\u0019A(\u0002\t1Lgn\u001b\u0005\u0006W>\u0002\r\u0001\\\u0001\ngR\fGoQ1dQ\u0016\u0004BaI7po&\u0011a\u000e\n\u0002\u0004\u001b\u0006\u0004\bC\u00019v\u001b\u0005\t(B\u0001:t\u0003\rqW\r\u001e\u0006\u0002i\u0006!!.\u0019<b\u0013\t1\u0018OA\u0002V%&\u0003\"\u0001\u000f=\n\u0005eL$A\u0003$jY\u0016\u001cF/\u0019;vg\"91p\fI\u0001\u0002\u0004a\u0018!D1qa6\u000b7\u000f^3s\u001f:d\u0017\u0010\u0005\u0002\u000f{&\u0011ap\u0004\u0002\b\u0005>|G.Z1o\u0011\u001d\t\t\u0001\u0001C\u0001\u0003\u0007\t1#\u001e9eCR,7i\u001c8gS\u001e,(/\u0019;j_:$2AMA\u0003\u0011\u0019yt\u00101\u0001\u0002\bA!\u0011\u0011BA\u0006\u001b\u00051\u0011bAA\u0007\r\tI1\u000b]1sW\u000e{gN\u001a\u0005\t\u0003#\u0001A\u0011\u0001\u0002\u0002\u0014\u0005iq-\u001a;WSNL'-\u001b7jif$\u0002\"!\u0006\u0002\u001c\u0005u\u0011\u0011\u0005\t\u00047\u0006]\u0011bAA\r9\n9Bj\\2bYJ+7o\\;sG\u00164\u0016n]5cS2LG/\u001f\u0005\u0007\u007f\u0005=\u0001\u0019\u0001!\t\u000f\u0005}\u0011q\u0002a\u0001_\u0006\u0019QO]5\t\r-\fy\u00011\u0001m\u0011\u001d\t)\u0003\u0001C\u0005\u0003O\t\u0001\"[:Qk\nd\u0017n\u0019\u000b\by\u0006%\u00121FA\u0017\u0011\u0019y\u00141\u0005a\u0001\u0001\"9\u0011qDA\u0012\u0001\u0004y\u0007BB6\u0002$\u0001\u0007A\u000eC\u0004\u00022\u0001!I!a\r\u0002?\u0005t7-Z:u_J\u001c\b*\u0019<f\u000bb,7-\u001e;f!\u0016\u0014X.[:tS>t7\u000fF\u0004}\u0003k\t9$a\u000f\t\rY\ny\u00031\u00018\u0011\u001d\tI$a\fA\u0002\u001d\u000bA\u0001]1uQ\"11.a\fA\u00021Dq!a\u0010\u0001\t\u0013\t\t%\u0001\fdQ\u0016\u001c7\u000eU3s[&\u001c8/[8o\u001f\u001a|E\u000f[3s)%a\u00181IA#\u0003\u000f\n9\u0006\u0003\u00047\u0003{\u0001\ra\u000e\u0005\b\u0003s\ti\u00041\u0001H\u0011!\tI%!\u0010A\u0002\u0005-\u0013AB1di&|g\u000e\u0005\u0003\u0002N\u0005MSBAA(\u0015\r\t\t&O\u0001\u000ba\u0016\u0014X.[:tS>t\u0017\u0002BA+\u0003\u001f\u0012\u0001BR:BGRLwN\u001c\u0005\u0007W\u0006u\u0002\u0019\u00017\t\u0011\u0005m\u0003\u0001\"\u0001\u0003\u0003;\nQbZ3u\r&dWm\u0015;biV\u001cHcB<\u0002`\u0005\u0005\u00141\r\u0005\u0007m\u0005e\u0003\u0019A\u001c\t\u000f\u0005}\u0011\u0011\fa\u0001_\"11.!\u0017A\u00021D\u0011\"a\u001a\u0001#\u0003%\t!!\u001b\u0002+\u0005$GMU3t_V\u00148-\u001a\u0013eK\u001a\fW\u000f\u001c;%qU\u0011\u00111\u000e\u0016\u0004y\u000654FAA8!\u0011\t\t(a\u001f\u000e\u0005\u0005M$\u0002BA;\u0003o\n\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005et\"\u0001\u0006b]:|G/\u0019;j_:LA!! \u0002t\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3")
public class ClientDistributedCacheManager
implements Logging {
    private final ListBuffer<CacheEntry> distCacheEntries;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private ListBuffer<CacheEntry> distCacheEntries() {
        return this.distCacheEntries;
    }

    public void addResource(FileSystem fs, Configuration conf, Path destPath, HashMap<String, LocalResource> localResources, LocalResourceType resourceType, String link, Map<URI, FileStatus> statCache, boolean appMasterOnly) {
        block0: {
            FileStatus destStatus = (FileStatus)statCache.getOrElse((Object)destPath.toUri(), (Function0 & Serializable & scala.Serializable)() -> fs.getFileStatus(destPath));
            LocalResource amJarRsrc = (LocalResource)Records.newRecord(LocalResource.class);
            amJarRsrc.setType(resourceType);
            LocalResourceVisibility visibility = this.getVisibility(conf, destPath.toUri(), statCache);
            amJarRsrc.setVisibility(visibility);
            amJarRsrc.setResource(ConverterUtils.getYarnUrlFromPath((Path)destPath));
            amJarRsrc.setTimestamp(destStatus.getModificationTime());
            amJarRsrc.setSize(destStatus.getLen());
            Predef$.MODULE$.require(link != null && new StringOps(Predef$.MODULE$.augmentString(link)).nonEmpty(), (Function0 & Serializable & scala.Serializable)() -> "You must specify a valid link name.");
            localResources.update((Object)link, (Object)amJarRsrc);
            if (appMasterOnly) break block0;
            URI uri = destPath.toUri();
            URI pathURI = new URI(uri.getScheme(), uri.getAuthority(), uri.getPath(), null, link);
            this.distCacheEntries().$plus$eq((Object)new CacheEntry(pathURI, destStatus.getLen(), destStatus.getModificationTime(), visibility, resourceType));
        }
    }

    public boolean addResource$default$8() {
        return false;
    }

    public void updateConfiguration(SparkConf conf) {
        conf.set(package$.MODULE$.CACHED_FILES(), this.distCacheEntries().map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.uri().toString(), ListBuffer$.MODULE$.canBuildFrom()));
        conf.set(package$.MODULE$.CACHED_FILES_SIZES(), this.distCacheEntries().map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToLong((long)x$2.size()), ListBuffer$.MODULE$.canBuildFrom()));
        conf.set(package$.MODULE$.CACHED_FILES_TIMESTAMPS(), this.distCacheEntries().map((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToLong((long)x$3.modTime()), ListBuffer$.MODULE$.canBuildFrom()));
        conf.set(package$.MODULE$.CACHED_FILES_VISIBILITIES(), this.distCacheEntries().map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.visibility().name(), ListBuffer$.MODULE$.canBuildFrom()));
        conf.set(package$.MODULE$.CACHED_FILES_TYPES(), this.distCacheEntries().map((Function1 & Serializable & scala.Serializable)x$5 -> x$5.resType().name(), ListBuffer$.MODULE$.canBuildFrom()));
    }

    public LocalResourceVisibility getVisibility(Configuration conf, URI uri, Map<URI, FileStatus> statCache) {
        return this.isPublic(conf, uri, statCache) ? LocalResourceVisibility.PUBLIC : LocalResourceVisibility.PRIVATE;
    }

    private boolean isPublic(Configuration conf, URI uri, Map<URI, FileStatus> statCache) {
        Path current;
        FileSystem fs = FileSystem.get((URI)uri, (Configuration)conf);
        if (!this.checkPermissionOfOther(fs, current = new Path(uri.getPath()), FsAction.READ, statCache)) {
            return false;
        }
        return this.ancestorsHaveExecutePermissions(fs, current.getParent(), statCache);
    }

    private boolean ancestorsHaveExecutePermissions(FileSystem fs, Path path, Map<URI, FileStatus> statCache) {
        for (Path current = path; current != null; current = current.getParent()) {
            if (this.checkPermissionOfOther(fs, current, FsAction.EXECUTE, statCache)) continue;
            return false;
        }
        return true;
    }

    private boolean checkPermissionOfOther(FileSystem fs, Path path, FsAction action, Map<URI, FileStatus> statCache) {
        FileStatus status = this.getFileStatus(fs, path.toUri(), statCache);
        FsPermission perms = status.getPermission();
        FsAction otherAction = perms.getOtherAction();
        return otherAction.implies(action);
    }

    public FileStatus getFileStatus(FileSystem fs, URI uri, Map<URI, FileStatus> statCache) {
        FileStatus fileStatus;
        Option option = statCache.get((Object)uri);
        if (option instanceof Some) {
            FileStatus existstat;
            Some some = (Some)option;
            fileStatus = existstat = (FileStatus)some.value();
        } else if (None$.MODULE$.equals(option)) {
            FileStatus newStat = fs.getFileStatus(new Path(uri));
            statCache.put((Object)uri, (Object)newStat);
            fileStatus = newStat;
        } else {
            throw new MatchError((Object)option);
        }
        FileStatus stat = fileStatus;
        return stat;
    }

    public ClientDistributedCacheManager() {
        Logging.$init$((Logging)this);
        this.distCacheEntries = new ListBuffer();
    }
}

