/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.deploy.yarn;

import java.io.DataOutputStream;
import java.io.File;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.DataOutputBuffer;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.yarn.api.ApplicationConstants;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ContainerLaunchContext;
import org.apache.hadoop.yarn.api.records.LocalResource;
import org.apache.hadoop.yarn.client.api.NMClient;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.ipc.YarnRPC;
import org.apache.hadoop.yarn.util.ConverterUtils;
import org.apache.hadoop.yarn.util.Records;
import org.apache.spark.SecurityManager;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkConf$;
import org.apache.spark.SparkException;
import org.apache.spark.deploy.yarn.Client$;
import org.apache.spark.deploy.yarn.YarnSparkHadoopUtil$;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.config.ConfigEntry;
import org.apache.spark.internal.config.package$;
import org.apache.spark.network.util.JavaUtils;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.JavaConverters$;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005ud!B\u0001\u0003\u0001\ta!\u0001E#yK\u000e,Ho\u001c:Sk:t\u0017M\u00197f\u0015\t\u0019A!\u0001\u0003zCJt'BA\u0003\u0007\u0003\u0019!W\r\u001d7ps*\u0011q\u0001C\u0001\u0006gB\f'o\u001b\u0006\u0003\u0013)\ta!\u00199bG\",'\"A\u0006\u0002\u0007=\u0014xmE\u0002\u0001\u001bM\u0001\"AD\t\u000e\u0003=Q\u0011\u0001E\u0001\u0006g\u000e\fG.Y\u0005\u0003%=\u0011a!\u00118z%\u00164\u0007C\u0001\u000b\u0018\u001b\u0005)\"B\u0001\f\u0007\u0003!Ig\u000e^3s]\u0006d\u0017B\u0001\r\u0016\u0005\u001daunZ4j]\u001eD\u0001B\u0007\u0001\u0003\u0002\u0003\u0006I\u0001H\u0001\nG>tG/Y5oKJ\u001c\u0001\u0001E\u0002\u000f;}I!AH\b\u0003\r=\u0003H/[8o!\t\u0001\u0003&D\u0001\"\u0015\t\u00113%A\u0004sK\u000e|'\u000fZ:\u000b\u0005\u0011*\u0013aA1qS*\u00111A\n\u0006\u0003O!\ta\u0001[1e_>\u0004\u0018BA\u0015\"\u0005%\u0019uN\u001c;bS:,'\u000f\u0003\u0005,\u0001\t\u0005\t\u0015!\u0003-\u0003\u0011\u0019wN\u001c4\u0011\u00055zS\"\u0001\u0018\u000b\u0005-*\u0013B\u0001\u0019/\u0005EI\u0016M\u001d8D_:4\u0017nZ;sCRLwN\u001c\u0005\te\u0001\u0011\t\u0011)A\u0005g\u0005I1\u000f]1sW\u000e{gN\u001a\t\u0003iUj\u0011AB\u0005\u0003m\u0019\u0011\u0011b\u00159be.\u001cuN\u001c4\t\u0011a\u0002!\u0011!Q\u0001\ne\nQ\"\\1ti\u0016\u0014\u0018\t\u001a3sKN\u001c\bC\u0001\u001eB\u001d\tYt\b\u0005\u0002=\u001f5\tQH\u0003\u0002?7\u00051AH]8pizJ!\u0001Q\b\u0002\rA\u0013X\rZ3g\u0013\t\u00115I\u0001\u0004TiJLgn\u001a\u0006\u0003\u0001>A\u0001\"\u0012\u0001\u0003\u0002\u0003\u0006I!O\u0001\u000bKb,7-\u001e;pe&#\u0007\u0002C$\u0001\u0005\u0003\u0005\u000b\u0011B\u001d\u0002\u0011!|7\u000f\u001e8b[\u0016D\u0001\"\u0013\u0001\u0003\u0002\u0003\u0006IAS\u0001\u000fKb,7-\u001e;pe6+Wn\u001c:z!\tq1*\u0003\u0002M\u001f\t\u0019\u0011J\u001c;\t\u00119\u0003!\u0011!Q\u0001\n)\u000bQ\"\u001a=fGV$xN]\"pe\u0016\u001c\b\u0002\u0003)\u0001\u0005\u0003\u0005\u000b\u0011B\u001d\u0002\u000b\u0005\u0004\b/\u00133\t\u0011I\u0003!\u0011!Q\u0001\nM\u000b1b]3dkJLG/_'heB\u0011A\u0007V\u0005\u0003+\u001a\u0011qbU3dkJLG/_'b]\u0006<WM\u001d\u0005\t/\u0002\u0011\t\u0011)A\u00051\u0006qAn\\2bYJ+7o\\;sG\u0016\u001c\b\u0003\u0002\u001eZsmK!AW\"\u0003\u00075\u000b\u0007\u000f\u0005\u0002!9&\u0011Q,\t\u0002\u000e\u0019>\u001c\u0017\r\u001c*fg>,(oY3\t\u000b}\u0003A\u0011\u00011\u0002\rqJg.\u001b;?)1\t7\rZ3gO\"L'n\u001b7n!\t\u0011\u0007!D\u0001\u0003\u0011\u0015Qb\f1\u0001\u001d\u0011\u0015Yc\f1\u0001-\u0011\u0015\u0011d\f1\u00014\u0011\u0015Ad\f1\u0001:\u0011\u0015)e\f1\u0001:\u0011\u00159e\f1\u0001:\u0011\u0015Ie\f1\u0001K\u0011\u0015qe\f1\u0001K\u0011\u0015\u0001f\f1\u0001:\u0011\u0015\u0011f\f1\u0001T\u0011\u00159f\f1\u0001Y\u0011\u001dy\u0007\u00011A\u0005\u0002A\f1A\u001d9d+\u0005\t\bC\u0001:v\u001b\u0005\u0019(B\u0001;&\u0003\rI\u0007oY\u0005\u0003mN\u0014q!W1s]J\u00036\tC\u0004y\u0001\u0001\u0007I\u0011A=\u0002\u000fI\u00048m\u0018\u0013fcR\u0011!0 \t\u0003\u001dmL!\u0001`\b\u0003\tUs\u0017\u000e\u001e\u0005\b}^\f\t\u00111\u0001r\u0003\rAH%\r\u0005\b\u0003\u0003\u0001\u0001\u0015)\u0003r\u0003\u0011\u0011\bo\u0019\u0011\t\u0017\u0005\u0015\u0001\u00011AA\u0002\u0013\u0005\u0011qA\u0001\t]6\u001cE.[3oiV\u0011\u0011\u0011\u0002\t\u0005\u0003\u0017\t\u0019\"\u0004\u0002\u0002\u000e)\u0019A%a\u0004\u000b\u0007\u0005EQ%\u0001\u0004dY&,g\u000e^\u0005\u0005\u0003+\tiA\u0001\u0005O\u001b\u000ec\u0017.\u001a8u\u0011-\tI\u0002\u0001a\u0001\u0002\u0004%\t!a\u0007\u0002\u00199l7\t\\5f]R|F%Z9\u0015\u0007i\fi\u0002C\u0005\u007f\u0003/\t\t\u00111\u0001\u0002\n!Y\u0011\u0011\u0005\u0001A\u0002\u0003\u0005\u000b\u0015BA\u0005\u0003%qWn\u00117jK:$\b\u0005C\u0004\u0002&\u0001!\t!a\n\u0002\u0007I,h\u000eF\u0001{\u0011\u001d\tY\u0003\u0001C\u0001\u0003[\ta\u0003\\1v]\u000eD7i\u001c8uKb$H)\u001a2vO&sgm\u001c\u000b\u0002s!9\u0011\u0011\u0007\u0001\u0005\u0002\u0005M\u0012AD:uCJ$8i\u001c8uC&tWM\u001d\u000b\u0003\u0003k\u0001r!a\u000e\u0002Be\n\u0019%\u0004\u0002\u0002:)!\u00111HA\u001f\u0003\u0011)H/\u001b7\u000b\u0005\u0005}\u0012\u0001\u00026bm\u0006L1AWA\u001d!\u0011\t)%a\u0013\u000e\u0005\u0005\u001d#\u0002BA%\u0003{\t1A\\5p\u0013\u0011\ti%a\u0012\u0003\u0015\tKH/\u001a\"vM\u001a,'\u000fC\u0004\u0002R\u0001!I!a\u0015\u0002\u001dA\u0014X\r]1sK\u000e{W.\\1oIR\u0011\u0011Q\u000b\t\u0006\u0003/\n\t'\u000f\b\u0005\u00033\niFD\u0002=\u00037J\u0011\u0001E\u0005\u0004\u0003?z\u0011a\u00029bG.\fw-Z\u0005\u0005\u0003G\n)G\u0001\u0003MSN$(bAA0\u001f!9\u0011\u0011\u000e\u0001\u0005\n\u0005-\u0014A\u00059sKB\f'/Z#om&\u0014xN\\7f]R$\"!!\u001c\u0011\r\u0005=\u0014\u0011P\u001d:\u001b\t\t\tH\u0003\u0003\u0002t\u0005U\u0014aB7vi\u0006\u0014G.\u001a\u0006\u0004\u0003oz\u0011AC2pY2,7\r^5p]&!\u00111PA9\u0005\u001dA\u0015m\u001d5NCB\u0004")
public class ExecutorRunnable
implements Logging {
    private final Option<Container> container;
    private final YarnConfiguration conf;
    private final SparkConf sparkConf;
    private final String masterAddress;
    private final String executorId;
    private final String hostname;
    private final int executorMemory;
    private final int executorCores;
    private final String appId;
    private final SecurityManager securityMgr;
    private final scala.collection.immutable.Map<String, LocalResource> localResources;
    private YarnRPC rpc;
    private NMClient nmClient;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public YarnRPC rpc() {
        return this.rpc;
    }

    public void rpc_$eq(YarnRPC x$1) {
        this.rpc = x$1;
    }

    public NMClient nmClient() {
        return this.nmClient;
    }

    public void nmClient_$eq(NMClient x$1) {
        this.nmClient = x$1;
    }

    public void run() {
        this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Starting Executor Container");
        this.nmClient_$eq(NMClient.createNMClient());
        this.nmClient().init((Configuration)this.conf);
        this.nmClient().start();
        this.startContainer();
    }

    public String launchContextDebugInfo() {
        List<String> commands = this.prepareCommand();
        HashMap<String, String> env = this.prepareEnvironment();
        return new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(279).append("\n    |===============================================================================\n    |YARN executor launch context:\n    |  env:\n    |").append(((TraversableOnce)Utils$.MODULE$.redact(this.sparkConf, env.toSeq()).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String k = (String)tuple2._1();
            String v = (String)tuple2._2();
            String string = new StringBuilder(9).append("    ").append(k).append(" -> ").append(v).append("\n").toString();
            return string;
        }, Seq$.MODULE$.canBuildFrom())).mkString()).append("\n    |  command:\n    |    ").append(commands.mkString(" \\ \n      ")).append("\n    |\n    |  resources:\n    |").append(((TraversableOnce)this.localResources.map((Function1 & Serializable & scala.Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String k = (String)tuple2._1();
            LocalResource v = (LocalResource)tuple2._2();
            String string = new StringBuilder(9).append("    ").append(k).append(" -> ").append(v).append("\n").toString();
            return string;
        }, Iterable$.MODULE$.canBuildFrom())).mkString()).append("\n    |===============================================================================").toString())).stripMargin();
    }

    public Map<String, ByteBuffer> startContainer() {
        Map map;
        ContainerLaunchContext ctx = (ContainerLaunchContext)Records.newRecord(ContainerLaunchContext.class);
        Map env = (Map)JavaConverters$.MODULE$.mutableMapAsJavaMapConverter(this.prepareEnvironment()).asJava();
        ctx.setLocalResources((Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(this.localResources).asJava());
        ctx.setEnvironment(env);
        Credentials credentials = UserGroupInformation.getCurrentUser().getCredentials();
        DataOutputBuffer dob = new DataOutputBuffer();
        credentials.writeTokenStorageToStream((DataOutputStream)dob);
        ctx.setTokens(ByteBuffer.wrap(dob.getData()));
        List<String> commands = this.prepareCommand();
        ctx.setCommands((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(commands).asJava());
        ctx.setApplicationACLs((Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(YarnSparkHadoopUtil$.MODULE$.getApplicationAclsForYarn(this.securityMgr)).asJava());
        if (BoxesRunTime.unboxToBoolean((Object)this.sparkConf.get(package$.MODULE$.SHUFFLE_SERVICE_ENABLED()))) {
            String secretString = this.securityMgr.getSecretKey();
            ByteBuffer secretBytes = secretString != null ? JavaUtils.stringToBytes((String)secretString) : ByteBuffer.allocate(0);
            ctx.setServiceData(Collections.singletonMap("spark_shuffle", secretBytes));
        }
        try {
            map = this.nmClient().startContainer((Container)this.container.get(), ctx);
        }
        catch (Exception ex) {
            throw new SparkException(new StringBuilder(35).append("Exception while starting container ").append(((Container)this.container.get()).getId()).append(new StringBuilder(9).append(" on host ").append(this.hostname).toString()).toString(), (Throwable)ex);
        }
        return map;
    }

    private List<String> prepareCommand() {
        ListBuffer javaOpts = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        String executorMemoryString = new StringBuilder(1).append(this.executorMemory).append("m").toString();
        javaOpts.$plus$eq((Object)new StringBuilder(4).append("-Xmx").append(executorMemoryString).toString());
        ((Option)this.sparkConf.get((ConfigEntry)package$.MODULE$.EXECUTOR_JAVA_OPTIONS())).foreach((Function1 & Serializable & scala.Serializable)opts -> {
            String subsOpt = Utils$.MODULE$.substituteAppNExecIds(opts, $this.appId, $this.executorId);
            return javaOpts.$plus$plus$eq((TraversableOnce)Utils$.MODULE$.splitCommandString(subsOpt).map((Function1 & Serializable & scala.Serializable)arg -> YarnSparkHadoopUtil$.MODULE$.escapeForShell((String)arg), Seq$.MODULE$.canBuildFrom()));
        });
        Option prefixEnv = ((Option)this.sparkConf.get((ConfigEntry)package$.MODULE$.EXECUTOR_LIBRARY_PATH())).map((Function1 & Serializable & scala.Serializable)libPath -> Client$.MODULE$.createLibraryPathPrefix((String)libPath, $this.sparkConf));
        javaOpts.$plus$eq((Object)new StringBuilder(17).append("-Djava.io.tmpdir=").append(new Path(ApplicationConstants.Environment.PWD.$$(), "./tmp")).toString());
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.sparkConf.getAll())).filter((Function1 & Serializable & scala.Serializable)x0$3 -> BoxesRunTime.boxToBoolean((boolean)ExecutorRunnable.$anonfun$prepareCommand$4(x0$3))))).foreach((Function1 & Serializable & scala.Serializable)x0$4 -> {
            Tuple2 tuple2 = x0$4;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String k = (String)tuple2._1();
            String v = (String)tuple2._2();
            ListBuffer listBuffer = javaOpts.$plus$eq((Object)YarnSparkHadoopUtil$.MODULE$.escapeForShell(new StringBuilder(3).append("-D").append(k).append("=").append(v).toString()));
            return listBuffer;
        });
        javaOpts.$plus$eq((Object)"-Dspark.yarn.app.container.log.dir=<LOG_DIR>");
        Seq userClassPath = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])Client$.MODULE$.getUserClasspath(this.sparkConf))).flatMap((Function1 & Serializable & scala.Serializable)uri -> {
            String absPath = new File(uri.getPath()).isAbsolute() ? Client$.MODULE$.getClusterPath($this.sparkConf, uri.getPath()) : Client$.MODULE$.buildPath((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{ApplicationConstants.Environment.PWD.$(), uri.getPath()}));
            return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--user-class-path", new StringBuilder(5).append("file:").append(absPath).toString()}));
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).toSeq();
        YarnSparkHadoopUtil$.MODULE$.addOutOfMemoryErrorArgument((ListBuffer<String>)javaOpts);
        Iterable commands = (Iterable)((TraversableLike)((TraversableLike)((TraversableLike)((TraversableLike)Option$.MODULE$.option2Iterable(prefixEnv).$plus$plus((GenTraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder(9).append(ApplicationConstants.Environment.JAVA_HOME.$$()).append("/bin/java").toString(), "-server"})), scala.collection.Iterable$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)javaOpts, scala.collection.Iterable$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"org.apache.spark.executor.CoarseGrainedExecutorBackend", "--driver-url", this.masterAddress, "--executor-id", this.executorId, "--hostname", this.hostname, "--cores", ((Object)BoxesRunTime.boxToInteger((int)this.executorCores)).toString(), "--app-id", this.appId})), scala.collection.Iterable$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)userClassPath, scala.collection.Iterable$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder(18).append("1>").append("<LOG_DIR>").append("/stdout").toString(), new StringBuilder(18).append("2>").append("<LOG_DIR>").append("/stderr").toString()})), scala.collection.Iterable$.MODULE$.canBuildFrom());
        return ((TraversableOnce)commands.map((Function1 & Serializable & scala.Serializable)s -> s == null ? "null" : s, scala.collection.Iterable$.MODULE$.canBuildFrom())).toList();
    }

    /*
     * WARNING - void declaration
     */
    private HashMap<String, String> prepareEnvironment() {
        void var1_1;
        String yarnHttpPolicy;
        HashMap env = new HashMap();
        Client$.MODULE$.populateClasspath(null, (Configuration)this.conf, this.sparkConf, (HashMap<String, String>)env, (Option<String>)((Option)this.sparkConf.get((ConfigEntry)package$.MODULE$.EXECUTOR_CLASS_PATH())));
        String string = yarnHttpPolicy = this.conf.get("yarn.http.policy", YarnConfiguration.YARN_HTTP_POLICY_DEFAULT);
        String string2 = "HTTPS_ONLY";
        String httpScheme = !(string != null ? !string.equals(string2) : string2 != null) ? "https://" : "http://";
        ((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(System.getenv()).asScala()).filterKeys((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.startsWith("SPARK"))).foreach((Function1 & Serializable & scala.Serializable)x0$5 -> {
            ExecutorRunnable.$anonfun$prepareEnvironment$2(env, x0$5);
            return BoxedUnit.UNIT;
        });
        this.sparkConf.getExecutorEnv().foreach((Function1 & Serializable & scala.Serializable)x0$6 -> {
            ExecutorRunnable.$anonfun$prepareEnvironment$3(env, x0$6);
            return BoxedUnit.UNIT;
        });
        this.container.foreach((Function1 & Serializable & scala.Serializable)c -> {
            ExecutorRunnable.$anonfun$prepareEnvironment$4(env, httpScheme, c);
            return BoxedUnit.UNIT;
        });
        return var1_1;
    }

    public static final /* synthetic */ boolean $anonfun$prepareCommand$4(Tuple2 x0$3) {
        Tuple2 tuple2 = x0$3;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String k = (String)tuple2._1();
        boolean bl = SparkConf$.MODULE$.isExecutorStartupConf(k);
        return bl;
    }

    public static final /* synthetic */ void $anonfun$prepareEnvironment$2(HashMap env$1, Tuple2 x0$5) {
        Tuple2 tuple2 = x0$5;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String k = (String)tuple2._1();
        String v = (String)tuple2._2();
        env$1.update((Object)k, (Object)v);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$prepareEnvironment$3(HashMap env$1, Tuple2 x0$6) {
        BoxedUnit boxedUnit;
        Tuple2 tuple2 = x0$6;
        if (tuple2 != null) {
            String key = (String)tuple2._1();
            String value = (String)tuple2._2();
            String string = key;
            String string2 = ApplicationConstants.Environment.CLASSPATH.name();
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                YarnSparkHadoopUtil$.MODULE$.addPathToEnvironment((HashMap<String, String>)env$1, key, value);
                boxedUnit = BoxedUnit.UNIT;
            } else {
                env$1.update((Object)key, (Object)value);
                boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            throw new MatchError((Object)tuple2);
        }
        BoxedUnit boxedUnit2 = boxedUnit;
    }

    public static final /* synthetic */ void $anonfun$prepareEnvironment$5(HashMap env$1, String httpScheme$1, Container c$1, String user) {
        String containerId = ConverterUtils.toString((ContainerId)c$1.getId());
        String address = c$1.getNodeHttpAddress();
        String baseUrl = new StringBuilder(21).append(httpScheme$1).append(address).append("/node/containerlogs/").append(containerId).append("/").append(user).toString();
        env$1.update((Object)"SPARK_LOG_URL_STDERR", (Object)new StringBuilder(19).append(baseUrl).append("/stderr?start=-4096").toString());
        env$1.update((Object)"SPARK_LOG_URL_STDOUT", (Object)new StringBuilder(19).append(baseUrl).append("/stdout?start=-4096").toString());
    }

    public static final /* synthetic */ void $anonfun$prepareEnvironment$4(HashMap env$1, String httpScheme$1, Container c) {
        scala.sys.package$.MODULE$.env().get((Object)"SPARK_USER").foreach((Function1 & Serializable & scala.Serializable)user -> {
            ExecutorRunnable.$anonfun$prepareEnvironment$5(env$1, httpScheme$1, c, user);
            return BoxedUnit.UNIT;
        });
    }

    public ExecutorRunnable(Option<Container> container, YarnConfiguration conf, SparkConf sparkConf, String masterAddress, String executorId, String hostname, int executorMemory, int executorCores, String appId, SecurityManager securityMgr, scala.collection.immutable.Map<String, LocalResource> localResources) {
        this.container = container;
        this.conf = conf;
        this.sparkConf = sparkConf;
        this.masterAddress = masterAddress;
        this.executorId = executorId;
        this.hostname = hostname;
        this.executorMemory = executorMemory;
        this.executorCores = executorCores;
        this.appId = appId;
        this.securityMgr = securityMgr;
        this.localResources = localResources;
        Logging.$init$((Logging)this);
        this.rpc = YarnRPC.create((Configuration)conf);
    }
}

