/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.deploy.yarn;

import java.io.Serializable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.client.api.AMRMClient;
import org.apache.spark.SparkConf;
import org.apache.spark.deploy.yarn.ContainerLocalityPreferences;
import org.apache.spark.deploy.yarn.SparkRackResolver;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.Map$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashMap$;
import scala.collection.mutable.Set;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.RichDouble$;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u0005ec!B\u0001\u0003\u0001\ta!a\u000b'pG\u0006d\u0017\u000e^=Qe\u00164WM\u001d:fI\u000e{g\u000e^1j]\u0016\u0014\b\u000b\\1dK6,g\u000e^*ue\u0006$XmZ=\u000b\u0005\r!\u0011\u0001B=be:T!!\u0002\u0004\u0002\r\u0011,\u0007\u000f\\8z\u0015\t9\u0001\"A\u0003ta\u0006\u00148N\u0003\u0002\n\u0015\u00051\u0011\r]1dQ\u0016T\u0011aC\u0001\u0004_J<7C\u0001\u0001\u000e!\tq\u0011#D\u0001\u0010\u0015\u0005\u0001\u0012!B:dC2\f\u0017B\u0001\n\u0010\u0005\u0019\te.\u001f*fM\"AA\u0003\u0001BC\u0002\u0013\u0005a#A\u0005ta\u0006\u00148nQ8oM\u000e\u0001Q#A\f\u0011\u0005aIR\"\u0001\u0004\n\u0005i1!!C*qCJ\\7i\u001c8g\u0011!a\u0002A!A!\u0002\u00139\u0012AC:qCJ\\7i\u001c8gA!Aa\u0004\u0001BC\u0002\u0013\u0005q$\u0001\u0005zCJt7i\u001c8g+\u0005\u0001\u0003CA\u0011'\u001b\u0005\u0011#BA\u0012%\u0003\u0011\u0019wN\u001c4\u000b\u0005\u0015B\u0011A\u00025bI>|\u0007/\u0003\u0002(E\ti1i\u001c8gS\u001e,(/\u0019;j_:D\u0001\"\u000b\u0001\u0003\u0002\u0003\u0006I\u0001I\u0001\ns\u0006\u0014hnQ8oM\u0002B\u0001b\u000b\u0001\u0003\u0006\u0004%\t\u0001L\u0001\te\u0016\u001cx.\u001e:dKV\tQ\u0006\u0005\u0002/i5\tqF\u0003\u00021c\u00059!/Z2pe\u0012\u001c(B\u0001\u001a4\u0003\r\t\u0007/\u001b\u0006\u0003\u0007\u0011J!!N\u0018\u0003\u0011I+7o\\;sG\u0016D\u0001b\u000e\u0001\u0003\u0002\u0003\u0006I!L\u0001\ne\u0016\u001cx.\u001e:dK\u0002B\u0001\"\u000f\u0001\u0003\u0002\u0003\u0006IAO\u0001\te\u0016\u001cx\u000e\u001c<feB\u00111\bP\u0007\u0002\u0005%\u0011QH\u0001\u0002\u0012'B\f'o\u001b*bG.\u0014Vm]8mm\u0016\u0014\b\"B \u0001\t\u0003\u0001\u0015A\u0002\u001fj]&$h\bF\u0003B\u0005\u000e#U\t\u0005\u0002<\u0001!)AC\u0010a\u0001/!)aD\u0010a\u0001A!)1F\u0010a\u0001[!)\u0011H\u0010a\u0001u!)q\t\u0001C\u0001\u0011\u0006iBn\\2bY&$\u0018p\u00144SKF,Xm\u001d;fI\u000e{g\u000e^1j]\u0016\u00148\u000f\u0006\u0004J\u001fR3fM\u001e\t\u0004\u001d)c\u0015BA&\u0010\u0005\u0015\t%O]1z!\tYT*\u0003\u0002O\u0005\ta2i\u001c8uC&tWM\u001d'pG\u0006d\u0017\u000e^=Qe\u00164WM]3oG\u0016\u001c\b\"\u0002)G\u0001\u0004\t\u0016\u0001\u00048v[\u000e{g\u000e^1j]\u0016\u0014\bC\u0001\bS\u0013\t\u0019vBA\u0002J]RDQ!\u0016$A\u0002E\u000bQC\\;n\u0019>\u001c\u0017\r\\5us\u0006;\u0018M]3UCN\\7\u000fC\u0003X\r\u0002\u0007\u0001,\u0001\u000bi_N$Hk\u001c'pG\u0006dG+Y:l\u0007>,h\u000e\u001e\t\u00053\u0002\u001c\u0017K\u0004\u0002[=B\u00111lD\u0007\u00029*\u0011Q,F\u0001\u0007yI|w\u000e\u001e \n\u0005}{\u0011A\u0002)sK\u0012,g-\u0003\u0002bE\n\u0019Q*\u00199\u000b\u0005}{\u0001CA-e\u0013\t)'M\u0001\u0004TiJLgn\u001a\u0005\u0006O\u001a\u0003\r\u0001[\u0001\u001dC2dwnY1uK\u0012Dun\u001d;U_\u000e{g\u000e^1j]\u0016\u00148/T1q!\u0011Ign\u00199\u000e\u0003)T!a\u001b7\u0002\u000f5,H/\u00192mK*\u0011QnD\u0001\u000bG>dG.Z2uS>t\u0017BA8k\u0005\u001dA\u0015m\u001d5NCB\u00042![9t\u0013\t\u0011(NA\u0002TKR\u0004\"A\f;\n\u0005U|#aC\"p]R\f\u0017N\\3s\u0013\u0012DQa\u001e$A\u0002a\f\u0011\u0005\\8dC2LG/_'bi\u000eDW\r\u001a)f]\u0012LgnZ!mY>\u001c\u0017\r^5p]N\u0004B!\u001f@\u0002\u00049\u0011!\u0010 \b\u00037nL\u0011\u0001E\u0005\u0003{>\tq\u0001]1dW\u0006<W-C\u0002\u0000\u0003\u0003\u00111aU3r\u0015\tix\u0002\u0005\u0003\u0002\u0006\u0005%b\u0002BA\u0004\u0003GqA!!\u0003\u0002 9!\u00111BA\u000e\u001d\u0011\ti!!\u0007\u000f\t\u0005=\u0011q\u0003\b\u0005\u0003#\t)BD\u0002\\\u0003'I\u0011aC\u0005\u0003\u0013)I!!\n\u0005\n\u0005\r!\u0013bAA\u000fg\u000511\r\\5f]RL1AMA\u0011\u0015\r\tibM\u0005\u0005\u0003K\t9#\u0001\u0006B\u001bJk5\t\\5f]RT1AMA\u0011\u0013\u0011\tY#!\f\u0003!\r{g\u000e^1j]\u0016\u0014(+Z9vKN$(\u0002BA\u0013\u0003OAq!!\r\u0001\t\u0013\t\u0019$A\nok6,\u00050Z2vi>\u00148\u000fU3oI&tw\rF\u0002R\u0003kAq!a\u000e\u00020\u0001\u0007\u0011+A\bok6$\u0016m]6t!\u0016tG-\u001b8h\u0011\u001d\tY\u0004\u0001C\u0005\u0003{\tA$\u001a=qK\u000e$X\r\u001a%pgR$vnQ8oi\u0006Lg.\u001a:D_VtG\u000fF\u0005Y\u0003\u007f\t\u0019%!\u0012\u0002H!9\u0011\u0011IA\u001d\u0001\u0004\t\u0016A\u00057pG\u0006d\u0017\u000e^=Bo\u0006\u0014X\rV1tWNDaaVA\u001d\u0001\u0004A\u0006BB4\u0002:\u0001\u0007\u0001\u000e\u0003\u0004x\u0003s\u0001\r\u0001\u001f\u0005\b\u0003\u0017\u0002A\u0011BA'\u0003m\u0001XM\u001c3j]\u001eDun\u001d;U_\u000e{g\u000e^1j]\u0016\u00148i\\;oiR!\u0011qJA,!\u0015I\u0006mYA)!\rq\u00111K\u0005\u0004\u0003+z!A\u0002#pk\ndW\r\u0003\u0004x\u0003\u0013\u0002\r\u0001\u001f")
public class LocalityPreferredContainerPlacementStrategy {
    private final SparkConf sparkConf;
    private final Configuration yarnConf;
    private final Resource resource;
    private final SparkRackResolver resolver;

    public SparkConf sparkConf() {
        return this.sparkConf;
    }

    public Configuration yarnConf() {
        return this.yarnConf;
    }

    public Resource resource() {
        return this.resource;
    }

    public ContainerLocalityPreferences[] localityOfRequestedContainers(int numContainer, int numLocalityAwareTasks, Map<String, Object> hostToLocalTaskCount, HashMap<String, Set<ContainerId>> allocatedHostToContainersMap, Seq<AMRMClient.ContainerRequest> localityMatchedPendingAllocations) {
        ArrayBuffer containerLocalityPreferences;
        block1: {
            Map<String, Object> updatedHostToContainerCount = this.expectedHostToContainerCount(numLocalityAwareTasks, hostToLocalTaskCount, allocatedHostToContainersMap, localityMatchedPendingAllocations);
            int updatedLocalityAwareContainerNum = BoxesRunTime.unboxToInt((Object)updatedHostToContainerCount.values().sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
            int requiredLocalityFreeContainerNum = package$.MODULE$.max(0, numContainer - updatedLocalityAwareContainerNum);
            int requiredLocalityAwareContainerNum = numContainer - requiredLocalityFreeContainerNum;
            containerLocalityPreferences = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
            if (requiredLocalityFreeContainerNum > 0) {
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), requiredLocalityFreeContainerNum).foreach((Function1 & Serializable & scala.Serializable)i -> containerLocalityPreferences.$plus$eq((Object)new ContainerLocalityPreferences(null, null)));
            }
            if (requiredLocalityAwareContainerNum <= 0) break block1;
            int largestRatio = BoxesRunTime.unboxToInt((Object)updatedHostToContainerCount.values().max((Ordering)Ordering.Int$.MODULE$));
            ObjectRef preferredLocalityRatio = ObjectRef.create((Object)((Map)updatedHostToContainerCount.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                String k = (String)tuple2._1();
                int ratio = tuple2._2$mcI$sp();
                double adjustedRatio = (double)ratio * (double)requiredLocalityAwareContainerNum / (double)largestRatio;
                Tuple2 tuple22 = new Tuple2((Object)k, (Object)BoxesRunTime.boxToInteger((int)((int)RichDouble$.MODULE$.ceil$extension(Predef$.MODULE$.doubleWrapper(adjustedRatio)))));
                return tuple22;
            }, Map$.MODULE$.canBuildFrom())));
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), requiredLocalityAwareContainerNum).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                String[] hosts = (String[])((MapLike)((Map)preferredLocalityRatio$1.elem).filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)LocalityPreferredContainerPlacementStrategy.$anonfun$localityOfRequestedContainers$4(x$1)))).keys().toArray(ClassTag$.MODULE$.apply(String.class));
                scala.collection.immutable.Set racks = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])hosts)).map((Function1 & Serializable & scala.Serializable)h -> $this.resolver.resolve(this.yarnConf(), (String)h), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).toSet();
                containerLocalityPreferences.$plus$eq((Object)new ContainerLocalityPreferences(hosts, (String[])racks.toArray(ClassTag$.MODULE$.apply(String.class))));
                preferredLocalityRatio$1.elem = (Map)((Map)preferredLocalityRatio$1.elem).map((Function1 & Serializable & scala.Serializable)x0$2 -> {
                    Tuple2 tuple2 = x0$2;
                    if (tuple2 == null) {
                        throw new MatchError((Object)tuple2);
                    }
                    String k = (String)tuple2._1();
                    int v = tuple2._2$mcI$sp();
                    Tuple2 tuple22 = new Tuple2((Object)k, (Object)BoxesRunTime.boxToInteger((int)(v - 1)));
                    return tuple22;
                }, Map$.MODULE$.canBuildFrom());
            });
        }
        return (ContainerLocalityPreferences[])containerLocalityPreferences.toArray(ClassTag$.MODULE$.apply(ContainerLocalityPreferences.class));
    }

    private int numExecutorsPending(int numTasksPending) {
        int coresPerExecutor = this.resource().getVirtualCores();
        return (numTasksPending * BoxesRunTime.unboxToInt((Object)this.sparkConf().get(org.apache.spark.internal.config.package$.MODULE$.CPUS_PER_TASK())) + coresPerExecutor - 1) / coresPerExecutor;
    }

    private Map<String, Object> expectedHostToContainerCount(int localityAwareTasks, Map<String, Object> hostToLocalTaskCount, HashMap<String, Set<ContainerId>> allocatedHostToContainersMap, Seq<AMRMClient.ContainerRequest> localityMatchedPendingAllocations) {
        int totalLocalTaskNum = BoxesRunTime.unboxToInt((Object)hostToLocalTaskCount.values().sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        Map<String, Object> pendingHostToContainersMap = this.pendingHostToContainerCount(localityMatchedPendingAllocations);
        return (Map)hostToLocalTaskCount.map((Function1 & Serializable & scala.Serializable)x0$3 -> {
            Tuple2 tuple2 = x0$3;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String host = (String)tuple2._1();
            int count = tuple2._2$mcI$sp();
            double expectedCount = (double)count * (double)this.numExecutorsPending(localityAwareTasks) / (double)totalLocalTaskNum;
            double existedCount = (double)BoxesRunTime.unboxToInt((Object)allocatedHostToContainersMap.get((Object)host).map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToInteger((int)x$2.size())).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 0)) + BoxesRunTime.unboxToDouble((Object)pendingHostToContainersMap.getOrElse((Object)host, (Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> 0.0));
            Tuple2 tuple22 = new Tuple2((Object)host, (Object)BoxesRunTime.boxToInteger((int)package$.MODULE$.max(0, (int)RichDouble$.MODULE$.ceil$extension(Predef$.MODULE$.doubleWrapper(expectedCount - existedCount)))));
            return tuple22;
        }, Map$.MODULE$.canBuildFrom());
    }

    private Map<String, Object> pendingHostToContainerCount(Seq<AMRMClient.ContainerRequest> localityMatchedPendingAllocations) {
        HashMap pendingHostToContainerCount = new HashMap();
        localityMatchedPendingAllocations.foreach((Function1 & Serializable & scala.Serializable)cr -> {
            LocalityPreferredContainerPlacementStrategy.$anonfun$pendingHostToContainerCount$1(pendingHostToContainerCount, cr);
            return BoxedUnit.UNIT;
        });
        int possibleTotalContainerNum = BoxesRunTime.unboxToInt((Object)pendingHostToContainerCount.values().sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        double localityMatchedPendingNum = localityMatchedPendingAllocations.size();
        return ((TraversableOnce)pendingHostToContainerCount.map((Function1 & Serializable & scala.Serializable)x0$4 -> {
            Tuple2 tuple2 = x0$4;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String k = (String)tuple2._1();
            int v = tuple2._2$mcI$sp();
            Tuple2 tuple22 = new Tuple2((Object)k, (Object)BoxesRunTime.boxToDouble((double)((double)v * localityMatchedPendingNum / (double)possibleTotalContainerNum)));
            return tuple22;
        }, HashMap$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    public static final /* synthetic */ boolean $anonfun$localityOfRequestedContainers$4(Tuple2 x$1) {
        return x$1._2$mcI$sp() > 0;
    }

    public static final /* synthetic */ void $anonfun$pendingHostToContainerCount$2(HashMap pendingHostToContainerCount$1, String n) {
        int count = BoxesRunTime.unboxToInt((Object)pendingHostToContainerCount$1.getOrElse((Object)n, (Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 0)) + 1;
        pendingHostToContainerCount$1.update((Object)n, (Object)BoxesRunTime.boxToInteger((int)count));
    }

    public static final /* synthetic */ void $anonfun$pendingHostToContainerCount$1(HashMap pendingHostToContainerCount$1, AMRMClient.ContainerRequest cr) {
        ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(cr.getNodes()).asScala()).foreach((Function1 & Serializable & scala.Serializable)n -> {
            LocalityPreferredContainerPlacementStrategy.$anonfun$pendingHostToContainerCount$2(pendingHostToContainerCount$1, n);
            return BoxedUnit.UNIT;
        });
    }

    public LocalityPreferredContainerPlacementStrategy(SparkConf sparkConf, Configuration yarnConf, Resource resource, SparkRackResolver resolver) {
        this.sparkConf = sparkConf;
        this.yarnConf = yarnConf;
        this.resource = resource;
        this.resolver = resolver;
    }
}

