/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.deploy.yarn;

import java.io.Serializable;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.FinalApplicationStatus;
import org.apache.hadoop.yarn.api.records.LocalResource;
import org.apache.hadoop.yarn.client.api.AMRMClient;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.webapp.util.WebAppUtils;
import org.apache.spark.SecurityManager;
import org.apache.spark.SparkConf;
import org.apache.spark.deploy.yarn.SparkRackResolver;
import org.apache.spark.deploy.yarn.YarnAllocator;
import org.apache.spark.deploy.yarn.YarnAllocator$;
import org.apache.spark.deploy.yarn.YarnSparkHadoopUtil$;
import org.apache.spark.deploy.yarn.config.package$;
import org.apache.spark.internal.Logging;
import org.apache.spark.rpc.RpcEndpointRef;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u0005}f!B\u0001\u0003\u0001\u0019a!\u0001D-be:\u0014Vj\u00117jK:$(BA\u0002\u0005\u0003\u0011I\u0018M\u001d8\u000b\u0005\u00151\u0011A\u00023fa2|\u0017P\u0003\u0002\b\u0011\u0005)1\u000f]1sW*\u0011\u0011BC\u0001\u0007CB\f7\r[3\u000b\u0003-\t1a\u001c:h'\r\u0001Qb\u0005\t\u0003\u001dEi\u0011a\u0004\u0006\u0002!\u0005)1oY1mC&\u0011!c\u0004\u0002\u0007\u0003:L(+\u001a4\u0011\u0005Q9R\"A\u000b\u000b\u0005Y1\u0011\u0001C5oi\u0016\u0014h.\u00197\n\u0005a)\"a\u0002'pO\u001eLgn\u001a\u0005\u00065\u0001!\t\u0001H\u0001\u0007y%t\u0017\u000e\u001e \u0004\u0001Q\tQ\u0004\u0005\u0002\u001f\u00015\t!\u0001C\u0005!\u0001\u0001\u0007\t\u0019!C\u0005C\u0005A\u0011-\\\"mS\u0016tG/F\u0001#!\r\u00193&L\u0007\u0002I)\u0011QEJ\u0001\u0004CBL'BA\u0014)\u0003\u0019\u0019G.[3oi*\u00111!\u000b\u0006\u0003U!\ta\u0001[1e_>\u0004\u0018B\u0001\u0017%\u0005)\tUJU'DY&,g\u000e\u001e\t\u0003]\u0001s!a\f \u000f\u0005AjdBA\u0019=\u001d\t\u00114H\u0004\u00024u9\u0011A'\u000f\b\u0003kaj\u0011A\u000e\u0006\u0003om\ta\u0001\u0010:p_Rt\u0014\"A\u0006\n\u0005%Q\u0011B\u0001\u0016\t\u0013\t\u0019\u0011&\u0003\u0002(Q%\u0011QEJ\u0005\u0003\u007f\u0011\n!\"Q'S\u001b\u000ec\u0017.\u001a8u\u0013\t\t%I\u0001\tD_:$\u0018-\u001b8feJ+\u0017/^3ti*\u0011q\b\n\u0005\n\t\u0002\u0001\r\u00111A\u0005\n\u0015\u000bA\"Y7DY&,g\u000e^0%KF$\"AR%\u0011\u000599\u0015B\u0001%\u0010\u0005\u0011)f.\u001b;\t\u000f)\u001b\u0015\u0011!a\u0001E\u0005\u0019\u0001\u0010J\u0019\t\u00131\u0003\u0001\u0019!A!B\u0013\u0011\u0013!C1n\u00072LWM\u001c;!\u0011%q\u0005\u00011AA\u0002\u0013%q*\u0001\tvS\"K7\u000f^8ss\u0006#GM]3tgV\t\u0001\u000b\u0005\u0002R+:\u0011!k\u0015\t\u0003k=I!\u0001V\b\u0002\rA\u0013X\rZ3g\u0013\t1vK\u0001\u0004TiJLgn\u001a\u0006\u0003)>A\u0011\"\u0017\u0001A\u0002\u0003\u0007I\u0011\u0002.\u0002)UL\u0007*[:u_JL\u0018\t\u001a3sKN\u001cx\fJ3r)\t15\fC\u0004K1\u0006\u0005\t\u0019\u0001)\t\u0013u\u0003\u0001\u0019!A!B\u0013\u0001\u0016!E;j\u0011&\u001cHo\u001c:z\u0003\u0012$'/Z:tA!9q\f\u0001a\u0001\n\u0013\u0001\u0017A\u0003:fO&\u001cH/\u001a:fIV\t\u0011\r\u0005\u0002\u000fE&\u00111m\u0004\u0002\b\u0005>|G.Z1o\u0011\u001d)\u0007\u00011A\u0005\n\u0019\faB]3hSN$XM]3e?\u0012*\u0017\u000f\u0006\u0002GO\"9!\nZA\u0001\u0002\u0004\t\u0007BB5\u0001A\u0003&\u0011-A\u0006sK\u001eL7\u000f^3sK\u0012\u0004\u0003\"B6\u0001\t\u0003a\u0017\u0001\u0003:fO&\u001cH/\u001a:\u0015\u0013\u0019kw\u000e^>\u0002\u0004\u00055\u0001\"\u00028k\u0001\u0004\u0001\u0016A\u00033sSZ,'\u000fS8ti\")\u0001O\u001ba\u0001c\u0006QAM]5wKJ\u0004vN\u001d;\u0011\u00059\u0011\u0018BA:\u0010\u0005\rIe\u000e\u001e\u0005\u0006k*\u0004\rA^\u0001\u0005G>tg\r\u0005\u0002xs6\t\u0001P\u0003\u0002vQ%\u0011!\u0010\u001f\u0002\u00123\u0006\u0014hnQ8oM&<WO]1uS>t\u0007\"\u0002?k\u0001\u0004i\u0018!C:qCJ\\7i\u001c8g!\tqx0D\u0001\u0007\u0013\r\t\tA\u0002\u0002\n'B\f'o[\"p]\u001aDq!!\u0002k\u0001\u0004\t9!A\u0005vS\u0006#GM]3tgB!a\"!\u0003Q\u0013\r\tYa\u0004\u0002\u0007\u001fB$\u0018n\u001c8\t\u000b9S\u0007\u0019\u0001)\t\u000f\u0005E\u0001\u0001\"\u0001\u0002\u0014\u0005y1M]3bi\u0016\fE\u000e\\8dCR|'\u000f\u0006\b\u0002\u0016\u0005m\u0011QDA\u0010\u0003G\t\u0019$!\u0010\u0011\u0007y\t9\"C\u0002\u0002\u001a\t\u0011Q\"W1s]\u0006cGn\\2bi>\u0014\bBB;\u0002\u0010\u0001\u0007a\u000f\u0003\u0004}\u0003\u001f\u0001\r! \u0005\b\u0003C\ty\u00011\u0001Q\u0003%!'/\u001b<feV\u0013H\u000e\u0003\u0005\u0002&\u0005=\u0001\u0019AA\u0014\u0003%!'/\u001b<feJ+g\r\u0005\u0003\u0002*\u0005=RBAA\u0016\u0015\r\tiCB\u0001\u0004eB\u001c\u0017\u0002BA\u0019\u0003W\u0011aB\u00159d\u000b:$\u0007o\\5oiJ+g\r\u0003\u0005\u00026\u0005=\u0001\u0019AA\u001c\u0003-\u0019XmY;sSRLXj\u001a:\u0011\u0007y\fI$C\u0002\u0002<\u0019\u0011qbU3dkJLG/_'b]\u0006<WM\u001d\u0005\t\u0003\u007f\ty\u00011\u0001\u0002B\u0005qAn\\2bYJ+7o\\;sG\u0016\u001c\bCB)\u0002DA\u000b9%C\u0002\u0002F]\u00131!T1q!\u0011\tI%!\u0015\u000e\u0005\u0005-#\u0002BA'\u0003\u001f\nqA]3d_J$7O\u0003\u0002&Q%!\u00111KA&\u00055aunY1m%\u0016\u001cx.\u001e:dK\"9\u0011q\u000b\u0001\u0005\u0002\u0005e\u0013AC;oe\u0016<\u0017n\u001d;feR)a)a\u0017\u0002f!A\u0011QLA+\u0001\u0004\ty&\u0001\u0004ti\u0006$Xo\u001d\t\u0005\u0003\u0013\n\t'\u0003\u0003\u0002d\u0005-#A\u0006$j]\u0006d\u0017\t\u001d9mS\u000e\fG/[8o'R\fG/^:\t\u0013\u0005\u001d\u0014Q\u000bI\u0001\u0002\u0004\u0001\u0016a\u00033jC\u001etwn\u001d;jGNDq!a\u001b\u0001\t\u0003\ti'\u0001\u0007hKR\fE\u000f^3naRLE\r\u0006\u0002\u0002pA!\u0011\u0011JA9\u0013\u0011\t\u0019(a\u0013\u0003)\u0005\u0003\b\u000f\\5dCRLwN\\!ui\u0016l\u0007\u000f^%e\u0011\u001d\t9\b\u0001C\u0001\u0003s\n1cZ3u\u00036L\u0005OR5mi\u0016\u0014\b+\u0019:b[N$b!a\u001f\u0002~\u0005}\u0004#B)\u0002DA\u0003\u0006BB;\u0002v\u0001\u0007a\u000fC\u0004\u0002\u0002\u0006U\u0004\u0019\u0001)\u0002\u0013A\u0014x\u000e_=CCN,\u0007bBAC\u0001\u0011\u0005\u0011qQ\u0001\u0012O\u0016$X*\u0019=SK\u001e\fE\u000f^3naR\u001cH#B9\u0002\n\u0006-\u0005B\u0002?\u0002\u0004\u0002\u0007Q\u0010C\u0004\u0002\u000e\u0006\r\u0005\u0019\u0001<\u0002\u0011e\f'O\\\"p]\u001aDq!!%\u0001\t\u0013\t\u0019*\u0001\u0007hKR,&\u000f\u001c\"z%6LE\rF\u0003Q\u0003+\u000b\t\u000bC\u0004v\u0003\u001f\u0003\r!a&\u0011\t\u0005e\u0015QT\u0007\u0003\u00037S!!^\u0015\n\t\u0005}\u00151\u0014\u0002\u000e\u0007>tg-[4ve\u0006$\u0018n\u001c8\t\u000f\u0005\r\u0016q\u0012a\u0001!\u0006!!/\\%e\u0011%\t9\u000bAI\u0001\n\u0003\tI+\u0001\u000bv]J,w-[:uKJ$C-\u001a4bk2$HEM\u000b\u0003\u0003WS3\u0001UAWW\t\ty\u000b\u0005\u0003\u00022\u0006mVBAAZ\u0015\u0011\t),a.\u0002\u0013Ut7\r[3dW\u0016$'bAA]\u001f\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005u\u00161\u0017\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0007")
public class YarnRMClient
implements Logging {
    private AMRMClient<AMRMClient.ContainerRequest> amClient;
    private String uiHistoryAddress;
    private boolean registered;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private AMRMClient<AMRMClient.ContainerRequest> amClient() {
        return this.amClient;
    }

    private void amClient_$eq(AMRMClient<AMRMClient.ContainerRequest> x$1) {
        this.amClient = x$1;
    }

    private String uiHistoryAddress() {
        return this.uiHistoryAddress;
    }

    private void uiHistoryAddress_$eq(String x$1) {
        this.uiHistoryAddress = x$1;
    }

    private boolean registered() {
        return this.registered;
    }

    private void registered_$eq(boolean x$1) {
        this.registered = x$1;
    }

    public void register(String driverHost, int driverPort, YarnConfiguration conf, SparkConf sparkConf, Option<String> uiAddress, String uiHistoryAddress) {
        this.amClient_$eq((AMRMClient<AMRMClient.ContainerRequest>)AMRMClient.createAMRMClient());
        this.amClient().init((Configuration)conf);
        this.amClient().start();
        this.uiHistoryAddress_$eq(uiHistoryAddress);
        String trackingUrl = (String)uiAddress.getOrElse((Function0 & Serializable & scala.Serializable)() -> BoxesRunTime.unboxToBoolean((Object)sparkConf.get(package$.MODULE$.ALLOW_HISTORY_SERVER_TRACKING_URL())) ? uiHistoryAddress : "");
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Registering the ApplicationMaster");
        YarnRMClient yarnRMClient = this;
        synchronized (yarnRMClient) {
            this.amClient().registerApplicationMaster(driverHost, driverPort, trackingUrl);
            this.registered_$eq(true);
        }
    }

    public YarnAllocator createAllocator(YarnConfiguration conf, SparkConf sparkConf, String driverUrl, RpcEndpointRef driverRef, SecurityManager securityMgr, Map<String, LocalResource> localResources) {
        Predef$.MODULE$.require(this.registered(), (Function0 & Serializable & scala.Serializable)() -> "Must register AM before creating allocator.");
        return new YarnAllocator(driverUrl, driverRef, conf, sparkConf, this.amClient(), this.getAttemptId(), securityMgr, localResources, new SparkRackResolver(), YarnAllocator$.MODULE$.$lessinit$greater$default$10());
    }

    public synchronized void unregister(FinalApplicationStatus status, String diagnostics) {
        block1: {
            if (this.registered()) {
                this.amClient().unregisterApplicationMaster(status, diagnostics, this.uiHistoryAddress());
            }
            if (this.amClient() == null) break block1;
            this.amClient().stop();
        }
    }

    public String unregister$default$2() {
        return "";
    }

    public ApplicationAttemptId getAttemptId() {
        return YarnSparkHadoopUtil$.MODULE$.getContainerId().getApplicationAttemptId();
    }

    public Map<String, String> getAmIpFilterParams(YarnConfiguration conf, String proxyBase) {
        String prefix = WebAppUtils.getHttpSchemePrefix((Configuration)conf);
        List proxies = WebAppUtils.getProxyHostsAndPortsForAmFilter((Configuration)conf);
        Buffer hosts = (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(proxies).asScala()).map((Function1 & Serializable & scala.Serializable)x$1 -> (String)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])x$1.split(":"))).head(), Buffer$.MODULE$.canBuildFrom());
        Buffer uriBases = (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(proxies).asScala()).map((Function1 & Serializable & scala.Serializable)proxy -> new StringBuilder(0).append(prefix).append((String)proxy).append(proxyBase).toString(), Buffer$.MODULE$.canBuildFrom());
        Map params = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"PROXY_HOSTS"), (Object)hosts.mkString(",")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"PROXY_URI_BASES"), (Object)uriBases.mkString(","))}));
        Iterable rmIds = (Iterable)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(conf.getStringCollection("yarn.resourcemanager.ha.rm-ids")).asScala();
        return rmIds != null && rmIds.nonEmpty() ? params.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"RM_HA_URLS"), (Object)((TraversableOnce)rmIds.map((Function1 & Serializable & scala.Serializable)x$2 -> this.getUrlByRmId((Configuration)conf, (String)x$2), Iterable$.MODULE$.canBuildFrom())).mkString(","))) : params;
    }

    public int getMaxRegAttempts(SparkConf sparkConf, YarnConfiguration yarnConf) {
        int n;
        Option sparkMaxAttempts = ((Option)sparkConf.get(package$.MODULE$.MAX_APP_ATTEMPTS())).map((Function1)(JFunction1.mcII.sp & Serializable & scala.Serializable)x$3 -> x$3);
        int yarnMaxAttempts = yarnConf.getInt("yarn.resourcemanager.am.max-attempts", 2);
        Option option = sparkMaxAttempts;
        if (option instanceof Some) {
            Some some = (Some)option;
            int x = BoxesRunTime.unboxToInt((Object)some.value());
            n = x <= yarnMaxAttempts ? x : yarnMaxAttempts;
        } else if (None$.MODULE$.equals(option)) {
            n = yarnMaxAttempts;
        } else {
            throw new MatchError((Object)option);
        }
        return n;
    }

    private String getUrlByRmId(Configuration conf, String rmId) {
        String string;
        String addressPropertyPrefix;
        String string2 = addressPropertyPrefix = YarnConfiguration.useHttps((Configuration)conf) ? "yarn.resourcemanager.webapp.https.address" : "yarn.resourcemanager.webapp.address";
        if (rmId == null || rmId.isEmpty()) {
            string = addressPropertyPrefix;
        } else {
            if (rmId.startsWith(".")) {
                throw new IllegalStateException(new StringBuilder(44).append("rmId ").append(rmId).append(" should not already have '.' prepended.").toString());
            }
            string = new StringBuilder(1).append(addressPropertyPrefix).append(".").append(rmId).toString();
        }
        String addressWithRmId = string;
        return conf.get(addressWithRmId);
    }

    public YarnRMClient() {
        Logging.$init$((Logging)this);
        this.registered = false;
    }
}

