/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.deploy.yarn.security;

import java.io.Serializable;
import java.security.PrivilegedExceptionAction;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.spark.SparkConf;
import org.apache.spark.deploy.SparkHadoopUtil$;
import org.apache.spark.deploy.yarn.config.package$;
import org.apache.spark.deploy.yarn.security.YARNHadoopDelegationTokenManager;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.config.ConfigEntry;
import org.apache.spark.rpc.RpcEndpointRef;
import org.apache.spark.scheduler.cluster.CoarseGrainedClusterMessages;
import org.apache.spark.ui.UIUtils$;
import org.apache.spark.util.ThreadUtils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Option;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005=c!B\u0001\u0003\u0001\u0011q!aE!N\u0007J,G-\u001a8uS\u0006d'+\u001a8fo\u0016\u0014(BA\u0002\u0005\u0003!\u0019XmY;sSRL(BA\u0003\u0007\u0003\u0011I\u0018M\u001d8\u000b\u0005\u001dA\u0011A\u00023fa2|\u0017P\u0003\u0002\n\u0015\u0005)1\u000f]1sW*\u00111\u0002D\u0001\u0007CB\f7\r[3\u000b\u00035\t1a\u001c:h'\r\u0001q\"\u0006\t\u0003!Mi\u0011!\u0005\u0006\u0002%\u0005)1oY1mC&\u0011A#\u0005\u0002\u0007\u0003:L(+\u001a4\u0011\u0005YIR\"A\f\u000b\u0005aA\u0011\u0001C5oi\u0016\u0014h.\u00197\n\u0005i9\"a\u0002'pO\u001eLgn\u001a\u0005\t9\u0001\u0011\t\u0011)A\u0005=\u0005I1\u000f]1sW\u000e{gNZ\u0002\u0001!\ty\u0002%D\u0001\t\u0013\t\t\u0003BA\u0005Ta\u0006\u00148nQ8oM\"A1\u0005\u0001B\u0001B\u0003%A%\u0001\u0006iC\u0012|w\u000e]\"p]\u001a\u0004\"!\n\u0016\u000e\u0003\u0019R!a\n\u0015\u0002\t\r|gN\u001a\u0006\u0003S)\ta\u0001[1e_>\u0004\u0018BA\u0016'\u00055\u0019uN\u001c4jOV\u0014\u0018\r^5p]\")Q\u0006\u0001C\u0001]\u00051A(\u001b8jiz\"2aL\u00193!\t\u0001\u0004!D\u0001\u0003\u0011\u0015aB\u00061\u0001\u001f\u0011\u0015\u0019C\u00061\u0001%\u0011\u001d!\u0004A1A\u0005\nU\n\u0011\u0002\u001d:j]\u000eL\u0007/\u00197\u0016\u0003Y\u0002\"a\u000e \u000f\u0005ab\u0004CA\u001d\u0012\u001b\u0005Q$BA\u001e\u001e\u0003\u0019a$o\\8u}%\u0011Q(E\u0001\u0007!J,G-\u001a4\n\u0005}\u0002%AB*ue&twM\u0003\u0002>#!1!\t\u0001Q\u0001\nY\n!\u0002\u001d:j]\u000eL\u0007/\u00197!\u0011\u001d!\u0005A1A\u0005\nU\naa[3zi\u0006\u0014\u0007B\u0002$\u0001A\u0003%a'A\u0004lKf$\u0018M\u0019\u0011\t\u000f!\u0003!\u0019!C\u0005\u0013\u0006\t2M]3eK:$\u0018.\u00197NC:\fw-\u001a:\u0016\u0003)\u0003\"\u0001M&\n\u00051\u0013!\u0001I-B%:C\u0015\rZ8pa\u0012+G.Z4bi&|g\u000eV8lK:l\u0015M\\1hKJDaA\u0014\u0001!\u0002\u0013Q\u0015AE2sK\u0012,g\u000e^5bY6\u000bg.Y4fe\u0002Bq\u0001\u0015\u0001C\u0002\u0013%\u0011+A\bsK:,w/\u00197Fq\u0016\u001cW\u000f^8s+\u0005\u0011\u0006CA*[\u001b\u0005!&BA+W\u0003)\u0019wN\\2veJ,g\u000e\u001e\u0006\u0003/b\u000bA!\u001e;jY*\t\u0011,\u0001\u0003kCZ\f\u0017BA.U\u0005a\u00196\r[3ek2,G-\u0012=fGV$xN]*feZL7-\u001a\u0005\u0007;\u0002\u0001\u000b\u0011\u0002*\u0002!I,g.Z<bY\u0016CXmY;u_J\u0004\u0003bB0\u0001\u0005\u0004%I\u0001Y\u0001\nIJLg/\u001a:SK\u001a,\u0012!\u0019\t\u0004E\u0016<W\"A2\u000b\u0005\u0011$\u0016AB1u_6L7-\u0003\u0002gG\ny\u0011\t^8nS\u000e\u0014VMZ3sK:\u001cW\r\u0005\u0002iW6\t\u0011N\u0003\u0002k\u0011\u0005\u0019!\u000f]2\n\u00051L'A\u0004*qG\u0016sG\r]8j]R\u0014VM\u001a\u0005\u0007]\u0002\u0001\u000b\u0011B1\u0002\u0015\u0011\u0014\u0018N^3s%\u00164\u0007\u0005C\u0004q\u0001\t\u0007I\u0011B9\u0002\u0017I,g.Z<bYR\u000b7o[\u000b\u0002eJ\u00191o^?\u0007\tQ,\bA\u001d\u0002\ryI,g-\u001b8f[\u0016tGO\u0010\u0005\u0007m\u0002\u0001\u000b\u0011\u0002:\u0002\u0019I,g.Z<bYR\u000b7o\u001b\u0011\u0011\u0005a\\X\"A=\u000b\u0005iD\u0016\u0001\u00027b]\u001eL!\u0001`=\u0003\r=\u0013'.Z2u!\tAh0\u0003\u0002\u0000s\nA!+\u001e8oC\ndW\rC\u0004\u0002\u0004\u0001!\t!!\u0002\u0002\u0019M,G\u000f\u0012:jm\u0016\u0014(+\u001a4\u0015\t\u0005\u001d\u0011Q\u0002\t\u0004!\u0005%\u0011bAA\u0006#\t!QK\\5u\u0011\u001d\ty!!\u0001A\u0002\u001d\f1A]3g\u0011\u001d\t\u0019\u0002\u0001C\u0001\u0003+\tQa\u001d;beR$\"!a\u0006\u0011\t\u0005e\u0011QD\u0007\u0003\u00037Q!a\u0001\u0015\n\t\u0005}\u00111\u0004\u0002\u0015+N,'o\u0012:pkBLeNZ8s[\u0006$\u0018n\u001c8\t\u000f\u0005\r\u0002\u0001\"\u0001\u0002&\u0005!1\u000f^8q)\t\t9\u0001C\u0004\u0002*\u0001!I!a\u000b\u0002\u001fM\u001c\u0007.\u001a3vY\u0016\u0014VM\\3xC2$B!a\u0002\u0002.!A\u0011qFA\u0014\u0001\u0004\t\t$A\u0003eK2\f\u0017\u0010E\u0002\u0011\u0003gI1!!\u000e\u0012\u0005\u0011auN\\4\t\u000f\u0005e\u0002\u0001\"\u0003\u0002&\u0005\u0001R\u000f\u001d3bi\u0016$vn[3ogR\u000b7o\u001b\u0005\b\u0003{\u0001A\u0011BA \u0003yy'\r^1j]R{7.\u001a8t\u0003:$7k\u00195fIVdWMU3oK^\fG\u000e\u0006\u0003\u0002B\u0005\u001d\u0003\u0003BA\r\u0003\u0007JA!!\u0012\u0002\u001c\tY1I]3eK:$\u0018.\u00197t\u0011!\tI%a\u000fA\u0002\u0005]\u0011aA;hS\"9\u0011Q\n\u0001\u0005\n\u0005U\u0011a\u00023p\u0019><\u0017N\u001c")
public class AMCredentialRenewer
implements Logging {
    public final SparkConf org$apache$spark$deploy$yarn$security$AMCredentialRenewer$$sparkConf;
    public final Configuration org$apache$spark$deploy$yarn$security$AMCredentialRenewer$$hadoopConf;
    private final String principal;
    private final String keytab;
    private final YARNHadoopDelegationTokenManager org$apache$spark$deploy$yarn$security$AMCredentialRenewer$$credentialManager;
    private final ScheduledExecutorService renewalExecutor;
    private final AtomicReference<RpcEndpointRef> driverRef;
    private final Runnable renewalTask;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private String principal() {
        return this.principal;
    }

    private String keytab() {
        return this.keytab;
    }

    public YARNHadoopDelegationTokenManager org$apache$spark$deploy$yarn$security$AMCredentialRenewer$$credentialManager() {
        return this.org$apache$spark$deploy$yarn$security$AMCredentialRenewer$$credentialManager;
    }

    private ScheduledExecutorService renewalExecutor() {
        return this.renewalExecutor;
    }

    private AtomicReference<RpcEndpointRef> driverRef() {
        return this.driverRef;
    }

    private Runnable renewalTask() {
        return this.renewalTask;
    }

    public void setDriverRef(RpcEndpointRef ref) {
        this.driverRef().set(ref);
    }

    /*
     * WARNING - void declaration
     */
    public UserGroupInformation start() {
        void var2_2;
        Credentials originalCreds = UserGroupInformation.getCurrentUser().getCredentials();
        UserGroupInformation ugi = this.doLogin();
        Runnable tgtRenewalTask = new Runnable(null, ugi){
            private final UserGroupInformation ugi$1;

            public void run() {
                this.ugi$1.checkTGTAndReloginFromKeytab();
            }
            {
                this.ugi$1 = ugi$1;
            }
        };
        long tgtRenewalPeriod = BoxesRunTime.unboxToLong((Object)this.org$apache$spark$deploy$yarn$security$AMCredentialRenewer$$sparkConf.get(package$.MODULE$.KERBEROS_RELOGIN_PERIOD()));
        this.renewalExecutor().scheduleAtFixedRate(tgtRenewalTask, tgtRenewalPeriod, tgtRenewalPeriod, TimeUnit.SECONDS);
        Credentials creds = this.obtainTokensAndScheduleRenewal(ugi);
        ugi.addCredentials(creds);
        Credentials existing = ugi.getCredentials();
        existing.mergeAll(originalCreds);
        ugi.addCredentials(existing);
        return var2_2;
    }

    public void stop() {
        this.renewalExecutor().shutdown();
    }

    public void org$apache$spark$deploy$yarn$security$AMCredentialRenewer$$scheduleRenewal(long delay) {
        long _delay = scala.math.package$.MODULE$.max(0L, delay);
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(33).append("Scheduling login from keytab in ").append(UIUtils$.MODULE$.formatDuration(delay)).append(".").toString());
        this.renewalExecutor().schedule(this.renewalTask(), _delay, TimeUnit.MILLISECONDS);
    }

    public void org$apache$spark$deploy$yarn$security$AMCredentialRenewer$$updateTokensTask() {
        block3: {
            try {
                UserGroupInformation freshUGI = this.doLogin();
                Credentials creds = this.obtainTokensAndScheduleRenewal(freshUGI);
                byte[] tokens = SparkHadoopUtil$.MODULE$.get().serialize(creds);
                RpcEndpointRef driver = this.driverRef().get();
                if (driver != null) {
                    this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Updating delegation tokens.");
                    driver.send((Object)new CoarseGrainedClusterMessages.UpdateDelegationTokens(tokens));
                    break block3;
                }
                this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Delegation tokens close to expiration but no driver has registered yet.");
                SparkHadoopUtil$.MODULE$.get().addDelegationTokens(tokens, this.org$apache$spark$deploy$yarn$security$AMCredentialRenewer$$sparkConf);
            }
            catch (Exception e) {
                long delay = TimeUnit.SECONDS.toMillis(BoxesRunTime.unboxToLong((Object)this.org$apache$spark$deploy$yarn$security$AMCredentialRenewer$$sparkConf.get(org.apache.spark.internal.config.package$.MODULE$.CREDENTIALS_RENEWAL_RETRY_WAIT())));
                this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(87).append("Failed to update tokens, will try again in ").append(UIUtils$.MODULE$.formatDuration(delay)).append("!").append(" If this happens too often tasks will fail.").toString(), e);
                this.org$apache$spark$deploy$yarn$security$AMCredentialRenewer$$scheduleRenewal(delay);
            }
        }
    }

    private Credentials obtainTokensAndScheduleRenewal(UserGroupInformation ugi) {
        return (Credentials)ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Credentials>(this){
            private final /* synthetic */ AMCredentialRenewer $outer;

            /*
             * WARNING - void declaration
             */
            public Credentials run() {
                void var1_1;
                Credentials creds = new Credentials();
                long nextRenewal = this.$outer.org$apache$spark$deploy$yarn$security$AMCredentialRenewer$$credentialManager().obtainDelegationTokens(this.$outer.org$apache$spark$deploy$yarn$security$AMCredentialRenewer$$hadoopConf, creds);
                long timeToWait = SparkHadoopUtil$.MODULE$.nextCredentialRenewalTime(nextRenewal, this.$outer.org$apache$spark$deploy$yarn$security$AMCredentialRenewer$$sparkConf) - System.currentTimeMillis();
                this.$outer.org$apache$spark$deploy$yarn$security$AMCredentialRenewer$$scheduleRenewal(timeToWait);
                return var1_1;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    private UserGroupInformation doLogin() {
        void var1_1;
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(44).append("Attempting to login to KDC using principal: ").append(this.principal()).toString());
        UserGroupInformation ugi = UserGroupInformation.loginUserFromKeytabAndReturnUGI((String)this.principal(), (String)this.keytab());
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Successfully logged into KDC.");
        return var1_1;
    }

    public AMCredentialRenewer(SparkConf sparkConf, Configuration hadoopConf) {
        this.org$apache$spark$deploy$yarn$security$AMCredentialRenewer$$sparkConf = sparkConf;
        this.org$apache$spark$deploy$yarn$security$AMCredentialRenewer$$hadoopConf = hadoopConf;
        Logging.$init$((Logging)this);
        this.principal = (String)((Option)sparkConf.get((ConfigEntry)org.apache.spark.internal.config.package$.MODULE$.PRINCIPAL())).get();
        this.keytab = (String)((Option)sparkConf.get((ConfigEntry)org.apache.spark.internal.config.package$.MODULE$.KEYTAB())).get();
        this.org$apache$spark$deploy$yarn$security$AMCredentialRenewer$$credentialManager = new YARNHadoopDelegationTokenManager(sparkConf, hadoopConf);
        this.renewalExecutor = ThreadUtils$.MODULE$.newDaemonSingleThreadScheduledExecutor("Credential Refresh Thread");
        this.driverRef = new AtomicReference();
        this.renewalTask = new Runnable(this){
            private final /* synthetic */ AMCredentialRenewer $outer;

            public void run() {
                this.$outer.org$apache$spark$deploy$yarn$security$AMCredentialRenewer$$updateTokensTask();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        };
    }
}

