/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.scheduler.cluster;

import java.io.Serializable;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.spark.SparkContext;
import org.apache.spark.deploy.yarn.config.package$;
import org.apache.spark.internal.Logging;
import org.apache.spark.scheduler.cluster.SchedulerExtensionService;
import org.apache.spark.scheduler.cluster.SchedulerExtensionServiceBinding;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001a4Q!\u0001\u0002\u0001\r1\u0011!dU2iK\u0012,H.\u001a:FqR,gn]5p]N+'O^5dKNT!a\u0001\u0003\u0002\u000f\rdWo\u001d;fe*\u0011QAB\u0001\ng\u000eDW\rZ;mKJT!a\u0002\u0005\u0002\u000bM\u0004\u0018M]6\u000b\u0005%Q\u0011AB1qC\u000eDWMC\u0001\f\u0003\ry'oZ\n\u0005\u00015\u0019r\u0003\u0005\u0002\u000f#5\tqBC\u0001\u0011\u0003\u0015\u00198-\u00197b\u0013\t\u0011rB\u0001\u0004B]f\u0014VM\u001a\t\u0003)Ui\u0011AA\u0005\u0003-\t\u0011\u0011dU2iK\u0012,H.\u001a:FqR,gn]5p]N+'O^5dKB\u0011\u0001dG\u0007\u00023)\u0011!DB\u0001\tS:$XM\u001d8bY&\u0011A$\u0007\u0002\b\u0019><w-\u001b8h\u0011\u0015q\u0002\u0001\"\u0001!\u0003\u0019a\u0014N\\5u}\r\u0001A#A\u0011\u0011\u0005Q\u0001\u0001bB\u0012\u0001\u0001\u0004%I\u0001J\u0001\u000eg\u0016\u0014h/[2f\u001fB$\u0018n\u001c8\u0016\u0003\u0015\u00022A\u0004\u0014)\u0013\t9sB\u0001\u0004PaRLwN\u001c\t\u0003SAr!A\u000b\u0018\u0011\u0005-zQ\"\u0001\u0017\u000b\u00055z\u0012A\u0002\u001fs_>$h(\u0003\u00020\u001f\u00051\u0001K]3eK\u001aL!!\r\u001a\u0003\rM#(/\u001b8h\u0015\tys\u0002C\u00045\u0001\u0001\u0007I\u0011B\u001b\u0002#M,'O^5dK>\u0003H/[8o?\u0012*\u0017\u000f\u0006\u00027sA\u0011abN\u0005\u0003q=\u0011A!\u00168ji\"9!hMA\u0001\u0002\u0004)\u0013a\u0001=%c!1A\b\u0001Q!\n\u0015\nab]3sm&\u001cWm\u00149uS>t\u0007\u0005C\u0004?\u0001\u0001\u0007I\u0011B \u0002\u0011M,'O^5dKN,\u0012\u0001\u0011\t\u0004\u0003\u001a\u001bbB\u0001\"E\u001d\tY3)C\u0001\u0011\u0013\t)u\"A\u0004qC\u000e\\\u0017mZ3\n\u0005\u001dC%\u0001\u0002'jgRT!!R\b\t\u000f)\u0003\u0001\u0019!C\u0005\u0017\u0006a1/\u001a:wS\u000e,7o\u0018\u0013fcR\u0011a\u0007\u0014\u0005\bu%\u000b\t\u00111\u0001A\u0011\u0019q\u0005\u0001)Q\u0005\u0001\u0006I1/\u001a:wS\u000e,7\u000f\t\u0005\b!\u0002\u0011\r\u0011\"\u0003R\u0003\u001d\u0019H/\u0019:uK\u0012,\u0012A\u0015\t\u0003'rk\u0011\u0001\u0016\u0006\u0003+Z\u000ba!\u0019;p[&\u001c'BA,Y\u0003)\u0019wN\\2veJ,g\u000e\u001e\u0006\u00033j\u000bA!\u001e;jY*\t1,\u0001\u0003kCZ\f\u0017BA/U\u00055\tEo\\7jG\n{w\u000e\\3b]\"1q\f\u0001Q\u0001\nI\u000b\u0001b\u001d;beR,G\r\t\u0005\nC\u0002\u0001\r\u00111A\u0005\n\t\fqAY5oI&tw-F\u0001d!\t!B-\u0003\u0002f\u0005\t\u00013k\u00195fIVdWM]#yi\u0016t7/[8o'\u0016\u0014h/[2f\u0005&tG-\u001b8h\u0011%9\u0007\u00011AA\u0002\u0013%\u0001.A\u0006cS:$\u0017N\\4`I\u0015\fHC\u0001\u001cj\u0011\u001dQd-!AA\u0002\rD\u0011b\u001b\u0001A\u0002\u0003\u0005\u000b\u0015B2\u0002\u0011\tLg\u000eZ5oO\u0002BQ!\u001c\u0001\u0005\u00029\fQa\u001d;beR$\"AN8\t\u000b\u0005d\u0007\u0019A2\t\u000bE\u0004A\u0011A \u0002\u0017\u001d,GoU3sm&\u001cWm\u001d\u0005\u0006g\u0002!\t\u0005^\u0001\u0005gR|\u0007\u000fF\u00017\u0011\u00151\b\u0001\"\u0011x\u0003!!xn\u0015;sS:<G#\u0001\u0015")
public class SchedulerExtensionServices
implements SchedulerExtensionService,
Logging {
    private Option<String> serviceOption;
    private List<SchedulerExtensionService> services;
    private final AtomicBoolean started;
    private SchedulerExtensionServiceBinding binding;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private Option<String> serviceOption() {
        return this.serviceOption;
    }

    private void serviceOption_$eq(Option<String> x$1) {
        this.serviceOption = x$1;
    }

    private List<SchedulerExtensionService> services() {
        return this.services;
    }

    private void services_$eq(List<SchedulerExtensionService> x$1) {
        this.services = x$1;
    }

    private AtomicBoolean started() {
        return this.started;
    }

    private SchedulerExtensionServiceBinding binding() {
        return this.binding;
    }

    private void binding_$eq(SchedulerExtensionServiceBinding x$1) {
        this.binding = x$1;
    }

    @Override
    public void start(SchedulerExtensionServiceBinding binding) {
        if (this.started().getAndSet(true)) {
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Ignoring re-entrant start operation");
            return;
        }
        Predef$.MODULE$.require(binding.sparkContext() != null, (Function0 & Serializable & scala.Serializable)() -> "Null context parameter");
        Predef$.MODULE$.require(binding.applicationId() != null, (Function0 & Serializable & scala.Serializable)() -> "Null appId parameter");
        this.binding_$eq(binding);
        SparkContext sparkContext = binding.sparkContext();
        ApplicationId appId = binding.applicationId();
        Option<ApplicationAttemptId> attemptId = binding.attemptId();
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(57).append("Starting Yarn extension services with app ").append(appId).append(" and attemptId ").append(attemptId).toString());
        this.services_$eq((List<SchedulerExtensionService>)((TraversableOnce)((TraversableLike)sparkContext.conf().get(package$.MODULE$.SCHEDULER_SERVICES())).map((Function1 & Serializable & scala.Serializable)sClass -> {
            void var3_3;
            SchedulerExtensionService instance = (SchedulerExtensionService)Utils$.MODULE$.classForName(sClass).newInstance();
            instance.start(binding);
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(16).append("Service ").append((String)sClass).append(" started").toString());
            return var3_3;
        }, Seq$.MODULE$.canBuildFrom())).toList());
    }

    public List<SchedulerExtensionService> getServices() {
        return this.services();
    }

    @Override
    public void stop() {
        block0: {
            if (!this.started().getAndSet(false)) break block0;
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(9).append("Stopping ").append(this).toString());
            this.services().foreach((Function1 & Serializable & scala.Serializable)s -> {
                Utils$.MODULE$.tryLogNonFatalError((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> s.stop());
                return BoxedUnit.UNIT;
            });
        }
    }

    public String toString() {
        return new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(81).append("SchedulerExtensionServices\n    |(serviceOption=").append(this.serviceOption()).append(",\n    | services=").append(this.services()).append(",\n    | started=").append(this.started()).append(")").toString())).stripMargin();
    }

    public SchedulerExtensionServices() {
        Logging.$init$((Logging)this);
        this.serviceOption = None$.MODULE$;
        this.services = Nil$.MODULE$;
        this.started = new AtomicBoolean(false);
    }
}

