/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.scheduler.cluster;

import java.io.Serializable;
import org.apache.hadoop.yarn.api.ApplicationConstants;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.spark.SparkContext;
import org.apache.spark.deploy.yarn.ApplicationMaster$;
import org.apache.spark.deploy.yarn.YarnSparkHadoopUtil$;
import org.apache.spark.scheduler.TaskSchedulerImpl;
import org.apache.spark.scheduler.cluster.SchedulerBackendUtils$;
import org.apache.spark.scheduler.cluster.YarnSchedulerBackend;
import org.apache.spark.util.Utils$;
import scala.Function0;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u00013Q!\u0001\u0002\u0001\r1\u00111$W1s]\u000ecWo\u001d;feN\u001b\u0007.\u001a3vY\u0016\u0014()Y2lK:$'BA\u0002\u0005\u0003\u001d\u0019G.^:uKJT!!\u0002\u0004\u0002\u0013M\u001c\u0007.\u001a3vY\u0016\u0014(BA\u0004\t\u0003\u0015\u0019\b/\u0019:l\u0015\tI!\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u0017\u0005\u0019qN]4\u0014\u0005\u0001i\u0001C\u0001\b\u0010\u001b\u0005\u0011\u0011B\u0001\t\u0003\u0005QI\u0016M\u001d8TG\",G-\u001e7fe\n\u000b7m[3oI\"AQ\u0001\u0001B\u0001B\u0003%1c\u0001\u0001\u0011\u0005Q)R\"\u0001\u0003\n\u0005Y!!!\u0005+bg.\u001c6\r[3ek2,'/S7qY\"A\u0001\u0004\u0001B\u0001B\u0003%\u0011$\u0001\u0002tGB\u0011!dG\u0007\u0002\r%\u0011AD\u0002\u0002\r'B\f'o[\"p]R,\u0007\u0010\u001e\u0005\u0006=\u0001!\taH\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0007\u0001\n#\u0005\u0005\u0002\u000f\u0001!)Q!\ba\u0001'!)\u0001$\ba\u00013!)A\u0005\u0001C!K\u0005)1\u000f^1siR\ta\u0005\u0005\u0002(U5\t\u0001FC\u0001*\u0003\u0015\u00198-\u00197b\u0013\tY\u0003F\u0001\u0003V]&$\b\"B\u0017\u0001\t\u0003r\u0013\u0001E4fi\u0012\u0013\u0018N^3s\u0019><WK\u001d7t+\u0005y\u0003cA\u00141e%\u0011\u0011\u0007\u000b\u0002\u0007\u001fB$\u0018n\u001c8\u0011\tMRT(\u0010\b\u0003ia\u0002\"!\u000e\u0015\u000e\u0003YR!a\u000e\n\u0002\rq\u0012xn\u001c;?\u0013\tI\u0004&\u0001\u0004Qe\u0016$WMZ\u0005\u0003wq\u00121!T1q\u0015\tI\u0004\u0006\u0005\u00024}%\u0011q\b\u0010\u0002\u0007'R\u0014\u0018N\\4")
public class YarnClusterSchedulerBackend
extends YarnSchedulerBackend {
    private final SparkContext sc;

    @Override
    public void start() {
        ApplicationAttemptId attemptId = ApplicationMaster$.MODULE$.getAttemptId();
        this.bindToYarn(attemptId.getApplicationId(), (Option<ApplicationAttemptId>)new Some((Object)attemptId));
        super.start();
        this.totalExpectedExecutors_$eq(SchedulerBackendUtils$.MODULE$.getInitialTargetExecutorNumber(this.sc.conf(), SchedulerBackendUtils$.MODULE$.getInitialTargetExecutorNumber$default$2()));
    }

    /*
     * WARNING - void declaration
     */
    public Option<Map<String, String>> getDriverLogUrls() {
        void var1_1;
        None$ driverLogs = None$.MODULE$;
        try {
            YarnConfiguration yarnConf = new YarnConfiguration(this.sc.hadoopConfiguration());
            ContainerId containerId = YarnSparkHadoopUtil$.MODULE$.getContainerId();
            String httpAddress = new StringBuilder(1).append(System.getenv(ApplicationConstants.Environment.NM_HOST.name())).append(":").append(System.getenv(ApplicationConstants.Environment.NM_HTTP_PORT.name())).toString();
            String yarnHttpPolicy = yarnConf.get("yarn.http.policy", YarnConfiguration.YARN_HTTP_POLICY_DEFAULT);
            String user = Utils$.MODULE$.getCurrentUserName();
            String string = yarnHttpPolicy;
            String string2 = "HTTPS_ONLY";
            String httpScheme = !(string != null ? !string.equals(string2) : string2 != null) ? "https://" : "http://";
            String baseUrl = new StringBuilder(21).append(httpScheme).append(httpAddress).append("/node/containerlogs/").append(containerId).append("/").append(user).toString();
            this.logDebug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(19).append("Base URL for logs: ").append(baseUrl).toString());
            driverLogs = new Some((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"stdout"), (Object)new StringBuilder(19).append(baseUrl).append("/stdout?start=-4096").toString()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"stderr"), (Object)new StringBuilder(19).append(baseUrl).append("/stderr?start=-4096").toString())})));
        }
        catch (Exception e) {
            this.logInfo((Function0 & Serializable & scala.Serializable)() -> "Error while building AM log links, so AM logs link will not appear in application UI", e);
        }
        return var1_1;
    }

    public YarnClusterSchedulerBackend(TaskSchedulerImpl scheduler, SparkContext sc) {
        this.sc = sc;
        super(scheduler, sc);
    }
}

