/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.scheduler.cluster;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.deploy.SparkHadoopUtil$;
import org.apache.spark.internal.Logging;
import org.apache.spark.rpc.RpcAddress;
import org.apache.spark.rpc.RpcCallContext;
import org.apache.spark.rpc.RpcEndpoint;
import org.apache.spark.rpc.RpcEndpointRef;
import org.apache.spark.rpc.RpcEnv;
import org.apache.spark.rpc.RpcTimeout;
import org.apache.spark.rpc.ThreadSafeRpcEndpoint;
import org.apache.spark.scheduler.ExecutorLossReason;
import org.apache.spark.scheduler.SchedulerBackend;
import org.apache.spark.scheduler.SlaveLost;
import org.apache.spark.scheduler.SlaveLost$;
import org.apache.spark.scheduler.TaskSchedulerImpl;
import org.apache.spark.scheduler.cluster.CoarseGrainedClusterMessages;
import org.apache.spark.scheduler.cluster.CoarseGrainedSchedulerBackend;
import org.apache.spark.scheduler.cluster.SchedulerExtensionServiceBinding;
import org.apache.spark.scheduler.cluster.SchedulerExtensionServices;
import org.apache.spark.scheduler.cluster.YarnSchedulerBackend$;
import org.apache.spark.scheduler.cluster.YarnSchedulerBackend$YarnSchedulerEndpoint$;
import org.apache.spark.ui.JettyUtils$;
import org.apache.spark.util.RpcUtils$;
import org.apache.spark.util.ThreadUtils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\tMgAB\u0001\u0003\u0003\u00031AB\u0001\u000bZCJt7k\u00195fIVdWM\u001d\"bG.,g\u000e\u001a\u0006\u0003\u0007\u0011\tqa\u00197vgR,'O\u0003\u0002\u0006\r\u0005I1o\u00195fIVdWM\u001d\u0006\u0003\u000f!\tQa\u001d9be.T!!\u0003\u0006\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005Y\u0011aA8sON\u0011\u0001!\u0004\t\u0003\u001d=i\u0011AA\u0005\u0003!\t\u0011QdQ8beN,wI]1j]\u0016$7k\u00195fIVdWM\u001d\"bG.,g\u000e\u001a\u0005\t\u000b\u0001\u0011\t\u0011)A\u0005'\r\u0001\u0001C\u0001\u000b\u0016\u001b\u0005!\u0011B\u0001\f\u0005\u0005E!\u0016m]6TG\",G-\u001e7fe&k\u0007\u000f\u001c\u0005\t1\u0001\u0011\t\u0011)A\u00053\u0005\u00111o\u0019\t\u00035mi\u0011AB\u0005\u00039\u0019\u0011Ab\u00159be.\u001cuN\u001c;fqRDQA\b\u0001\u0005\u0002}\ta\u0001P5oSRtDc\u0001\u0011\"EA\u0011a\u0002\u0001\u0005\u0006\u000bu\u0001\ra\u0005\u0005\u00061u\u0001\r!\u0007\u0005\bI\u0001\u0011\r\u0011\"\u0003&\u0003\u001d\u0019Ho\u001c9qK\u0012,\u0012A\n\t\u0003OAj\u0011\u0001\u000b\u0006\u0003S)\na!\u0019;p[&\u001c'BA\u0016-\u0003)\u0019wN\\2veJ,g\u000e\u001e\u0006\u0003[9\nA!\u001e;jY*\tq&\u0001\u0003kCZ\f\u0017BA\u0019)\u00055\tEo\\7jG\n{w\u000e\\3b]\"11\u0007\u0001Q\u0001\n\u0019\n\u0001b\u001d;paB,G\r\t\u0005\bk\u0001\u0011\r\u0011\"\u00117\u0003Ii\u0017N\u001c*fO&\u001cH/\u001a:fIJ\u000bG/[8\u0016\u0003]\u0002\"\u0001O\u001e\u000e\u0003eR\u0011AO\u0001\u0006g\u000e\fG.Y\u0005\u0003ye\u0012a\u0001R8vE2,\u0007B\u0002 \u0001A\u0003%q'A\nnS:\u0014VmZ5ti\u0016\u0014X\r\u001a*bi&|\u0007\u0005C\u0004A\u0001\u0001\u0007I\u0011C!\u0002-Q|G/\u00197FqB,7\r^3e\u000bb,7-\u001e;peN,\u0012A\u0011\t\u0003q\rK!\u0001R\u001d\u0003\u0007%sG\u000fC\u0004G\u0001\u0001\u0007I\u0011C$\u00025Q|G/\u00197FqB,7\r^3e\u000bb,7-\u001e;peN|F%Z9\u0015\u0005![\u0005C\u0001\u001dJ\u0013\tQ\u0015H\u0001\u0003V]&$\bb\u0002'F\u0003\u0003\u0005\rAQ\u0001\u0004q\u0012\n\u0004B\u0002(\u0001A\u0003&!)A\fu_R\fG.\u0012=qK\u000e$X\rZ#yK\u000e,Ho\u001c:tA!9\u0001\u000b\u0001b\u0001\n\u0013\t\u0016!F=be:\u001c6\r[3ek2,'/\u00128ea>Lg\u000e^\u000b\u0002%B\u00111\u000bV\u0007\u0002\u0001\u0019!Q\u000b\u0001\u0003W\u0005UI\u0016M\u001d8TG\",G-\u001e7fe\u0016sG\r]8j]R\u001cB\u0001V,[AB\u0011\u0001\bW\u0005\u00033f\u0012a!\u00118z%\u00164\u0007CA._\u001b\u0005a&BA/\u0007\u0003\r\u0011\boY\u0005\u0003?r\u0013Q\u0003\u00165sK\u0006$7+\u00194f%B\u001cWI\u001c3q_&tG\u000f\u0005\u0002bI6\t!M\u0003\u0002d\r\u0005A\u0011N\u001c;fe:\fG.\u0003\u0002fE\n9Aj\\4hS:<\u0007\u0002C4U\u0005\u000b\u0007I\u0011\t5\u0002\rI\u00048-\u00128w+\u0005I\u0007CA.k\u0013\tYGL\u0001\u0004Sa\u000e,eN\u001e\u0005\t[R\u0013\t\u0011)A\u0005S\u00069!\u000f]2F]Z\u0004\u0003\"\u0002\u0010U\t\u0003yGC\u0001*q\u0011\u00159g\u000e1\u0001j\u0011\u001d\u0011H\u000b1A\u0005\nM\f!\"Y7F]\u0012\u0004x.\u001b8u+\u0005!\bc\u0001\u001dvo&\u0011a/\u000f\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0005mC\u0018BA=]\u00059\u0011\u0006oY#oIB|\u0017N\u001c;SK\u001aDqa\u001f+A\u0002\u0013%A0\u0001\bb[\u0016sG\r]8j]R|F%Z9\u0015\u0005!k\bb\u0002'{\u0003\u0003\u0005\r\u0001\u001e\u0005\u0007\u007fR\u0003\u000b\u0015\u0002;\u0002\u0017\u0005lWI\u001c3q_&tG\u000f\t\u0005\b\u0003\u0007!F\u0011IA\u0003\u0003\u001d\u0011XmY3jm\u0016,\"!a\u0002\u0011\ra\nI!!\u0004I\u0013\r\tY!\u000f\u0002\u0010!\u0006\u0014H/[1m\rVt7\r^5p]B\u0019\u0001(a\u0004\n\u0007\u0005E\u0011HA\u0002B]fDq!!\u0006U\t\u0003\n9\"A\bsK\u000e,\u0017N^3B]\u0012\u0014V\r\u001d7z)\u0011\t9!!\u0007\t\u0011\u0005m\u00111\u0003a\u0001\u0003;\tqaY8oi\u0016DH\u000fE\u0002\\\u0003?I1!!\t]\u00059\u0011\u0006oY\"bY2\u001cuN\u001c;fqRDq!!\nU\t\u0003\n9#\u0001\bp]\u0012K7oY8o]\u0016\u001cG/\u001a3\u0015\u0007!\u000bI\u0003\u0003\u0005\u0002,\u0005\r\u0002\u0019AA\u0017\u00035\u0011X-\\8uK\u0006#GM]3tgB\u00191,a\f\n\u0007\u0005EBL\u0001\u0006Sa\u000e\fE\r\u001a:fgNDA\"!\u000eU\u0005\u0003\u0005\t\u0011\"\u0001\u0001\u0003o\tQl\u001c:hI\u0005\u0004\u0018m\u00195fIM\u0004\u0018M]6%g\u000eDW\rZ;mKJ$3\r\\;ti\u0016\u0014H%W1s]N\u001b\u0007.\u001a3vY\u0016\u0014()Y2lK:$G\u0005\n5b]\u0012dW-\u0012=fGV$xN\u001d#jg\u000e|gN\\3di\u0016$gI]8n\tJLg/\u001a:\u0015\u000b!\u000bI$a\u0015\t\u0011\u0005m\u00121\u0007a\u0001\u0003{\t!\"\u001a=fGV$xN]%e!\u0011\ty$!\u0014\u000f\t\u0005\u0005\u0013\u0011\n\t\u0004\u0003\u0007JTBAA#\u0015\r\t9EE\u0001\u0007yI|w\u000e\u001e \n\u0007\u0005-\u0013(\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003\u001f\n\tF\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003\u0017J\u0004\u0002CA+\u0003g\u0001\r!!\f\u0002%\u0015DXmY;u_J\u0014\u0006oY!eIJ,7o\u001d\u0005\b\u00033\u0002\u0001\u0015!\u0003S\u0003YI\u0018M\u001d8TG\",G-\u001e7fe\u0016sG\r]8j]R\u0004\u0003\"CA/\u0001\t\u0007I\u0011BA0\u0003aI\u0018M\u001d8TG\",G-\u001e7fe\u0016sG\r]8j]R\u0014VMZ\u000b\u0002o\"9\u00111\r\u0001!\u0002\u00139\u0018!G=be:\u001c6\r[3ek2,'/\u00128ea>Lg\u000e\u001e*fM\u0002B\u0011\"a\u001a\u0001\u0005\u0004%Y!!\u001b\u0002\u0015\u0005\u001c8\u000eV5nK>,H/\u0006\u0002\u0002lA\u00191,!\u001c\n\u0007\u0005=DL\u0001\u0006Sa\u000e$\u0016.\\3pkRD\u0001\"a\u001d\u0001A\u0003%\u00111N\u0001\fCN\\G+[7f_V$\b\u0005C\u0005\u0002x\u0001\u0001\r\u0011\"\u0005\u0002z\u0005)\u0011\r\u001d9JIV\u0011\u00111\u0010\t\u0005qU\fi\b\u0005\u0003\u0002\u0000\u0005EUBAAA\u0015\u0011\t\u0019)!\"\u0002\u000fI,7m\u001c:eg*!\u0011qQAE\u0003\r\t\u0007/\u001b\u0006\u0005\u0003\u0017\u000bi)\u0001\u0003zCJt'bAAH\u0011\u00051\u0001.\u00193p_BLA!a%\u0002\u0002\ni\u0011\t\u001d9mS\u000e\fG/[8o\u0013\u0012D\u0011\"a&\u0001\u0001\u0004%\t\"!'\u0002\u0013\u0005\u0004\b/\u00133`I\u0015\fHc\u0001%\u0002\u001c\"IA*!&\u0002\u0002\u0003\u0007\u00111\u0010\u0005\t\u0003?\u0003\u0001\u0015)\u0003\u0002|\u00051\u0011\r\u001d9JI\u0002B\u0011\"a)\u0001\u0001\u0004%I!!*\u0002\u0013\u0005$H/Z7qi&#WCAAT!\u0011AT/!+\u0011\t\u0005}\u00141V\u0005\u0005\u0003[\u000b\tI\u0001\u000bBaBd\u0017nY1uS>t\u0017\t\u001e;f[B$\u0018\n\u001a\u0005\n\u0003c\u0003\u0001\u0019!C\u0005\u0003g\u000bQ\"\u0019;uK6\u0004H/\u00133`I\u0015\fHc\u0001%\u00026\"IA*a,\u0002\u0002\u0003\u0007\u0011q\u0015\u0005\t\u0003s\u0003\u0001\u0015)\u0003\u0002(\u0006Q\u0011\r\u001e;f[B$\u0018\n\u001a\u0011\t\u0013\u0005u\u0006A1A\u0005\n\u0005}\u0016\u0001C:feZL7-Z:\u0016\u0005\u0005\u0005\u0007c\u0001\b\u0002D&\u0019\u0011Q\u0019\u0002\u00035M\u001b\u0007.\u001a3vY\u0016\u0014X\t\u001f;f]NLwN\\*feZL7-Z:\t\u0011\u0005%\u0007\u0001)A\u0005\u0003\u0003\f\u0011b]3sm&\u001cWm\u001d\u0011\t\u000f\u00055\u0007\u0001\"\u0005\u0002P\u0006Q!-\u001b8e)>L\u0016M\u001d8\u0015\u000b!\u000b\t.a5\t\u0011\u0005]\u00141\u001aa\u0001\u0003{B\u0001\"a)\u0002L\u0002\u0007\u0011q\u0015\u0005\b\u0003/\u0004A\u0011IAm\u0003\u0015\u0019H/\u0019:u)\u0005A\u0005bBAo\u0001\u0011\u0005\u0013\u0011\\\u0001\u0005gR|\u0007\u000fC\u0004\u0002b\u0002!\t%a9\u0002)\u0005\u0004\b\u000f\\5dCRLwN\\!ui\u0016l\u0007\u000f^%e)\t\t)\u000f\u0005\u00039k\u0006u\u0002bBAu\u0001\u0011\u0005\u00131^\u0001\u000eCB\u0004H.[2bi&|g.\u00133\u0015\u0005\u0005u\u0002\u0002CAx\u0001\u0011\u0005!!!=\u0002/A\u0014X\r]1sKJ+\u0017/^3ti\u0016CXmY;u_J\u001cH\u0003BAz\u0005+\u0001B!!>\u0003\u00109!\u0011q\u001fB\u0006\u001d\u0011\tIP!\u0003\u000f\t\u0005m(q\u0001\b\u0005\u0003{\u0014)A\u0004\u0003\u0002\u0000\n\ra\u0002BA\"\u0005\u0003I\u0011aC\u0005\u0003\u0013)I!a\u0002\u0005\n\u0005\u00151\u0011BA\u0002\u0005\u0013\r\u0011iAA\u0001\u001d\u0007>\f'o]3He\u0006Lg.\u001a3DYV\u001cH/\u001a:NKN\u001c\u0018mZ3t\u0013\u0011\u0011\tBa\u0005\u0003!I+\u0017/^3ti\u0016CXmY;u_J\u001c(b\u0001B\u0007\u0005!9!qCAw\u0001\u0004\u0011\u0015A\u0004:fcV,7\u000f^3e)>$\u0018\r\u001c\u0005\b\u00057\u0001A\u0011\tB\u000f\u0003]!wNU3rk\u0016\u001cH\u000fV8uC2,\u00050Z2vi>\u00148\u000f\u0006\u0003\u0003 \t=\u0002C\u0002B\u0011\u0005K\u0011I#\u0004\u0002\u0003$)\u00111&O\u0005\u0005\u0005O\u0011\u0019C\u0001\u0004GkR,(/\u001a\t\u0004q\t-\u0012b\u0001B\u0017s\t9!i\\8mK\u0006t\u0007b\u0002B\f\u00053\u0001\rA\u0011\u0005\b\u0005g\u0001A\u0011\tB\u001b\u0003=!wnS5mY\u0016CXmY;u_J\u001cH\u0003\u0002B\u0010\u0005oA\u0001B!\u000f\u00032\u0001\u0007!1H\u0001\fKb,7-\u001e;pe&#7\u000f\u0005\u0004\u0003>\t\u001d\u0013Q\b\b\u0005\u0005\u007f\u0011\u0019E\u0004\u0003\u0002D\t\u0005\u0013\"\u0001\u001e\n\u0007\t\u0015\u0013(A\u0004qC\u000e\\\u0017mZ3\n\t\t%#1\n\u0002\u0004'\u0016\f(b\u0001B#s!9!q\n\u0001\u0005B\tE\u0013!H:vM\u001aL7-[3oiJ+7o\\;sG\u0016\u001c(+Z4jgR,'/\u001a3\u0015\u0005\t%\u0002b\u0002B+\u0001\u0011%!qK\u0001\u000fC\u0012$w+\u001a2V\u0013\u001aKG\u000e^3s)\u001dA%\u0011\fB/\u0005OB\u0001Ba\u0017\u0003T\u0001\u0007\u0011QH\u0001\u000bM&dG/\u001a:OC6,\u0007\u0002\u0003B0\u0005'\u0002\rA!\u0019\u0002\u0019\u0019LG\u000e^3s!\u0006\u0014\u0018-\\:\u0011\u0011\u0005}\"1MA\u001f\u0003{IAA!\u001a\u0002R\t\u0019Q*\u00199\t\u0011\t%$1\u000ba\u0001\u0003{\t\u0011\u0002\u001d:pqf\u0014\u0015m]3\t\u000f\t5\u0004\u0001\"\u0011\u0003p\u0005!2M]3bi\u0016$%/\u001b<fe\u0016sG\r]8j]R$BA!\u001d\u0003xA\u00191Ka\u001d\n\u0007\tUtB\u0001\bEe&4XM]#oIB|\u0017N\u001c;\t\u0011\te$1\u000ea\u0001\u0005w\n!\u0002\u001d:pa\u0016\u0014H/[3t!\u0019\u0011iDa\u0012\u0003~A9\u0001Ha \u0002>\u0005u\u0012b\u0001BAs\t1A+\u001e9mKJBqA!\"\u0001\t#\nI.A\u0003sKN,GO\u0002\u0004\u0003\n\u0002!!1\u0012\u0002\u00133\u0006\u0014h\u000e\u0012:jm\u0016\u0014XI\u001c3q_&tGo\u0005\u0003\u0003\b\nE\u0004bC4\u0003\b\n\u0005\t\u0015!\u0003j\u0005\u001fK1a\u001aB:\u0011-\u0011\u0019Ja\"\u0003\u0002\u0003\u0006IAa\u001f\u0002\u001fM\u0004\u0018M]6Qe>\u0004XM\u001d;jKNDqA\bBD\t\u0003\u00119\n\u0006\u0004\u0003\u001a\nm%Q\u0014\t\u0004'\n\u001d\u0005BB4\u0003\u0016\u0002\u0007\u0011\u000e\u0003\u0005\u0003\u0014\nU\u0005\u0019\u0001B>\u0011!\t)Ca\"\u0005B\t\u0005Fc\u0001%\u0003$\"A!Q\u0015BP\u0001\u0004\ti#\u0001\u0006sa\u000e\fE\r\u001a:fgNDaB!+\u0001!\u0003\r\t\u0011!C\u0005\u0003W\u0014Y+A\ntkB,'\u000fJ1qa2L7-\u0019;j_:LE-\u0003\u0003\u0002j\n5\u0016b\u0001BX\t\t\u00012k\u00195fIVdWM\u001d\"bG.,g\u000eZ\u0004\t\u0005g\u0013\u0001\u0012\u0001\u0004\u00036\u0006!\u0012,\u0019:o'\u000eDW\rZ;mKJ\u0014\u0015mY6f]\u0012\u00042A\u0004B\\\r\u001d\t!\u0001#\u0001\u0007\u0005s\u001b2Aa.X\u0011\u001dq\"q\u0017C\u0001\u0005{#\"A!.\t\u0015\t\u0005'q\u0017b\u0001\n\u0003\u0011\u0019-A\u0007F\u001d\u0012\u0003v*\u0013(U?:\u000bU*R\u000b\u0003\u0005\u000b\u0004BAa2\u0003N6\u0011!\u0011\u001a\u0006\u0004\u0005\u0017t\u0013\u0001\u00027b]\u001eLA!a\u0014\u0003J\"I!\u0011\u001bB\\A\u0003%!QY\u0001\u000f\u000b:#\u0005kT%O)~s\u0015)T#!\u0001")
public abstract class YarnSchedulerBackend
extends CoarseGrainedSchedulerBackend {
    private final TaskSchedulerImpl scheduler;
    public final SparkContext org$apache$spark$scheduler$cluster$YarnSchedulerBackend$$sc;
    private final AtomicBoolean org$apache$spark$scheduler$cluster$YarnSchedulerBackend$$stopped;
    private final double minRegisteredRatio;
    private int totalExpectedExecutors;
    private final YarnSchedulerEndpoint org$apache$spark$scheduler$cluster$YarnSchedulerBackend$$yarnSchedulerEndpoint;
    private final RpcEndpointRef yarnSchedulerEndpointRef;
    private final RpcTimeout org$apache$spark$scheduler$cluster$YarnSchedulerBackend$$askTimeout;
    private Option<ApplicationId> appId;
    private Option<ApplicationAttemptId> attemptId;
    private final SchedulerExtensionServices services;

    public static String ENDPOINT_NAME() {
        return YarnSchedulerBackend$.MODULE$.ENDPOINT_NAME();
    }

    private /* synthetic */ String super$applicationId() {
        return SchedulerBackend.applicationId$((SchedulerBackend)this);
    }

    public AtomicBoolean org$apache$spark$scheduler$cluster$YarnSchedulerBackend$$stopped() {
        return this.org$apache$spark$scheduler$cluster$YarnSchedulerBackend$$stopped;
    }

    public double minRegisteredRatio() {
        return this.minRegisteredRatio;
    }

    public int totalExpectedExecutors() {
        return this.totalExpectedExecutors;
    }

    public void totalExpectedExecutors_$eq(int x$1) {
        this.totalExpectedExecutors = x$1;
    }

    public YarnSchedulerEndpoint org$apache$spark$scheduler$cluster$YarnSchedulerBackend$$yarnSchedulerEndpoint() {
        return this.org$apache$spark$scheduler$cluster$YarnSchedulerBackend$$yarnSchedulerEndpoint;
    }

    private RpcEndpointRef yarnSchedulerEndpointRef() {
        return this.yarnSchedulerEndpointRef;
    }

    public RpcTimeout org$apache$spark$scheduler$cluster$YarnSchedulerBackend$$askTimeout() {
        return this.org$apache$spark$scheduler$cluster$YarnSchedulerBackend$$askTimeout;
    }

    public Option<ApplicationId> appId() {
        return this.appId;
    }

    public void appId_$eq(Option<ApplicationId> x$1) {
        this.appId = x$1;
    }

    private Option<ApplicationAttemptId> attemptId() {
        return this.attemptId;
    }

    private void attemptId_$eq(Option<ApplicationAttemptId> x$1) {
        this.attemptId = x$1;
    }

    private SchedulerExtensionServices services() {
        return this.services;
    }

    public void bindToYarn(ApplicationId appId, Option<ApplicationAttemptId> attemptId) {
        this.appId_$eq((Option<ApplicationId>)new Some((Object)appId));
        this.attemptId_$eq(attemptId);
    }

    public void start() {
        Predef$.MODULE$.require(this.appId().isDefined(), (Function0 & Serializable & scala.Serializable)() -> "application ID unset");
        SchedulerExtensionServiceBinding binding = new SchedulerExtensionServiceBinding(this.org$apache$spark$scheduler$cluster$YarnSchedulerBackend$$sc, (ApplicationId)this.appId().get(), this.attemptId());
        this.services().start(binding);
        super.start();
    }

    public void stop() {
        try {
            this.requestTotalExecutors(0, 0, Predef$.MODULE$.Map().empty());
            super.stop();
        }
        finally {
            this.org$apache$spark$scheduler$cluster$YarnSchedulerBackend$$stopped().set(true);
            this.services().stop();
        }
    }

    public Option<String> applicationAttemptId() {
        return this.attemptId().map((Function1 & Serializable & scala.Serializable)x$1 -> ((Object)BoxesRunTime.boxToInteger((int)x$1.getAttemptId())).toString());
    }

    public String applicationId() {
        return (String)this.appId().map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.toString()).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            this.logWarning((Function0 & Serializable & scala.Serializable)() -> "Application ID is not initialized yet.");
            return this.super$applicationId();
        });
    }

    public CoarseGrainedClusterMessages.RequestExecutors prepareRequestExecutors(int requestedTotal) {
        Set nodeBlacklist = this.scheduler.nodeBlacklist();
        Map filteredHostToLocalTaskCount = (Map)this.hostToLocalTaskCount().filter((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)YarnSchedulerBackend.$anonfun$prepareRequestExecutors$1(nodeBlacklist, x0$1)));
        return new CoarseGrainedClusterMessages.RequestExecutors(requestedTotal, this.localityAwareTasks(), filteredHostToLocalTaskCount, nodeBlacklist);
    }

    public Future<Object> doRequestTotalExecutors(int requestedTotal) {
        return this.yarnSchedulerEndpointRef().ask((Object)this.prepareRequestExecutors(requestedTotal), ClassTag$.MODULE$.Boolean());
    }

    public Future<Object> doKillExecutors(Seq<String> executorIds) {
        return this.yarnSchedulerEndpointRef().ask((Object)new CoarseGrainedClusterMessages.KillExecutors(executorIds), ClassTag$.MODULE$.Boolean());
    }

    public boolean sufficientResourcesRegistered() {
        return (double)this.totalRegisteredExecutors().get() >= (double)this.totalExpectedExecutors() * this.minRegisteredRatio();
    }

    public void org$apache$spark$scheduler$cluster$YarnSchedulerBackend$$addWebUIFilter(String filterName, Map<String, String> filterParams, String proxyBase) {
        block0: {
            boolean hasFilter;
            Object object = proxyBase != null && new StringOps(Predef$.MODULE$.augmentString(proxyBase)).nonEmpty() ? System.setProperty("spark.ui.proxyBase", proxyBase) : BoxedUnit.UNIT;
            boolean bl = hasFilter = filterName != null && new StringOps(Predef$.MODULE$.augmentString(filterName)).nonEmpty() && filterParams != null && filterParams.nonEmpty();
            if (!hasFilter) break block0;
            this.logInfo((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(22).append("Add WebUI Filter. ").append(filterName).append(", ").append(filterParams).append(", ").append(proxyBase).toString());
            this.conf().set("spark.ui.filters", filterName);
            filterParams.foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
                Tuple2 tuple2 = x0$2;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                String k = (String)tuple2._1();
                String v = (String)tuple2._2();
                SparkConf sparkConf = this.conf().set(new StringBuilder(13).append("spark.").append(filterName).append(".param.").append(k).toString(), v);
                return sparkConf;
            });
            this.scheduler.sc().ui().foreach((Function1 & Serializable & scala.Serializable)ui -> {
                JettyUtils$.MODULE$.addFilters(ui.getHandlers(), this.conf());
                return BoxedUnit.UNIT;
            });
        }
    }

    public CoarseGrainedSchedulerBackend.DriverEndpoint createDriverEndpoint(Seq<Tuple2<String, String>> properties) {
        return new YarnDriverEndpoint(this, this.rpcEnv(), properties);
    }

    public void reset() {
        super.reset();
        this.org$apache$spark$scheduler$cluster$YarnSchedulerBackend$$sc.executorAllocationManager().foreach((Function1 & Serializable & scala.Serializable)x$3 -> {
            x$3.reset();
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$prepareRequestExecutors$1(Set nodeBlacklist$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String k = (String)tuple2._1();
        boolean bl = !nodeBlacklist$1.contains((Object)k);
        return bl;
    }

    public YarnSchedulerBackend(TaskSchedulerImpl scheduler, SparkContext sc) {
        this.scheduler = scheduler;
        this.org$apache$spark$scheduler$cluster$YarnSchedulerBackend$$sc = sc;
        super(scheduler, sc.env().rpcEnv());
        this.org$apache$spark$scheduler$cluster$YarnSchedulerBackend$$stopped = new AtomicBoolean(false);
        this.minRegisteredRatio = this.conf().getOption("spark.scheduler.minRegisteredResourcesRatio").isEmpty() ? 0.8 : super.minRegisteredRatio();
        this.totalExpectedExecutors = 0;
        this.org$apache$spark$scheduler$cluster$YarnSchedulerBackend$$yarnSchedulerEndpoint = new YarnSchedulerEndpoint(this, this.rpcEnv());
        this.yarnSchedulerEndpointRef = this.rpcEnv().setupEndpoint(YarnSchedulerBackend$.MODULE$.ENDPOINT_NAME(), (RpcEndpoint)this.org$apache$spark$scheduler$cluster$YarnSchedulerBackend$$yarnSchedulerEndpoint());
        this.org$apache$spark$scheduler$cluster$YarnSchedulerBackend$$askTimeout = RpcUtils$.MODULE$.askRpcTimeout(sc.conf());
        this.appId = None$.MODULE$;
        this.attemptId = None$.MODULE$;
        this.services = new SchedulerExtensionServices();
    }

    public class YarnDriverEndpoint
    extends CoarseGrainedSchedulerBackend.DriverEndpoint {
        public void onDisconnected(RpcAddress rpcAddress) {
            this.addressToExecutorId().get((Object)rpcAddress).foreach((Function1 & Serializable & scala.Serializable)executorId -> {
                YarnDriverEndpoint.$anonfun$onDisconnected$1(this, rpcAddress, executorId);
                return BoxedUnit.UNIT;
            });
        }

        public /* synthetic */ YarnSchedulerBackend org$apache$spark$scheduler$cluster$YarnSchedulerBackend$YarnDriverEndpoint$$$outer() {
            return (YarnSchedulerBackend)this.$outer;
        }

        public static final /* synthetic */ void $anonfun$onDisconnected$1(YarnDriverEndpoint $this, RpcAddress rpcAddress$1, String executorId) {
            block0: {
                if ($this.org$apache$spark$scheduler$cluster$YarnSchedulerBackend$YarnDriverEndpoint$$$outer().org$apache$spark$scheduler$cluster$YarnSchedulerBackend$$stopped().get() || !$this.disableExecutor(executorId)) break block0;
                $this.org$apache$spark$scheduler$cluster$YarnSchedulerBackend$YarnDriverEndpoint$$$outer().org$apache$spark$scheduler$cluster$YarnSchedulerBackend$$yarnSchedulerEndpoint().org$apache$spark$scheduler$cluster$YarnSchedulerBackend$$handleExecutorDisconnectedFromDriver(executorId, rpcAddress$1);
            }
        }

        public YarnDriverEndpoint(YarnSchedulerBackend $outer, RpcEnv rpcEnv, Seq<Tuple2<String, String>> sparkProperties) {
            super((CoarseGrainedSchedulerBackend)$outer, rpcEnv, sparkProperties);
        }
    }

    public class YarnSchedulerEndpoint
    implements ThreadSafeRpcEndpoint,
    Logging {
        private final RpcEnv rpcEnv;
        private Option<RpcEndpointRef> org$apache$spark$scheduler$cluster$YarnSchedulerBackend$YarnSchedulerEndpoint$$amEndpoint;
        private transient Logger org$apache$spark$internal$Logging$$log_;
        public final /* synthetic */ YarnSchedulerBackend $outer;

        public String logName() {
            return Logging.logName$((Logging)this);
        }

        public Logger log() {
            return Logging.log$((Logging)this);
        }

        public void logInfo(Function0<String> msg) {
            Logging.logInfo$((Logging)this, msg);
        }

        public void logDebug(Function0<String> msg) {
            Logging.logDebug$((Logging)this, msg);
        }

        public void logTrace(Function0<String> msg) {
            Logging.logTrace$((Logging)this, msg);
        }

        public void logWarning(Function0<String> msg) {
            Logging.logWarning$((Logging)this, msg);
        }

        public void logError(Function0<String> msg) {
            Logging.logError$((Logging)this, msg);
        }

        public void logInfo(Function0<String> msg, Throwable throwable) {
            Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
        }

        public void logDebug(Function0<String> msg, Throwable throwable) {
            Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
        }

        public void logTrace(Function0<String> msg, Throwable throwable) {
            Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
        }

        public void logWarning(Function0<String> msg, Throwable throwable) {
            Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
        }

        public void logError(Function0<String> msg, Throwable throwable) {
            Logging.logError$((Logging)this, msg, (Throwable)throwable);
        }

        public boolean isTraceEnabled() {
            return Logging.isTraceEnabled$((Logging)this);
        }

        public void initializeLogIfNecessary(boolean isInterpreter) {
            Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
        }

        public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
            return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
        }

        public boolean initializeLogIfNecessary$default$2() {
            return Logging.initializeLogIfNecessary$default$2$((Logging)this);
        }

        public final RpcEndpointRef self() {
            return RpcEndpoint.self$((RpcEndpoint)this);
        }

        public void onError(Throwable cause) {
            RpcEndpoint.onError$((RpcEndpoint)this, (Throwable)cause);
        }

        public void onConnected(RpcAddress remoteAddress) {
            RpcEndpoint.onConnected$((RpcEndpoint)this, (RpcAddress)remoteAddress);
        }

        public void onNetworkError(Throwable cause, RpcAddress remoteAddress) {
            RpcEndpoint.onNetworkError$((RpcEndpoint)this, (Throwable)cause, (RpcAddress)remoteAddress);
        }

        public void onStart() {
            RpcEndpoint.onStart$((RpcEndpoint)this);
        }

        public void onStop() {
            RpcEndpoint.onStop$((RpcEndpoint)this);
        }

        public final void stop() {
            RpcEndpoint.stop$((RpcEndpoint)this);
        }

        public Logger org$apache$spark$internal$Logging$$log_() {
            return this.org$apache$spark$internal$Logging$$log_;
        }

        public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
            this.org$apache$spark$internal$Logging$$log_ = x$1;
        }

        public RpcEnv rpcEnv() {
            return this.rpcEnv;
        }

        public Option<RpcEndpointRef> org$apache$spark$scheduler$cluster$YarnSchedulerBackend$YarnSchedulerEndpoint$$amEndpoint() {
            return this.org$apache$spark$scheduler$cluster$YarnSchedulerBackend$YarnSchedulerEndpoint$$amEndpoint;
        }

        public void org$apache$spark$scheduler$cluster$YarnSchedulerBackend$YarnSchedulerEndpoint$$amEndpoint_$eq(Option<RpcEndpointRef> x$1) {
            this.org$apache$spark$scheduler$cluster$YarnSchedulerBackend$YarnSchedulerEndpoint$$amEndpoint = x$1;
        }

        public void org$apache$spark$scheduler$cluster$YarnSchedulerBackend$$handleExecutorDisconnectedFromDriver(String executorId, RpcAddress executorRpcAddress) {
            Future future;
            Option<RpcEndpointRef> option = this.org$apache$spark$scheduler$cluster$YarnSchedulerBackend$YarnSchedulerEndpoint$$amEndpoint();
            if (option instanceof Some) {
                Some some = (Some)option;
                RpcEndpointRef am = (RpcEndpointRef)some.value();
                CoarseGrainedClusterMessages.GetExecutorLossReason lossReasonRequest = new CoarseGrainedClusterMessages.GetExecutorLossReason(executorId);
                future = am.ask((Object)lossReasonRequest, this.org$apache$spark$scheduler$cluster$YarnSchedulerBackend$YarnSchedulerEndpoint$$$outer().org$apache$spark$scheduler$cluster$YarnSchedulerBackend$$askTimeout(), ClassTag$.MODULE$.apply(ExecutorLossReason.class)).map((Function1 & Serializable & scala.Serializable)reason -> new CoarseGrainedClusterMessages.RemoveExecutor(executorId, reason), (ExecutionContext)ThreadUtils$.MODULE$.sameThread()).recover((PartialFunction)new scala.Serializable(this, executorId, executorRpcAddress){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ YarnSchedulerEndpoint $outer;
                    private final String executorId$1;
                    private final RpcAddress executorRpcAddress$1;

                    public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                        Object object;
                        A1 A1 = x1;
                        Option option = NonFatal$.MODULE$.unapply(A1);
                        if (!option.isEmpty()) {
                            Throwable e = (Throwable)option.get();
                            this.$outer.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(81).append("Attempted to get executor loss reason").append(new StringBuilder(34).append(" for executor id ").append($this.executorId$1).append(" at RPC address ").append($this.executorRpcAddress$1).append(",").toString()).append(" but got no response. Marking as slave lost.").toString(), e);
                            object = new CoarseGrainedClusterMessages.RemoveExecutor(this.executorId$1, (ExecutorLossReason)new SlaveLost(SlaveLost$.MODULE$.apply$default$1(), SlaveLost$.MODULE$.apply$default$2()));
                        } else {
                            object = function1.apply(x1);
                        }
                        return (B1)object;
                    }

                    public final boolean isDefinedAt(Throwable x1) {
                        Throwable throwable = x1;
                        Option option = NonFatal$.MODULE$.unapply(throwable);
                        boolean bl = !option.isEmpty();
                        return bl;
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.executorId$1 = executorId$1;
                        this.executorRpcAddress$1 = executorRpcAddress$1;
                    }

                    private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                        return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$1(org.apache.spark.scheduler.cluster.YarnSchedulerBackend$YarnSchedulerEndpoint$$anonfun$1 )}, serializedLambda);
                    }
                }, (ExecutionContext)ThreadUtils$.MODULE$.sameThread());
            } else if (None$.MODULE$.equals(option)) {
                this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Attempted to check for an executor loss reason before the AM has registered!");
                future = Future$.MODULE$.successful((Object)new CoarseGrainedClusterMessages.RemoveExecutor(executorId, (ExecutorLossReason)new SlaveLost("AM is not yet registered.", SlaveLost$.MODULE$.apply$default$2())));
            } else {
                throw new MatchError(option);
            }
            Future removeExecutorMessage = future;
            removeExecutorMessage.foreach((Function1 & Serializable & scala.Serializable)message -> {
                YarnSchedulerEndpoint.$anonfun$org$apache$spark$scheduler$cluster$YarnSchedulerBackend$$handleExecutorDisconnectedFromDriver$3(this, message);
                return BoxedUnit.UNIT;
            }, ExecutionContext.Implicits$.MODULE$.global());
        }

        public PartialFunction<Object, BoxedUnit> receive() {
            return new scala.Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ YarnSchedulerEndpoint $outer;

                public final <A1, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                    Object object;
                    A1 A1 = x2;
                    if (A1 instanceof CoarseGrainedClusterMessages.RegisterClusterManager) {
                        CoarseGrainedClusterMessages.RegisterClusterManager registerClusterManager = (CoarseGrainedClusterMessages.RegisterClusterManager)A1;
                        RpcEndpointRef am = registerClusterManager.am();
                        this.$outer.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(32).append("ApplicationMaster registered as ").append(am).toString());
                        this.$outer.org$apache$spark$scheduler$cluster$YarnSchedulerBackend$YarnSchedulerEndpoint$$amEndpoint_$eq((Option<RpcEndpointRef>)Option$.MODULE$.apply((Object)am));
                        this.$outer.org$apache$spark$scheduler$cluster$YarnSchedulerBackend$YarnSchedulerEndpoint$$$outer().reset();
                        object = BoxedUnit.UNIT;
                    } else if (A1 instanceof CoarseGrainedClusterMessages.AddWebUIFilter) {
                        CoarseGrainedClusterMessages.AddWebUIFilter addWebUIFilter = (CoarseGrainedClusterMessages.AddWebUIFilter)A1;
                        String filterName = addWebUIFilter.filterName();
                        Map filterParams = addWebUIFilter.filterParams();
                        String proxyBase = addWebUIFilter.proxyBase();
                        this.$outer.org$apache$spark$scheduler$cluster$YarnSchedulerBackend$YarnSchedulerEndpoint$$$outer().org$apache$spark$scheduler$cluster$YarnSchedulerBackend$$addWebUIFilter(filterName, (Map<String, String>)filterParams, proxyBase);
                        object = BoxedUnit.UNIT;
                    } else if (A1 instanceof CoarseGrainedClusterMessages.RemoveExecutor) {
                        BoxedUnit boxedUnit;
                        CoarseGrainedClusterMessages.RemoveExecutor removeExecutor = (CoarseGrainedClusterMessages.RemoveExecutor)A1;
                        String executorId = removeExecutor.executorId();
                        ExecutorLossReason reason = removeExecutor.reason();
                        if (!this.$outer.org$apache$spark$scheduler$cluster$YarnSchedulerBackend$YarnSchedulerEndpoint$$$outer().org$apache$spark$scheduler$cluster$YarnSchedulerBackend$$stopped().get()) {
                            this.$outer.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(49).append("Requesting driver to remove executor ").append(executorId).append(" for reason ").append(reason).toString());
                            this.$outer.org$apache$spark$scheduler$cluster$YarnSchedulerBackend$YarnSchedulerEndpoint$$$outer().driverEndpoint().send((Object)removeExecutor);
                            boxedUnit = BoxedUnit.UNIT;
                        } else {
                            boxedUnit = BoxedUnit.UNIT;
                        }
                        object = boxedUnit;
                    } else if (A1 instanceof CoarseGrainedClusterMessages.UpdateDelegationTokens) {
                        CoarseGrainedClusterMessages.UpdateDelegationTokens updateDelegationTokens = (CoarseGrainedClusterMessages.UpdateDelegationTokens)A1;
                        byte[] tokens = updateDelegationTokens.tokens();
                        SparkHadoopUtil$.MODULE$.get().addDelegationTokens(tokens, this.$outer.org$apache$spark$scheduler$cluster$YarnSchedulerBackend$YarnSchedulerEndpoint$$$outer().org$apache$spark$scheduler$cluster$YarnSchedulerBackend$$sc.conf());
                        this.$outer.org$apache$spark$scheduler$cluster$YarnSchedulerBackend$YarnSchedulerEndpoint$$$outer().driverEndpoint().send((Object)updateDelegationTokens);
                        object = BoxedUnit.UNIT;
                    } else {
                        object = function1.apply(x2);
                    }
                    return (B1)object;
                }

                public final boolean isDefinedAt(Object x2) {
                    Object object = x2;
                    boolean bl = object instanceof CoarseGrainedClusterMessages.RegisterClusterManager ? true : (object instanceof CoarseGrainedClusterMessages.AddWebUIFilter ? true : (object instanceof CoarseGrainedClusterMessages.RemoveExecutor ? true : object instanceof CoarseGrainedClusterMessages.UpdateDelegationTokens));
                    return bl;
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }

                private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                    return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$2(org.apache.spark.rpc.RpcEndpointRef ), $anonfun$applyOrElse$3(java.lang.String org.apache.spark.scheduler.ExecutorLossReason )}, serializedLambda);
                }
            };
        }

        public PartialFunction<Object, BoxedUnit> receiveAndReply(RpcCallContext context) {
            return new scala.Serializable(this, context){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ YarnSchedulerEndpoint $outer;
                public final RpcCallContext context$1;

                public final <A1, B1> B1 applyOrElse(A1 x3, Function1<A1, B1> function1) {
                    Object object;
                    A1 A1 = x3;
                    if (A1 instanceof CoarseGrainedClusterMessages.RequestExecutors) {
                        CoarseGrainedClusterMessages.RequestExecutors requestExecutors = (CoarseGrainedClusterMessages.RequestExecutors)A1;
                        Option<RpcEndpointRef> option = this.$outer.org$apache$spark$scheduler$cluster$YarnSchedulerBackend$YarnSchedulerEndpoint$$amEndpoint();
                        if (option instanceof Some) {
                            Some some = (Some)option;
                            RpcEndpointRef am = (RpcEndpointRef)some.value();
                            am.ask((Object)requestExecutors, ClassTag$.MODULE$.Boolean()).andThen((PartialFunction)new scala.Serializable(this, requestExecutors){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ YarnSchedulerEndpoint$$anonfun$receiveAndReply$1 $outer;
                                private final CoarseGrainedClusterMessages.RequestExecutors x2$1;

                                public final <A1 extends Try<Object>, B1> B1 applyOrElse(A1 x4, Function1<A1, B1> function1) {
                                    Failure failure;
                                    Throwable throwable;
                                    Option option;
                                    Object object;
                                    A1 A1 = x4;
                                    if (A1 instanceof Success) {
                                        Success success = (Success)A1;
                                        boolean b = BoxesRunTime.unboxToBoolean((Object)success.value());
                                        this.$outer.context$1.reply((Object)BoxesRunTime.boxToBoolean((boolean)b));
                                        object = BoxedUnit.UNIT;
                                    } else if (A1 instanceof Failure && !(option = NonFatal$.MODULE$.unapply(throwable = (failure = (Failure)A1).exception())).isEmpty()) {
                                        Throwable e = (Throwable)option.get();
                                        this.$outer.org$apache$spark$scheduler$cluster$YarnSchedulerBackend$YarnSchedulerEndpoint$$anonfun$$$outer().logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(31).append("Sending ").append($this.x2$1).append(" to AM was unsuccessful").toString(), e);
                                        this.$outer.context$1.sendFailure(e);
                                        object = BoxedUnit.UNIT;
                                    } else {
                                        object = function1.apply(x4);
                                    }
                                    return (B1)object;
                                }

                                public final boolean isDefinedAt(Try<Object> x4) {
                                    Failure failure;
                                    Throwable throwable;
                                    Option option;
                                    Try<Object> try_ = x4;
                                    boolean bl = try_ instanceof Success ? true : try_ instanceof Failure && !(option = NonFatal$.MODULE$.unapply(throwable = (failure = (Failure)try_).exception())).isEmpty();
                                    return bl;
                                }
                                {
                                    if ($outer == null) {
                                        throw null;
                                    }
                                    this.$outer = $outer;
                                    this.x2$1 = x2$1;
                                }

                                private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                                    return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$4(org.apache.spark.scheduler.cluster.YarnSchedulerBackend$YarnSchedulerEndpoint$$anonfun$receiveAndReply$1$$anonfun$applyOrElse$8 )}, serializedLambda);
                                }
                            }, (ExecutionContext)ThreadUtils$.MODULE$.sameThread());
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        } else if (None$.MODULE$.equals(option)) {
                            this.$outer.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Attempted to request executors before the AM has registered!");
                            this.context$1.reply((Object)BoxesRunTime.boxToBoolean((boolean)false));
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        } else {
                            throw new MatchError(option);
                        }
                        object = BoxedUnit.UNIT;
                    } else if (A1 instanceof CoarseGrainedClusterMessages.KillExecutors) {
                        CoarseGrainedClusterMessages.KillExecutors killExecutors = (CoarseGrainedClusterMessages.KillExecutors)A1;
                        Option<RpcEndpointRef> option = this.$outer.org$apache$spark$scheduler$cluster$YarnSchedulerBackend$YarnSchedulerEndpoint$$amEndpoint();
                        if (option instanceof Some) {
                            Some some = (Some)option;
                            RpcEndpointRef am = (RpcEndpointRef)some.value();
                            am.ask((Object)killExecutors, ClassTag$.MODULE$.Boolean()).andThen((PartialFunction)new scala.Serializable(this, killExecutors){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ YarnSchedulerEndpoint$$anonfun$receiveAndReply$1 $outer;
                                private final CoarseGrainedClusterMessages.KillExecutors x3$1;

                                public final <A1 extends Try<Object>, B1> B1 applyOrElse(A1 x5, Function1<A1, B1> function1) {
                                    Failure failure;
                                    Throwable throwable;
                                    Option option;
                                    Object object;
                                    A1 A1 = x5;
                                    if (A1 instanceof Success) {
                                        Success success = (Success)A1;
                                        boolean b = BoxesRunTime.unboxToBoolean((Object)success.value());
                                        this.$outer.context$1.reply((Object)BoxesRunTime.boxToBoolean((boolean)b));
                                        object = BoxedUnit.UNIT;
                                    } else if (A1 instanceof Failure && !(option = NonFatal$.MODULE$.unapply(throwable = (failure = (Failure)A1).exception())).isEmpty()) {
                                        Throwable e = (Throwable)option.get();
                                        this.$outer.org$apache$spark$scheduler$cluster$YarnSchedulerBackend$YarnSchedulerEndpoint$$anonfun$$$outer().logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(31).append("Sending ").append($this.x3$1).append(" to AM was unsuccessful").toString(), e);
                                        this.$outer.context$1.sendFailure(e);
                                        object = BoxedUnit.UNIT;
                                    } else {
                                        object = function1.apply(x5);
                                    }
                                    return (B1)object;
                                }

                                public final boolean isDefinedAt(Try<Object> x5) {
                                    Failure failure;
                                    Throwable throwable;
                                    Option option;
                                    Try<Object> try_ = x5;
                                    boolean bl = try_ instanceof Success ? true : try_ instanceof Failure && !(option = NonFatal$.MODULE$.unapply(throwable = (failure = (Failure)try_).exception())).isEmpty();
                                    return bl;
                                }
                                {
                                    if ($outer == null) {
                                        throw null;
                                    }
                                    this.$outer = $outer;
                                    this.x3$1 = x3$1;
                                }

                                private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                                    return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$6(org.apache.spark.scheduler.cluster.YarnSchedulerBackend$YarnSchedulerEndpoint$$anonfun$receiveAndReply$1$$anonfun$applyOrElse$9 )}, serializedLambda);
                                }
                            }, (ExecutionContext)ThreadUtils$.MODULE$.sameThread());
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        } else if (None$.MODULE$.equals(option)) {
                            this.$outer.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Attempted to kill executors before the AM has registered!");
                            this.context$1.reply((Object)BoxesRunTime.boxToBoolean((boolean)false));
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        } else {
                            throw new MatchError(option);
                        }
                        object = BoxedUnit.UNIT;
                    } else if (CoarseGrainedClusterMessages.RetrieveLastAllocatedExecutorId$.MODULE$.equals(A1)) {
                        this.context$1.reply((Object)BoxesRunTime.boxToInteger((int)this.$outer.org$apache$spark$scheduler$cluster$YarnSchedulerBackend$YarnSchedulerEndpoint$$$outer().currentExecutorIdCounter()));
                        object = BoxedUnit.UNIT;
                    } else {
                        object = function1.apply(x3);
                    }
                    return (B1)object;
                }

                public final boolean isDefinedAt(Object x3) {
                    Object object = x3;
                    boolean bl = object instanceof CoarseGrainedClusterMessages.RequestExecutors ? true : (object instanceof CoarseGrainedClusterMessages.KillExecutors ? true : CoarseGrainedClusterMessages.RetrieveLastAllocatedExecutorId$.MODULE$.equals(object));
                    return bl;
                }

                public /* synthetic */ YarnSchedulerEndpoint org$apache$spark$scheduler$cluster$YarnSchedulerBackend$YarnSchedulerEndpoint$$anonfun$$$outer() {
                    return this.$outer;
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.context$1 = context$1;
                }

                private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                    return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$5(), $anonfun$applyOrElse$7()}, serializedLambda);
                }
            };
        }

        public void onDisconnected(RpcAddress remoteAddress) {
            block0: {
                if (!this.org$apache$spark$scheduler$cluster$YarnSchedulerBackend$YarnSchedulerEndpoint$$amEndpoint().exists((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)YarnSchedulerEndpoint.$anonfun$onDisconnected$2(remoteAddress, x$4)))) break block0;
                this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(37).append("ApplicationMaster has disassociated: ").append(remoteAddress).toString());
                this.org$apache$spark$scheduler$cluster$YarnSchedulerBackend$YarnSchedulerEndpoint$$amEndpoint_$eq((Option<RpcEndpointRef>)None$.MODULE$);
            }
        }

        public /* synthetic */ YarnSchedulerBackend org$apache$spark$scheduler$cluster$YarnSchedulerBackend$YarnSchedulerEndpoint$$$outer() {
            return this.$outer;
        }

        public static final /* synthetic */ void $anonfun$org$apache$spark$scheduler$cluster$YarnSchedulerBackend$$handleExecutorDisconnectedFromDriver$3(YarnSchedulerEndpoint $this, CoarseGrainedClusterMessages.RemoveExecutor message) {
            $this.org$apache$spark$scheduler$cluster$YarnSchedulerBackend$YarnSchedulerEndpoint$$$outer().driverEndpoint().send((Object)message);
        }

        public static final /* synthetic */ boolean $anonfun$onDisconnected$2(RpcAddress remoteAddress$1, RpcEndpointRef x$4) {
            RpcAddress rpcAddress = x$4.address();
            RpcAddress rpcAddress2 = remoteAddress$1;
            return !(rpcAddress != null ? !rpcAddress.equals(rpcAddress2) : rpcAddress2 != null);
        }

        public YarnSchedulerEndpoint(YarnSchedulerBackend $outer, RpcEnv rpcEnv) {
            this.rpcEnv = rpcEnv;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            RpcEndpoint.$init$((RpcEndpoint)this);
            Logging.$init$((Logging)this);
            this.org$apache$spark$scheduler$cluster$YarnSchedulerBackend$YarnSchedulerEndpoint$$amEndpoint = None$.MODULE$;
        }
    }
}

