/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.deploy.yarn;

import java.io.Serializable;
import org.apache.hadoop.yarn.client.api.AMRMClient;
import org.apache.spark.SparkConf;
import org.apache.spark.deploy.yarn.FailureTracker;
import org.apache.spark.deploy.yarn.config.package$;
import org.apache.spark.internal.Logging;
import org.apache.spark.scheduler.BlacklistTracker$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function2;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.GenTraversableOnce;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.Set;
import scala.collection.mutable.HashMap;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005%e!\u0002\u0010 \u0001\rJ\u0003\u0002\u0003\u001c\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u001d\t\u0011q\u0002!\u0011!Q\u0001\nuB\u0001B\u0018\u0001\u0003\u0002\u0003\u0006Ia\u0018\u0005\u0006G\u0002!\t\u0001\u001a\u0005\bS\u0002\u0011\r\u0011\"\u0003k\u0011\u0019q\u0007\u0001)A\u0005W\"9q\u000e\u0001b\u0001\n\u0013\u0001\bB\u0002;\u0001A\u0003%\u0011\u000fC\u0004v\u0001\t\u0007I\u0011\u0002<\t\ri\u0004\u0001\u0015!\u0003x\u0011\u001dY\bA1A\u0005\nqDq!a\u0007\u0001A\u0003%Q\u0010C\u0005\u0002\u001e\u0001\u0001\r\u0011\"\u0003\u0002 !I\u0011Q\u0006\u0001A\u0002\u0013%\u0011q\u0006\u0005\t\u0003w\u0001\u0001\u0015)\u0003\u0002\"!I\u0011Q\b\u0001A\u0002\u0013%\u0011q\u0004\u0005\n\u0003\u007f\u0001\u0001\u0019!C\u0005\u0003\u0003B\u0001\"!\u0012\u0001A\u0003&\u0011\u0011\u0005\u0005\t\u0003\u000f\u0002\u0001\u0019!C\u0005m\"I\u0011\u0011\n\u0001A\u0002\u0013%\u00111\n\u0005\b\u0003\u001f\u0002\u0001\u0015)\u0003x\u0011\u001d\t\t\u0006\u0001C\u0001\u0003'Bq!a\u0016\u0001\t\u0003\tI\u0006C\u0004\u0002f\u0001!I!a\u001a\t\u000f\u00055\u0004\u0001\"\u0001\u0002p!1\u0011\u0011\u0010\u0001\u0005\u0002ADq!a\u001f\u0001\t\u0013\ti\bC\u0004\u0002\u0000\u0001!I!!!\t\u000f\u0005\u001d\u0005\u0001\"\u0003\u0002~\ti\u0012,\u0019:o\u00032dwnY1u_J\u0014E.Y2lY&\u001cH\u000f\u0016:bG.,'O\u0003\u0002!C\u0005!\u00110\u0019:o\u0015\t\u00113%\u0001\u0004eKBdw.\u001f\u0006\u0003I\u0015\nQa\u001d9be.T!AJ\u0014\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005A\u0013aA8sON\u0019\u0001A\u000b\u0019\u0011\u0005-rS\"\u0001\u0017\u000b\u00035\nQa]2bY\u0006L!a\f\u0017\u0003\r\u0005s\u0017PU3g!\t\tD'D\u00013\u0015\t\u00194%\u0001\u0005j]R,'O\\1m\u0013\t)$GA\u0004M_\u001e<\u0017N\\4\u0002\u0013M\u0004\u0018M]6D_:47\u0001\u0001\t\u0003sij\u0011aI\u0005\u0003w\r\u0012\u0011b\u00159be.\u001cuN\u001c4\u0002\u0011\u0005l7\t\\5f]R\u00042A\u0010$I\u001b\u0005y$B\u0001!B\u0003\r\t\u0007/\u001b\u0006\u0003\u0005\u000e\u000baa\u00197jK:$(B\u0001\u0011E\u0015\t)U%\u0001\u0004iC\u0012|w\u000e]\u0005\u0003\u000f~\u0012!\"Q'S\u001b\u000ec\u0017.\u001a8u!\tI5L\u0004\u0002K3:\u00111\n\u0017\b\u0003\u0019^s!!\u0014,\u000f\u00059+fBA(U\u001d\t\u00016+D\u0001R\u0015\t\u0011v'\u0001\u0004=e>|GOP\u0005\u0002Q%\u0011aeJ\u0005\u0003\u000b\u0016J!\u0001\t#\n\u0005\t\u001b\u0015B\u0001!B\u0013\tQv(\u0001\u0006B\u001bJk5\t\\5f]RL!\u0001X/\u0003!\r{g\u000e^1j]\u0016\u0014(+Z9vKN$(B\u0001.@\u000391\u0017-\u001b7ve\u0016$&/Y2lKJ\u0004\"\u0001Y1\u000e\u0003}I!AY\u0010\u0003\u001d\u0019\u000b\u0017\u000e\\;sKR\u0013\u0018mY6fe\u00061A(\u001b8jiz\"B!\u001a4hQB\u0011\u0001\r\u0001\u0005\u0006m\u0011\u0001\r\u0001\u000f\u0005\u0006y\u0011\u0001\r!\u0010\u0005\u0006=\u0012\u0001\raX\u0001\u0017E2\f7m\u001b7jgR$\u0016.\\3pkRl\u0015\u000e\u001c7jgV\t1\u000e\u0005\u0002,Y&\u0011Q\u000e\f\u0002\u0005\u0019>tw-A\fcY\u0006\u001c7\u000e\\5tiRKW.Z8vi6KG\u000e\\5tA\u00051B.Y;oG\"\u0014E.Y2lY&\u001cH/\u00128bE2,G-F\u0001r!\tY#/\u0003\u0002tY\t9!i\\8mK\u0006t\u0017a\u00067bk:\u001c\u0007N\u00117bG.d\u0017n\u001d;F]\u0006\u0014G.\u001a3!\u0003Ii\u0017\r\u001f$bS2,(/Z:QKJDun\u001d;\u0016\u0003]\u0004\"a\u000b=\n\u0005ed#aA%oi\u0006\u0019R.\u0019=GC&dWO]3t!\u0016\u0014\bj\\:uA\u0005\u0011\u0012\r\u001c7pG\u0006$xN\u001d\"mC\u000e\\G.[:u+\u0005i\bC\u0002@\u0002\b\u0005-1.D\u0001\u0000\u0015\u0011\t\t!a\u0001\u0002\u000f5,H/\u00192mK*\u0019\u0011Q\u0001\u0017\u0002\u0015\r|G\u000e\\3di&|g.C\u0002\u0002\n}\u0014q\u0001S1tQ6\u000b\u0007\u000f\u0005\u0003\u0002\u000e\u0005Ua\u0002BA\b\u0003#\u0001\"\u0001\u0015\u0017\n\u0007\u0005MA&\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003/\tIB\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003'a\u0013aE1mY>\u001c\u0017\r^8s\u00052\f7m\u001b7jgR\u0004\u0013aG2veJ,g\u000e\u001e\"mC\u000e\\G.[:uK\u0012L\u0016M\u001d8O_\u0012,7/\u0006\u0002\u0002\"A1\u00111EA\u0015\u0003\u0017i!!!\n\u000b\t\u0005\u001d\u00121A\u0001\nS6lW\u000f^1cY\u0016LA!a\u000b\u0002&\t\u00191+\u001a;\u0002?\r,(O]3oi\nc\u0017mY6mSN$X\rZ-be:tu\u000eZ3t?\u0012*\u0017\u000f\u0006\u0003\u00022\u0005]\u0002cA\u0016\u00024%\u0019\u0011Q\u0007\u0017\u0003\tUs\u0017\u000e\u001e\u0005\n\u0003sq\u0011\u0011!a\u0001\u0003C\t1\u0001\u001f\u00132\u0003q\u0019WO\u001d:f]R\u0014E.Y2lY&\u001cH/\u001a3ZCJtgj\u001c3fg\u0002\n!c]2iK\u0012,H.\u001a:CY\u0006\u001c7\u000e\\5ti\u000612o\u00195fIVdWM\u001d\"mC\u000e\\G.[:u?\u0012*\u0017\u000f\u0006\u0003\u00022\u0005\r\u0003\"CA\u001d#\u0005\u0005\t\u0019AA\u0011\u0003M\u00198\r[3ek2,'O\u00117bG.d\u0017n\u001d;!\u0003=qW/\\\"mkN$XM\u001d(pI\u0016\u001c\u0018a\u00058v[\u000ecWo\u001d;fe:{G-Z:`I\u0015\fH\u0003BA\u0019\u0003\u001bB\u0001\"!\u000f\u0015\u0003\u0003\u0005\ra^\u0001\u0011]Vl7\t\\;ti\u0016\u0014hj\u001c3fg\u0002\n!c]3u\u001dVl7\t\\;ti\u0016\u0014hj\u001c3fgR!\u0011\u0011GA+\u0011\u0019\t9E\u0006a\u0001o\u0006y\u0002.\u00198eY\u0016\u0014Vm]8ve\u000e,\u0017\t\u001c7pG\u0006$\u0018n\u001c8GC&dWO]3\u0015\t\u0005E\u00121\f\u0005\b\u0003;:\u0002\u0019AA0\u0003\u001dAwn\u001d;PaR\u0004RaKA1\u0003\u0017I1!a\u0019-\u0005\u0019y\u0005\u000f^5p]\u0006\u0001S\u000f\u001d3bi\u0016\fE\u000e\\8dCRLwN\u001c\"mC\u000e\\G.[:uK\u0012tu\u000eZ3t)\u0011\t\t$!\u001b\t\u000f\u0005-\u0004\u00041\u0001\u0002\f\u0005A\u0001n\\:u]\u0006lW-\u0001\u000ftKR\u001c6\r[3ek2,'O\u00117bG.d\u0017n\u001d;fI:{G-Z:\u0015\t\u0005E\u0012\u0011\u000f\u0005\b\u0003gJ\u0002\u0019AA;\u0003\r\u001a8\r[3ek2,'O\u00117bG.d\u0017n\u001d;fI:{G-Z:XSRDW\t\u001f9jef\u0004b!!\u0004\u0002x\u0005-\u0011\u0002BA\u0016\u00033\tA#[:BY2tu\u000eZ3CY\u0006\u001c7\u000e\\5ti\u0016$\u0017a\u0006:fMJ,7\u000f\u001b\"mC\u000e\\G.[:uK\u0012tu\u000eZ3t)\t\t\t$\u0001\u0012ts:\u001c\u0007N]8oSj,'\t\\1dW2L7\u000f^3e\u001d>$WmV5uQf\u000b'O\u001c\u000b\u0005\u0003c\t\u0019\tC\u0004\u0002\u0006r\u0001\r!!\u001e\u0002!9|G-Z:U_\nc\u0017mY6mSN$\u0018!\t:f[>4X-\u0012=qSJ,G-W1s]\nc\u0017mY6mSN$X\r\u001a(pI\u0016\u001c\b")
public class YarnAllocatorBlacklistTracker
implements Logging {
    private final AMRMClient<AMRMClient.ContainerRequest> amClient;
    private final FailureTracker failureTracker;
    private final long blacklistTimeoutMillis;
    private final boolean launchBlacklistEnabled;
    private final int maxFailuresPerHost;
    private final HashMap<String, Object> allocatorBlacklist;
    private Set<String> currentBlacklistedYarnNodes;
    private Set<String> schedulerBlacklist;
    private int numClusterNodes;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private long blacklistTimeoutMillis() {
        return this.blacklistTimeoutMillis;
    }

    private boolean launchBlacklistEnabled() {
        return this.launchBlacklistEnabled;
    }

    private int maxFailuresPerHost() {
        return this.maxFailuresPerHost;
    }

    private HashMap<String, Object> allocatorBlacklist() {
        return this.allocatorBlacklist;
    }

    private Set<String> currentBlacklistedYarnNodes() {
        return this.currentBlacklistedYarnNodes;
    }

    private void currentBlacklistedYarnNodes_$eq(Set<String> x$1) {
        this.currentBlacklistedYarnNodes = x$1;
    }

    private Set<String> schedulerBlacklist() {
        return this.schedulerBlacklist;
    }

    private void schedulerBlacklist_$eq(Set<String> x$1) {
        this.schedulerBlacklist = x$1;
    }

    private int numClusterNodes() {
        return this.numClusterNodes;
    }

    private void numClusterNodes_$eq(int x$1) {
        this.numClusterNodes = x$1;
    }

    public void setNumClusterNodes(int numClusterNodes) {
        this.numClusterNodes_$eq(numClusterNodes);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void handleResourceAllocationFailure(Option<String> hostOpt) {
        Option<String> option = hostOpt;
        if (option instanceof Some) {
            Some some = (Some)option;
            String hostname = (String)some.value();
            if (this.launchBlacklistEnabled()) {
                BoxedUnit boxedUnit;
                if (!this.schedulerBlacklist().contains((Object)hostname) && !this.allocatorBlacklist().contains((Object)hostname)) {
                    this.failureTracker.registerFailureOnHost(hostname);
                    this.updateAllocationBlacklistedNodes(hostname);
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                BoxedUnit boxedUnit2 = boxedUnit;
                return;
            }
        }
        this.failureTracker.registerExecutorFailure();
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    private void updateAllocationBlacklistedNodes(String hostname) {
        block0: {
            int failuresOnHost = this.failureTracker.numFailuresOnHost(hostname);
            if (failuresOnHost <= this.maxFailuresPerHost()) break block0;
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(46).append("blacklisting ").append(hostname).append(" as YARN allocation failed ").append(failuresOnHost).append(" times").toString());
            this.allocatorBlacklist().put((Object)hostname, (Object)BoxesRunTime.boxToLong((long)(this.failureTracker.clock().getTimeMillis() + this.blacklistTimeoutMillis())));
            this.refreshBlacklistedNodes();
        }
    }

    public void setSchedulerBlacklistedNodes(Set<String> schedulerBlacklistedNodesWithExpiry) {
        this.schedulerBlacklist_$eq(schedulerBlacklistedNodesWithExpiry);
        this.refreshBlacklistedNodes();
    }

    public boolean isAllNodeBlacklisted() {
        return this.currentBlacklistedYarnNodes().size() >= this.numClusterNodes();
    }

    private void refreshBlacklistedNodes() {
        this.removeExpiredYarnBlacklistedNodes();
        Set allBlacklistedNodes = (Set)this.schedulerBlacklist().$plus$plus((GenTraversableOnce)this.allocatorBlacklist().keySet());
        this.synchronizeBlacklistedNodeWithYarn((Set<String>)allBlacklistedNodes);
    }

    private void synchronizeBlacklistedNodeWithYarn(Set<String> nodesToBlacklist) {
        List additions = (List)((TraversableOnce)nodesToBlacklist.$minus$minus(this.currentBlacklistedYarnNodes())).toList().sorted((Ordering)Ordering.String$.MODULE$);
        List removals = (List)((TraversableOnce)this.currentBlacklistedYarnNodes().$minus$minus(nodesToBlacklist)).toList().sorted((Ordering)Ordering.String$.MODULE$);
        if (additions.nonEmpty()) {
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(53).append("adding nodes to YARN application master's blacklist: ").append(additions).toString());
        }
        if (removals.nonEmpty()) {
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(57).append("removing nodes from YARN application master's blacklist: ").append(removals).toString());
        }
        if (additions.nonEmpty() || removals.nonEmpty()) {
            this.amClient.updateBlacklist((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)additions).asJava(), (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)removals).asJava());
        }
        this.currentBlacklistedYarnNodes_$eq(nodesToBlacklist);
    }

    private void removeExpiredYarnBlacklistedNodes() {
        long now = this.failureTracker.clock().getTimeMillis();
        this.allocatorBlacklist().retain((Function2 & Serializable & scala.Serializable)(x$1, expiryTime) -> BoxesRunTime.boxToBoolean((boolean)YarnAllocatorBlacklistTracker.$anonfun$removeExpiredYarnBlacklistedNodes$1(now, x$1, BoxesRunTime.unboxToLong((Object)expiryTime))));
    }

    public static final /* synthetic */ boolean $anonfun$removeExpiredYarnBlacklistedNodes$1(long now$1, String x$1, long expiryTime) {
        return expiryTime > now$1;
    }

    public YarnAllocatorBlacklistTracker(SparkConf sparkConf, AMRMClient<AMRMClient.ContainerRequest> amClient, FailureTracker failureTracker) {
        this.amClient = amClient;
        this.failureTracker = failureTracker;
        Logging.$init$((Logging)this);
        this.blacklistTimeoutMillis = BlacklistTracker$.MODULE$.getBlacklistTimeout(sparkConf);
        this.launchBlacklistEnabled = BoxesRunTime.unboxToBoolean((Object)sparkConf.get(package$.MODULE$.YARN_EXECUTOR_LAUNCH_BLACKLIST_ENABLED()));
        this.maxFailuresPerHost = BoxesRunTime.unboxToInt((Object)sparkConf.get(org.apache.spark.internal.config.package$.MODULE$.MAX_FAILED_EXEC_PER_NODE()));
        this.allocatorBlacklist = new HashMap();
        this.currentBlacklistedYarnNodes = Predef$.MODULE$.Set().empty();
        this.schedulerBlacklist = Predef$.MODULE$.Set().empty();
        this.numClusterNodes = Integer.MAX_VALUE;
    }
}

