/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.deploy.yarn.security;

import java.io.Serializable;
import java.security.PrivilegedExceptionAction;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.spark.SparkConf;
import org.apache.spark.deploy.SparkHadoopUtil$;
import org.apache.spark.deploy.yarn.config.package$;
import org.apache.spark.deploy.yarn.security.YARNHadoopDelegationTokenManager;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.config.ConfigEntry;
import org.apache.spark.rpc.RpcEndpointRef;
import org.apache.spark.scheduler.cluster.CoarseGrainedClusterMessages;
import org.apache.spark.ui.UIUtils$;
import org.apache.spark.util.ThreadUtils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Option;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005mc!\u0002\r\u001a\u0001m)\u0003\u0002\u0003\u001a\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u001b\t\u0011a\u0002!\u0011!Q\u0001\neBQ!\u0011\u0001\u0005\u0002\tCqa\u0012\u0001C\u0002\u0013%\u0001\n\u0003\u0004U\u0001\u0001\u0006I!\u0013\u0005\b+\u0002\u0011\r\u0011\"\u0003I\u0011\u00191\u0006\u0001)A\u0005\u0013\"9q\u000b\u0001b\u0001\n\u0013A\u0006B\u0002/\u0001A\u0003%\u0011\fC\u0004^\u0001\t\u0007I\u0011\u00020\t\r%\u0004\u0001\u0015!\u0003`\u0011\u001dQ\u0007A1A\u0005\n-Da\u0001\u001f\u0001!\u0002\u0013a\u0007bB=\u0001\u0005\u0004%IA\u001f\u0005\u0007}\u0002\u0001\u000b\u0011B>\t\u000f\u0005E\u0001\u0001\"\u0001\u0002\u0014!9\u0011q\u0004\u0001\u0005\u0002\u0005\u0005\u0002bBA\u0017\u0001\u0011%\u0011q\u0006\u0005\b\u0003\u007f\u0001A\u0011AA!\u0011\u001d\t\u0019\u0005\u0001C\u0005\u0003\u000bBq!!\u0015\u0001\t\u0013\t\t\u0005C\u0004\u0002T\u0001!I!!\u0016\t\u000f\u0005e\u0003\u0001\"\u0003\u0002\"\t\u0019\u0012)T\"sK\u0012,g\u000e^5bYJ+g.Z<fe*\u0011!dG\u0001\tg\u0016\u001cWO]5us*\u0011A$H\u0001\u0005s\u0006\u0014hN\u0003\u0002\u001f?\u00051A-\u001a9m_fT!\u0001I\u0011\u0002\u000bM\u0004\u0018M]6\u000b\u0005\t\u001a\u0013AB1qC\u000eDWMC\u0001%\u0003\ry'oZ\n\u0004\u0001\u0019b\u0003CA\u0014+\u001b\u0005A#\"A\u0015\u0002\u000bM\u001c\u0017\r\\1\n\u0005-B#AB!osJ+g\r\u0005\u0002.a5\taF\u0003\u00020?\u0005A\u0011N\u001c;fe:\fG.\u0003\u00022]\t9Aj\\4hS:<\u0017!C:qCJ\\7i\u001c8g\u0007\u0001\u0001\"!\u000e\u001c\u000e\u0003}I!aN\u0010\u0003\u0013M\u0003\u0018M]6D_:4\u0017A\u00035bI>|\u0007oQ8oMB\u0011!hP\u0007\u0002w)\u0011A(P\u0001\u0005G>tgM\u0003\u0002?C\u00051\u0001.\u00193p_BL!\u0001Q\u001e\u0003\u001b\r{gNZ5hkJ\fG/[8o\u0003\u0019a\u0014N\\5u}Q\u00191)\u0012$\u0011\u0005\u0011\u0003Q\"A\r\t\u000bI\u001a\u0001\u0019\u0001\u001b\t\u000ba\u001a\u0001\u0019A\u001d\u0002\u0013A\u0014\u0018N\\2ja\u0006dW#A%\u0011\u0005)\u000bfBA&P!\ta\u0005&D\u0001N\u0015\tq5'\u0001\u0004=e>|GOP\u0005\u0003!\"\na\u0001\u0015:fI\u00164\u0017B\u0001*T\u0005\u0019\u0019FO]5oO*\u0011\u0001\u000bK\u0001\u000baJLgnY5qC2\u0004\u0013AB6fsR\f'-A\u0004lKf$\u0018M\u0019\u0011\u0002#\r\u0014X\rZ3oi&\fG.T1oC\u001e,'/F\u0001Z!\t!%,\u0003\u0002\\3\t\u0001\u0013,\u0011*O\u0011\u0006$wn\u001c9EK2,w-\u0019;j_:$vn[3o\u001b\u0006t\u0017mZ3s\u0003I\u0019'/\u001a3f]RL\u0017\r\\'b]\u0006<WM\u001d\u0011\u0002\u001fI,g.Z<bY\u0016CXmY;u_J,\u0012a\u0018\t\u0003A\u001el\u0011!\u0019\u0006\u0003E\u000e\f!bY8oGV\u0014(/\u001a8u\u0015\t!W-\u0001\u0003vi&d'\"\u00014\u0002\t)\fg/Y\u0005\u0003Q\u0006\u0014\u0001dU2iK\u0012,H.\u001a3Fq\u0016\u001cW\u000f^8s'\u0016\u0014h/[2f\u0003A\u0011XM\\3xC2,\u00050Z2vi>\u0014\b%A\u0005ee&4XM\u001d*fMV\tA\u000eE\u0002naJl\u0011A\u001c\u0006\u0003_\u0006\fa!\u0019;p[&\u001c\u0017BA9o\u0005=\tEo\\7jGJ+g-\u001a:f]\u000e,\u0007CA:w\u001b\u0005!(BA; \u0003\r\u0011\boY\u0005\u0003oR\u0014aB\u00159d\u000b:$\u0007o\\5oiJ+g-\u0001\u0006ee&4XM\u001d*fM\u0002\n1B]3oK^\fG\u000eV1tWV\t1P\u0005\u0003}\u007f\u0006-a\u0001B?\u0010\u0001m\u0014A\u0002\u0010:fM&tW-\\3oiz\nAB]3oK^\fG\u000eV1tW\u0002\u0002B!!\u0001\u0002\b5\u0011\u00111\u0001\u0006\u0004\u0003\u000b)\u0017\u0001\u00027b]\u001eLA!!\u0003\u0002\u0004\t1qJ\u00196fGR\u0004B!!\u0001\u0002\u000e%!\u0011qBA\u0002\u0005!\u0011VO\u001c8bE2,\u0017\u0001D:fi\u0012\u0013\u0018N^3s%\u00164G\u0003BA\u000b\u00037\u00012aJA\f\u0013\r\tI\u0002\u000b\u0002\u0005+:LG\u000f\u0003\u0004\u0002\u001eA\u0001\rA]\u0001\u0004e\u00164\u0017!B:uCJ$HCAA\u0012!\u0011\t)#!\u000b\u000e\u0005\u0005\u001d\"B\u0001\u000e>\u0013\u0011\tY#a\n\u0003)U\u001bXM]$s_V\u0004\u0018J\u001c4pe6\fG/[8o\u00035\u0019H/\u0019:u\u0013:$XM\u001d8bYR1\u0011QCA\u0019\u0003kAq!a\r\u0013\u0001\u0004\t\u0019#A\u0002vO&Dq!a\u000e\u0013\u0001\u0004\tI$A\u0007pe&<\u0017N\\1m\u0007J,Gm\u001d\t\u0005\u0003K\tY$\u0003\u0003\u0002>\u0005\u001d\"aC\"sK\u0012,g\u000e^5bYN\fAa\u001d;paR\u0011\u0011QC\u0001\u0010g\u000eDW\rZ;mKJ+g.Z<bYR!\u0011QCA$\u0011\u001d\tI\u0005\u0006a\u0001\u0003\u0017\nQ\u0001Z3mCf\u00042aJA'\u0013\r\ty\u0005\u000b\u0002\u0005\u0019>tw-\u0001\tva\u0012\fG/\u001a+pW\u0016t7\u000fV1tW\u0006qrN\u0019;bS:$vn[3og\u0006sGmU2iK\u0012,H.\u001a*f]\u0016<\u0018\r\u001c\u000b\u0005\u0003s\t9\u0006C\u0004\u00024Y\u0001\r!a\t\u0002\u000f\u0011|Gj\\4j]\u0002")
public class AMCredentialRenewer
implements Logging {
    public final SparkConf org$apache$spark$deploy$yarn$security$AMCredentialRenewer$$sparkConf;
    public final Configuration org$apache$spark$deploy$yarn$security$AMCredentialRenewer$$hadoopConf;
    private final String principal;
    private final String keytab;
    private final YARNHadoopDelegationTokenManager org$apache$spark$deploy$yarn$security$AMCredentialRenewer$$credentialManager;
    private final ScheduledExecutorService renewalExecutor;
    private final AtomicReference<RpcEndpointRef> driverRef;
    private final Runnable renewalTask;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private String principal() {
        return this.principal;
    }

    private String keytab() {
        return this.keytab;
    }

    public YARNHadoopDelegationTokenManager org$apache$spark$deploy$yarn$security$AMCredentialRenewer$$credentialManager() {
        return this.org$apache$spark$deploy$yarn$security$AMCredentialRenewer$$credentialManager;
    }

    private ScheduledExecutorService renewalExecutor() {
        return this.renewalExecutor;
    }

    private AtomicReference<RpcEndpointRef> driverRef() {
        return this.driverRef;
    }

    private Runnable renewalTask() {
        return this.renewalTask;
    }

    public void setDriverRef(RpcEndpointRef ref) {
        this.driverRef().set(ref);
    }

    /*
     * WARNING - void declaration
     */
    public UserGroupInformation start() {
        void var2_2;
        Credentials originalCreds = UserGroupInformation.getCurrentUser().getCredentials();
        UserGroupInformation ugi = this.doLogin();
        ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<BoxedUnit>(this, ugi, originalCreds){
            private final /* synthetic */ AMCredentialRenewer $outer;
            private final UserGroupInformation ugi$1;
            private final Credentials originalCreds$1;

            public void run() {
                this.$outer.org$apache$spark$deploy$yarn$security$AMCredentialRenewer$$startInternal(this.ugi$1, this.originalCreds$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.ugi$1 = ugi$1;
                this.originalCreds$1 = originalCreds$1;
            }
        });
        return var2_2;
    }

    public void org$apache$spark$deploy$yarn$security$AMCredentialRenewer$$startInternal(UserGroupInformation ugi, Credentials originalCreds) {
        Runnable tgtRenewalTask = new Runnable(null, ugi){
            private final UserGroupInformation ugi$2;

            public void run() {
                this.ugi$2.checkTGTAndReloginFromKeytab();
            }
            {
                this.ugi$2 = ugi$2;
            }
        };
        long tgtRenewalPeriod = BoxesRunTime.unboxToLong((Object)this.org$apache$spark$deploy$yarn$security$AMCredentialRenewer$$sparkConf.get(package$.MODULE$.KERBEROS_RELOGIN_PERIOD()));
        this.renewalExecutor().scheduleAtFixedRate(tgtRenewalTask, tgtRenewalPeriod, tgtRenewalPeriod, TimeUnit.SECONDS);
        Credentials creds = this.obtainTokensAndScheduleRenewal(ugi);
        ugi.addCredentials(creds);
        Credentials existing = ugi.getCredentials();
        existing.mergeAll(originalCreds);
        ugi.addCredentials(existing);
    }

    public void stop() {
        this.renewalExecutor().shutdown();
    }

    public void org$apache$spark$deploy$yarn$security$AMCredentialRenewer$$scheduleRenewal(long delay) {
        long _delay = scala.math.package$.MODULE$.max(0L, delay);
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(33).append("Scheduling login from keytab in ").append(UIUtils$.MODULE$.formatDuration(delay)).append(".").toString());
        this.renewalExecutor().schedule(this.renewalTask(), _delay, TimeUnit.MILLISECONDS);
    }

    public void org$apache$spark$deploy$yarn$security$AMCredentialRenewer$$updateTokensTask() {
        try {
            UserGroupInformation freshUGI = this.doLogin();
            Credentials creds = this.obtainTokensAndScheduleRenewal(freshUGI);
            byte[] tokens = SparkHadoopUtil$.MODULE$.get().serialize(creds);
            RpcEndpointRef driver = this.driverRef().get();
            if (driver != null) {
                this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Updating delegation tokens.");
                driver.send((Object)new CoarseGrainedClusterMessages.UpdateDelegationTokens(tokens));
            } else {
                this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Delegation tokens close to expiration but no driver has registered yet.");
            }
            SparkHadoopUtil$.MODULE$.get().addDelegationTokens(tokens, this.org$apache$spark$deploy$yarn$security$AMCredentialRenewer$$sparkConf);
        }
        catch (Exception e) {
            long delay = TimeUnit.SECONDS.toMillis(BoxesRunTime.unboxToLong((Object)this.org$apache$spark$deploy$yarn$security$AMCredentialRenewer$$sparkConf.get(org.apache.spark.internal.config.package$.MODULE$.CREDENTIALS_RENEWAL_RETRY_WAIT())));
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(87).append("Failed to update tokens, will try again in ").append(UIUtils$.MODULE$.formatDuration(delay)).append("!").append(" If this happens too often tasks will fail.").toString(), e);
            this.org$apache$spark$deploy$yarn$security$AMCredentialRenewer$$scheduleRenewal(delay);
        }
    }

    private Credentials obtainTokensAndScheduleRenewal(UserGroupInformation ugi) {
        return (Credentials)ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Credentials>(this){
            private final /* synthetic */ AMCredentialRenewer $outer;

            /*
             * WARNING - void declaration
             */
            public Credentials run() {
                void var1_1;
                Credentials creds = new Credentials();
                long nextRenewal = this.$outer.org$apache$spark$deploy$yarn$security$AMCredentialRenewer$$credentialManager().obtainDelegationTokens(this.$outer.org$apache$spark$deploy$yarn$security$AMCredentialRenewer$$hadoopConf, creds);
                long timeToWait = SparkHadoopUtil$.MODULE$.nextCredentialRenewalTime(nextRenewal, this.$outer.org$apache$spark$deploy$yarn$security$AMCredentialRenewer$$sparkConf) - System.currentTimeMillis();
                this.$outer.org$apache$spark$deploy$yarn$security$AMCredentialRenewer$$scheduleRenewal(timeToWait);
                return var1_1;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    private UserGroupInformation doLogin() {
        void var1_1;
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(44).append("Attempting to login to KDC using principal: ").append(this.principal()).toString());
        UserGroupInformation ugi = UserGroupInformation.loginUserFromKeytabAndReturnUGI((String)this.principal(), (String)this.keytab());
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Successfully logged into KDC.");
        return var1_1;
    }

    public AMCredentialRenewer(SparkConf sparkConf, Configuration hadoopConf) {
        this.org$apache$spark$deploy$yarn$security$AMCredentialRenewer$$sparkConf = sparkConf;
        this.org$apache$spark$deploy$yarn$security$AMCredentialRenewer$$hadoopConf = hadoopConf;
        Logging.$init$((Logging)this);
        this.principal = (String)((Option)sparkConf.get((ConfigEntry)org.apache.spark.internal.config.package$.MODULE$.PRINCIPAL())).get();
        this.keytab = (String)((Option)sparkConf.get((ConfigEntry)org.apache.spark.internal.config.package$.MODULE$.KEYTAB())).get();
        this.org$apache$spark$deploy$yarn$security$AMCredentialRenewer$$credentialManager = new YARNHadoopDelegationTokenManager(sparkConf, hadoopConf);
        this.renewalExecutor = ThreadUtils$.MODULE$.newDaemonSingleThreadScheduledExecutor("Credential Refresh Thread");
        this.driverRef = new AtomicReference();
        this.renewalTask = new Runnable(this){
            private final /* synthetic */ AMCredentialRenewer $outer;

            public void run() {
                this.$outer.org$apache$spark$deploy$yarn$security$AMCredentialRenewer$$updateTokensTask();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        };
    }
}

