/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.deploy.yarn;

import com.google.common.io.Files;
import java.io.File;
import java.io.Serializable;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.spark.TestUtils$;
import org.apache.spark.api.python.PythonUtils$;
import org.apache.spark.deploy.yarn.BaseYarnClusterSuite;
import org.apache.spark.deploy.yarn.ExecutorEnvTestApp$;
import org.apache.spark.deploy.yarn.SparkContextTimeoutApp$;
import org.apache.spark.deploy.yarn.YarnAddJarTest$;
import org.apache.spark.deploy.yarn.YarnClasspathTest$;
import org.apache.spark.deploy.yarn.YarnClusterDriver$;
import org.apache.spark.deploy.yarn.YarnClusterDriverUseSparkHadoopUtilConf$;
import org.apache.spark.deploy.yarn.YarnClusterDriverWithFailure$;
import org.apache.spark.deploy.yarn.YarnLauncherTestApp$;
import org.apache.spark.deploy.yarn.config.package$;
import org.apache.spark.internal.config.UI$;
import org.apache.spark.launcher.SparkAppHandle;
import org.apache.spark.launcher.SparkLauncher;
import org.apache.spark.tags.ExtendedYarnTest;
import org.apache.spark.util.Utils$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.Tag;
import org.scalatest.concurrent.Eventually$;
import org.scalatest.enablers.Retrying$;
import org.scalatest.exceptions.TestFailedException;
import org.scalatest.matchers.should.Matchers$;
import org.scalatest.time.Span$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Map$;
import scala.collection.immutable.MapLike;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.package;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ExtendedYarnTest
@ScalaSignature(bytes="\u0006\u0001\u0005mc\u0001\u0002\u000e\u001c\u0001\u0019BQa\u000b\u0001\u0005\u00021B!B\f\u0001\u0011\u0002\u0003\r\t\u0015!\u00030\u0011\u001d\u0019\u0005A1A\u0005\n\u0011Ca!\u0012\u0001!\u0002\u0013)\u0004b\u0002$\u0001\u0005\u0004%Ia\u0012\u0005\u0007\u0011\u0002\u0001\u000b\u0011\u0002\u001d\t\u000b%\u0003A\u0011\t&\t\u000fQ\u0003!\u0019!C\u0005\u000f\"1Q\u000b\u0001Q\u0001\naBqA\u0016\u0001C\u0002\u0013%q\t\u0003\u0004X\u0001\u0001\u0006I\u0001\u000f\u0005\u00061\u0002!I!\u0017\u0005\bG\u0002\t\n\u0011\"\u0003e\u0011\u0015y\u0007\u0001\"\u0003q\u0011\u0015I\b\u0001\"\u0003{\u0011!\t)\u0001AI\u0001\n\u0013!\u0007\"CA\u0004\u0001E\u0005I\u0011BA\u0005\u0011\u001d\ti\u0001\u0001C\u0005\u0003\u001fA\u0001\"!\u0007\u0001#\u0003%I\u0001\u001a\u0005\t\u00037\u0001\u0011\u0013!C\u0005I\"9\u0011Q\u0004\u0001\u0005\n\u0005}\u0001bBA\u0012\u0001\u0011%\u0011Q\u0005\u0005\b\u0003S\u0001A\u0011AA\u0016\u0011\u001d\tI\u0004\u0001C\u0001\u0003wA\u0011\"a\u0013\u0001#\u0003%\t!!\u0003\u0003!e\u000b'O\\\"mkN$XM]*vSR,'B\u0001\u000f\u001e\u0003\u0011I\u0018M\u001d8\u000b\u0005yy\u0012A\u00023fa2|\u0017P\u0003\u0002!C\u0005)1\u000f]1sW*\u0011!eI\u0001\u0007CB\f7\r[3\u000b\u0003\u0011\n1a\u001c:h\u0007\u0001\u0019\"\u0001A\u0014\u0011\u0005!JS\"A\u000e\n\u0005)Z\"\u0001\u0006\"bg\u0016L\u0016M\u001d8DYV\u001cH/\u001a:Tk&$X-\u0001\u0004=S:LGO\u0010\u000b\u0002[A\u0011\u0001\u0006A\u0001\u0004q\u0012\n\u0004\u0003\u0002\u00194kaj\u0011!\r\u0006\u0002e\u0005)1oY1mC&\u0011A'\r\u0002\u0007)V\u0004H.\u001a\u001a\u0011\u0005A2\u0014BA\u001c2\u0005\u001d\u0011un\u001c7fC:\u0004\"!\u000f!\u000f\u0005ir\u0004CA\u001e2\u001b\u0005a$BA\u001f&\u0003\u0019a$o\\8u}%\u0011q(M\u0001\u0007!J,G-\u001a4\n\u0005\u0005\u0013%AB*ue&twM\u0003\u0002@c\u0005\t\u0012n\u001d)zi\"|g.\u0011<bS2\f'\r\\3\u0016\u0003U\n!#[:QsRDwN\\!wC&d\u0017M\u00197fA\u0005!\u0002/\u001f;i_:,\u00050Z2vi\u0006\u0014G.\u001a)bi\",\u0012\u0001O\u0001\u0016af$\bn\u001c8Fq\u0016\u001cW\u000f^1cY\u0016\u0004\u0016\r\u001e5!\u00035qWm^-be:\u001cuN\u001c4jOR\t1\n\u0005\u0002M%6\tQJ\u0003\u0002O\u001f\u0006!1m\u001c8g\u0015\ta\u0002K\u0003\u0002RC\u00051\u0001.\u00193p_BL!aU'\u0003#e\u000b'O\\\"p]\u001aLw-\u001e:bi&|g.A\u0006U\u000bN#v\fU-G\u00132+\u0015\u0001\u0004+F'R{\u0006+\u0017$J\u0019\u0016\u0003\u0013!\u0004+F'R{\u0006+W'P\tVcU)\u0001\bU\u000bN#v\fU-N\u001f\u0012+F*\u0012\u0011\u0002!Q,7\u000f\u001e\"bg&\u001c\u0017,\u0019:o\u0003B\u0004Hc\u0001.^?B\u0011\u0001gW\u0005\u00039F\u0012A!\u00168ji\")a\f\u0004a\u0001k\u0005Q1\r\\5f]Rlu\u000eZ3\t\u000f9c\u0001\u0013!a\u0001AB!\u0011(\u0019\u001d9\u0013\t\u0011'IA\u0002NCB\f!\u0004^3ti\n\u000b7/[2ZCJt\u0017\t\u001d9%I\u00164\u0017-\u001e7uII*\u0012!\u001a\u0016\u0003A\u001a\\\u0013a\u001a\t\u0003Q6l\u0011!\u001b\u0006\u0003U.\f\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u00051\f\u0014AC1o]>$\u0018\r^5p]&\u0011a.\u001b\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017!I2sK\u0006$XMS1s/&$\bn\u0014:jO&t\u0017\r\u001c*fg>,(oY3GS2,G#A9\u0011\u0005I<X\"A:\u000b\u0005Q,\u0018a\u00018fi*\ta/\u0001\u0003kCZ\f\u0017B\u0001=t\u0005\r)&\u000bT\u0001\u000fi\u0016\u001cHoV5uQ\u0006#GMS1s)\u0019Q6\u0010 @\u0002\u0002!)al\u0004a\u0001k!)Qp\u0004a\u0001q\u00059!.\u0019:QCRD\u0007bB@\u0010!\u0003\u0005\r\u0001Y\u0001\nKb$(/Y\"p]\u001aD\u0001\"a\u0001\u0010!\u0003\u0005\r!N\u0001\u0016Kb\u0004Xm\u0019;Fq\u0016\u001cW\u000f^8s\r\u0006LG.\u001e:f\u0003a!Xm\u001d;XSRD\u0017\t\u001a3KCJ$C-\u001a4bk2$HeM\u0001\u0019i\u0016\u001cHoV5uQ\u0006#GMS1sI\u0011,g-Y;mi\u0012\"TCAA\u0006U\t)d-A\u0006uKN$\b+_*qCJ\\Gc\u0002.\u0002\u0012\u0005M\u0011Q\u0003\u0005\u0006=J\u0001\r!\u000e\u0005\b\u007fJ\u0001\n\u00111\u0001a\u0011!\t9B\u0005I\u0001\u0002\u0004\u0001\u0017\u0001C3yiJ\fWI\u001c<\u0002+Q,7\u000f\u001e)z'B\f'o\u001b\u0013eK\u001a\fW\u000f\u001c;%e\u0005)B/Z:u!f\u001c\u0006/\u0019:lI\u0011,g-Y;mi\u0012\u001a\u0014!\u0006;fgR,6/Z\"mCN\u001c\b+\u0019;i\r&\u00148\u000f\u001e\u000b\u00045\u0006\u0005\u0002\"\u00020\u0016\u0001\u0004)\u0014a\u0004;fgR,\u00050Z2vi>\u0014XI\u001c<\u0015\u0007i\u000b9\u0003C\u0003_-\u0001\u0007Q'\u0001\u000ede\u0016\fG/Z#naRL\u0018J^=TKR$\u0018N\\4t\r&dW-\u0006\u0002\u0002.A!\u0011qFA\u001b\u001b\t\t\tDC\u0002\u00024U\f!![8\n\t\u0005]\u0012\u0011\u0007\u0002\u0005\r&dW-A\u000euKN$\u0018J^=TKR$\u0018N\\4t\t&\u001cHO]5ckRLwN\u001c\u000b\n5\u0006u\u0012qHA\"\u0003\u000fBQA\u0018\rA\u0002UBa!!\u0011\u0019\u0001\u0004A\u0014aD5wsN+G\u000f^5oON\u0004\u0016\r\u001e5\t\r\u0005\u0015\u0003\u00041\u00019\u0003\u0005*\u0007\u0010]3di\u0016$\u0017J^=TKR$\u0018N\\4t!J,g-\u001b=P]\u0012\u0013\u0018N^3s\u0011!\tI\u0005\u0007I\u0001\u0002\u0004)\u0014a\u00039sK\u001aL\u00070T1uG\"\fQ\u0005^3ti&3\u0018pU3ui&twm\u001d#jgR\u0014\u0018NY;uS>tG\u0005Z3gCVdG\u000f\n\u001b)\u0007\u0001\ty\u0005\u0005\u0003\u0002R\u0005]SBAA*\u0015\r\t)fH\u0001\u0005i\u0006<7/\u0003\u0003\u0002Z\u0005M#\u0001E#yi\u0016tG-\u001a3ZCJtG+Z:u\u0001")
public class YarnClusterSuite
extends BaseYarnClusterSuite {
    private final /* synthetic */ Tuple2 x$1;
    private final boolean isPythonAvailable;
    private final String pythonExecutablePath;
    private final String TEST_PYFILE;
    private final String TEST_PYMODULE;

    private boolean isPythonAvailable() {
        return this.isPythonAvailable;
    }

    private String pythonExecutablePath() {
        return this.pythonExecutablePath;
    }

    @Override
    public YarnConfiguration newYarnConfig() {
        return new YarnConfiguration();
    }

    private String TEST_PYFILE() {
        return this.TEST_PYFILE;
    }

    private String TEST_PYMODULE() {
        return this.TEST_PYMODULE;
    }

    private void testBasicYarnApp(boolean clientMode, Map<String, String> conf) {
        File result = File.createTempFile("result", null, this.tempDir());
        boolean x$1 = clientMode;
        String x$2 = this.mainClassName(YarnClusterDriver$.MODULE$.getClass());
        Seq x$3 = (Seq)new .colon.colon((Object)result.getAbsolutePath(), (List)Nil$.MODULE$);
        Map<String, String> x$4 = conf;
        Seq<Tuple2<String, String>> x$5 = this.runSpark$default$4();
        Seq<String> x$6 = this.runSpark$default$5();
        Seq<String> x$7 = this.runSpark$default$6();
        Map<String, String> x$8 = this.runSpark$default$8();
        Option<File> x$9 = this.runSpark$default$9();
        SparkAppHandle.State finalState = this.runSpark(x$1, x$2, (Seq<String>)x$3, x$5, x$6, x$7, x$4, x$8, x$9);
        this.checkResult(finalState, result, this.checkResult$default$3(), this.checkResult$default$4());
    }

    private Map<String, String> testBasicYarnApp$default$2() {
        return (Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$);
    }

    private URL createJarWithOriginalResourceFile() {
        return TestUtils$.MODULE$.createJarWithFiles((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"test.resource"), (Object)"ORIGINAL")})), this.tempDir());
    }

    private void testWithAddJar(boolean clientMode, String jarPath, Map<String, String> extraConf, boolean expectExecutorFailure) {
        File driverResult = File.createTempFile("driver", null, this.tempDir());
        File executorResult = File.createTempFile("executor", null, this.tempDir());
        boolean x$1 = clientMode;
        String x$2 = this.mainClassName(YarnClasspathTest$.MODULE$.getClass());
        Seq x$3 = (Seq)new .colon.colon((Object)driverResult.getAbsolutePath(), (List)new .colon.colon((Object)executorResult.getAbsolutePath(), (List)Nil$.MODULE$));
        Seq x$4 = (Seq)new .colon.colon((Object)jarPath, (List)Nil$.MODULE$);
        Map<String, String> x$5 = extraConf;
        Seq<Tuple2<String, String>> x$6 = this.runSpark$default$4();
        Seq<String> x$7 = this.runSpark$default$5();
        Map<String, String> x$8 = this.runSpark$default$8();
        Option<File> x$9 = this.runSpark$default$9();
        SparkAppHandle.State finalState = this.runSpark(x$1, x$2, (Seq<String>)x$3, x$6, x$7, (Seq<String>)x$4, x$5, x$8, x$9);
        this.checkResult(finalState, driverResult, "ORIGINAL", this.checkResult$default$4());
        this.checkResult(finalState, executorResult, expectExecutorFailure ? "failure" : "ORIGINAL", this.checkResult$default$4());
    }

    private Map<String, String> testWithAddJar$default$3() {
        return (Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$);
    }

    private boolean testWithAddJar$default$4() {
        return false;
    }

    private void testPySpark(boolean clientMode, Map<String, String> extraConf, Map<String, String> extraEnv) {
        SparkAppHandle.State finalState;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(this.isPythonAvailable(), "YarnClusterSuite.this.isPythonAvailable", Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssume($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("YarnClusterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 376));
        File primaryPyFile = new File(this.tempDir(), "test.py");
        Files.write((CharSequence)this.TEST_PYFILE(), (File)primaryPyFile, (Charset)StandardCharsets.UTF_8);
        String sparkHome = (String)scala.sys.package$.MODULE$.props().apply((Object)"spark.test.home");
        Seq pythonPath = (Seq)new .colon.colon((Object)new StringBuilder(12).append(sparkHome).append("/python/lib/").append(PythonUtils$.MODULE$.PY4J_ZIP_NAME()).toString(), (List)new .colon.colon((Object)new StringBuilder(7).append(sparkHome).append("/python").toString(), (List)Nil$.MODULE$));
        Map extraEnvVars = ((MapLike)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"PYSPARK_ARCHIVES_PATH"), (Object)((TraversableOnce)pythonPath.map((Function1 & Serializable & scala.Serializable)x$2 -> new StringBuilder(6).append("local:").append((String)x$2).toString(), Seq$.MODULE$.canBuildFrom())).mkString(File.pathSeparator)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"PYTHONPATH"), (Object)pythonPath.mkString(File.pathSeparator)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"PYSPARK_DRIVER_PYTHON"), (Object)this.pythonExecutablePath()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"PYSPARK_PYTHON"), (Object)this.pythonExecutablePath())}))).$plus$plus(extraEnv);
        File subdir = new File(this.tempDir(), "pyModules");
        subdir.mkdir();
        File moduleDir = subdir;
        File pyModule = new File(moduleDir, "mod1.py");
        Files.write((CharSequence)this.TEST_PYMODULE(), (File)pyModule, (Charset)StandardCharsets.UTF_8);
        URL mod2Archive = TestUtils$.MODULE$.createJarWithFiles((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"mod2.py"), (Object)this.TEST_PYMODULE())})), moduleDir);
        String pyFiles = ((TraversableOnce)new .colon.colon((Object)pyModule.getAbsolutePath(), (List)new .colon.colon((Object)mod2Archive.getPath(), (List)Nil$.MODULE$))).mkString(",");
        File result = File.createTempFile("result", null, this.tempDir());
        Some outFile = new Some((Object)File.createTempFile("stdout", null, this.tempDir()));
        boolean x$1 = clientMode;
        String x$22 = primaryPyFile.getAbsolutePath();
        Seq x$3 = (Seq)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"--py-files"), (Object)pyFiles), (List)Nil$.MODULE$);
        Seq x$4 = (Seq)new .colon.colon((Object)result.getAbsolutePath(), (List)Nil$.MODULE$);
        Map x$5 = extraEnvVars;
        Map<String, String> x$6 = extraConf;
        Some x$7 = outFile;
        Seq<String> x$8 = this.runSpark$default$5();
        Seq<String> x$9 = this.runSpark$default$6();
        SparkAppHandle.State x$10 = finalState = this.runSpark(x$1, x$22, (Seq<String>)x$4, (Seq<Tuple2<String, String>>)x$3, x$8, x$9, x$6, (Map<String, String>)x$5, (Option<File>)x$7);
        File x$11 = result;
        Some x$12 = outFile;
        String x$13 = this.checkResult$default$3();
        this.checkResult(x$10, x$11, x$13, (Option<File>)x$12);
    }

    private Map<String, String> testPySpark$default$2() {
        return (Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$);
    }

    private Map<String, String> testPySpark$default$3() {
        return (Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$);
    }

    private void testUseClassPathFirst(boolean clientMode) {
        URL originalJar = TestUtils$.MODULE$.createJarWithFiles((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"test.resource"), (Object)"ORIGINAL")})), this.tempDir());
        URL userJar = TestUtils$.MODULE$.createJarWithFiles((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"test.resource"), (Object)"OVERRIDDEN")})), this.tempDir());
        File driverResult = File.createTempFile("driver", null, this.tempDir());
        File executorResult = File.createTempFile("executor", null, this.tempDir());
        boolean x$1 = clientMode;
        String x$2 = this.mainClassName(YarnClasspathTest$.MODULE$.getClass());
        Seq x$3 = (Seq)new .colon.colon((Object)driverResult.getAbsolutePath(), (List)new .colon.colon((Object)executorResult.getAbsolutePath(), (List)Nil$.MODULE$));
        Seq x$4 = (Seq)new .colon.colon((Object)originalJar.getPath(), (List)Nil$.MODULE$);
        Seq x$5 = (Seq)new .colon.colon((Object)new StringBuilder(6).append("local:").append(userJar.getPath()).toString(), (List)Nil$.MODULE$);
        Map x$6 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"spark.driver.userClassPathFirst"), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"spark.executor.userClassPathFirst"), (Object)"true")}));
        Seq<Tuple2<String, String>> x$7 = this.runSpark$default$4();
        Map<String, String> x$8 = this.runSpark$default$8();
        Option<File> x$9 = this.runSpark$default$9();
        SparkAppHandle.State finalState = this.runSpark(x$1, x$2, (Seq<String>)x$3, x$7, (Seq<String>)x$4, (Seq<String>)x$5, (Map<String, String>)x$6, x$8, x$9);
        this.checkResult(finalState, driverResult, "OVERRIDDEN", this.checkResult$default$4());
        this.checkResult(finalState, executorResult, "OVERRIDDEN", this.checkResult$default$4());
    }

    private void testExecutorEnv(boolean clientMode) {
        File result = File.createTempFile("result", null, this.tempDir());
        boolean x$1 = clientMode;
        String x$2 = this.mainClassName(ExecutorEnvTestApp$.MODULE$.getClass());
        Seq x$3 = (Seq)new .colon.colon((Object)result.getAbsolutePath(), (List)Nil$.MODULE$);
        Map x$4 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"spark.yarn.appMasterEnv.TEST_ENV"), (Object)"am_val"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"spark.executorEnv.TEST_ENV"), (Object)"executor_val")}));
        Seq<Tuple2<String, String>> x$5 = this.runSpark$default$4();
        Seq<String> x$6 = this.runSpark$default$5();
        Seq<String> x$7 = this.runSpark$default$6();
        Map<String, String> x$8 = this.runSpark$default$8();
        Option<File> x$9 = this.runSpark$default$9();
        SparkAppHandle.State finalState = this.runSpark(x$1, x$2, (Seq<String>)x$3, x$5, x$6, x$7, (Map<String, String>)x$4, x$8, x$9);
        this.checkResult(finalState, result, "true", this.checkResult$default$4());
    }

    public File createEmptyIvySettingsFile() {
        File emptyIvySettings = File.createTempFile("ivy", ".xml");
        Files.write((CharSequence)"<ivysettings />", (File)emptyIvySettings, (Charset)StandardCharsets.UTF_8);
        return emptyIvySettings;
    }

    public void testIvySettingsDistribution(boolean clientMode, String ivySettingsPath, String expectedIvySettingsPrefixOnDriver, boolean prefixMatch) {
        SparkAppHandle.State finalState;
        File result = File.createTempFile("result", null, this.tempDir());
        File outFile = File.createTempFile("out", null, this.tempDir());
        boolean x$1 = clientMode;
        String x$2 = this.mainClassName(YarnAddJarTest$.MODULE$.getClass());
        Seq x$3 = (Seq)new .colon.colon((Object)result.getAbsolutePath(), (List)new .colon.colon((Object)expectedIvySettingsPrefixOnDriver, (List)new .colon.colon((Object)Boolean.toString(prefixMatch), (List)Nil$.MODULE$)));
        Map x$4 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"spark.jars.ivySettings"), (Object)ivySettingsPath)}));
        Option x$5 = Option$.MODULE$.apply((Object)outFile);
        Seq<Tuple2<String, String>> x$6 = this.runSpark$default$4();
        Seq<String> x$7 = this.runSpark$default$5();
        Seq<String> x$8 = this.runSpark$default$6();
        Map<String, String> x$9 = this.runSpark$default$8();
        SparkAppHandle.State x$10 = finalState = this.runSpark(x$1, x$2, (Seq<String>)x$3, x$6, x$7, x$8, (Map<String, String>)x$4, x$9, (Option<File>)x$5);
        File x$11 = result;
        Option x$12 = Option$.MODULE$.apply((Object)outFile);
        String x$13 = this.checkResult$default$3();
        this.checkResult(x$10, x$11, x$13, (Option<File>)x$12);
    }

    public boolean testIvySettingsDistribution$default$4() {
        return false;
    }

    public YarnClusterSuite() {
        Tuple2 tuple2;
        Tuple2 tuple22;
        Option option = TestUtils$.MODULE$.getAbsolutePathFromExecutable("python3");
        if (option instanceof Some) {
            Some some = (Some)option;
            String path = (String)some.value();
            tuple22 = new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)path);
        } else {
            tuple22 = tuple2 = new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)"");
        }
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        boolean isPythonAvailable = tuple2._1$mcZ$sp();
        String pythonExecutablePath = (String)tuple2._2();
        this.x$1 = new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)isPythonAvailable), (Object)pythonExecutablePath);
        this.isPythonAvailable = this.x$1._1$mcZ$sp();
        this.pythonExecutablePath = (String)this.x$1._2();
        this.TEST_PYFILE = new StringOps(Predef$.MODULE$.augmentString("\n    |import mod1, mod2\n    |import sys\n    |from operator import add\n    |\n    |from pyspark import SparkConf , SparkContext\n    |if __name__ == \"__main__\":\n    |    if len(sys.argv) != 2:\n    |        print >> sys.stderr, \"Usage: test.py [result file]\"\n    |        exit(-1)\n    |    sc = SparkContext(conf=SparkConf())\n    |    status = open(sys.argv[1],'w')\n    |    result = \"failure\"\n    |    rdd = sc.parallelize(range(10)).map(lambda x: x * mod1.func() * mod2.func())\n    |    cnt = rdd.count()\n    |    if cnt == 10:\n    |        result = \"success\"\n    |    status.write(result)\n    |    status.close()\n    |    sc.stop()\n    ")).stripMargin();
        this.TEST_PYMODULE = new StringOps(Predef$.MODULE$.augmentString("\n    |def func():\n    |    return 42\n    ")).stripMargin();
        this.test("run Spark in yarn-client mode", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.testBasicYarnApp(true, this.testBasicYarnApp$default$2()), new Position("YarnClusterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 95));
        this.test("run Spark in yarn-cluster mode", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.testBasicYarnApp(false, this.testBasicYarnApp$default$2()), new Position("YarnClusterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 99));
        this.test("run Spark in yarn-client mode with unmanaged am", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.testBasicYarnApp(true, (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)package$.MODULE$.YARN_UNMANAGED_AM().key()), (Object)"true")})))), new Position("YarnClusterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 103));
        this.test("run Spark in yarn-client mode with different configurations, ensuring redaction", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.testBasicYarnApp(true, (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)org.apache.spark.internal.config.package$.MODULE$.DRIVER_MEMORY().key()), (Object)"512m"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)org.apache.spark.internal.config.package$.MODULE$.EXECUTOR_CORES().key()), (Object)"1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)org.apache.spark.internal.config.package$.MODULE$.EXECUTOR_MEMORY().key()), (Object)"512m"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)org.apache.spark.internal.config.package$.MODULE$.EXECUTOR_INSTANCES().key()), (Object)"2"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"spark.executorEnv.HADOOP_CREDSTORE_PASSWORD"), (Object)YarnClusterDriver$.MODULE$.SECRET_PASSWORD()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"spark.yarn.appMasterEnv.HADOOP_CREDSTORE_PASSWORD"), (Object)YarnClusterDriver$.MODULE$.SECRET_PASSWORD())})))), new Position("YarnClusterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 107));
        this.test("run Spark in yarn-cluster mode with different configurations, ensuring redaction", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.testBasicYarnApp(false, (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)org.apache.spark.internal.config.package$.MODULE$.DRIVER_MEMORY().key()), (Object)"512m"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)org.apache.spark.internal.config.package$.MODULE$.DRIVER_CORES().key()), (Object)"1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)org.apache.spark.internal.config.package$.MODULE$.EXECUTOR_CORES().key()), (Object)"1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)org.apache.spark.internal.config.package$.MODULE$.EXECUTOR_MEMORY().key()), (Object)"512m"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)org.apache.spark.internal.config.package$.MODULE$.EXECUTOR_INSTANCES().key()), (Object)"2"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"spark.executorEnv.HADOOP_CREDSTORE_PASSWORD"), (Object)YarnClusterDriver$.MODULE$.SECRET_PASSWORD()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"spark.yarn.appMasterEnv.HADOOP_CREDSTORE_PASSWORD"), (Object)YarnClusterDriver$.MODULE$.SECRET_PASSWORD())})))), new Position("YarnClusterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 120));
        this.test("yarn-cluster should respect conf overrides in SparkHadoopUtil (SPARK-16414, SPARK-23630)", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            File customConf = Utils$.MODULE$.createTempDir();
            String coreSite = new StringOps(Predef$.MODULE$.augmentString("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n      |<configuration>\n      |  <property>\n      |    <name>spark.test.key</name>\n      |    <value>testvalue</value>\n      |  </property>\n      |</configuration>\n      |")).stripMargin();
            Files.write((CharSequence)coreSite, (File)new File(customConf, "core-site.xml"), (Charset)StandardCharsets.UTF_8);
            File result = File.createTempFile("result", null, this.tempDir());
            boolean x$1 = false;
            String x$2 = this.mainClassName(YarnClusterDriverUseSparkHadoopUtilConf$.MODULE$.getClass());
            Seq x$3 = (Seq)new .colon.colon((Object)"key=value", (List)new .colon.colon((Object)"spark.test.key=testvalue", (List)new .colon.colon((Object)result.getAbsolutePath(), (List)Nil$.MODULE$)));
            Map x$4 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"spark.hadoop.key"), (Object)"value")}));
            Map x$5 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"SPARK_TEST_HADOOP_CONF_DIR"), (Object)customConf.getAbsolutePath())}));
            Seq<Tuple2<String, String>> x$6 = this.runSpark$default$4();
            Seq<String> x$7 = this.runSpark$default$5();
            Seq<String> x$8 = this.runSpark$default$6();
            Option<File> x$9 = this.runSpark$default$9();
            SparkAppHandle.State finalState = this.runSpark(x$1, x$2, (Seq<String>)x$3, x$6, x$7, x$8, (Map<String, String>)x$4, (Map<String, String>)x$5, x$9);
            this.checkResult(finalState, result, this.checkResult$default$3(), this.checkResult$default$4());
        }, new Position("YarnClusterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 134));
        this.test("SPARK-35672: run Spark in yarn-client mode with additional jar using URI scheme 'local'", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String jarPath = this.createJarWithOriginalResourceFile().getPath();
            this.testWithAddJar(true, new StringBuilder(6).append("local:").append(jarPath).toString(), this.testWithAddJar$default$3(), this.testWithAddJar$default$4());
        }, new Position("YarnClusterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 156));
        this.test("SPARK-35672: run Spark in yarn-cluster mode with additional jar using URI scheme 'local'", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String jarPath = this.createJarWithOriginalResourceFile().getPath();
            this.testWithAddJar(false, new StringBuilder(6).append("local:").append(jarPath).toString(), this.testWithAddJar$default$3(), this.testWithAddJar$default$4());
        }, new Position("YarnClusterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 161));
        this.test("SPARK-35672: run Spark in yarn-client mode with additional jar using URI scheme 'local' and gateway-replacement path", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            URL jarUrl = this.createJarWithOriginalResourceFile();
            this.testWithAddJar(true, new StringBuilder(6).append("local:").append(jarUrl.getPath()).toString(), (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)package$.MODULE$.GATEWAY_ROOT_PATH().key()), (Object)((Object)Paths.get(jarUrl.toURI()).getParent()).toString()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)package$.MODULE$.REPLACEMENT_ROOT_PATH().key()), (Object)"/nonexistent/path/")}))), true);
        }, new Position("YarnClusterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 167));
        this.test("SPARK-35672: run Spark in yarn-cluster mode with additional jar using URI scheme 'local' and gateway-replacement path", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String jarPath = this.createJarWithOriginalResourceFile().getPath();
            String gatewayPath = "/replaceme/nonexistent/";
            this.testWithAddJar(false, new StringBuilder(6).append("local:").append(gatewayPath).append(jarPath).toString(), (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)package$.MODULE$.GATEWAY_ROOT_PATH().key()), (Object)gatewayPath), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)package$.MODULE$.REPLACEMENT_ROOT_PATH().key()), (Object)"")}))), this.testWithAddJar$default$4());
        }, new Position("YarnClusterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 180));
        this.test("SPARK-35672: run Spark in yarn-cluster mode with additional jar using URI scheme 'local' and gateway-replacement path containing an environment variable", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Path jarPath = Paths.get(this.createJarWithOriginalResourceFile().toURI());
            Map envVarConfigs = (Map)((TraversableLike)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"PARENT"), (Object)jarPath.getParent()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"FILENAME"), (Object)jarPath.getFileName())}))).flatMap((Function1 & Serializable & scala.Serializable)envVar -> (Seq)((TraversableLike)new .colon.colon((Object)"spark.yarn.appMasterEnv.", (List)new .colon.colon((Object)"spark.executorEnv.", (List)Nil$.MODULE$))).map((Function1 & Serializable & scala.Serializable)prefix -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new StringBuilder(0).append((String)prefix).append(envVar._1()).toString()), (Object)envVar._2().toString()), Seq$.MODULE$.canBuildFrom()), Map$.MODULE$.canBuildFrom());
            String osSpecificEnvVar = Utils$.MODULE$.isWindows() ? "%PARENT%" : "${PARENT}";
            this.testWithAddJar(false, "local:/replaceme", (Map<String, String>)((MapLike)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)package$.MODULE$.GATEWAY_ROOT_PATH().key()), (Object)"/replaceme"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)package$.MODULE$.REPLACEMENT_ROOT_PATH().key()), (Object)new StringBuilder(13).append(osSpecificEnvVar).append("/{{FILENAME}}").toString())}))).$plus$plus((GenTraversableOnce)envVarConfigs), this.testWithAddJar$default$4());
        }, new Position("YarnClusterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 193));
        this.test("SPARK-35672: run Spark in yarn-client mode with additional jar using URI scheme 'file'", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String jarPath = this.createJarWithOriginalResourceFile().getPath();
            this.testWithAddJar(true, new StringBuilder(5).append("file:").append(jarPath).toString(), this.testWithAddJar$default$3(), this.testWithAddJar$default$4());
        }, new Position("YarnClusterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 212));
        this.test("SPARK-35672: run Spark in yarn-cluster mode with additional jar using URI scheme 'file'", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String jarPath = this.createJarWithOriginalResourceFile().getPath();
            this.testWithAddJar(false, new StringBuilder(5).append("file:").append(jarPath).toString(), this.testWithAddJar$default$3(), this.testWithAddJar$default$4());
        }, new Position("YarnClusterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 217));
        this.test("run Spark in yarn-cluster mode unsuccessfully", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> {
            SparkAppHandle.State finalState = this.runSpark(false, this.mainClassName(YarnClusterDriver$.MODULE$.getClass()), this.runSpark$default$3(), this.runSpark$default$4(), this.runSpark$default$5(), this.runSpark$default$6(), this.runSpark$default$7(), this.runSpark$default$8(), this.runSpark$default$9());
            return Matchers$.MODULE$.convertToAnyShouldWrapper((Object)finalState, new Position("YarnClusterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 225), Prettifier$.MODULE$.default()).should(this.be().apply((Object)SparkAppHandle.State.FAILED));
        }, new Position("YarnClusterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 222));
        this.test("run Spark in yarn-cluster mode failure after sc initialized", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> {
            SparkAppHandle.State finalState = this.runSpark(false, this.mainClassName(YarnClusterDriverWithFailure$.MODULE$.getClass()), this.runSpark$default$3(), this.runSpark$default$4(), this.runSpark$default$5(), this.runSpark$default$6(), this.runSpark$default$7(), this.runSpark$default$8(), this.runSpark$default$9());
            return Matchers$.MODULE$.convertToAnyShouldWrapper((Object)finalState, new Position("YarnClusterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 230), Prettifier$.MODULE$.default()).should(this.be().apply((Object)SparkAppHandle.State.FAILED));
        }, new Position("YarnClusterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 228));
        this.test("run Python application in yarn-client mode", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.testPySpark(true, this.testPySpark$default$2(), this.testPySpark$default$3()), new Position("YarnClusterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 233));
        this.test("run Python application in yarn-cluster mode", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.testPySpark(false, this.testPySpark$default$2(), this.testPySpark$default$3()), new Position("YarnClusterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 237));
        this.test("run Python application in yarn-cluster mode using spark.yarn.appMasterEnv to override local envvar", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.testPySpark(false, (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"spark.yarn.appMasterEnv.PYSPARK_DRIVER_PYTHON"), scala.sys.package$.MODULE$.env().getOrElse((Object)"PYSPARK_DRIVER_PYTHON", (Function0 & Serializable & scala.Serializable)() -> this.pythonExecutablePath())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"spark.yarn.appMasterEnv.PYSPARK_PYTHON"), scala.sys.package$.MODULE$.env().getOrElse((Object)"PYSPARK_PYTHON", (Function0 & Serializable & scala.Serializable)() -> this.pythonExecutablePath()))}))), (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"PYSPARK_DRIVER_PYTHON"), (Object)"not python"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"PYSPARK_PYTHON"), (Object)"not python")})))), new Position("YarnClusterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 242));
        this.test("user class path first in client mode", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.testUseClassPathFirst(true), new Position("YarnClusterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 255));
        this.test("user class path first in cluster mode", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.testUseClassPathFirst(false), new Position("YarnClusterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 259));
        this.test("monitor app using launcher library", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> {
            Object object;
            HashMap<String, String> env = new HashMap<String, String>();
            env.put("YARN_CONF_DIR", this.hadoopConfDir().getAbsolutePath());
            env.put("SPARK_PREFER_IPV6", Boolean.toString(Utils$.MODULE$.preferIPv6()));
            String propsFile = this.createConfFile(this.createConfFile$default$1(), this.createConfFile$default$2());
            SparkAppHandle handle = new SparkLauncher(env).setSparkHome((String)scala.sys.package$.MODULE$.props().apply((Object)"spark.test.home")).setConf(UI$.MODULE$.UI_ENABLED().key(), "false").setPropertiesFile(propsFile).setMaster("yarn").setDeployMode("client").setAppResource("spark-internal").setMainClass(this.mainClassName(YarnLauncherTestApp$.MODULE$.getClass())).startApplication(new SparkAppHandle.Listener[0]);
            try {
                Eventually$.MODULE$.eventually(Eventually$.MODULE$.timeout(Span$.MODULE$.convertDurationToSpan((Duration)new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(3)).minutes())), Eventually$.MODULE$.interval(Span$.MODULE$.convertDurationToSpan((Duration)new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(100)).milliseconds())), (Function0 & Serializable & scala.Serializable)() -> Matchers$.MODULE$.convertToAnyShouldWrapper((Object)handle.getState(), new Position("YarnClusterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 281), Prettifier$.MODULE$.default()).should(this.be().apply((Object)SparkAppHandle.State.RUNNING)), Retrying$.MODULE$.retryingNatureOfT(), new Position("YarnClusterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 280));
                Matchers$.MODULE$.convertToStringShouldWrapper(handle.getAppId(), new Position("YarnClusterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 284), Prettifier$.MODULE$.default()).should(this.not()).be(null, Predef$.MODULE$.$conforms());
                Matchers$.MODULE$.convertToStringShouldWrapper(handle.getAppId(), new Position("YarnClusterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 285), Prettifier$.MODULE$.default()).should(this.startWith().apply("application_"));
                handle.stop();
                object = Eventually$.MODULE$.eventually(Eventually$.MODULE$.timeout(Span$.MODULE$.convertDurationToSpan((Duration)new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(3)).minutes())), Eventually$.MODULE$.interval(Span$.MODULE$.convertDurationToSpan((Duration)new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(100)).milliseconds())), (Function0 & Serializable & scala.Serializable)() -> Matchers$.MODULE$.convertToAnyShouldWrapper((Object)handle.getState(), new Position("YarnClusterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 289), Prettifier$.MODULE$.default()).should(this.be().apply((Object)SparkAppHandle.State.KILLED)), Retrying$.MODULE$.retryingNatureOfT(), new Position("YarnClusterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 288));
            }
            finally {
                handle.kill();
            }
            return object;
        }, new Position("YarnClusterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 263));
        this.test("running Spark in yarn-cluster mode displays driver log links", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> {
            File log4jConf = new File(this.tempDir(), "log4j.properties");
            File logOutFile = new File(this.tempDir(), "logs");
            Files.write((CharSequence)new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(244).append("rootLogger.level = debug\n         |rootLogger.appenderRef.file.ref = file\n         |appender.file.type = File\n         |appender.file.name = file\n         |appender.file.fileName = ").append(logOutFile).append("\n         |appender.file.layout.type = PatternLayout\n         |").toString())).stripMargin(), (File)log4jConf, (Charset)StandardCharsets.UTF_8);
            File confDir = new File(this.tempDir(), "conf");
            confDir.mkdir();
            File javaOptsFile = new File(confDir, "java-opts");
            Files.write((CharSequence)new StringBuilder(34).append("-Dlog4j.configurationFile=file://").append(log4jConf).append("\n").toString(), (File)javaOptsFile, (Charset)StandardCharsets.UTF_8);
            File result = File.createTempFile("result", null, this.tempDir());
            boolean x$10 = false;
            String x$11 = this.mainClassName(YarnClusterDriver$.MODULE$.getClass());
            Seq x$12 = (Seq)new .colon.colon((Object)result.getAbsolutePath(), (List)Nil$.MODULE$);
            Map x$13 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"SPARK_CONF_DIR"), (Object)confDir.getAbsolutePath())}));
            Map x$14 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)package$.MODULE$.CLIENT_INCLUDE_DRIVER_LOGS_LINK().key()), (Object)Boolean.toString(true))}));
            Seq<Tuple2<String, String>> x$15 = this.runSpark$default$4();
            Seq<String> x$16 = this.runSpark$default$5();
            Seq<String> x$17 = this.runSpark$default$6();
            Option<File> x$18 = this.runSpark$default$9();
            SparkAppHandle.State finalState = this.runSpark(x$10, x$11, (Seq<String>)x$12, x$15, x$16, x$17, (Map<String, String>)x$14, (Map<String, String>)x$13, x$18);
            this.checkResult(finalState, result, this.checkResult$default$3(), this.checkResult$default$4());
            String logOutput = Files.toString((File)logOutFile, (Charset)StandardCharsets.UTF_8);
            String logFilePattern = "(?s).+\\sDriver Logs \\(<NAME>\\): https?://.+/<NAME>(\\?\\S+)?\\s.+";
            Matchers$.MODULE$.convertToStringShouldWrapper(logOutput, new Position("YarnClusterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 326), Prettifier$.MODULE$.default()).should(this.fullyMatch()).regex(logFilePattern.replace("<NAME>", "stdout"));
            return Matchers$.MODULE$.convertToStringShouldWrapper(logOutput, new Position("YarnClusterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 327), Prettifier$.MODULE$.default()).should(this.fullyMatch()).regex(logFilePattern.replace("<NAME>", "stderr"));
        }, new Position("YarnClusterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 296));
        this.test("timeout to get SparkContext in cluster mode triggers failure", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> {
            int timeout = 2000;
            boolean x$19 = false;
            String x$20 = this.mainClassName(SparkContextTimeoutApp$.MODULE$.getClass());
            Seq x$21 = (Seq)new .colon.colon((Object)Integer.toString(timeout * 4), (List)Nil$.MODULE$);
            Map x$22 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)package$.MODULE$.AM_MAX_WAIT_TIME().key()), (Object)Integer.toString(timeout))}));
            Seq<Tuple2<String, String>> x$23 = this.runSpark$default$4();
            Seq<String> x$24 = this.runSpark$default$5();
            Seq<String> x$25 = this.runSpark$default$6();
            Map<String, String> x$26 = this.runSpark$default$8();
            Option<File> x$27 = this.runSpark$default$9();
            SparkAppHandle.State finalState = this.runSpark(x$19, x$20, (Seq<String>)x$21, x$23, x$24, x$25, (Map<String, String>)x$22, x$26, x$27);
            return Matchers$.MODULE$.convertToAnyShouldWrapper((Object)finalState, new Position("YarnClusterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 335), Prettifier$.MODULE$.default()).should(this.be().apply((Object)SparkAppHandle.State.FAILED));
        }, new Position("YarnClusterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 330));
        this.test("executor env overwrite AM env in client mode", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.testExecutorEnv(true), new Position("YarnClusterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 338));
        this.test("executor env overwrite AM env in cluster mode", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.testExecutorEnv(false), new Position("YarnClusterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 342));
        this.test("SPARK-34472: ivySettings file with no scheme or file:// scheme should be localized on driver in cluster mode", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            File emptyIvySettings = this.createEmptyIvySettingsFile();
            this.testIvySettingsDistribution(false, emptyIvySettings.getAbsolutePath(), emptyIvySettings.getName(), true);
            this.testIvySettingsDistribution(false, new StringBuilder(7).append("file://").append(emptyIvySettings.getAbsolutePath()).toString(), emptyIvySettings.getName(), true);
        }, new Position("YarnClusterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 452));
        this.test("SPARK-34472: ivySettings file with no scheme or file:// scheme should retain user provided path in client mode", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            File emptyIvySettings = this.createEmptyIvySettingsFile();
            this.testIvySettingsDistribution(true, emptyIvySettings.getAbsolutePath(), emptyIvySettings.getAbsolutePath(), this.testIvySettingsDistribution$default$4());
            this.testIvySettingsDistribution(true, new StringBuilder(7).append("file://").append(emptyIvySettings.getAbsolutePath()).toString(), new StringBuilder(7).append("file://").append(emptyIvySettings.getAbsolutePath()).toString(), this.testIvySettingsDistribution$default$4());
        }, new Position("YarnClusterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 464));
        this.test("SPARK-34472: ivySettings file with non-file:// schemes should throw an error", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> {
            File emptyIvySettings = this.createEmptyIvySettingsFile();
            TestFailedException e1 = (TestFailedException)this.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.testIvySettingsDistribution(false, new StringBuilder(8).append("local://").append(emptyIvySettings.getAbsolutePath()).toString(), "", this.testIvySettingsDistribution$default$4()), ClassTag$.MODULE$.apply(TestFailedException.class), new Position("YarnClusterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 476));
            String $org_scalatest_assert_macro_left = e1.getMessage();
            String $org_scalatest_assert_macro_right = "IllegalArgumentException: Scheme local not supported in spark.jars.ivySettings";
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("YarnClusterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 480));
            TestFailedException e2 = (TestFailedException)this.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.testIvySettingsDistribution(false, new StringBuilder(7).append("hdfs://").append(emptyIvySettings.getAbsolutePath()).toString(), "", this.testIvySettingsDistribution$default$4()), ClassTag$.MODULE$.apply(TestFailedException.class), new Position("YarnClusterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 482));
            String $org_scalatest_assert_macro_left2 = e2.getMessage();
            String $org_scalatest_assert_macro_right2 = "IllegalArgumentException: Scheme hdfs not supported in spark.jars.ivySettings";
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "contains", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.contains($org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("YarnClusterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 486));
        }, new Position("YarnClusterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 474));
    }
}

