/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.deploy.yarn;

import java.io.File;
import java.io.Serializable;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.spark.deploy.yarn.BaseYarnClusterSuite;
import org.apache.spark.deploy.yarn.YarnExternalShuffleDriver$;
import org.apache.spark.deploy.yarn.config.package$;
import org.apache.spark.launcher.SparkAppHandle;
import org.apache.spark.network.shuffledb.DBBackend;
import org.apache.spark.network.yarn.YarnShuffleService;
import org.apache.spark.network.yarn.YarnTestAccessor$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.Tag;
import scala.Function0;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u00013Q!\u0002\u0004\u0002\u0002EAQA\u0006\u0001\u0005\u0002]AQ!\u0007\u0001\u0007\u0012iAQa\t\u0001\u0005B\u0011BQA\f\u0001\u0005\u0012=\u00121$W1s]NCWO\u001a4mK&sG/Z4sCRLwN\\*vSR,'BA\u0004\t\u0003\u0011I\u0018M\u001d8\u000b\u0005%Q\u0011A\u00023fa2|\u0017P\u0003\u0002\f\u0019\u0005)1\u000f]1sW*\u0011QBD\u0001\u0007CB\f7\r[3\u000b\u0003=\t1a\u001c:h\u0007\u0001\u0019\"\u0001\u0001\n\u0011\u0005M!R\"\u0001\u0004\n\u0005U1!\u0001\u0006\"bg\u0016L\u0016M\u001d8DYV\u001cH/\u001a:Tk&$X-\u0001\u0004=S:LGO\u0010\u000b\u00021A\u00111\u0003A\u0001\nI\n\u0014\u0015mY6f]\u0012,\u0012a\u0007\t\u00039\u0005j\u0011!\b\u0006\u0003=}\t\u0011b\u001d5vM\u001adW\r\u001a2\u000b\u0005\u0001R\u0011a\u00028fi^|'o[\u0005\u0003Eu\u0011\u0011\u0002\u0012\"CC\u000e\\WM\u001c3\u0002\u001b9,w/W1s]\u000e{gNZ5h)\u0005)\u0003C\u0001\u0014-\u001b\u00059#B\u0001\u0015*\u0003\u0011\u0019wN\u001c4\u000b\u0005\u001dQ#BA\u0016\r\u0003\u0019A\u0017\rZ8pa&\u0011Qf\n\u0002\u00123\u0006\u0014hnQ8oM&<WO]1uS>t\u0017AD3yiJ\f7\u000b]1sW\u000e{gN\u001a\u000b\u0002aA!\u0011GO\u001f>\u001d\t\u0011\u0004\b\u0005\u00024m5\tAG\u0003\u00026!\u00051AH]8pizR\u0011aN\u0001\u0006g\u000e\fG.Y\u0005\u0003sY\na\u0001\u0015:fI\u00164\u0017BA\u001e=\u0005\ri\u0015\r\u001d\u0006\u0003sY\u0002\"!\r \n\u0005}b$AB*ue&tw\r")
public abstract class YarnShuffleIntegrationSuite
extends BaseYarnClusterSuite {
    public abstract DBBackend dbBackend();

    @Override
    public YarnConfiguration newYarnConfig() {
        YarnConfiguration yarnConfig = new YarnConfiguration();
        yarnConfig.set("yarn.nodemanager.aux-services", "spark_shuffle");
        yarnConfig.set(new StringOps(Predef$.MODULE$.augmentString("yarn.nodemanager.aux-services.%s.class")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"spark_shuffle"})), YarnShuffleService.class.getCanonicalName());
        yarnConfig.set(org.apache.spark.internal.config.package$.MODULE$.SHUFFLE_SERVICE_PORT().key(), "0");
        yarnConfig.set(org.apache.spark.internal.config.package$.MODULE$.SHUFFLE_SERVICE_DB_BACKEND().key(), this.dbBackend().name());
        yarnConfig.set(YarnTestAccessor$.MODULE$.shuffleServiceIntegrationTestingKey(), "true");
        return yarnConfig;
    }

    public Map<String, String> extraSparkConf() {
        int shuffleServicePort = YarnTestAccessor$.MODULE$.getShuffleServicePort();
        YarnShuffleService shuffleService = YarnTestAccessor$.MODULE$.getShuffleServiceInstance();
        this.logInfo((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(23).append("Shuffle service port = ").append(shuffleServicePort).toString());
        return (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)org.apache.spark.internal.config.package$.MODULE$.SHUFFLE_SERVICE_ENABLED().key()), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)org.apache.spark.internal.config.package$.MODULE$.SHUFFLE_SERVICE_PORT().key()), (Object)Integer.toString(shuffleServicePort)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)package$.MODULE$.MAX_EXECUTOR_FAILURES().key()), (Object)"1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)org.apache.spark.internal.config.package$.MODULE$.SHUFFLE_SERVICE_DB_BACKEND().key()), (Object)this.dbBackend().name())}));
    }

    public YarnShuffleIntegrationSuite() {
        this.test("external shuffle service", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> {
            File registeredExecFile;
            int shuffleServicePort = YarnTestAccessor$.MODULE$.getShuffleServicePort();
            YarnShuffleService shuffleService = YarnTestAccessor$.MODULE$.getShuffleServiceInstance();
            File $org_scalatest_assert_macro_left = registeredExecFile = YarnTestAccessor$.MODULE$.getRegisteredExecutorFile(shuffleService);
            Object $org_scalatest_assert_macro_right = null;
            File file = $org_scalatest_assert_macro_left;
            Object var7_6 = null;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "!=", null, file == null ? var7_6 != null : !((Object)file).equals(var7_6), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("YarnShuffleIntegrationSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 75));
            File result = File.createTempFile("result", null, this.tempDir());
            boolean x$1 = false;
            String x$2 = this.mainClassName(YarnExternalShuffleDriver$.MODULE$.getClass());
            Seq x$3 = (Seq)new .colon.colon((Object)result.getAbsolutePath(), (List)new .colon.colon((Object)registeredExecFile.getAbsolutePath(), (List)Nil$.MODULE$));
            Map<String, String> x$4 = this.extraSparkConf();
            Seq<Tuple2<String, String>> x$5 = this.runSpark$default$4();
            Seq<String> x$6 = this.runSpark$default$5();
            Seq<String> x$7 = this.runSpark$default$6();
            Map<String, String> x$8 = this.runSpark$default$8();
            Option<File> x$9 = this.runSpark$default$9();
            SparkAppHandle.State finalState = this.runSpark(x$1, x$2, (Seq<String>)x$3, x$5, x$6, x$7, x$4, x$8, x$9);
            this.checkResult(finalState, result, this.checkResult$default$3(), this.checkResult$default$4());
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(YarnTestAccessor$.MODULE$.getRegisteredExecutorFile(shuffleService).exists(), "org.apache.spark.network.yarn.YarnTestAccessor.getRegisteredExecutorFile(shuffleService).exists()", Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("YarnShuffleIntegrationSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 86));
        }, new Position("YarnShuffleIntegrationSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 70));
    }
}

