/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.deploy.yarn;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Map;
import org.apache.hadoop.yarn.api.records.ContainerLaunchContext;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.util.Records;
import org.apache.spark.SecurityManager;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.deploy.yarn.ExecutorRunnable;
import org.apache.spark.deploy.yarn.ExecutorRunnable$;
import org.apache.spark.internal.config.package$;
import org.apache.spark.network.util.JavaUtils;
import org.mockito.Mockito;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.Tag;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001i2A!\u0002\u0004\u0001#!)a\u0003\u0001C\u0001/!)!\u0004\u0001C\u00057!9\u0011\u0006AI\u0001\n\u0013Q\u0003bB\u001c\u0001#\u0003%I\u0001\u000f\u0002\u0016\u000bb,7-\u001e;peJ+hN\\1cY\u0016\u001cV/\u001b;f\u0015\t9\u0001\"\u0001\u0003zCJt'BA\u0005\u000b\u0003\u0019!W\r\u001d7ps*\u00111\u0002D\u0001\u0006gB\f'o\u001b\u0006\u0003\u001b9\ta!\u00199bG\",'\"A\b\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0005\u0001\u0011\u0002CA\n\u0015\u001b\u0005Q\u0011BA\u000b\u000b\u00055\u0019\u0006/\u0019:l\rVt7+^5uK\u00061A(\u001b8jiz\"\u0012\u0001\u0007\t\u00033\u0001i\u0011AB\u0001\u0017GJ,\u0017\r^3Fq\u0016\u001cW\u000f^8s%Vtg.\u00192mKR\u0019Ad\b\u0013\u0011\u0005ei\u0012B\u0001\u0010\u0007\u0005A)\u00050Z2vi>\u0014(+\u001e8oC\ndW\rC\u0004!\u0005A\u0005\t\u0019A\u0011\u0002\u0013M\u0004\u0018M]6D_:4\u0007CA\n#\u0013\t\u0019#BA\u0005Ta\u0006\u00148nQ8oM\"9QE\u0001I\u0001\u0002\u00041\u0013aD:fGV\u0014\u0018\u000e^=NC:\fw-\u001a:\u0011\u0005M9\u0013B\u0001\u0015\u000b\u0005=\u0019VmY;sSRLX*\u00198bO\u0016\u0014\u0018\u0001I2sK\u0006$X-\u0012=fGV$xN\u001d*v]:\f'\r\\3%I\u00164\u0017-\u001e7uIE*\u0012a\u000b\u0016\u0003C1Z\u0013!\f\t\u0003]Uj\u0011a\f\u0006\u0003aE\n\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0005I\u001a\u0014AC1o]>$\u0018\r^5p]*\tA'A\u0003tG\u0006d\u0017-\u0003\u00027_\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002A\r\u0014X-\u0019;f\u000bb,7-\u001e;peJ+hN\\1cY\u0016$C-\u001a4bk2$HEM\u000b\u0002s)\u0012a\u0005\f")
public class ExecutorRunnableSuite
extends SparkFunSuite {
    private ExecutorRunnable createExecutorRunnable(SparkConf sparkConf, SecurityManager securityManager) {
        return new ExecutorRunnable((Option)None$.MODULE$, new YarnConfiguration(), sparkConf, "yarn", "exec-1", "localhost", 1, 1, "application_123_1", securityManager, Predef$.MODULE$.Map().empty(), 0);
    }

    private SparkConf createExecutorRunnable$default$1() {
        return new SparkConf();
    }

    private SecurityManager createExecutorRunnable$default$2() {
        return (SecurityManager)Mockito.mock(SecurityManager.class);
    }

    public ExecutorRunnableSuite() {
        ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapBooleanArray(new boolean[]{true, false}))).foreach((Function1 & Serializable & scala.Serializable)shuffleServerRecoveryDisabled -> {
            this.test(new StringBuilder(61).append("validate service data when $shuffleServerRecoveryDisabled is ").append(BoxesRunTime.unboxToBoolean((Object)shuffleServerRecoveryDisabled)).toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
                String string;
                ByteBuffer serviceData;
                SparkConf sparkConf = new SparkConf();
                sparkConf.set(package$.MODULE$.SHUFFLE_SERVER_RECOVERY_DISABLED(), (Object)BoxesRunTime.boxToBoolean((boolean)shuffleServerRecoveryDisabled));
                SecurityManager securityManager = (SecurityManager)Mockito.mock(SecurityManager.class);
                Mockito.when((Object)securityManager.getSecretKey()).thenReturn((Object)"secret");
                ExecutorRunnable execRunnable = $this.createExecutorRunnable(sparkConf, securityManager);
                ContainerLaunchContext ctx = (ContainerLaunchContext)Records.newRecord(ContainerLaunchContext.class);
                execRunnable.configureServiceData(ctx);
                String serviceName = (String)sparkConf.get(package$.MODULE$.SHUFFLE_SERVICE_NAME());
                ByteBuffer $org_scalatest_assert_macro_left = serviceData = (ByteBuffer)ctx.getServiceData().get(serviceName);
                Object $org_scalatest_assert_macro_right = null;
                ByteBuffer byteBuffer = $org_scalatest_assert_macro_left;
                Object var11_10 = null;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "!=", null, byteBuffer == null ? var11_10 != null : !((Object)byteBuffer).equals(var11_10), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ExecutorRunnableSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 66));
                String payload = JavaUtils.bytesToString((ByteBuffer)serviceData);
                Map metaInfo = null;
                try {
                    ObjectMapper mapper = new ObjectMapper();
                    metaInfo = (Map)mapper.readValue(payload, (TypeReference)new TypeReference<Map<String, Object>>(null){});
                    string = (String)metaInfo.get(ExecutorRunnable$.MODULE$.SECRET_KEY());
                }
                catch (IOException iOException) {
                    string = payload;
                }
                String secret = string;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(secret.equals("secret"), "secret.equals(\"secret\")", Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ExecutorRunnableSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 78));
                if (shuffleServerRecoveryDisabled) {
                    Object metadataStorageVal;
                    Map $org_scalatest_assert_macro_left2 = metaInfo;
                    Object $org_scalatest_assert_macro_right2 = null;
                    Map map = $org_scalatest_assert_macro_left2;
                    Object var20_19 = null;
                    Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "!=", null, map == null ? var20_19 != null : !((Object)map).equals(var20_19), Prettifier$.MODULE$.default());
                    Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("ExecutorRunnableSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 80));
                    Object $org_scalatest_assert_macro_left3 = metadataStorageVal = metaInfo.get(package$.MODULE$.SHUFFLE_SERVER_RECOVERY_DISABLED().key());
                    Object $org_scalatest_assert_macro_right3 = null;
                    Object v = $org_scalatest_assert_macro_left3;
                    Object var26_24 = null;
                    Bool $org_scalatest_assert_macro_left4 = Bool$.MODULE$.binaryMacroBool($org_scalatest_assert_macro_left3, "!=", null, v == null ? var26_24 != null : !v.equals(var26_24), Prettifier$.MODULE$.default());
                    Bool $org_scalatest_assert_macro_right4 = $org_scalatest_assert_macro_left4.value() ? Bool$.MODULE$.simpleMacroBool(BoxesRunTime.unboxToBoolean(metadataStorageVal), "metadataStorageVal.asInstanceOf[Boolean]", Prettifier$.MODULE$.default()) : Bool$.MODULE$.simpleMacroBool(false, "", Prettifier$.MODULE$.default());
                    Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "&&", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.$amp$amp((Function0 & Serializable & scala.Serializable)() -> $org_scalatest_assert_macro_right4), Prettifier$.MODULE$.default());
                    return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("ExecutorRunnableSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 82));
                }
                return BoxedUnit.UNIT;
            }, new Position("ExecutorRunnableSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 55));
            return BoxedUnit.UNIT;
        });
        this.test("if shuffle server recovery is disabled and authentication is disabled, then service data should not contain secret", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Object metadataStorageVal;
            ByteBuffer serviceData;
            SparkConf sparkConf = new SparkConf();
            sparkConf.set(package$.MODULE$.SHUFFLE_SERVER_RECOVERY_DISABLED(), (Object)BoxesRunTime.boxToBoolean((boolean)true));
            ExecutorRunnable execRunnable = this.createExecutorRunnable(sparkConf, this.createExecutorRunnable$default$2());
            ContainerLaunchContext ctx = (ContainerLaunchContext)Records.newRecord(ContainerLaunchContext.class);
            execRunnable.configureServiceData(ctx);
            String serviceName = (String)sparkConf.get(package$.MODULE$.SHUFFLE_SERVICE_NAME());
            ByteBuffer $org_scalatest_assert_macro_left = serviceData = (ByteBuffer)ctx.getServiceData().get(serviceName);
            Object $org_scalatest_assert_macro_right = null;
            ByteBuffer byteBuffer = $org_scalatest_assert_macro_left;
            Object var9_8 = null;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "!=", null, byteBuffer == null ? var9_8 != null : !((Object)byteBuffer).equals(var9_8), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ExecutorRunnableSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 97));
            String payload = JavaUtils.bytesToString((ByteBuffer)serviceData);
            ObjectMapper mapper = new ObjectMapper();
            Map metaInfo = (Map)mapper.readValue(payload, (TypeReference)new TypeReference<Map<String, Object>>(null){});
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(metaInfo.containsKey(ExecutorRunnable$.MODULE$.SECRET_KEY()), "metaInfo.containsKey(ExecutorRunnable.SECRET_KEY)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ExecutorRunnableSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 102));
            Object $org_scalatest_assert_macro_left2 = metadataStorageVal = metaInfo.get(package$.MODULE$.SHUFFLE_SERVER_RECOVERY_DISABLED().key());
            Object $org_scalatest_assert_macro_right2 = null;
            Object v = $org_scalatest_assert_macro_left2;
            Object var19_17 = null;
            Bool $org_scalatest_assert_macro_left3 = Bool$.MODULE$.binaryMacroBool($org_scalatest_assert_macro_left2, "!=", null, v == null ? var19_17 != null : !v.equals(var19_17), Prettifier$.MODULE$.default());
            Bool $org_scalatest_assert_macro_right3 = $org_scalatest_assert_macro_left3.value() ? Bool$.MODULE$.simpleMacroBool(BoxesRunTime.unboxToBoolean(metadataStorageVal), "metadataStorageVal.asInstanceOf[Boolean]", Prettifier$.MODULE$.default()) : Bool$.MODULE$.simpleMacroBool(false, "", Prettifier$.MODULE$.default());
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "&&", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$amp$amp((Function0 & Serializable & scala.Serializable)() -> $org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("ExecutorRunnableSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 104));
        }, new Position("ExecutorRunnableSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 88));
    }
}

