/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.connector.common;

import java.util.List;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericRecord;
import org.apache.sqoop.classification.InterfaceAudience;
import org.apache.sqoop.classification.InterfaceStability;
import org.apache.sqoop.schema.type.Binary;
import org.apache.sqoop.schema.type.Bit;
import org.apache.sqoop.schema.type.Column;
import org.apache.sqoop.schema.type.FixedPoint;
import org.apache.sqoop.schema.type.FloatingPoint;
import org.apache.sqoop.schema.type.Text;
import org.apache.sqoop.schema.type.Unknown;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class AvroDataTypeUtil {
    public static org.apache.sqoop.schema.Schema createSqoopSchema(Schema avroSchema) {
        org.apache.sqoop.schema.Schema schema = new org.apache.sqoop.schema.Schema(avroSchema.getName());
        schema.setNote(avroSchema.getDoc());
        for (Schema.Field field : avroSchema.getFields()) {
            Column column = AvroDataTypeUtil.avroTypeToSchemaType(field);
            schema.addColumn(column);
        }
        return schema;
    }

    private static Column avroTypeToSchemaType(Schema.Field field) {
        Schema.Type schemaType = field.schema().getType();
        if (schemaType == Schema.Type.UNION) {
            List unionSchema = field.schema().getTypes();
            if (unionSchema.size() == 2) {
                Schema.Type first = ((Schema)unionSchema.get(0)).getType();
                Schema.Type second = ((Schema)unionSchema.get(1)).getType();
                if (first == Schema.Type.NULL && second != Schema.Type.NULL || first != Schema.Type.NULL && second == Schema.Type.NULL) {
                    return AvroDataTypeUtil.avroPrimitiveTypeToSchemaType(field.name(), first != Schema.Type.NULL ? first : second);
                }
            }
            return new Unknown(field.name());
        }
        return AvroDataTypeUtil.avroPrimitiveTypeToSchemaType(field.name(), schemaType);
    }

    private static Column avroPrimitiveTypeToSchemaType(String name, Schema.Type type) {
        assert (type != Schema.Type.UNION);
        switch (type) {
            case INT: {
                return new FixedPoint(name, Long.valueOf(4L), Boolean.valueOf(true));
            }
            case LONG: {
                return new FixedPoint(name, Long.valueOf(8L), Boolean.valueOf(true));
            }
            case STRING: {
                return new Text(name);
            }
            case DOUBLE: {
                return new FloatingPoint(name, Long.valueOf(8L));
            }
            case BOOLEAN: {
                return new Bit(name);
            }
            case BYTES: {
                return new Binary(name);
            }
        }
        return new Unknown(name);
    }

    public static Object[] extractGenericRecord(GenericRecord data) {
        List fields = data.getSchema().getFields();
        Object[] record = new Object[fields.size()];
        for (int i = 0; i < fields.size(); ++i) {
            record[i] = data.get(i);
        }
        return record;
    }
}

