/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.connector.idf;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Set;
import org.apache.log4j.Logger;
import org.apache.sqoop.classification.InterfaceAudience;
import org.apache.sqoop.classification.InterfaceStability;
import org.apache.sqoop.connector.common.SqoopIDFUtils;
import org.apache.sqoop.connector.idf.IntermediateDataFormat;
import org.apache.sqoop.schema.Schema;

@InterfaceAudience.Public
@InterfaceStability.Unstable
public class CSVIntermediateDataFormat
extends IntermediateDataFormat<String> {
    public static final Logger LOG = Logger.getLogger(CSVIntermediateDataFormat.class);

    public CSVIntermediateDataFormat() {
    }

    public CSVIntermediateDataFormat(Schema schema) {
        super.setSchema(schema);
    }

    @Override
    public String getCSVTextData() {
        return (String)super.getData();
    }

    @Override
    public void setCSVTextData(String csvText) {
        super.setData(csvText);
    }

    @Override
    public Object[] getObjectData() {
        super.validateSchema(this.schema);
        return SqoopIDFUtils.fromCSV((String)this.data, this.schema);
    }

    @Override
    public void setObjectData(Object[] data) {
        super.validateSchema(this.schema);
        this.data = this.toCSV(data);
    }

    @Override
    public void write(DataOutput out) throws IOException {
        out.writeUTF((String)this.data);
    }

    @Override
    public void read(DataInput in) throws IOException {
        this.data = in.readUTF();
    }

    private String toCSV(Object[] objectArray) {
        return SqoopIDFUtils.toCSV(objectArray, this.schema);
    }

    @Override
    public Set<String> getJars() {
        return super.getJars();
    }
}

