/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.connector.idf;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.apache.sqoop.classification.InterfaceAudience;
import org.apache.sqoop.classification.InterfaceStability;
import org.apache.sqoop.common.ErrorCode;
import org.apache.sqoop.common.SqoopException;
import org.apache.sqoop.error.code.IntermediateDataFormatError;
import org.apache.sqoop.schema.Schema;
import org.apache.sqoop.utils.ClassUtils;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;
import org.joda.time.LocalDateTime;
import org.joda.time.LocalTime;
import org.json.simple.JSONValue;

@InterfaceAudience.Public
@InterfaceStability.Unstable
public abstract class IntermediateDataFormat<T>
implements Comparable {
    protected volatile T data;
    protected Schema schema;

    public T getData() {
        this.validateSchema(this.schema);
        return this.data;
    }

    public void setData(T obj) {
        this.validateSchema(this.schema);
        this.data = obj;
    }

    public abstract String getCSVTextData();

    public abstract void setCSVTextData(String var1);

    public abstract Object[] getObjectData();

    public abstract void setObjectData(Object[] var1);

    public void setSchema(Schema schema) {
        this.validateSchema(schema);
        this.schema = schema;
    }

    protected void validateSchema(Schema schema) {
        if (schema == null) {
            throw new SqoopException((ErrorCode)IntermediateDataFormatError.INTERMEDIATE_DATA_FORMAT_0002);
        }
    }

    public abstract void write(DataOutput var1) throws IOException;

    public abstract void read(DataInput var1) throws IOException;

    public Set<String> getJars() {
        HashSet<String> jars = new HashSet<String>();
        jars.add(ClassUtils.jarForClass(LocalDate.class));
        jars.add(ClassUtils.jarForClass(LocalDateTime.class));
        jars.add(ClassUtils.jarForClass(DateTime.class));
        jars.add(ClassUtils.jarForClass(LocalTime.class));
        jars.add(ClassUtils.jarForClass(JSONValue.class));
        return jars;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.data == null ? 0 : this.data.hashCode());
        result = 31 * result + (this.schema == null ? 0 : this.schema.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        IntermediateDataFormat other = (IntermediateDataFormat)obj;
        if (this.data == null ? other.data != null : !this.data.equals(other.data)) {
            return false;
        }
        return !(this.schema == null ? other.schema != null : !this.schema.equals((Object)other.schema));
    }

    public String toString() {
        return this.data.toString();
    }

    public int compareTo(Object o) {
        IntermediateDataFormat idf = (IntermediateDataFormat)o;
        return this.toString().compareTo(idf.toString());
    }
}

