/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.connector.idf;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import org.apache.commons.codec.binary.Base64;
import org.apache.sqoop.classification.InterfaceAudience;
import org.apache.sqoop.classification.InterfaceStability;
import org.apache.sqoop.common.ErrorCode;
import org.apache.sqoop.common.SqoopException;
import org.apache.sqoop.connector.common.SqoopIDFUtils;
import org.apache.sqoop.connector.idf.IntermediateDataFormat;
import org.apache.sqoop.error.code.IntermediateDataFormatError;
import org.apache.sqoop.error.code.JSONIntermediateDataFormatError;
import org.apache.sqoop.schema.Schema;
import org.apache.sqoop.schema.type.Column;
import org.apache.sqoop.utils.ClassUtils;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

@InterfaceAudience.Public
@InterfaceStability.Unstable
@SuppressWarnings(value={"PZLA_PREFER_ZERO_LENGTH_ARRAYS"})
public class JSONIntermediateDataFormat
extends IntermediateDataFormat<JSONObject> {
    public JSONIntermediateDataFormat() {
    }

    public JSONIntermediateDataFormat(Schema schema) {
        this.setSchema(schema);
    }

    @Override
    public void setCSVTextData(String text) {
        super.validateSchema(this.schema);
        this.data = this.toJSON(text);
    }

    @Override
    public String getCSVTextData() {
        super.validateSchema(this.schema);
        return this.toCSV((JSONObject)this.data);
    }

    @Override
    public void setObjectData(Object[] data) {
        super.validateSchema(this.schema);
        this.data = this.toJSON(data);
    }

    @Override
    public Object[] getObjectData() {
        super.validateSchema(this.schema);
        return this.toObject((JSONObject)this.data);
    }

    @Override
    public void write(DataOutput out) throws IOException {
        out.writeUTF(((JSONObject)this.data).toJSONString());
    }

    @Override
    public void read(DataInput in) throws IOException {
        try {
            this.data = (JSONObject)new JSONParser().parse(in.readUTF());
        }
        catch (ParseException e) {
            throw new SqoopException((ErrorCode)JSONIntermediateDataFormatError.JSON_INTERMEDIATE_DATA_FORMAT_0002, (Throwable)e);
        }
    }

    @Override
    public Set<String> getJars() {
        Set<String> jars = super.getJars();
        jars.add(ClassUtils.jarForClass(JSONObject.class));
        jars.add(ClassUtils.jarForClass(JSONArray.class));
        return jars;
    }

    private JSONObject toJSON(String csv) {
        String[] csvStringArray = SqoopIDFUtils.parseCSVString(csv);
        if (csvStringArray == null) {
            return null;
        }
        Column[] columns = this.schema.getColumnsArray();
        if (csvStringArray.length != columns.length) {
            throw new SqoopException((ErrorCode)IntermediateDataFormatError.INTERMEDIATE_DATA_FORMAT_0001, "The data " + csv + " has the wrong number of fields.");
        }
        JSONObject object = new JSONObject();
        for (int i = 0; i < csvStringArray.length; ++i) {
            if (csvStringArray[i].equals("NULL") && !columns[i].isNullable().booleanValue()) {
                throw new SqoopException((ErrorCode)IntermediateDataFormatError.INTERMEDIATE_DATA_FORMAT_0005, columns[i].getName() + " does not support null values");
            }
            if (csvStringArray[i].equals("NULL")) {
                object.put((Object)columns[i].getName(), null);
                continue;
            }
            object.put((Object)columns[i].getName(), this.toJSON(csvStringArray[i], columns[i]));
        }
        return object;
    }

    private Object toJSON(String csvString, Column column) {
        Object returnValue = null;
        switch (column.getType()) {
            case ARRAY: 
            case SET: {
                try {
                    returnValue = (JSONArray)new JSONParser().parse(SqoopIDFUtils.removeQuotes(csvString));
                    break;
                }
                catch (ParseException e) {
                    throw new SqoopException((ErrorCode)JSONIntermediateDataFormatError.JSON_INTERMEDIATE_DATA_FORMAT_0002, (Throwable)e);
                }
            }
            case MAP: {
                try {
                    returnValue = (JSONObject)new JSONParser().parse(SqoopIDFUtils.removeQuotes(csvString));
                    break;
                }
                catch (ParseException e) {
                    throw new SqoopException((ErrorCode)JSONIntermediateDataFormatError.JSON_INTERMEDIATE_DATA_FORMAT_0002, (Throwable)e);
                }
            }
            case ENUM: 
            case TEXT: {
                returnValue = SqoopIDFUtils.toText(csvString);
                break;
            }
            case BINARY: 
            case UNKNOWN: {
                returnValue = Base64.encodeBase64String((byte[])SqoopIDFUtils.toByteArray(csvString));
                break;
            }
            case FIXED_POINT: {
                returnValue = SqoopIDFUtils.toFixedPoint(csvString, column);
                break;
            }
            case FLOATING_POINT: {
                returnValue = SqoopIDFUtils.toFloatingPoint(csvString, column);
                break;
            }
            case DECIMAL: {
                returnValue = SqoopIDFUtils.toDecimal(csvString, column);
                break;
            }
            case DATE: 
            case TIME: 
            case DATE_TIME: {
                returnValue = SqoopIDFUtils.removeQuotes(csvString);
                break;
            }
            case BIT: {
                returnValue = Boolean.valueOf(SqoopIDFUtils.removeQuotes(csvString));
                break;
            }
            default: {
                throw new SqoopException((ErrorCode)IntermediateDataFormatError.INTERMEDIATE_DATA_FORMAT_0004, "Column type from schema was not recognized for " + column.getType());
            }
        }
        return returnValue;
    }

    private JSONObject toJSON(Object[] objectArray) {
        if (objectArray == null) {
            return null;
        }
        Column[] columns = this.schema.getColumnsArray();
        if (objectArray.length != columns.length) {
            throw new SqoopException((ErrorCode)IntermediateDataFormatError.INTERMEDIATE_DATA_FORMAT_0001, "The data " + Arrays.toString(objectArray) + " has the wrong number of fields.");
        }
        JSONObject json = new JSONObject();
        block10: for (int i = 0; i < objectArray.length; ++i) {
            if (objectArray[i] == null && !columns[i].isNullable().booleanValue()) {
                throw new SqoopException((ErrorCode)IntermediateDataFormatError.INTERMEDIATE_DATA_FORMAT_0005, columns[i].getName() + " does not support null values");
            }
            if (objectArray[i] == null) {
                json.put((Object)columns[i].getName(), null);
                continue;
            }
            switch (columns[i].getType()) {
                case ARRAY: 
                case SET: {
                    Object[] objArray = (Object[])objectArray[i];
                    JSONArray jsonArray = SqoopIDFUtils.toJSONArray(objArray);
                    json.put((Object)columns[i].getName(), (Object)jsonArray);
                    continue block10;
                }
                case MAP: {
                    Map map = (Map)objectArray[i];
                    JSONObject jsonObject = new JSONObject();
                    jsonObject.putAll(map);
                    json.put((Object)columns[i].getName(), (Object)jsonObject);
                    continue block10;
                }
                case BINARY: 
                case UNKNOWN: {
                    json.put((Object)columns[i].getName(), (Object)Base64.encodeBase64String((byte[])((byte[])objectArray[i])));
                    continue block10;
                }
                case ENUM: 
                case TEXT: 
                case FIXED_POINT: 
                case FLOATING_POINT: 
                case DECIMAL: {
                    json.put((Object)columns[i].getName(), objectArray[i]);
                    continue block10;
                }
                case DATE_TIME: {
                    json.put((Object)columns[i].getName(), (Object)SqoopIDFUtils.removeQuotes(SqoopIDFUtils.toCSVDateTime(objectArray[i], columns[i])));
                    continue block10;
                }
                case TIME: {
                    json.put((Object)columns[i].getName(), (Object)SqoopIDFUtils.removeQuotes(SqoopIDFUtils.toCSVTime(objectArray[i], columns[i])));
                    continue block10;
                }
                case DATE: {
                    json.put((Object)columns[i].getName(), (Object)SqoopIDFUtils.removeQuotes(SqoopIDFUtils.toCSVDate(objectArray[i])));
                    continue block10;
                }
                case BIT: {
                    json.put((Object)columns[i].getName(), (Object)Boolean.valueOf(SqoopIDFUtils.toCSVBit(objectArray[i])));
                    continue block10;
                }
                default: {
                    throw new SqoopException((ErrorCode)IntermediateDataFormatError.INTERMEDIATE_DATA_FORMAT_0001, "Column type from schema was not recognized for " + columns[i].getType());
                }
            }
        }
        return json;
    }

    private String toCSV(JSONObject json) {
        Column[] columns = this.schema.getColumnsArray();
        StringBuilder csvString = new StringBuilder();
        for (int i = 0; i < columns.length; ++i) {
            Object obj = json.get((Object)columns[i].getName());
            if (obj == null && !columns[i].isNullable().booleanValue()) {
                throw new SqoopException((ErrorCode)IntermediateDataFormatError.INTERMEDIATE_DATA_FORMAT_0005, columns[i].getName() + " does not support null values");
            }
            if (obj == null) {
                csvString.append("NULL");
            } else {
                switch (columns[i].getType()) {
                    case ARRAY: 
                    case SET: {
                        JSONArray array = (JSONArray)obj;
                        csvString.append(SqoopIDFUtils.encloseWithQuotes(array.toJSONString()));
                        break;
                    }
                    case MAP: {
                        csvString.append(SqoopIDFUtils.encloseWithQuotes(((JSONObject)obj).toJSONString()));
                        break;
                    }
                    case ENUM: 
                    case TEXT: {
                        csvString.append(SqoopIDFUtils.toCSVString(obj.toString()));
                        break;
                    }
                    case BINARY: 
                    case UNKNOWN: {
                        csvString.append(SqoopIDFUtils.toCSVByteArray(Base64.decodeBase64((String)obj.toString())));
                        break;
                    }
                    case FIXED_POINT: {
                        csvString.append(SqoopIDFUtils.toCSVFixedPoint(obj, columns[i]));
                        break;
                    }
                    case FLOATING_POINT: {
                        csvString.append(SqoopIDFUtils.toCSVFloatingPoint(obj, columns[i]));
                        break;
                    }
                    case DECIMAL: {
                        csvString.append(SqoopIDFUtils.toCSVDecimal(obj));
                        break;
                    }
                    case DATE: 
                    case TIME: 
                    case DATE_TIME: {
                        csvString.append(SqoopIDFUtils.encloseWithQuotes(obj.toString()));
                        break;
                    }
                    case BIT: {
                        csvString.append(SqoopIDFUtils.toCSVBit(obj));
                        break;
                    }
                    default: {
                        throw new SqoopException((ErrorCode)IntermediateDataFormatError.INTERMEDIATE_DATA_FORMAT_0001, "Column type from schema was not recognized for " + columns[i].getType());
                    }
                }
            }
            if (i >= columns.length - 1) continue;
            csvString.append(',');
        }
        return csvString.toString();
    }

    private Object[] toObject(JSONObject json) {
        if (json == null) {
            return null;
        }
        Column[] columns = this.schema.getColumnsArray();
        Object[] object = new Object[columns.length];
        Set entrySet = json.entrySet();
        block13: for (Map.Entry entry : entrySet) {
            Integer nameIndex = this.schema.getColumnNameIndex((String)entry.getKey());
            Column column = columns[nameIndex];
            Object obj = entry.getValue();
            if (obj == null && !column.isNullable().booleanValue()) {
                throw new SqoopException((ErrorCode)IntermediateDataFormatError.INTERMEDIATE_DATA_FORMAT_0005, column.getName() + " does not support null values");
            }
            if (obj == null) {
                object[nameIndex.intValue()] = null;
                continue;
            }
            switch (column.getType()) {
                case ARRAY: 
                case SET: {
                    object[nameIndex.intValue()] = SqoopIDFUtils.toList((JSONArray)obj).toArray();
                    continue block13;
                }
                case MAP: {
                    object[nameIndex.intValue()] = SqoopIDFUtils.toMap((JSONObject)obj);
                    continue block13;
                }
                case ENUM: 
                case TEXT: {
                    object[nameIndex.intValue()] = SqoopIDFUtils.toText(obj.toString());
                    continue block13;
                }
                case BINARY: 
                case UNKNOWN: {
                    object[nameIndex.intValue()] = Base64.decodeBase64((String)obj.toString());
                    continue block13;
                }
                case FIXED_POINT: {
                    object[nameIndex.intValue()] = SqoopIDFUtils.toFixedPoint(obj.toString(), column);
                    continue block13;
                }
                case FLOATING_POINT: {
                    object[nameIndex.intValue()] = SqoopIDFUtils.toFloatingPoint(obj.toString(), column);
                    continue block13;
                }
                case DECIMAL: {
                    object[nameIndex.intValue()] = SqoopIDFUtils.toDecimal(obj.toString(), column);
                    continue block13;
                }
                case DATE: {
                    object[nameIndex.intValue()] = SqoopIDFUtils.toDate(obj.toString(), column);
                    continue block13;
                }
                case TIME: {
                    object[nameIndex.intValue()] = SqoopIDFUtils.toTime(obj.toString(), column);
                    continue block13;
                }
                case DATE_TIME: {
                    object[nameIndex.intValue()] = SqoopIDFUtils.toDateTime(obj.toString(), column);
                    continue block13;
                }
                case BIT: {
                    object[nameIndex.intValue()] = SqoopIDFUtils.toBit(obj.toString());
                    continue block13;
                }
            }
            throw new SqoopException((ErrorCode)IntermediateDataFormatError.INTERMEDIATE_DATA_FORMAT_0001, "Column type from schema was not recognized for " + column.getType());
        }
        return object;
    }

    @Override
    public String toString() {
        return ((JSONObject)this.data).toJSONString();
    }
}

