/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.connector.matcher;

import java.util.HashMap;
import org.apache.sqoop.classification.InterfaceAudience;
import org.apache.sqoop.classification.InterfaceStability;
import org.apache.sqoop.connector.matcher.Matcher;
import org.apache.sqoop.schema.Schema;
import org.apache.sqoop.schema.type.Column;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class NameMatcher
extends Matcher {
    private HashMap<String, Integer> fromColNameIndexMap = new HashMap();

    public NameMatcher(Schema from, Schema to) {
        super(from, to);
        int fromIndex = 0;
        for (Column fromCol : this.getFromSchema().getColumnsList()) {
            this.fromColNameIndexMap.put(fromCol.getName(), fromIndex);
            ++fromIndex;
        }
    }

    @Override
    public Object[] getMatchingData(Object[] fields) {
        if (this.getToSchema().isEmpty()) {
            return fields;
        }
        Object[] out = new Object[this.getToSchema().getColumnsCount()];
        int i = 0;
        for (Column toCol : this.getToSchema().getColumnsList()) {
            Integer fromIndex = this.fromColNameIndexMap.get(toCol.getName());
            if (fromIndex != null && fromIndex < fields.length) {
                out[i] = fields[fromIndex];
            } else {
                this.tryFillNullInArrayForUnexpectedColumn(toCol, out, i);
            }
            ++i;
        }
        return out;
    }
}

