/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.classloader;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import org.apache.log4j.Logger;
import org.apache.sqoop.classloader.ConnectorURLFactory;
import org.apache.sqoop.classloader.URLFactory;
import sun.misc.CompoundEnumeration;

public class ConnectorClassLoader
extends URLClassLoader {
    public static final String SYSTEM_CLASSES_DEFAULT;
    private static final String PROPERTIES_FILE = "org.apache.sqoop.connector-classloader.properties";
    private static final String SYSTEM_CLASSES_DEFAULT_KEY = "system.classes.default";
    private static final String MANIFEST = "META-INF/MANIFEST.MF";
    private static final String CLASS = ".class";
    private static final String LIB_PREFIX = "lib/";
    private Map<String, ByteCode> byteCodeCache = new HashMap<String, ByteCode>();
    private Set<String> jarNames = new LinkedHashSet<String>();
    private Map<String, ProtectionDomain> pdCache = new HashMap<String, ProtectionDomain>();
    private URLFactory urlFactory;
    private static final Logger LOG;
    private static final FilenameFilter JAR_FILENAME_FILTER;
    private final ClassLoader parent;
    private final List<String> systemClasses;

    public ConnectorClassLoader(URL url, ClassLoader parent, List<String> systemClasses, boolean overrideDefaultSystemClasses) throws IOException {
        super(new URL[]{url}, parent);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("url: " + url));
            LOG.debug((Object)("system classes: " + systemClasses));
        }
        this.parent = parent;
        if (parent == null) {
            throw new IllegalArgumentException("No parent classloader!");
        }
        this.systemClasses = new ArrayList<String>();
        if (systemClasses != null && !systemClasses.isEmpty()) {
            this.systemClasses.addAll(systemClasses);
        }
        if (!overrideDefaultSystemClasses || this.systemClasses.isEmpty()) {
            this.systemClasses.addAll(Arrays.asList(SYSTEM_CLASSES_DEFAULT.split("\\s*,\\s*")));
        }
        LOG.info((Object)("system classes: " + this.systemClasses));
        this.urlFactory = new ConnectorURLFactory(this);
        this.load(url);
    }

    public ConnectorClassLoader(String connectorJar, ClassLoader parent, List<String> systemClasses) throws IOException {
        this(connectorJar, parent, systemClasses, true);
    }

    public ConnectorClassLoader(String connectorJar, ClassLoader parent, List<String> systemClasses, boolean overrideDefaultSystemClasses) throws IOException {
        this(new File(connectorJar).toURI().toURL(), parent, systemClasses, overrideDefaultSystemClasses);
    }

    static URL[] constructUrlsFromClasspath(String classpath) throws MalformedURLException {
        ArrayList<URL> urls = new ArrayList<URL>();
        for (String element : classpath.split(File.pathSeparator)) {
            if (element.endsWith("/*")) {
                String dir = element.substring(0, element.length() - 1);
                File[] files = new File(dir).listFiles(JAR_FILENAME_FILTER);
                if (files == null) continue;
                for (File file : files) {
                    urls.add(file.toURI().toURL());
                }
                continue;
            }
            File file = new File(element);
            if (!file.exists()) continue;
            urls.add(new File(element).toURI().toURL());
        }
        return urls.toArray(new URL[urls.size()]);
    }

    @Override
    public URL getResource(String name) {
        URL url = null;
        if (!ConnectorClassLoader.isSystemClass(name, this.systemClasses) && (url = this.findResource(name)) == null && name.startsWith("/")) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Remove leading / off " + name));
            }
            url = this.findResource(name.substring(1));
        }
        if (url == null) {
            url = this.parent.getResource(name);
        }
        if (url != null && LOG.isDebugEnabled()) {
            LOG.debug((Object)("getResource(" + name + ")=" + url));
        }
        return url;
    }

    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        Enumeration[] tmp = new Enumeration[2];
        if (!ConnectorClassLoader.isSystemClass(name, this.systemClasses)) {
            tmp[0] = this.findResources(name);
            if (!tmp[0].hasMoreElements() && name.startsWith("/")) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Remove leading / off " + name));
                }
                tmp[0] = this.findResources(name.substring(1));
            }
        }
        tmp[1] = this.parent.getResources(name);
        return new CompoundEnumeration(tmp);
    }

    @Override
    public Class<?> loadClass(String name) throws ClassNotFoundException {
        return this.loadClass(name, false);
    }

    @Override
    protected synchronized Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Loading class: " + name));
        }
        Class<?> c = this.findLoadedClass(name);
        ClassNotFoundException ex = null;
        if (c == null && !ConnectorClassLoader.isSystemClass(name, this.systemClasses)) {
            try {
                c = this.findClass(name);
                if (LOG.isDebugEnabled() && c != null) {
                    LOG.debug((Object)("Loaded class: " + name + " "));
                }
            }
            catch (ClassNotFoundException e) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)e);
                }
                ex = e;
            }
        }
        if (c == null) {
            c = this.parent.loadClass(name);
            if (LOG.isDebugEnabled() && c != null) {
                LOG.debug((Object)("Loaded class from parent: " + name + " "));
            }
        }
        if (c == null) {
            throw ex != null ? ex : new ClassNotFoundException(name);
        }
        if (resolve) {
            this.resolveClass(c);
        }
        return c;
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        Class<?> cls = this.findLoadedClass(name);
        if (cls != null) {
            return cls;
        }
        String cache = name.replace('.', '/') + CLASS;
        if ((cache = this.resolve(cache)) != null) {
            ByteCode bytecode = this.byteCodeCache.get(cache);
            ProtectionDomain pd = this.pdCache.get(bytecode.codebase);
            if (pd == null) {
                try {
                    URL url = this.urlFactory.getCodeBase(bytecode.codebase);
                    CodeSource source = new CodeSource(url, (Certificate[])null);
                    pd = new ProtectionDomain(source, null, this, null);
                    this.pdCache.put(bytecode.codebase, pd);
                }
                catch (MalformedURLException mux) {
                    throw new ClassNotFoundException(name, mux);
                }
            }
            byte[] bytes = bytecode.bytes;
            int i = name.lastIndexOf(46);
            if (i != -1) {
                String pkgname = name.substring(0, i);
                Package pkg = this.getPackage(pkgname);
                Manifest man = bytecode.manifest;
                if (pkg != null) {
                    if (pkg.isSealed()) {
                        if (!pkg.isSealed(pd.getCodeSource().getLocation())) {
                            throw new SecurityException("sealing violation: package " + pkgname + " is sealed");
                        }
                    } else if (man != null && this.isSealed(pkgname, man)) {
                        throw new SecurityException("sealing violation: can't seal package " + pkgname + ": already loaded");
                    }
                } else if (man != null) {
                    this.definePackage(pkgname, man, pd.getCodeSource().getLocation());
                } else {
                    this.definePackage(pkgname, null, null, null, null, null, null, null);
                }
            }
            return this.defineClass(name, bytes, 0, bytes.length, pd);
        }
        return null;
    }

    @Override
    public URL findResource(String name) {
        LOG.debug((Object)("Finding resource: " + name));
        try {
            String resource = this.resolve(name);
            if (resource != null) {
                ByteCode entry = this.byteCodeCache.get(resource);
                return this.urlFactory.getURL(entry.codebase, name);
            }
        }
        catch (MalformedURLException mux) {
            LOG.debug((Object)("Unable to find resource: " + name + " due to " + mux));
        }
        return null;
    }

    @Override
    @SuppressWarnings(value={"SIC_INNER_SHOULD_BE_STATIC_ANON"})
    public Enumeration<URL> findResources(String name) throws IOException {
        LOG.debug((Object)("Finding resources: " + name));
        ArrayList<URL> resources = new ArrayList<URL>();
        ByteCode entry = this.byteCodeCache.get(name);
        if (entry != null) {
            URL url = this.urlFactory.getURL(entry.codebase, name);
            LOG.debug((Object)("Adding " + url + " to resources list for " + name));
            resources.add(url);
        }
        Iterator<String> jarNameIter = this.jarNames.iterator();
        while (jarNameIter.hasNext()) {
            String resource = jarNameIter.next() + "/" + name;
            entry = this.byteCodeCache.get(resource);
            if (entry == null) continue;
            URL url = this.urlFactory.getURL(entry.codebase, name);
            LOG.debug((Object)("Adding " + url + " to resources list for " + name));
            resources.add(url);
        }
        final Iterator resIter = resources.iterator();
        return new Enumeration<URL>(){

            @Override
            public boolean hasMoreElements() {
                return resIter.hasNext();
            }

            @Override
            public URL nextElement() {
                return (URL)resIter.next();
            }
        };
    }

    public InputStream getByteStream(String resource) {
        InputStream result = null;
        if (!ConnectorClassLoader.isSystemClass(resource, this.systemClasses)) {
            resource = this.canon(resource);
            ByteCode bytecode = null;
            String name = this.resolve(resource);
            if (name != null) {
                bytecode = this.byteCodeCache.get(name);
            }
            if (bytecode != null) {
                result = new ByteArrayInputStream(bytecode.bytes);
            }
            if (result == null && this.jarNames.contains(resource)) {
                LOG.debug((Object)("Loading resource file directly: " + resource));
                result = super.getResourceAsStream(resource);
            }
        }
        if (result == null) {
            result = this.parent.getResourceAsStream(resource);
        }
        return result;
    }

    private boolean isSealed(String name, Manifest man) {
        String path = name.concat("/");
        Attributes attr = man.getAttributes(path);
        String sealed = null;
        if (attr != null) {
            sealed = attr.getValue(Attributes.Name.SEALED);
        }
        if (sealed == null && (attr = man.getMainAttributes()) != null) {
            sealed = attr.getValue(Attributes.Name.SEALED);
        }
        return "true".equalsIgnoreCase(sealed);
    }

    private String canon(String path) {
        String next;
        String canon = path = path.replaceAll("/\\./", "/");
        while (!(next = canon).equals(canon = canon.replaceFirst("([^/]*/\\.\\./)", ""))) {
        }
        return canon;
    }

    private String resolve(String name) {
        if (name.startsWith("/")) {
            name = name.substring(1);
        }
        String resource = null;
        if (this.byteCodeCache.containsKey(name)) {
            resource = name;
        }
        if (resource == null) {
            Iterator<String> jarNameIter = this.jarNames.iterator();
            while (jarNameIter.hasNext()) {
                String tmp = jarNameIter.next() + "/" + name;
                if (!this.byteCodeCache.containsKey(tmp)) continue;
                resource = tmp;
                break;
            }
        }
        return resource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void load(URL connectorUrl) throws IOException {
        String jarName = connectorUrl.getPath();
        JarFile jarFile = null;
        try {
            jarFile = new JarFile(jarName);
            Manifest manifest = jarFile.getManifest();
            Enumeration<JarEntry> entryEnum = jarFile.entries();
            while (entryEnum.hasMoreElements()) {
                JarEntry entry = entryEnum.nextElement();
                if (entry.isDirectory()) continue;
                String entryName = entry.getName();
                InputStream is = jarFile.getInputStream(entry);
                if (is == null) {
                    throw new IOException("Unable to load resource " + entryName);
                }
                try {
                    if (entryName.startsWith(LIB_PREFIX)) {
                        LOG.debug((Object)("Caching " + entryName));
                        this.loadBytesFromJar(is, entryName);
                        continue;
                    }
                    if (entryName.endsWith(CLASS)) {
                        this.loadBytes(entry, is, "/", manifest);
                        LOG.debug((Object)("Loaded class: " + jarFile.getName() + "!/" + entry.getName()));
                        continue;
                    }
                    this.loadBytes(entry, is, "/", manifest);
                    LOG.debug((Object)("Loaded resource: " + jarFile.getName() + "!/" + entry.getName()));
                }
                finally {
                    is.close();
                }
            }
        }
        finally {
            if (jarFile != null) {
                try {
                    jarFile.close();
                }
                catch (IOException e) {
                    LOG.debug((Object)("Exception closing jarFile: " + jarName), (Throwable)e);
                }
            }
        }
    }

    private void loadBytesFromJar(InputStream is, String jar) throws IOException {
        JarInputStream jis = new JarInputStream(is);
        Manifest manifest = jis.getManifest();
        JarEntry entry = null;
        while ((entry = jis.getNextJarEntry()) != null) {
            this.loadBytes(entry, jis, jar, manifest);
        }
        if (manifest != null) {
            entry = new JarEntry(MANIFEST);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            manifest.write(baos);
            ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
            this.loadBytes(entry, bais, jar, manifest);
        }
    }

    private void loadBytes(JarEntry entry, InputStream is, String jar, Manifest man) throws IOException {
        String packageName;
        String entryName = entry.getName();
        int index = entryName.lastIndexOf(46);
        int index2 = entryName.lastIndexOf(47, index - 1);
        if (entryName.endsWith(CLASS) && index2 > -1 && this.getPackage(packageName = entryName.substring(0, index2).replace('/', '.')) == null) {
            if (man != null) {
                this.definePackage(packageName, man, this.urlFactory.getCodeBase(jar));
            } else {
                this.definePackage(packageName, null, null, null, null, null, null, null);
            }
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ConnectorClassLoader.copy(is, baos);
        if (entryName.endsWith(CLASS)) {
            if (this.byteCodeCache.containsKey(entryName)) {
                return;
            }
            this.byteCodeCache.put(entryName, new ByteCode(baos.toByteArray(), jar, man));
        } else {
            String localname = jar + "/" + entryName;
            byte[] bytes = baos.toByteArray();
            this.byteCodeCache.put(localname, new ByteCode(bytes, jar, man));
            this.jarNames.add(jar);
        }
    }

    private static void copy(InputStream in, OutputStream out) throws IOException {
        int len;
        byte[] buf = new byte[1024];
        while ((len = in.read(buf)) >= 0) {
            out.write(buf, 0, len);
        }
    }

    public static boolean isSystemClass(String name, List<String> systemClasses) {
        boolean result = false;
        if (systemClasses != null) {
            String canonicalName = name.replace('/', '.');
            while (canonicalName.startsWith(".")) {
                canonicalName = canonicalName.substring(1);
            }
            int maxMatchLength = -1;
            for (String c : systemClasses) {
                boolean shouldInclude = true;
                if (c.startsWith("-")) {
                    c = c.substring(1);
                    shouldInclude = false;
                }
                if (!canonicalName.startsWith(c) || !c.endsWith(".") && canonicalName.length() != c.length() && (canonicalName.length() <= c.length() || canonicalName.charAt(c.length()) != '$')) continue;
                if (c.length() > maxMatchLength) {
                    maxMatchLength = c.length();
                    if (shouldInclude) {
                        result = true;
                        continue;
                    }
                    result = false;
                    continue;
                }
                if (c.length() != maxMatchLength || shouldInclude) continue;
                result = false;
            }
        }
        return result;
    }

    static {
        LOG = Logger.getLogger(ConnectorClassLoader.class);
        JAR_FILENAME_FILTER = new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".jar") || name.endsWith(".JAR");
            }
        };
        try (InputStream is = ConnectorClassLoader.class.getClassLoader().getResourceAsStream(PROPERTIES_FILE);){
            if (is == null) {
                throw new ExceptionInInitializerError("properties file org.apache.sqoop.connector-classloader.properties is not found");
            }
            Properties props = new Properties();
            props.load(is);
            String systemClassesDefault = props.getProperty(SYSTEM_CLASSES_DEFAULT_KEY);
            if (systemClassesDefault == null) {
                throw new ExceptionInInitializerError("property system.classes.default is not found");
            }
            SYSTEM_CLASSES_DEFAULT = systemClassesDefault;
        }
        catch (IOException e) {
            throw new ExceptionInInitializerError(e);
        }
    }

    private static class ByteCode {
        public byte[] bytes;
        public String codebase;
        public Manifest manifest;

        public ByteCode(byte[] bytes, String codebase, Manifest manifest) {
            this.bytes = bytes;
            this.codebase = codebase;
            this.manifest = manifest;
        }
    }
}

