/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.classloader;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.IOException;
import java.io.InputStream;
import java.net.FileNameMap;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import org.apache.sqoop.classloader.ConnectorClassLoader;
import org.apache.sqoop.classloader.URLFactory;

@SuppressWarnings(value={"SIC_INNER_SHOULD_BE_STATIC_ANON"})
public class ConnectorURLFactory
implements URLFactory {
    private URLStreamHandler handler;

    public ConnectorURLFactory(final ConnectorClassLoader loader) {
        this.handler = new URLStreamHandler(){

            @Override
            protected URLConnection openConnection(URL u) throws IOException {
                final String resource = u.getPath();
                return new URLConnection(u){

                    @Override
                    public void connect() {
                    }

                    @Override
                    public String getContentType() {
                        FileNameMap fileNameMap = URLConnection.getFileNameMap();
                        String contentType = fileNameMap.getContentTypeFor(resource);
                        if (contentType == null) {
                            contentType = "text/plain";
                        }
                        return contentType;
                    }

                    @Override
                    public InputStream getInputStream() throws IOException {
                        InputStream is = loader.getByteStream(resource);
                        if (is == null) {
                            throw new IOException("loader.getByteStream() returned null for " + resource);
                        }
                        return is;
                    }
                };
            }
        };
    }

    @Override
    public URL getURL(String codebase, String resource) throws MalformedURLException {
        String base = resource.endsWith(".class") ? "" : codebase + "/";
        URL url = new URL(null, "sqoopconnector:/" + base + resource, this.handler);
        return url;
    }

    @Override
    public URL getCodeBase(String jar) throws MalformedURLException {
        return new URL(null, "sqoopconnector:" + jar, this.handler);
    }
}

