/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.common;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;
import org.apache.sqoop.classification.InterfaceAudience;
import org.apache.sqoop.classification.InterfaceStability;
import org.apache.sqoop.common.ImmutableContext;

@InterfaceAudience.Public
@InterfaceStability.Unstable
public class MapContext
implements ImmutableContext {
    private static final Logger LOG = Logger.getLogger(MapContext.class);
    private final Map<String, String> options;

    public MapContext(Map<String, String> options) {
        this.options = options == null ? new HashMap() : options;
    }

    protected Map<String, String> getOptions() {
        return this.options;
    }

    @Override
    public String getString(String key) {
        String value = this.options.get(key);
        if (value == null || value.trim().length() == 0) {
            LOG.debug((Object)("Value not found in configuration for key: " + key));
        }
        return value;
    }

    @Override
    public String getString(String key, String defaultValue) {
        String value = this.getString(key);
        if (value == null || value.trim().length() == 0) {
            value = defaultValue;
        }
        return value;
    }

    @Override
    public boolean getBoolean(String key, boolean defaultValue) {
        String value = this.getString(key);
        boolean result = defaultValue;
        if (value != null) {
            result = Boolean.valueOf(value);
        }
        return result;
    }

    @Override
    public long getLong(String key, long defaultValue) {
        if (!this.options.containsKey(key)) {
            LOG.debug((Object)("Value not found in configuration for key: " + key));
            return defaultValue;
        }
        String value = this.options.get(key);
        return Long.parseLong(value);
    }

    @Override
    public int getInt(String key, int defaultValue) {
        if (!this.options.containsKey(key)) {
            LOG.debug((Object)("Value not found in configuration for key: " + key));
            return defaultValue;
        }
        String value = this.options.get(key);
        return Integer.parseInt(value);
    }

    public Map<String, String> getNestedProperties(String prefix) {
        HashMap<String, String> subProps = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : this.options.entrySet()) {
            if (!entry.getKey().startsWith(prefix)) continue;
            subProps.put(entry.getKey().substring(prefix.length()), entry.getValue());
        }
        if (subProps.isEmpty()) {
            LOG.debug((Object)("Value not found in configuration for prefix: " + prefix));
        }
        return subProps;
    }

    public Map<String, String> getValByRegex(String regex) {
        Pattern p = Pattern.compile(regex);
        HashMap<String, String> result = new HashMap<String, String>();
        for (String item : this.options.keySet()) {
            Matcher m = p.matcher(item);
            if (!m.find()) continue;
            result.put(item, this.getString(item));
        }
        if (result.isEmpty()) {
            LOG.debug((Object)("Value not found in configuration for regex: " + regex));
        }
        return result;
    }

    @Override
    public Iterator<Map.Entry<String, String>> iterator() {
        return this.options.entrySet().iterator();
    }
}

