/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.json;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import org.apache.sqoop.classification.InterfaceAudience;
import org.apache.sqoop.classification.InterfaceStability;
import org.apache.sqoop.json.JSONUtils;
import org.apache.sqoop.json.JsonBean;
import org.apache.sqoop.json.util.ConfigInputSerialization;
import org.apache.sqoop.model.MConfig;
import org.apache.sqoop.model.MLink;
import org.apache.sqoop.model.MLinkConfig;
import org.apache.sqoop.model.MValidator;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class LinkBean
implements JsonBean {
    static final String CONNECTOR_NAME = "connector-name";
    static final String LINK_CONFIG_VALUES = "link-config-values";
    static final String LINKS = "links";
    private List<MLink> links;
    private Map<String, ResourceBundle> linkConfigBundles = new HashMap<String, ResourceBundle>();

    public LinkBean(MLink link) {
        this();
        this.links = new ArrayList<MLink>();
        this.links.add(link);
    }

    public LinkBean(List<MLink> links) {
        this();
        this.links = links;
    }

    public LinkBean() {
    }

    public void addConnectorConfigBundle(String connectorName, ResourceBundle connectorConfigBundle) {
        this.linkConfigBundles.put(connectorName, connectorConfigBundle);
    }

    public boolean hasConnectorConfigBundle(String connectorName) {
        return this.linkConfigBundles.containsKey(connectorName);
    }

    public List<MLink> getLinks() {
        return this.links;
    }

    public ResourceBundle getConnectorConfigBundle(String connectorName) {
        return this.linkConfigBundles.get(connectorName);
    }

    @Override
    public JSONObject extract(boolean skipSensitive) {
        JSONArray linkArray = this.extractLinks(skipSensitive);
        JSONObject links = new JSONObject();
        links.put((Object)LINKS, (Object)linkArray);
        return links;
    }

    @Override
    public void restore(JSONObject jsonObject) {
        JSONArray array = JSONUtils.getJSONArray(jsonObject, LINKS);
        this.restoreLinks(array);
    }

    protected JSONArray extractLinks(boolean skipSensitive) {
        JSONArray linkArray = new JSONArray();
        for (MLink link : this.links) {
            linkArray.add((Object)this.extractLink(skipSensitive, link));
        }
        return linkArray;
    }

    private JSONObject extractLink(boolean skipSensitive, MLink link) {
        JSONObject linkJsonObject = new JSONObject();
        linkJsonObject.put((Object)"id", (Object)link.getPersistenceId());
        linkJsonObject.put((Object)"name", (Object)link.getName());
        linkJsonObject.put((Object)"enabled", (Object)link.getEnabled());
        linkJsonObject.put((Object)"creation-user", (Object)link.getCreationUser());
        linkJsonObject.put((Object)"creation-date", (Object)link.getCreationDate().getTime());
        linkJsonObject.put((Object)"update-user", (Object)link.getLastUpdateUser());
        linkJsonObject.put((Object)"update-date", (Object)link.getLastUpdateDate().getTime());
        linkJsonObject.put((Object)CONNECTOR_NAME, (Object)link.getConnectorName());
        linkJsonObject.put((Object)LINK_CONFIG_VALUES, (Object)ConfigInputSerialization.extractConfigList(link.getConnectorLinkConfig(), skipSensitive));
        return linkJsonObject;
    }

    protected void restoreLinks(JSONArray array) {
        this.links = new ArrayList<MLink>();
        for (Object obj : array) {
            this.links.add(this.restoreLink(obj));
        }
    }

    private MLink restoreLink(Object obj) {
        JSONObject object = (JSONObject)obj;
        String connectorName = (String)object.get((Object)CONNECTOR_NAME);
        JSONObject connectorLinkConfig = JSONUtils.getJSONObject(object, LINK_CONFIG_VALUES);
        List<MConfig> linkConfigs = ConfigInputSerialization.restoreConfigs(JSONUtils.getJSONArray(connectorLinkConfig, "configs"));
        List<MValidator> linkValidators = ConfigInputSerialization.restoreValidator(JSONUtils.getJSONArray(connectorLinkConfig, "validators"));
        MLink link = new MLink(connectorName, new MLinkConfig(linkConfigs, linkValidators));
        link.setPersistenceId(JSONUtils.getLong(object, "id"));
        link.setName(JSONUtils.getString(object, "name"));
        link.setEnabled(JSONUtils.getBoolean(object, "enabled"));
        link.setCreationUser(JSONUtils.getString(object, "creation-user"));
        link.setCreationDate(new Date(JSONUtils.getLong(object, "creation-date")));
        link.setLastUpdateUser(JSONUtils.getString(object, "update-user"));
        link.setLastUpdateDate(new Date(JSONUtils.getLong(object, "update-date")));
        return link;
    }
}

