/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.json.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.sqoop.classification.InterfaceAudience;
import org.apache.sqoop.classification.InterfaceStability;
import org.apache.sqoop.common.ErrorCode;
import org.apache.sqoop.common.SqoopException;
import org.apache.sqoop.json.JSONUtils;
import org.apache.sqoop.json.util.SerializationError;
import org.apache.sqoop.model.InputEditable;
import org.apache.sqoop.model.MBooleanInput;
import org.apache.sqoop.model.MConfig;
import org.apache.sqoop.model.MConfigList;
import org.apache.sqoop.model.MConfigType;
import org.apache.sqoop.model.MDateTimeInput;
import org.apache.sqoop.model.MEnumInput;
import org.apache.sqoop.model.MInput;
import org.apache.sqoop.model.MInputType;
import org.apache.sqoop.model.MIntegerInput;
import org.apache.sqoop.model.MListInput;
import org.apache.sqoop.model.MLongInput;
import org.apache.sqoop.model.MMapInput;
import org.apache.sqoop.model.MStringInput;
import org.apache.sqoop.model.MValidator;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public final class ConfigInputSerialization {
    public static JSONObject extractConfigList(MConfigList mConfigList, boolean skipSensitive) {
        JSONObject jsonConfigList = new JSONObject();
        jsonConfigList.put((Object)"validators", (Object)ConfigInputSerialization.extractValidators(mConfigList.getValidators()));
        JSONArray configs = new JSONArray();
        for (MConfig mConfig : mConfigList.getConfigs()) {
            configs.add((Object)ConfigInputSerialization.extractConfig(mConfig, mConfigList.getType(), skipSensitive));
        }
        jsonConfigList.put((Object)"configs", (Object)configs);
        return jsonConfigList;
    }

    static JSONObject extractConfig(MConfig mConfig, MConfigType type, boolean skipSensitive) {
        JSONObject config = new JSONObject();
        config.put((Object)"id", (Object)mConfig.getPersistenceId());
        config.put((Object)"name", (Object)mConfig.getName());
        config.put((Object)"type", (Object)type.name());
        config.put((Object)"validators", (Object)ConfigInputSerialization.extractValidators(mConfig.getValidators()));
        JSONArray mInputs = new JSONArray();
        config.put((Object)"inputs", (Object)mInputs);
        for (MInput<?> mInput : mConfig.getInputs()) {
            JSONObject input = new JSONObject();
            input.put((Object)"id", (Object)mInput.getPersistenceId());
            input.put((Object)"name", (Object)mInput.getName());
            input.put((Object)"type", (Object)mInput.getType().toString());
            input.put((Object)"sensitive", (Object)mInput.isSensitive());
            input.put((Object)"editable", (Object)mInput.getEditable().name());
            input.put((Object)"overrides", (Object)mInput.getOverrides());
            input.put((Object)"validators", (Object)ConfigInputSerialization.extractValidators(mInput.getValidators()));
            if (mInput.getType() == MInputType.STRING) {
                input.put((Object)"size", (Object)((MStringInput)mInput).getMaxLength());
            }
            if (mInput.getType() == MInputType.ENUM) {
                input.put((Object)"values", (Object)StringUtils.join((Object[])((MEnumInput)mInput).getValues(), (String)","));
            }
            if (mInput.getType() == MInputType.MAP) {
                input.put((Object)"sensitive-pattern", (Object)((MMapInput)mInput).getSensitiveKeyPattern());
            }
            if (!(mInput.isEmpty() || skipSensitive && mInput.isSensitive())) {
                if (mInput.getType() == MInputType.MAP) {
                    MMapInput mMapInput = (MMapInput)mInput;
                    if (skipSensitive) {
                        input.put((Object)"value", mMapInput.getNonsenstiveValue());
                    } else {
                        input.put((Object)"value", mMapInput.getValue());
                    }
                } else {
                    input.put((Object)"value", (Object)mInput.getUrlSafeValueString());
                }
            }
            mInputs.add((Object)input);
        }
        return config;
    }

    public static JSONArray extractValidators(List<MValidator> mValidators) {
        JSONArray jsonValidators = new JSONArray();
        for (MValidator mValidator : mValidators) {
            JSONObject jsonValidator = new JSONObject();
            jsonValidator.put((Object)"validator-class", (Object)mValidator.getValidatorClass());
            jsonValidator.put((Object)"validator-str-arg", (Object)mValidator.getStrArg());
            jsonValidators.add((Object)jsonValidator);
        }
        return jsonValidators;
    }

    public static List<MValidator> restoreValidator(JSONArray jsonValidators) {
        ArrayList<MValidator> mValidators = new ArrayList<MValidator>();
        for (int validatorCounter = 0; validatorCounter < jsonValidators.size(); ++validatorCounter) {
            JSONObject jsonValidator = (JSONObject)jsonValidators.get(validatorCounter);
            String validatorClassName = JSONUtils.getString(jsonValidator, "validator-class");
            String validatorStrArg = JSONUtils.getString(jsonValidator, "validator-str-arg");
            mValidators.add(new MValidator(validatorClassName, validatorStrArg));
        }
        return mValidators;
    }

    public static List<MConfig> restoreConfigs(JSONArray configs) {
        ArrayList<MConfig> mConfigs = new ArrayList<MConfig>();
        for (int i = 0; i < configs.size(); ++i) {
            mConfigs.add(ConfigInputSerialization.restoreConfig((JSONObject)configs.get(i)));
        }
        return mConfigs;
    }

    static MConfig restoreConfig(JSONObject config) {
        JSONArray inputs = JSONUtils.getJSONArray(config, "inputs");
        ArrayList mInputs = new ArrayList();
        for (int i = 0; i < inputs.size(); ++i) {
            JSONObject input = (JSONObject)inputs.get(i);
            MInputType type = MInputType.valueOf(JSONUtils.getString(input, "type"));
            String name = JSONUtils.getString(input, "name");
            Boolean sensitive = JSONUtils.getBoolean(input, "sensitive");
            InputEditable editable = input.containsKey((Object)"editable") ? InputEditable.valueOf(JSONUtils.getString(input, "editable")) : InputEditable.USER_ONLY;
            String overrides = JSONUtils.getString(input, "overrides");
            String sensitveKeyPattern = input.containsKey((Object)"sensitive-pattern") ? JSONUtils.getString(input, "sensitive-pattern") : null;
            List<MValidator> mValidatorsForInput = ConfigInputSerialization.restoreValidator(JSONUtils.getJSONArray(input, "validators"));
            MInput mInput = null;
            switch (type) {
                case STRING: {
                    long size = JSONUtils.getLong(input, "size");
                    mInput = new MStringInput(name, sensitive, editable, overrides, (short)size, mValidatorsForInput);
                    break;
                }
                case MAP: {
                    mInput = new MMapInput(name, sensitive, editable, overrides, sensitveKeyPattern, mValidatorsForInput);
                    break;
                }
                case INTEGER: {
                    mInput = new MIntegerInput(name, sensitive, editable, overrides, mValidatorsForInput);
                    break;
                }
                case LONG: {
                    mInput = new MLongInput(name, sensitive, editable, overrides, mValidatorsForInput);
                    break;
                }
                case BOOLEAN: {
                    mInput = new MBooleanInput(name, sensitive, editable, overrides, mValidatorsForInput);
                    break;
                }
                case ENUM: {
                    String values = JSONUtils.getString(input, "values");
                    mInput = new MEnumInput(name, sensitive, editable, overrides, values.split(","), mValidatorsForInput);
                    break;
                }
                case LIST: {
                    mInput = new MListInput(name, sensitive, editable, overrides, mValidatorsForInput);
                    break;
                }
                case DATETIME: {
                    mInput = new MDateTimeInput(name, sensitive, editable, overrides, mValidatorsForInput);
                    break;
                }
            }
            Long id = JSONUtils.getLong(input, "id");
            if (id == null) {
                throw new SqoopException((ErrorCode)SerializationError.SERIALIZATION_002, "Missing field: id");
            }
            mInput.setPersistenceId(id);
            if (input.containsKey((Object)"value")) {
                switch (type) {
                    case MAP: {
                        try {
                            mInput.setValue((Map)input.get((Object)"value"));
                            break;
                        }
                        catch (ClassCastException e) {
                            throw new SqoopException((ErrorCode)SerializationError.SERIALIZATION_001, name + " requires a 'map' value.");
                        }
                    }
                    default: {
                        mInput.restoreFromUrlSafeValueString(JSONUtils.getString(input, "value"));
                    }
                }
            }
            mInputs.add(mInput);
        }
        List<MValidator> mValidatorsForConfig = ConfigInputSerialization.restoreValidator(JSONUtils.getJSONArray(config, "validators"));
        MConfig mConfig = new MConfig(JSONUtils.getString(config, "name"), mInputs, mValidatorsForConfig);
        mConfig.setPersistenceId(JSONUtils.getLong(config, "id"));
        return mConfig;
    }

    private ConfigInputSerialization() {
    }
}

