/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.model;

import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.sqoop.classification.InterfaceAudience;
import org.apache.sqoop.classification.InterfaceStability;
import org.apache.sqoop.common.ErrorCode;
import org.apache.sqoop.common.SqoopException;
import org.apache.sqoop.model.InputEditable;
import org.apache.sqoop.model.MInput;
import org.apache.sqoop.model.MInputType;
import org.apache.sqoop.model.MValidator;
import org.apache.sqoop.model.ModelError;

@InterfaceAudience.Public
@InterfaceStability.Unstable
public class MEnumInput
extends MInput<String> {
    String[] values;

    public MEnumInput(String name, boolean sensitive, InputEditable editable, String overrides, String[] values, List<MValidator> mValidators) {
        super(name, sensitive, editable, overrides, mValidators);
        this.values = values != null ? (String[])values.clone() : null;
    }

    public String[] getValues() {
        if (this.values != null) {
            return (String[])this.values.clone();
        }
        return new String[0];
    }

    @Override
    public void setValue(String value) {
        if (value == null) {
            super.setValue(null);
            return;
        }
        for (String allowedValue : this.values) {
            if (!allowedValue.equals(value)) continue;
            super.setValue(value);
            return;
        }
        throw new SqoopException((ErrorCode)ModelError.MODEL_008, "Invalid value " + value);
    }

    @Override
    public void setValue(Enum value) {
        this.setValue(value.toString());
    }

    @Override
    public String getUrlSafeValueString() {
        return (String)this.getValue();
    }

    @Override
    public void restoreFromUrlSafeValueString(String valueString) {
        this.setValue(valueString);
    }

    @Override
    public MInputType getType() {
        return MInputType.ENUM;
    }

    @Override
    public boolean hasExtraInfo() {
        return true;
    }

    @Override
    public String getExtraInfoToString() {
        return StringUtils.join((Object[])this.values, (String)",");
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof MEnumInput)) {
            return false;
        }
        MEnumInput mei = (MEnumInput)other;
        return this.getName().equals(mei.getName()) && Arrays.equals(this.values, mei.values);
    }

    @Override
    public int hashCode() {
        int hash = 23 + 31 * this.getName().hashCode();
        for (String value : this.values) {
            hash += 31 * value.hashCode();
        }
        return hash;
    }

    @Override
    public boolean isEmpty() {
        return this.getValue() == null;
    }

    @Override
    public void setEmpty() {
        this.setValue((String)null);
    }

    @Override
    public MEnumInput clone(boolean cloneWithValue) {
        MEnumInput copy = new MEnumInput(this.getName(), this.isSensitive(), this.getEditable(), this.getOverrides(), this.getValues(), this.getCloneOfValidators());
        copy.setPersistenceId(this.getPersistenceId());
        if (cloneWithValue) {
            copy.setValue((String)this.getValue());
        }
        return copy;
    }
}

