/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.model;

import java.util.List;
import org.apache.sqoop.classification.InterfaceAudience;
import org.apache.sqoop.classification.InterfaceStability;
import org.apache.sqoop.model.InputEditable;
import org.apache.sqoop.model.MClonable;
import org.apache.sqoop.model.MInputType;
import org.apache.sqoop.model.MNamedElement;
import org.apache.sqoop.model.MValidator;

@InterfaceAudience.Public
@InterfaceStability.Unstable
public abstract class MInput<T>
extends MNamedElement
implements MClonable {
    private final boolean sensitive;
    private final String overrides;
    private final InputEditable editable;
    private T value;

    protected MInput(String name, boolean sensitive, InputEditable editable, String overrides, List<MValidator> mValidators) {
        super(name, mValidators);
        this.sensitive = sensitive;
        this.editable = editable;
        this.overrides = overrides;
    }

    public void setValue(T value) {
        this.value = value;
    }

    public T getValue() {
        return this.value;
    }

    public boolean isSensitive() {
        return this.sensitive;
    }

    public InputEditable getEditable() {
        return this.editable;
    }

    public String getOverrides() {
        return this.overrides;
    }

    public abstract String getUrlSafeValueString();

    public abstract void restoreFromUrlSafeValueString(String var1);

    public abstract MInputType getType();

    public boolean hasExtraInfo() {
        return false;
    }

    public String getExtraInfoToString() {
        return null;
    }

    public abstract boolean equals(Object var1);

    public abstract int hashCode();

    public abstract boolean isEmpty();

    public abstract void setEmpty();

    @Override
    public final String toString() {
        StringBuilder sb = new StringBuilder("input-").append(this.getName());
        sb.append(":").append(this.getPersistenceId()).append(":");
        sb.append((Object)this.getType()).append(":").append(this.isSensitive()).append(":").append(this.getEditable().name()).append(":").append(this.getOverrides());
        if (this.hasExtraInfo()) {
            sb.append(":").append(this.getExtraInfoToString());
        }
        return sb.toString();
    }
}

