/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.model;

import org.apache.sqoop.classification.InterfaceAudience;
import org.apache.sqoop.classification.InterfaceStability;
import org.apache.sqoop.model.MAccountableEntity;
import org.apache.sqoop.model.MClonable;
import org.apache.sqoop.model.MDriverConfig;
import org.apache.sqoop.model.MFromConfig;
import org.apache.sqoop.model.MToConfig;

@InterfaceAudience.Public
@InterfaceStability.Unstable
public class MJob
extends MAccountableEntity
implements MClonable {
    private final String fromConnectorName;
    private final String toConnectorName;
    private final String fromLinkName;
    private final String toLinkName;
    private final MFromConfig fromConfig;
    private final MToConfig toConfig;
    private final MDriverConfig driverConfig;

    public MJob(String fromConnectorName, String toConnectorName, String fromLinkName, String toLinkName, MFromConfig fromConfig, MToConfig toConfig, MDriverConfig driverConfig) {
        this.fromConnectorName = fromConnectorName;
        this.toConnectorName = toConnectorName;
        this.fromLinkName = fromLinkName;
        this.toLinkName = toLinkName;
        this.fromConfig = fromConfig;
        this.toConfig = toConfig;
        this.driverConfig = driverConfig;
    }

    public MJob(MJob other) {
        this(other, other.getFromJobConfig().clone(true), other.getToJobConfig().clone(true), other.driverConfig.clone(true));
    }

    public MJob(MJob other, MFromConfig fromConfig, MToConfig toConfig, MDriverConfig driverConfig) {
        super(other);
        this.fromConnectorName = other.getFromConnectorName();
        this.toConnectorName = other.getToConnectorName();
        this.fromLinkName = other.getFromLinkName();
        this.toLinkName = other.getToLinkName();
        this.fromConfig = fromConfig;
        this.toConfig = toConfig;
        this.driverConfig = driverConfig;
        this.setPersistenceId(other.getPersistenceId());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("job");
        sb.append("From job config: ").append(this.getFromJobConfig());
        sb.append(", To job config: ").append(this.getToJobConfig());
        sb.append(", Driver config: ").append(this.driverConfig);
        return sb.toString();
    }

    public String getFromLinkName() {
        return this.fromLinkName;
    }

    public String getToLinkName() {
        return this.toLinkName;
    }

    public String getFromConnectorName() {
        return this.fromConnectorName;
    }

    public String getToConnectorName() {
        return this.toConnectorName;
    }

    public MFromConfig getFromJobConfig() {
        return this.fromConfig;
    }

    public MToConfig getToJobConfig() {
        return this.toConfig;
    }

    public MDriverConfig getDriverConfig() {
        return this.driverConfig;
    }

    @Override
    public MJob clone(boolean cloneWithValue) {
        if (cloneWithValue) {
            return new MJob(this);
        }
        return new MJob(this.getFromConnectorName(), this.getToConnectorName(), this.getFromLinkName(), this.getToLinkName(), this.getFromJobConfig().clone(false), this.getToJobConfig().clone(false), this.getDriverConfig().clone(false));
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof MJob)) {
            return false;
        }
        MJob job = (MJob)object;
        return job.getFromConnectorName().equals(this.getFromConnectorName()) && job.getToConnectorName().equals(this.getToConnectorName()) && job.getFromLinkName().equals(this.getFromLinkName()) && job.getToLinkName().equals(this.getToLinkName()) && job.getPersistenceId() == this.getPersistenceId() && job.getFromJobConfig().equals(this.getFromJobConfig()) && job.getToJobConfig().equals(this.getToJobConfig()) && job.getDriverConfig().equals(this.driverConfig);
    }

    public int hashCode() {
        int result = this.fromConnectorName != null ? this.fromConnectorName.hashCode() : 0;
        result = 31 * result + (this.toConnectorName != null ? this.toConnectorName.hashCode() : 0);
        result = 31 * result + (this.fromLinkName != null ? this.fromLinkName.hashCode() : 0);
        result = 31 * result + (this.toLinkName != null ? this.toLinkName.hashCode() : 0);
        result = 31 * result + (this.fromConfig != null ? this.fromConfig.hashCode() : 0);
        result = 31 * result + (this.toConfig != null ? this.toConfig.hashCode() : 0);
        result = 31 * result + (this.driverConfig != null ? this.driverConfig.hashCode() : 0);
        return result;
    }
}

