/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.model;

import java.util.Date;
import org.apache.sqoop.classification.InterfaceAudience;
import org.apache.sqoop.classification.InterfaceStability;
import org.apache.sqoop.common.ImmutableContext;
import org.apache.sqoop.model.MAccountableEntity;
import org.apache.sqoop.model.SubmissionError;
import org.apache.sqoop.schema.Schema;
import org.apache.sqoop.submission.SubmissionStatus;
import org.apache.sqoop.submission.counter.Counters;

@InterfaceAudience.Public
@InterfaceStability.Unstable
public class MSubmission
extends MAccountableEntity {
    private String jobName;
    SubmissionStatus status = SubmissionStatus.UNKNOWN;
    String externalJobId;
    double progress = -1.0;
    Counters counters;
    String externalLink;
    SubmissionError error;
    Schema fromSchema;
    Schema toSchema;
    ImmutableContext fromConnectorContext;
    ImmutableContext toConnectorContext;
    ImmutableContext driverContext;
    public static final MSubmission UNKNOWN = new MSubmission();

    public MSubmission() {
    }

    public MSubmission(String jobName, Date creationDate, SubmissionStatus status) {
        this();
        this.jobName = jobName;
        this.status = status;
        this.setCreationDate(creationDate);
    }

    public MSubmission(String jobName) {
        this(jobName, new Date(), SubmissionStatus.BOOTING);
    }

    public MSubmission(String jobName, Date creationDate, SubmissionStatus status, String externalId) {
        this(jobName, creationDate, status);
        this.externalJobId = externalId;
    }

    public MSubmission(String jobName, Date creationDate, SubmissionStatus status, String externalId, String externalLink, Counters counters) {
        this(jobName, creationDate, status, externalId);
        this.externalLink = externalLink;
        this.counters = counters;
    }

    public String getJobName() {
        return this.jobName;
    }

    public void setJobName(String jobName) {
        this.jobName = jobName;
    }

    public void setStatus(SubmissionStatus status) {
        this.status = status;
    }

    public SubmissionStatus getStatus() {
        return this.status;
    }

    public void setExternalJobId(String externalJobId) {
        this.externalJobId = externalJobId;
    }

    public String getExternalJobId() {
        return this.externalJobId;
    }

    public void setProgress(double progress) {
        this.progress = progress;
    }

    public double getProgress() {
        return this.progress;
    }

    public void setCounters(Counters counters) {
        this.counters = counters;
    }

    public Counters getCounters() {
        return this.counters;
    }

    public void setExternalLink(String externalLink) {
        this.externalLink = externalLink;
    }

    public String getExternalLink() {
        return this.externalLink;
    }

    public void setError(SubmissionError error) {
        this.error = error;
    }

    public ImmutableContext getFromConnectorContext() {
        return this.fromConnectorContext;
    }

    public void setFromConnectorContext(ImmutableContext fromConnectorContext) {
        this.fromConnectorContext = fromConnectorContext;
    }

    public ImmutableContext getToConnectorContext() {
        return this.toConnectorContext;
    }

    public void setToConnectorContext(ImmutableContext toConnectorContext) {
        this.toConnectorContext = toConnectorContext;
    }

    public ImmutableContext getDriverContext() {
        return this.driverContext;
    }

    public void setDriverContext(ImmutableContext driverContext) {
        this.driverContext = driverContext;
    }

    public SubmissionError getError() {
        if (this.error == null) {
            this.error = new SubmissionError();
        }
        return this.error;
    }

    public Schema getFromSchema() {
        return this.fromSchema;
    }

    public void setFromSchema(Schema fromSchema) {
        this.fromSchema = fromSchema;
    }

    public Schema getToSchema() {
        return this.toSchema;
    }

    public void setToSchema(Schema toSchema) {
        this.toSchema = toSchema;
    }

    @Override
    public String toString() {
        return "MSubmission [jobName=" + this.jobName + ", status=" + (Object)((Object)this.status) + ", externalId=" + this.externalJobId + ", progress=" + this.progress + ", counters=" + this.counters + ", externalLink=" + this.externalLink + ", error=" + this.error + ", fromSchema=" + this.fromSchema + ", toSchema=" + this.toSchema + "]";
    }
}

