/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.schema.type;

import org.apache.sqoop.classification.InterfaceAudience;
import org.apache.sqoop.classification.InterfaceStability;
import org.apache.sqoop.schema.type.AbstractNumber;
import org.apache.sqoop.schema.type.ColumnType;

@InterfaceAudience.Public
@InterfaceStability.Unstable
public class FixedPoint
extends AbstractNumber {
    private Long byteSize;
    private Boolean signed;

    public FixedPoint(String name, Long byteSize, Boolean signed) {
        super(name);
        this.byteSize = byteSize;
        this.signed = signed;
    }

    public FixedPoint(String name, Boolean nullable, Long byteSize, Boolean signed) {
        super(name, nullable);
        this.byteSize = byteSize;
        this.signed = signed;
    }

    public Long getByteSize() {
        return this.byteSize;
    }

    public Boolean isSigned() {
        return this.signed;
    }

    @Override
    public ColumnType getType() {
        return ColumnType.FIXED_POINT;
    }

    @Override
    public String toString() {
        return "FixedPoint{" + super.toString() + ",byteSize=" + this.byteSize + ",signed=" + this.signed + "}";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FixedPoint)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        FixedPoint that = (FixedPoint)o;
        if (this.byteSize != null ? !this.byteSize.equals(that.byteSize) : that.byteSize != null) {
            return false;
        }
        return !(this.signed != null ? !this.signed.equals(that.signed) : that.signed != null);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.byteSize != null ? this.byteSize.hashCode() : 0);
        result = 31 * result + (this.signed != null ? this.signed.hashCode() : 0);
        return result;
    }
}

