/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.utils;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.sqoop.common.ErrorCode;
import org.apache.sqoop.common.MapContext;
import org.apache.sqoop.common.SqoopException;
import org.apache.sqoop.error.code.PasswordError;

public class PasswordUtils {
    private static final Logger LOG = Logger.getLogger(PasswordUtils.class);

    public static String readPassword(MapContext configurationContext, String passwordProperty, String passwordGeneratorProperty) {
        String plaintextPassword = configurationContext.getString(passwordProperty);
        String passwordGenerator = configurationContext.getString(passwordGeneratorProperty);
        if (StringUtils.isNotBlank((String)plaintextPassword)) {
            if (StringUtils.isNotBlank((String)passwordGenerator)) {
                LOG.warn((Object)(passwordProperty + " and " + passwordGeneratorProperty + " are both set, using " + passwordProperty));
            }
            return plaintextPassword;
        }
        if (StringUtils.isNotBlank((String)passwordGenerator)) {
            try {
                String password = PasswordUtils.readOutputFromGenerator(passwordGenerator);
                if (StringUtils.isNotBlank((String)password)) {
                    return password;
                }
                throw new SqoopException(PasswordError.PASSWORD_0001);
            }
            catch (IOException exception) {
                throw new SqoopException((ErrorCode)PasswordError.PASSWORD_0000, (Throwable)exception);
            }
        }
        return null;
    }

    public static String readOutputFromGenerator(String generatorCommand) throws IOException {
        String output;
        ProcessBuilder processBuilder = new ProcessBuilder("/bin/sh", "-c", generatorCommand);
        Process process = processBuilder.start();
        try (InputStreamReader inputStreamReader = new InputStreamReader(process.getInputStream(), Charset.forName("UTF-8"));
             BufferedReader bufferedReader = new BufferedReader(inputStreamReader);){
            output = bufferedReader.readLine();
        }
        return output;
    }
}

