/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.validation.validators;

import org.apache.sqoop.classification.InterfaceAudience;
import org.apache.sqoop.classification.InterfaceStability;
import org.apache.sqoop.common.ErrorCode;
import org.apache.sqoop.common.SqoopException;
import org.apache.sqoop.error.code.CoreError;
import org.apache.sqoop.validation.Status;
import org.apache.sqoop.validation.validators.AbstractValidator;

@InterfaceAudience.Public
@InterfaceStability.Unstable
public class InRange
extends AbstractValidator<Integer> {
    @Override
    public void validate(Integer instance) {
        if (instance != null) {
            int max;
            int min;
            if (this.getStringArgument().equals("")) {
                throw new SqoopException((ErrorCode)CoreError.CORE_0010, "InRange validator needs argument");
            }
            try {
                min = Integer.parseInt(this.getStringArgument().split(",")[0]);
                max = Integer.parseInt(this.getStringArgument().split(",")[1]);
            }
            catch (NumberFormatException exception) {
                throw new SqoopException(CoreError.CORE_0011, "InRange argument needs to have form MIN,MAX", exception);
            }
            if (instance < min || instance > max) {
                this.addMessage(Status.ERROR, "Integer must be in interval: [" + this.getStringArgument() + "]");
            }
        }
    }
}

