/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.security.authorization;

import com.beust.jcommander.internal.Lists;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.sqoop.common.SqoopException;
import org.apache.sqoop.model.MConnector;
import org.apache.sqoop.model.MJob;
import org.apache.sqoop.model.MLink;
import org.apache.sqoop.model.MPersistableEntity;
import org.apache.sqoop.model.MPrincipal;
import org.apache.sqoop.model.MPrivilege;
import org.apache.sqoop.model.MResource;
import org.apache.sqoop.model.MSubmission;
import org.apache.sqoop.repository.Repository;
import org.apache.sqoop.repository.RepositoryManager;
import org.apache.sqoop.security.AuthorizationHandler;
import org.apache.sqoop.security.AuthorizationManager;

public class AuthorizationEngine {
    private static String getResourceName(Object resource) {
        if (resource instanceof MConnector) {
            return ((MConnector)resource).getUniqueName();
        }
        if (resource instanceof MLink) {
            return ((MLink)resource).getName();
        }
        if (resource instanceof MJob) {
            return ((MJob)resource).getName();
        }
        return null;
    }

    public static <T extends MPersistableEntity> List<T> filterResource(final String doUserName, final MResource.TYPE type, List<T> resources) throws SqoopException {
        Collection collection = Collections2.filter(resources, (Predicate)new Predicate<T>(){

            public boolean apply(T input) {
                try {
                    String name = AuthorizationEngine.getResourceName(input);
                    AuthorizationEngine.checkPrivilege(doUserName, new MPrivilege[]{AuthorizationEngine.getPrivilege(type, name, MPrivilege.ACTION.READ)});
                    return true;
                }
                catch (RuntimeException e) {
                    return false;
                }
            }
        });
        return Lists.newArrayList((Collection)collection);
    }

    public static void readConnector(String doUserName, String connectorName) throws SqoopException {
        AuthorizationEngine.checkPrivilege(doUserName, AuthorizationEngine.getPrivilege(MResource.TYPE.CONNECTOR, connectorName, MPrivilege.ACTION.READ));
    }

    public static void readLink(String doUserName, String linkName) throws SqoopException {
        AuthorizationEngine.checkPrivilege(doUserName, AuthorizationEngine.getPrivilege(MResource.TYPE.LINK, linkName, MPrivilege.ACTION.READ));
    }

    public static void createLink(String doUserName, String connectorName) throws SqoopException {
        AuthorizationEngine.checkPrivilege(doUserName, AuthorizationEngine.getPrivilege(MResource.TYPE.CONNECTOR, connectorName, MPrivilege.ACTION.READ));
    }

    public static void updateLink(String doUserName, String connectorName, String linkName) throws SqoopException {
        MPrivilege privilege1 = AuthorizationEngine.getPrivilege(MResource.TYPE.CONNECTOR, connectorName, MPrivilege.ACTION.READ);
        MPrivilege privilege2 = AuthorizationEngine.getPrivilege(MResource.TYPE.LINK, linkName, MPrivilege.ACTION.WRITE);
        AuthorizationEngine.checkPrivilege(doUserName, privilege1, privilege2);
    }

    public static void deleteLink(String doUserName, String linkName) throws SqoopException {
        AuthorizationEngine.checkPrivilege(doUserName, AuthorizationEngine.getPrivilege(MResource.TYPE.LINK, linkName, MPrivilege.ACTION.WRITE));
    }

    public static void enableDisableLink(String doUserName, String linkName) throws SqoopException {
        AuthorizationEngine.checkPrivilege(doUserName, AuthorizationEngine.getPrivilege(MResource.TYPE.LINK, linkName, MPrivilege.ACTION.WRITE));
    }

    public static void readJob(String doUserName, String jobName) throws SqoopException {
        AuthorizationEngine.checkPrivilege(doUserName, AuthorizationEngine.getPrivilege(MResource.TYPE.JOB, jobName, MPrivilege.ACTION.READ));
    }

    public static void createJob(String doUserName, String linkName1, String linkName2) throws SqoopException {
        MPrivilege privilege1 = AuthorizationEngine.getPrivilege(MResource.TYPE.LINK, linkName1, MPrivilege.ACTION.READ);
        MPrivilege privilege2 = AuthorizationEngine.getPrivilege(MResource.TYPE.LINK, linkName2, MPrivilege.ACTION.READ);
        AuthorizationEngine.checkPrivilege(doUserName, privilege1, privilege2);
    }

    public static void updateJob(String doUserName, String linkName1, String linkName2, String jobName) throws SqoopException {
        MPrivilege privilege1 = AuthorizationEngine.getPrivilege(MResource.TYPE.LINK, linkName1, MPrivilege.ACTION.READ);
        MPrivilege privilege2 = AuthorizationEngine.getPrivilege(MResource.TYPE.LINK, linkName2, MPrivilege.ACTION.READ);
        MPrivilege privilege3 = AuthorizationEngine.getPrivilege(MResource.TYPE.JOB, jobName, MPrivilege.ACTION.WRITE);
        AuthorizationEngine.checkPrivilege(doUserName, privilege1, privilege2, privilege3);
    }

    public static void deleteJob(String doUserName, String jobName) throws SqoopException {
        AuthorizationEngine.checkPrivilege(doUserName, AuthorizationEngine.getPrivilege(MResource.TYPE.JOB, jobName, MPrivilege.ACTION.WRITE));
    }

    public static void enableDisableJob(String doUserName, String jobName) throws SqoopException {
        AuthorizationEngine.checkPrivilege(doUserName, AuthorizationEngine.getPrivilege(MResource.TYPE.JOB, jobName, MPrivilege.ACTION.WRITE));
    }

    public static void startJob(String doUserName, String jobName) throws SqoopException {
        AuthorizationEngine.checkPrivilege(doUserName, AuthorizationEngine.getPrivilege(MResource.TYPE.JOB, jobName, MPrivilege.ACTION.WRITE));
    }

    public static void stopJob(String doUserName, String jobName) throws SqoopException {
        AuthorizationEngine.checkPrivilege(doUserName, AuthorizationEngine.getPrivilege(MResource.TYPE.JOB, jobName, MPrivilege.ACTION.WRITE));
    }

    public static void statusJob(String doUserName, String jobName) throws SqoopException {
        AuthorizationEngine.checkPrivilege(doUserName, AuthorizationEngine.getPrivilege(MResource.TYPE.JOB, jobName, MPrivilege.ACTION.READ));
    }

    public static List<MSubmission> filterSubmission(final String doUserName, List<MSubmission> submissions) throws SqoopException {
        Collection collection = Collections2.filter(submissions, (Predicate)new Predicate<MSubmission>(){

            public boolean apply(MSubmission input) {
                try {
                    AuthorizationEngine.checkPrivilege(doUserName, new MPrivilege[]{AuthorizationEngine.getPrivilege(MResource.TYPE.JOB, input.getJobName(), MPrivilege.ACTION.READ)});
                    return true;
                }
                catch (RuntimeException e) {
                    return false;
                }
            }
        });
        return Lists.newArrayList((Collection)collection);
    }

    private static MPrivilege getPrivilege(MResource.TYPE resourceType, String resourceName, MPrivilege.ACTION privilegeAction) {
        return new MPrivilege(new MResource(resourceName, resourceType), privilegeAction, false);
    }

    private static void checkPrivilege(String doUserName, MPrivilege ... privileges) {
        AuthorizationHandler handler = AuthorizationManager.getInstance().getAuthorizationHandler();
        MPrincipal principal = new MPrincipal(doUserName, MPrincipal.TYPE.USER);
        ArrayList<MPrivilege> privilegesNeedCheck = new ArrayList<MPrivilege>();
        for (MPrivilege privilege : privileges) {
            Repository repository = RepositoryManager.getInstance().getRepository();
            if (MResource.TYPE.LINK.name().equalsIgnoreCase(privilege.getResource().getType())) {
                MLink link = repository.findLink(privilege.getResource().getName());
                if (doUserName.equals(link.getCreationUser())) continue;
                privilegesNeedCheck.add(privilege);
                continue;
            }
            if (MResource.TYPE.JOB.name().equalsIgnoreCase(privilege.getResource().getType())) {
                MJob job = repository.findJob(privilege.getResource().getName());
                if (doUserName.equals(job.getCreationUser())) continue;
                privilegesNeedCheck.add(privilege);
                continue;
            }
            privilegesNeedCheck.add(privilege);
        }
        handler.checkPrivileges(principal, privilegesNeedCheck);
    }
}

