/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.attachments;

import java.io.File;
import java.io.IOException;
import javax.activation.FileDataSource;
import org.apache.axiom.attachments.AttachmentCacheMonitor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CachedFileDataSource
extends FileDataSource {
    String contentType = null;
    protected static Log log = LogFactory.getLog(CachedFileDataSource.class);
    private static AttachmentCacheMonitor acm = AttachmentCacheMonitor.getAttachmentCacheMonitor();
    private String cachedFileName = null;

    public CachedFileDataSource(File arg0) {
        super(arg0);
        if (log.isDebugEnabled()) {
            log.debug("Enter CachedFileDataSource ctor");
        }
        if (arg0 != null) {
            try {
                this.cachedFileName = arg0.getCanonicalPath();
            }
            catch (IOException e) {
                log.error("IOException caught: " + e);
            }
        }
        if (this.cachedFileName != null) {
            if (log.isDebugEnabled()) {
                log.debug("Cached file: " + this.cachedFileName);
                log.debug("Registering the file with AttachmentCacheMonitor and also marked it as being accessed");
            }
            acm.access(this.cachedFileName);
            acm.register(this.cachedFileName);
        }
    }

    public String getContentType() {
        if (this.contentType != null) {
            return this.contentType;
        }
        return super.getContentType();
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }
}

