/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.om.impl.builder;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMComment;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMDocument;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMException;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMHierarchyException;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.OMProcessingInstruction;
import org.apache.axiom.om.OMText;
import org.apache.axiom.om.impl.OMContainerEx;
import org.apache.axiom.om.impl.OMNodeEx;
import org.apache.axiom.om.impl.builder.CustomBuilder;
import org.apache.axiom.om.impl.builder.StAXBuilder;
import org.apache.axiom.om.util.StAXUtils;
import org.apache.axiom.util.stax.XMLEventUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class StAXOMBuilder
extends StAXBuilder {
    private static final Log log = LogFactory.getLog(StAXOMBuilder.class);
    private boolean doTrace = log.isDebugEnabled();
    private static int nsCount = 0;
    boolean namespaceURIInterning = false;
    int lookAheadToken = -1;

    public StAXOMBuilder(OMFactory ombuilderFactory, XMLStreamReader parser) {
        super(ombuilderFactory, parser);
        this.document = this.createDocument();
    }

    public StAXOMBuilder(OMFactory factory, XMLStreamReader parser, OMElement element, String characterEncoding) {
        super(factory, parser, characterEncoding);
        this.doTrace = log.isDebugEnabled();
        this.namespaceURIInterning = false;
        this.lookAheadToken = -1;
        this.document = this.createDocument();
        this.lastNode = element;
        this.document.setOMDocumentElement(element);
        this.populateOMElement(element);
    }

    public StAXOMBuilder(OMFactory factory, XMLStreamReader parser, OMElement element) {
        this(factory, parser, element, null);
    }

    public StAXOMBuilder(String filePath) throws XMLStreamException, FileNotFoundException {
        this(StAXUtils.createXMLStreamReader(new FileInputStream(filePath)));
    }

    public StAXOMBuilder(XMLStreamReader parser) {
        super(parser);
        this.doTrace = log.isDebugEnabled();
        this.namespaceURIInterning = false;
        this.lookAheadToken = -1;
        this.omfactory = OMAbstractFactory.getOMFactory();
        this.document = this.createDocument();
    }

    public StAXOMBuilder(InputStream inStream) throws XMLStreamException {
        this(StAXUtils.createXMLStreamReader(inStream));
    }

    public StAXOMBuilder() {
        this.doTrace = log.isDebugEnabled();
        this.namespaceURIInterning = false;
        this.lookAheadToken = -1;
    }

    private OMDocument createDocument() {
        OMDocument document = this.omfactory.createOMDocument(this);
        if (this.charEncoding != null) {
            document.setCharsetEncoding(this.charEncoding);
        }
        if (this.parser.getEventType() == 7) {
            document.setXMLVersion(this.parser.getVersion());
            document.setStandalone(this.parser.isStandalone() ? "yes" : "no");
        } else {
            document.setXMLVersion("1.0");
            document.setStandalone("yes");
        }
        return document;
    }

    public int next() throws OMException {
        try {
            int token;
            block16: while (true) {
                int currentParserToken;
                if (this.done) {
                    throw new OMException();
                }
                token = this.parserNext();
                if (!this.cache) {
                    return token;
                }
                if (this.doTrace && (currentParserToken = this.parser.getEventType()) != token) {
                    log.debug("WARNING: The current state of the parser is not equal to the state just received from the parser. The current state in the paser is " + XMLEventUtils.getEventTypeString(currentParserToken) + " the state just received is " + XMLEventUtils.getEventTypeString(token));
                }
                if (this.doTrace) {
                    this.logParserState();
                }
                switch (token) {
                    case 1: {
                        ++this.elementLevel;
                        this.lastNode = this.createNextOMElement();
                        break block16;
                    }
                    case 4: {
                        this.lastNode = this.createOMText(4);
                        break block16;
                    }
                    case 12: {
                        this.lastNode = this.createOMText(12);
                        break block16;
                    }
                    case 2: {
                        this.endElement();
                        --this.elementLevel;
                        break block16;
                    }
                    case 8: {
                        this.done = true;
                        ((OMContainerEx)((Object)this.document)).setComplete(true);
                        break block16;
                    }
                    case 6: {
                        try {
                            this.lastNode = this.createOMText(6);
                            if (this.lastNode != null) break block16;
                        }
                        catch (OMHierarchyException ex) {}
                        continue block16;
                    }
                    case 5: {
                        this.lastNode = this.createComment();
                        break block16;
                    }
                    case 11: {
                        this.createDTD();
                        break block16;
                    }
                    case 3: {
                        this.lastNode = this.createPI();
                        break block16;
                    }
                    case 9: {
                        this.lastNode = this.createOMText(9);
                        break block16;
                    }
                    default: {
                        throw new OMException();
                    }
                }
                break;
            }
            return token;
        }
        catch (XMLStreamException e) {
            throw new OMException(e);
        }
    }

    protected OMNode createNextOMElement() {
        String localPart;
        String namespace;
        CustomBuilder customBuilder;
        OMNode newElement = null;
        if (this.elementLevel == 1 && this.customBuilderForPayload != null) {
            newElement = this.createWithCustomBuilder(this.customBuilderForPayload, this.omfactory);
        } else if (this.customBuilders != null && this.elementLevel <= this.maxDepthForCustomBuilders && (customBuilder = this.getCustomBuilder(namespace = this.parser.getNamespaceURI(), localPart = this.parser.getLocalName())) != null) {
            newElement = this.createWithCustomBuilder(customBuilder, this.omfactory);
        }
        if (newElement == null) {
            newElement = this.createOMElement();
        } else {
            --this.elementLevel;
        }
        return newElement;
    }

    protected OMNode createWithCustomBuilder(CustomBuilder customBuilder, OMFactory factory) {
        String namespace = this.parser.getNamespaceURI();
        String localPart = this.parser.getLocalName();
        if (log.isDebugEnabled()) {
            log.debug("Invoking CustomBuilder, " + customBuilder.toString() + ", to the OMNode for {" + namespace + "}" + localPart);
        }
        OMContainer parent = null;
        parent = this.lastNode != null ? (this.lastNode.isComplete() ? this.lastNode.getParent() : (OMContainer)((Object)this.lastNode)) : this.document;
        OMElement node = customBuilder.create(namespace, localPart, parent, this.parser, factory);
        if (log.isDebugEnabled()) {
            if (node != null) {
                log.debug("The CustomBuilder, " + customBuilder.toString() + "successfully constructed the OMNode for {" + namespace + "}" + localPart);
            } else {
                log.debug("The CustomBuilder, " + customBuilder.toString() + " did not construct an OMNode for {" + namespace + "}" + localPart + ". The OMNode will be constructed using the installed stax om builder");
            }
            log.debug("The current state of the parser is: ");
            this.logParserState();
        }
        return node;
    }

    protected void logParserState() {
        if (this.doTrace) {
            int currentEvent = this.parser.getEventType();
            switch (currentEvent) {
                case 1: {
                    log.trace("START_ELEMENT: ");
                    log.trace("  QName: " + this.parser.getName());
                    break;
                }
                case 7: {
                    log.trace("START_DOCUMENT: ");
                    break;
                }
                case 4: {
                    log.trace("CHARACTERS: ");
                    break;
                }
                case 12: {
                    log.trace("CDATA: ");
                    break;
                }
                case 2: {
                    log.trace("END_ELEMENT: ");
                    log.trace("  QName: " + this.parser.getName());
                    break;
                }
                case 8: {
                    log.trace("END_DOCUMENT: ");
                    break;
                }
                case 6: {
                    log.trace("SPACE: ");
                    break;
                }
                case 5: {
                    log.trace("COMMENT: ");
                    break;
                }
                case 11: {
                    log.trace("DTD: ");
                    log.trace("[" + this.parser.getText() + "]");
                    break;
                }
                case 3: {
                    log.trace("PROCESSING_INSTRUCTION: ");
                    log.trace("   [" + this.parser.getPITarget() + "][" + this.parser.getPIData() + "]");
                    break;
                }
                case 9: {
                    log.trace("ENTITY_REFERENCE: ");
                    log.trace("    " + this.parser.getLocalName() + "[" + this.parser.getText() + "]");
                    break;
                }
                default: {
                    log.trace("UNKNOWN_STATE: " + currentEvent);
                }
            }
        }
    }

    private void populateOMElement(OMElement node) {
        this.processNamespaceData(node);
        this.processAttributes(node);
        Location location = this.parser.getLocation();
        if (location != null) {
            node.setLineNumber(location.getLineNumber());
        }
    }

    protected OMNode createOMElement() throws OMException {
        OMElement node;
        String elementName = this.parser.getLocalName();
        if (this.lastNode == null) {
            node = this.omfactory.createOMElement(elementName, null, this.document, this);
        } else if (this.lastNode.isComplete()) {
            node = this.omfactory.createOMElement(elementName, null, this.lastNode.getParent(), this);
            ((OMNodeEx)this.lastNode).setNextOMSibling(node);
            ((OMNodeEx)((Object)node)).setPreviousOMSibling(this.lastNode);
        } else {
            OMContainerEx e = (OMContainerEx)((Object)this.lastNode);
            node = this.omfactory.createOMElement(elementName, null, (OMElement)this.lastNode, this);
            e.setFirstChild(node);
        }
        this.populateOMElement(node);
        return node;
    }

    protected OMNode createComment() throws OMException {
        OMComment node = this.lastNode == null ? this.omfactory.createOMComment(this.document, this.parser.getText()) : (this.lastNode.isComplete() ? this.omfactory.createOMComment(this.lastNode.getParent(), this.parser.getText()) : this.omfactory.createOMComment((OMElement)this.lastNode, this.parser.getText()));
        return node;
    }

    protected OMNode createDTD() throws OMException {
        if (!this.parser.hasText()) {
            return null;
        }
        String dtdText = this.getDTDText();
        this.lastNode = this.omfactory.createOMDocType(this.document, dtdText);
        return this.lastNode;
    }

    private String getDTDText() throws OMException {
        String text;
        block3: {
            text = null;
            try {
                text = this.parser.getText();
            }
            catch (RuntimeException e) {
                Boolean b = (Boolean)this.parser.getProperty("javax.xml.stream.isSupportingExternalEntities");
                if (b == null || b == Boolean.TRUE) {
                    throw e;
                }
                if (!log.isDebugEnabled()) break block3;
                log.debug("An exception occurred while calling getText() for a DOCTYPE.  The exception is ignored because external entites support is disabled.  The ignored exception is " + e);
            }
        }
        return text;
    }

    protected OMNode createPI() throws OMException {
        String target = this.parser.getPITarget();
        String data = this.parser.getPIData();
        OMProcessingInstruction node = this.lastNode == null ? this.omfactory.createOMProcessingInstruction(this.document, target, data) : (this.lastNode.isComplete() ? this.omfactory.createOMProcessingInstruction(this.lastNode.getParent(), target, data) : (this.lastNode instanceof OMText ? this.omfactory.createOMProcessingInstruction(this.lastNode.getParent(), target, data) : this.omfactory.createOMProcessingInstruction((OMContainer)((Object)this.lastNode), target, data)));
        return node;
    }

    protected void endElement() {
        if (this.lastNode.isComplete()) {
            OMNodeEx parent = (OMNodeEx)((Object)this.lastNode.getParent());
            parent.setComplete(true);
            this.lastNode = parent;
        } else {
            OMNodeEx e = (OMNodeEx)this.lastNode;
            e.setComplete(true);
        }
    }

    public OMElement getDocumentElement() {
        return this.getDocumentElement(false);
    }

    public OMElement getDocumentElement(boolean discardDocument) {
        OMElement element = this.document.getOMDocumentElement();
        if (discardDocument) {
            OMNodeEx nodeEx = (OMNodeEx)((Object)element);
            nodeEx.setParent(null);
            nodeEx.setPreviousOMSibling(null);
            nodeEx.setNextOMSibling(null);
        }
        return element;
    }

    protected void processNamespaceData(OMElement node) {
        String namespaceURI = this.parser.getNamespaceURI();
        String prefix = this.parser.getPrefix();
        int namespaceCount = this.parser.getNamespaceCount();
        for (int i = 0; i < namespaceCount; ++i) {
            String nsprefix = this.parser.getNamespacePrefix(i);
            String namespaceURIFromParser = this.parser.getNamespaceURI(i);
            if (nsprefix == null || "".equals(nsprefix)) {
                String nsuri = this.parser.getNamespaceURI(i);
                node.declareDefaultNamespace(nsuri == null ? "" : nsuri);
                continue;
            }
            if (this.isNamespaceURIInterning()) {
                namespaceURIFromParser = namespaceURIFromParser.intern();
            }
            node.declareNamespace(namespaceURIFromParser, nsprefix);
        }
        if (namespaceURI != null && namespaceURI.length() > 0) {
            OMNamespace namespace = node.findNamespaceURI(prefix == null ? "" : prefix);
            if (namespace == null || !namespace.getNamespaceURI().equals(namespaceURI)) {
                if (this.isNamespaceURIInterning()) {
                    namespaceURI = namespaceURI.intern();
                }
                namespace = prefix == null || "".equals(prefix) ? node.declareDefaultNamespace(namespaceURI) : node.declareNamespace(namespaceURI, prefix);
            }
            node.setNamespaceWithNoFindInCurrentScope(namespace);
        }
    }

    public void setDoDebug(boolean doDebug) {
        this.doTrace = doDebug;
    }

    protected String createPrefix() {
        return "ns" + nsCount++;
    }

    public void setNamespaceURIInterning(boolean b) {
        this.namespaceURIInterning = b;
    }

    public boolean isNamespaceURIInterning() {
        return this.namespaceURIInterning;
    }

    private int parserNext() throws XMLStreamException {
        if (this.lookAheadToken >= 0) {
            int token = this.lookAheadToken;
            this.lookAheadToken = -1;
            return token;
        }
        if (this.parserException != null) {
            log.warn("Attempt to access a parser that has thrown a parse exception before; rethrowing the original exception.");
            if (this.parserException instanceof XMLStreamException) {
                throw (XMLStreamException)this.parserException;
            }
            throw (RuntimeException)this.parserException;
        }
        try {
            return this.parser.next();
        }
        catch (XMLStreamException ex) {
            this.parserException = ex;
            throw ex;
        }
    }

    public boolean lookahead() {
        try {
            while (true) {
                if (this.lookAheadToken < 0) {
                    this.lookAheadToken = this.parserNext();
                }
                if (this.lookAheadToken == 1) {
                    return true;
                }
                if (this.lookAheadToken == 2 || this.lookAheadToken == 7 || this.lookAheadToken == 8) {
                    this.next();
                    return false;
                }
                this.next();
            }
        }
        catch (XMLStreamException e) {
            throw new OMException(e);
        }
    }

    public boolean isLookahead() {
        return this.lookAheadToken >= 0;
    }
}

