/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.builder;

import java.io.InputStream;
import javax.mail.internet.ContentType;
import javax.mail.internet.ParseException;
import org.apache.axiom.attachments.Attachments;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMException;
import org.apache.axis2.AxisFault;
import org.apache.axis2.builder.Builder;
import org.apache.axis2.builder.BuilderUtil;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.util.MessageProcessorSelector;

public class MIMEBuilder
implements Builder {
    @Override
    public OMElement processDocument(InputStream inputStream, String contentType, MessageContext msgContext) throws AxisFault {
        String startInfo;
        ContentType ct;
        Attachments attachments = BuilderUtil.createAttachmentsMap(msgContext, inputStream, contentType);
        String charSetEncoding = BuilderUtil.getCharSetEncoding(attachments.getSOAPPartContentType());
        if (charSetEncoding == null || "null".equalsIgnoreCase(charSetEncoding)) {
            charSetEncoding = "UTF-8";
        }
        msgContext.setProperty("CHARACTER_SET_ENCODING", charSetEncoding);
        msgContext.setProperty("Attachments", attachments);
        msgContext.setAttachmentMap(attachments);
        msgContext.setDoingSwA(true);
        try {
            ct = new ContentType(contentType);
        }
        catch (ParseException e) {
            throw new OMException("Invalid Content Type Field in the Mime Message", e);
        }
        String type = ct.getParameter("type");
        Builder builder = MessageProcessorSelector.getMessageBuilder(type, msgContext);
        if ("application/xop+xml".equals(type) && (startInfo = ct.getParameter("start-info")) != null) {
            type = startInfo;
        }
        return builder.processDocument(attachments.getSOAPPartInputStream(), type, msgContext);
    }
}

