/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.clustering.state.commands;

import org.apache.axis2.clustering.ClusteringFault;
import org.apache.axis2.clustering.state.commands.UpdateStateCommand;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.ServiceGroupContext;
import org.apache.axis2.description.AxisServiceGroup;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class UpdateServiceGroupStateCommand
extends UpdateStateCommand {
    private static Log log = LogFactory.getLog(UpdateServiceGroupStateCommand.class);
    protected String serviceGroupName;
    protected String serviceGroupContextId;

    public String getServiceGroupName() {
        return this.serviceGroupName;
    }

    public void setServiceGroupName(String serviceGroupName) {
        this.serviceGroupName = serviceGroupName;
    }

    public String getServiceGroupContextId() {
        return this.serviceGroupContextId;
    }

    public void setServiceGroupContextId(String serviceGroupContextId) {
        this.serviceGroupContextId = serviceGroupContextId;
    }

    @Override
    public void execute(ConfigurationContext configContext) throws ClusteringFault {
        ServiceGroupContext sgCtx = configContext.getServiceGroupContext(this.serviceGroupContextId);
        if (sgCtx == null) {
            AxisServiceGroup axisServiceGroup = configContext.getAxisConfiguration().getServiceGroup(this.serviceGroupName);
            if (axisServiceGroup == null) {
                return;
            }
            sgCtx = new ServiceGroupContext(configContext, axisServiceGroup);
            sgCtx.setId(this.serviceGroupContextId);
            configContext.addServiceGroupContextIntoSoapSessionTable(sgCtx);
        }
        if (log.isDebugEnabled()) {
            log.debug("Gonna update SG prop in " + this.serviceGroupContextId + "===" + sgCtx);
        }
        this.propertyUpdater.updateProperties(sgCtx);
    }

    public String toString() {
        return "UpdateServiceGroupStateCommand";
    }
}

