/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.databinding.types.soapencoding;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axis2.databinding.ADBBean;
import org.apache.axis2.databinding.ADBDataSource;
import org.apache.axis2.databinding.ADBException;
import org.apache.axis2.databinding.types.Id;
import org.apache.axis2.databinding.types.URI;
import org.apache.axis2.databinding.types.soapencoding.ExtensionMapper;
import org.apache.axis2.databinding.utils.BeanUtil;
import org.apache.axis2.databinding.utils.ConverterUtil;

public class Array
implements ADBBean {
    public static final String CHILD_LOCAL_NAME = "item";
    public static final String SOAP_NAMESPACE_PREFIX = "SOAP-ENC";
    protected List objectList = new ArrayList();
    protected QName arrayTypeQName;
    protected String localArrayType;
    protected String localOffset;
    protected Id localId;
    protected URI localHref;

    private static String generatePrefix(String namespace) {
        if (namespace.equals("http://schemas.xmlsoap.org/soap/encoding/")) {
            return SOAP_NAMESPACE_PREFIX;
        }
        return BeanUtil.getUniquePrefix();
    }

    public List getObjectList() {
        return this.objectList;
    }

    public void setObjectList(List objectList) {
        this.objectList = objectList;
    }

    public void addObject(Object object) {
        this.objectList.add(object);
    }

    public void setArrayTypeQName(QName qname) {
        this.arrayTypeQName = qname;
    }

    public QName getArrayTypeQName() {
        return this.arrayTypeQName;
    }

    public String getArrayType() {
        return this.localArrayType;
    }

    public void setArrayType(String param) {
        this.localArrayType = param;
    }

    public String getOffset() {
        return this.localOffset;
    }

    public void setOffset(String param) {
        this.localOffset = param;
    }

    public Id getId() {
        return this.localId;
    }

    public void setId(Id param) {
        this.localId = param;
    }

    public URI getHref() {
        return this.localHref;
    }

    public void setHref(URI param) {
        this.localHref = param;
    }

    public static boolean isReaderMTOMAware(XMLStreamReader reader) {
        boolean isReaderMTOMAware = false;
        try {
            isReaderMTOMAware = Boolean.TRUE.equals(reader.getProperty("IsDatahandlersAwareParsing"));
        }
        catch (IllegalArgumentException e) {
            isReaderMTOMAware = false;
        }
        return isReaderMTOMAware;
    }

    @Override
    public OMElement getOMElement(QName parentQName, OMFactory factory) throws ADBException {
        ADBDataSource dataSource = new ADBDataSource(this, parentQName);
        return factory.createOMElement(dataSource, parentQName);
    }

    @Override
    public void serialize(QName parentQName, XMLStreamWriter xmlWriter) throws XMLStreamException, ADBException {
        this.serialize(parentQName, xmlWriter, false);
    }

    @Override
    public void serialize(QName parentQName, XMLStreamWriter xmlWriter, boolean serializeType) throws XMLStreamException, ADBException {
        String prefix = parentQName.getPrefix();
        String namespace = parentQName.getNamespaceURI();
        this.writeStartElement(namespace, parentQName.getLocalPart(), prefix, xmlWriter);
        if (serializeType) {
            String namespacePrefix = this.registerPrefix(xmlWriter, "http://schemas.xmlsoap.org/soap/encoding/");
            if (namespacePrefix != null && namespacePrefix.trim().length() > 0) {
                this.writeAttribute("xsi", "http://www.w3.org/2001/XMLSchema-instance", "type", namespacePrefix + ":Array", xmlWriter);
            } else {
                this.writeAttribute("xsi", "http://www.w3.org/2001/XMLSchema-instance", "type", "Array", xmlWriter);
            }
        }
        String arrayTypePrefix = null;
        String arrayType = null;
        if (this.arrayTypeQName != null) {
            arrayTypePrefix = this.registerPrefix(xmlWriter, this.arrayTypeQName.getNamespaceURI());
            arrayType = this.arrayTypeQName.getLocalPart() + "[" + this.objectList.size() + "]";
        } else {
            arrayTypePrefix = this.registerPrefix(xmlWriter, "http://www.w3.org/2001/XMLSchema");
            arrayType = "ur-type[" + this.objectList.size() + "]";
        }
        if (arrayTypePrefix != null && arrayTypePrefix.trim().length() > 0) {
            arrayType = arrayTypePrefix + ":" + arrayType;
        }
        this.writeAttribute(this.registerPrefix(xmlWriter, "http://schemas.xmlsoap.org/soap/encoding/"), "http://schemas.xmlsoap.org/soap/encoding/", "arrayType", arrayType, xmlWriter);
        if (this.localOffset != null) {
            this.writeAttribute("http://schemas.xmlsoap.org/soap/encoding/", "offset", ConverterUtil.convertToString(this.localOffset), xmlWriter);
        }
        if (this.localId != null) {
            this.writeAttribute("", "id", ConverterUtil.convertToString(this.localId), xmlWriter);
        }
        if (this.localHref != null) {
            this.writeAttribute("", "href", ConverterUtil.convertToString(this.localHref), xmlWriter);
        }
        for (ADBBean adbBean : this.objectList) {
            if (adbBean != null) {
                if (this.arrayTypeQName != null) {
                    adbBean.serialize(new QName("", CHILD_LOCAL_NAME), xmlWriter);
                    continue;
                }
                adbBean.serialize(new QName("", CHILD_LOCAL_NAME), xmlWriter, true);
                continue;
            }
            this.writeStartElement("", CHILD_LOCAL_NAME, null, xmlWriter);
            this.writeAttribute("xsi", "http://www.w3.org/2001/XMLSchema-instance", "nil", "1", xmlWriter);
            xmlWriter.writeEndElement();
        }
        xmlWriter.writeEndElement();
    }

    private void writeStartElement(String namespace, String localPart, String prefix, XMLStreamWriter xmlWriter) throws XMLStreamException {
        if (namespace != null && namespace.trim().length() > 0) {
            String writerPrefix = xmlWriter.getPrefix(namespace);
            if (writerPrefix != null) {
                xmlWriter.writeStartElement(namespace, localPart);
            } else {
                if (prefix == null) {
                    prefix = Array.generatePrefix(namespace);
                }
                xmlWriter.writeStartElement(prefix, localPart, namespace);
                xmlWriter.writeNamespace(prefix, namespace);
                xmlWriter.setPrefix(prefix, namespace);
            }
        } else {
            xmlWriter.writeStartElement(localPart);
        }
    }

    private void writeAttribute(String prefix, String namespace, String attName, String attValue, XMLStreamWriter xmlWriter) throws XMLStreamException {
        if (xmlWriter.getPrefix(namespace) == null) {
            xmlWriter.writeNamespace(prefix, namespace);
            xmlWriter.setPrefix(prefix, namespace);
        }
        xmlWriter.writeAttribute(namespace, attName, attValue);
    }

    private void writeAttribute(String namespace, String attName, String attValue, XMLStreamWriter xmlWriter) throws XMLStreamException {
        if (namespace.equals("")) {
            xmlWriter.writeAttribute(attName, attValue);
        } else {
            this.registerPrefix(xmlWriter, namespace);
            xmlWriter.writeAttribute(namespace, attName, attValue);
        }
    }

    private void writeQNameAttribute(String namespace, String attName, QName qname, XMLStreamWriter xmlWriter) throws XMLStreamException {
        String attributeNamespace = qname.getNamespaceURI();
        String attributePrefix = xmlWriter.getPrefix(attributeNamespace);
        if (attributePrefix == null) {
            attributePrefix = this.registerPrefix(xmlWriter, attributeNamespace);
        }
        String attributeValue = attributePrefix.trim().length() > 0 ? attributePrefix + ":" + qname.getLocalPart() : qname.getLocalPart();
        if (namespace.equals("")) {
            xmlWriter.writeAttribute(attName, attributeValue);
        } else {
            this.registerPrefix(xmlWriter, namespace);
            xmlWriter.writeAttribute(namespace, attName, attributeValue);
        }
    }

    private void writeQName(QName qname, XMLStreamWriter xmlWriter) throws XMLStreamException {
        String namespaceURI = qname.getNamespaceURI();
        if (namespaceURI != null) {
            String prefix = xmlWriter.getPrefix(namespaceURI);
            if (prefix == null) {
                prefix = Array.generatePrefix(namespaceURI);
                xmlWriter.writeNamespace(prefix, namespaceURI);
                xmlWriter.setPrefix(prefix, namespaceURI);
            }
            if (prefix.trim().length() > 0) {
                xmlWriter.writeCharacters(prefix + ":" + ConverterUtil.convertToString(qname));
            } else {
                xmlWriter.writeCharacters(ConverterUtil.convertToString(qname));
            }
        } else {
            xmlWriter.writeCharacters(ConverterUtil.convertToString(qname));
        }
    }

    private void writeQNames(QName[] qnames, XMLStreamWriter xmlWriter) throws XMLStreamException {
        if (qnames != null) {
            StringBuffer stringToWrite = new StringBuffer();
            String namespaceURI = null;
            String prefix = null;
            for (int i = 0; i < qnames.length; ++i) {
                if (i > 0) {
                    stringToWrite.append(" ");
                }
                if ((namespaceURI = qnames[i].getNamespaceURI()) != null) {
                    prefix = xmlWriter.getPrefix(namespaceURI);
                    if (prefix == null || prefix.length() == 0) {
                        prefix = Array.generatePrefix(namespaceURI);
                        xmlWriter.writeNamespace(prefix, namespaceURI);
                        xmlWriter.setPrefix(prefix, namespaceURI);
                    }
                    if (prefix.trim().length() > 0) {
                        stringToWrite.append(prefix).append(":").append(ConverterUtil.convertToString(qnames[i]));
                        continue;
                    }
                    stringToWrite.append(ConverterUtil.convertToString(qnames[i]));
                    continue;
                }
                stringToWrite.append(ConverterUtil.convertToString(qnames[i]));
            }
            xmlWriter.writeCharacters(stringToWrite.toString());
        }
    }

    private String registerPrefix(XMLStreamWriter xmlWriter, String namespace) throws XMLStreamException {
        String prefix = xmlWriter.getPrefix(namespace);
        if (prefix == null) {
            prefix = Array.generatePrefix(namespace);
            while (xmlWriter.getNamespaceContext().getNamespaceURI(prefix) != null) {
                prefix = BeanUtil.getUniquePrefix();
            }
            xmlWriter.writeNamespace(prefix, namespace);
            xmlWriter.setPrefix(prefix, namespace);
        }
        return prefix;
    }

    @Override
    public XMLStreamReader getPullParser(QName qName) throws ADBException {
        return null;
    }

    public static class Factory {
        public static Array parse(XMLStreamReader reader, Class mapperClass) throws Exception {
            Array object = new Array();
            String nillableValue = null;
            String prefix = "";
            String namespaceuri = "";
            try {
                while (!reader.isStartElement() && !reader.isEndElement()) {
                    reader.next();
                }
                Vector<String> handledAttributes = new Vector<String>();
                String attributeType = reader.getAttributeValue("http://schemas.xmlsoap.org/soap/encoding/", "arrayType");
                object.setArrayType(ConverterUtil.convertToString(attributeType));
                handledAttributes.add("arrayType");
                String offset = reader.getAttributeValue("http://schemas.xmlsoap.org/soap/encoding/", "offset");
                object.setOffset(ConverterUtil.convertToString(offset));
                handledAttributes.add("offset");
                String id = reader.getAttributeValue(null, "id");
                object.setId(ConverterUtil.convertToID(id));
                handledAttributes.add("id");
                String href = reader.getAttributeValue(null, "href");
                object.setHref(ConverterUtil.convertToAnyURI(href));
                handledAttributes.add("href");
                reader.next();
                while (!reader.isStartElement() && !reader.isEndElement()) {
                    reader.next();
                }
                QName arrayElementQName = Factory.getInnerElementsQName(attributeType, reader);
                object.setArrayTypeQName(arrayElementQName);
                if (reader.isStartElement()) {
                    boolean loopDone = false;
                    while (!loopDone) {
                        if (reader.isStartElement()) {
                            nillableValue = reader.getAttributeValue("http://www.w3.org/2001/XMLSchema-instance", "nil");
                            if ("true".equals(nillableValue) || "1".equals(nillableValue)) {
                                while (!reader.isEndElement()) {
                                    reader.next();
                                }
                                object.addObject(null);
                            } else if (arrayElementQName != null) {
                                object.addObject(Factory.getObject(arrayElementQName, reader, mapperClass));
                            } else {
                                QName typeQName = Factory.getTypeQName(reader);
                                if (typeQName == null) {
                                    typeQName = reader.getName();
                                }
                                object.addObject(Factory.getObject(typeQName, reader, mapperClass));
                            }
                            while (!reader.isStartElement() && !reader.isEndElement()) {
                                reader.next();
                            }
                            reader.next();
                            continue;
                        }
                        if (reader.isEndElement()) {
                            loopDone = true;
                            continue;
                        }
                        reader.next();
                    }
                }
                while (!reader.isStartElement() && !reader.isEndElement()) {
                    reader.next();
                }
                if (reader.isStartElement()) {
                    throw new ADBException("Unexpected subelement " + reader.getLocalName());
                }
            }
            catch (XMLStreamException e) {
                throw new Exception("Exception while parsing array", e);
            }
            return object;
        }

        private static Object getObject(QName qName, XMLStreamReader reader, Class mapperClass) throws Exception {
            Object returnObject = null;
            if (qName.getNamespaceURI().equals("http://schemas.xmlsoap.org/soap/encoding/")) {
                returnObject = ExtensionMapper.getTypeObject(qName.getNamespaceURI(), qName.getLocalPart(), reader);
            } else if (qName.getNamespaceURI().equals("http://www.w3.org/2001/XMLSchema")) {
                returnObject = org.apache.axis2.databinding.types.xsd.ExtensionMapper.getTypeObject(qName.getNamespaceURI(), qName.getLocalPart(), reader);
            } else {
                Method getObjectMethod = mapperClass.getMethod("getTypeObject", String.class, String.class, XMLStreamReader.class);
                returnObject = getObjectMethod.invoke(null, qName.getNamespaceURI(), qName.getLocalPart(), reader);
            }
            return returnObject;
        }

        private static QName getInnerElementsQName(String attributeType, XMLStreamReader reader) {
            QName typeQName = null;
            String prefix = "";
            String type = attributeType;
            if (attributeType.indexOf(":") > -1) {
                prefix = attributeType.substring(0, attributeType.indexOf(":"));
                type = attributeType.substring(attributeType.indexOf(":") + 1);
            }
            String namespace = reader.getNamespaceURI(prefix);
            if (!(type = type.substring(0, type.indexOf("["))).equals("ur-type")) {
                typeQName = new QName(namespace, type);
            }
            return typeQName;
        }

        private static QName getTypeQName(XMLStreamReader reader) {
            String fullTypeName;
            QName typeQName = null;
            if (reader.getAttributeValue("http://www.w3.org/2001/XMLSchema-instance", "type") != null && (fullTypeName = reader.getAttributeValue("http://www.w3.org/2001/XMLSchema-instance", "type")) != null) {
                String nsPrefix = null;
                if (fullTypeName.indexOf(":") > -1) {
                    nsPrefix = fullTypeName.substring(0, fullTypeName.indexOf(":"));
                }
                nsPrefix = nsPrefix == null ? "" : nsPrefix;
                String type = fullTypeName.substring(fullTypeName.indexOf(":") + 1);
                typeQName = new QName(reader.getNamespaceURI(nsPrefix), type);
            }
            return typeQName;
        }
    }
}

