/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.datasource;

import java.io.ByteArrayInputStream;
import java.io.UnsupportedEncodingException;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.axiom.om.OMDataSourceExt;
import org.apache.axiom.om.ds.OMDataSourceExtBase;
import org.apache.axiom.om.util.StAXUtils;

public class XMLStringDataSource
extends OMDataSourceExtBase {
    String data;

    public XMLStringDataSource(String data) {
        this.data = data;
    }

    @Override
    public void close() {
    }

    @Override
    public OMDataSourceExt copy() {
        return new XMLStringDataSource(this.data);
    }

    @Override
    public Object getObject() {
        return this.data;
    }

    @Override
    public XMLStreamReader getReader() throws XMLStreamException {
        try {
            String encoding = "utf-8";
            ByteArrayInputStream is = new ByteArrayInputStream(this.getXMLBytes(encoding));
            return StAXUtils.createXMLStreamReader(is, encoding);
        }
        catch (UnsupportedEncodingException e) {
            throw new XMLStreamException(e);
        }
    }

    @Override
    public byte[] getXMLBytes(String encoding) throws UnsupportedEncodingException {
        return this.data.getBytes(encoding);
    }

    @Override
    public boolean isDestructiveRead() {
        return false;
    }

    @Override
    public boolean isDestructiveWrite() {
        return false;
    }
}

