/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.datasource.jaxb;

import javax.xml.namespace.NamespaceContext;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.axis2.jaxws.utility.JavaUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class JAXBXMLStreamWriterFilter
implements XMLStreamWriter {
    private static final Log log = LogFactory.getLog(JAXBXMLStreamWriterFilter.class);
    XMLStreamWriter delegate;
    int numElements = 0;
    int numDefaultNS = 0;

    public JAXBXMLStreamWriterFilter(XMLStreamWriter delegate) {
        this.delegate = delegate;
    }

    @Override
    public void close() throws XMLStreamException {
        this.delegate.close();
    }

    @Override
    public void flush() throws XMLStreamException {
        this.delegate.flush();
    }

    @Override
    public NamespaceContext getNamespaceContext() {
        return this.delegate.getNamespaceContext();
    }

    @Override
    public String getPrefix(String arg0) throws XMLStreamException {
        return this.delegate.getPrefix(arg0);
    }

    @Override
    public Object getProperty(String arg0) throws IllegalArgumentException {
        return this.delegate.getProperty(arg0);
    }

    @Override
    public void setDefaultNamespace(String namespaceURI) throws XMLStreamException {
        if (this.numElements == 1) {
            if (log.isDebugEnabled()) {
                log.debug("  default namespaceURI=" + namespaceURI);
            }
            ++this.numDefaultNS;
            if (this.numDefaultNS > 1) {
                if (log.isDebugEnabled()) {
                    log.debug("    WHY IS THE DEFAULT NAMESPACE WRITTEN TWICE?");
                    log.trace(JavaUtils.stackToString());
                }
                return;
            }
        }
        this.delegate.setDefaultNamespace(namespaceURI);
    }

    @Override
    public void setNamespaceContext(NamespaceContext arg0) throws XMLStreamException {
        this.delegate.setNamespaceContext(arg0);
    }

    @Override
    public void setPrefix(String arg0, String arg1) throws XMLStreamException {
        this.delegate.setPrefix(arg0, arg1);
    }

    @Override
    public void writeAttribute(String prefix, String namespaceURI, String localName, String value) throws XMLStreamException {
        if (this.numElements == 1 && log.isDebugEnabled()) {
            log.debug("  prefix=" + prefix + " namespace=" + namespaceURI + " localName=" + localName + " value=" + value);
        }
        this.delegate.writeAttribute(prefix, namespaceURI, localName, value);
    }

    @Override
    public void writeAttribute(String namespaceURI, String localName, String value) throws XMLStreamException {
        if (this.numElements == 1 && log.isDebugEnabled()) {
            log.debug("  namespace=" + namespaceURI + " localName=" + localName + " value=" + value);
        }
        this.delegate.writeAttribute(namespaceURI, localName, value);
    }

    @Override
    public void writeAttribute(String localName, String value) throws XMLStreamException {
        if (this.numElements == 1 && log.isDebugEnabled()) {
            log.debug("  localName=" + localName + " value=" + value);
        }
        this.delegate.writeAttribute(localName, value);
    }

    @Override
    public void writeCData(String arg0) throws XMLStreamException {
        this.delegate.writeCData(arg0);
    }

    @Override
    public void writeCharacters(char[] arg0, int arg1, int arg2) throws XMLStreamException {
        this.delegate.writeCharacters(arg0, arg1, arg2);
    }

    @Override
    public void writeCharacters(String arg0) throws XMLStreamException {
        this.delegate.writeCharacters(arg0);
    }

    @Override
    public void writeComment(String arg0) throws XMLStreamException {
        this.delegate.writeComment(arg0);
    }

    @Override
    public void writeDefaultNamespace(String arg0) throws XMLStreamException {
        this.delegate.writeDefaultNamespace(arg0);
    }

    @Override
    public void writeDTD(String arg0) throws XMLStreamException {
        this.delegate.writeDTD(arg0);
    }

    @Override
    public void writeEmptyElement(String arg0, String arg1, String arg2) throws XMLStreamException {
        this.delegate.writeEmptyElement(arg0, arg1, arg2);
    }

    @Override
    public void writeEmptyElement(String arg0, String arg1) throws XMLStreamException {
        this.delegate.writeEmptyElement(arg0, arg1);
    }

    @Override
    public void writeEmptyElement(String arg0) throws XMLStreamException {
        this.delegate.writeEmptyElement(arg0);
    }

    @Override
    public void writeEndDocument() throws XMLStreamException {
        this.delegate.writeEndDocument();
    }

    @Override
    public void writeEndElement() throws XMLStreamException {
        this.delegate.writeEndElement();
    }

    @Override
    public void writeEntityRef(String arg0) throws XMLStreamException {
        this.delegate.writeEntityRef(arg0);
    }

    @Override
    public void writeNamespace(String prefix, String namespaceURI) throws XMLStreamException {
        if (this.numElements == 1) {
            if (log.isDebugEnabled()) {
                log.debug("  prefix=" + prefix + " namespaceURI=" + namespaceURI);
            }
            if ("xmlns".equals(prefix)) {
                if (log.isDebugEnabled()) {
                    log.debug("    INVALID XMLNS attribute is removed prefix=");
                    log.trace(JavaUtils.stackToString());
                }
                return;
            }
        }
        this.delegate.writeNamespace(prefix, namespaceURI);
    }

    @Override
    public void writeProcessingInstruction(String arg0, String arg1) throws XMLStreamException {
        this.delegate.writeProcessingInstruction(arg0, arg1);
    }

    @Override
    public void writeProcessingInstruction(String arg0) throws XMLStreamException {
        this.delegate.writeProcessingInstruction(arg0);
    }

    @Override
    public void writeStartDocument() throws XMLStreamException {
        this.delegate.writeStartDocument();
    }

    @Override
    public void writeStartDocument(String arg0, String arg1) throws XMLStreamException {
        this.delegate.writeStartDocument(arg0, arg1);
    }

    @Override
    public void writeStartDocument(String arg0) throws XMLStreamException {
        this.delegate.writeStartDocument(arg0);
    }

    @Override
    public void writeStartElement(String prefix, String namespaceURI, String localName) throws XMLStreamException {
        ++this.numElements;
        if (this.numElements == 1 && log.isDebugEnabled()) {
            log.debug("  prefix=" + prefix + " namespace=" + namespaceURI + " localName=" + localName);
        }
        this.delegate.writeStartElement(prefix, namespaceURI, localName);
    }

    @Override
    public void writeStartElement(String namespaceURI, String localName) throws XMLStreamException {
        ++this.numElements;
        if (this.numElements == 1 && log.isDebugEnabled()) {
            log.debug("  namespace=" + namespaceURI + " localName=" + localName);
        }
        this.delegate.writeStartElement(namespaceURI, localName);
    }

    @Override
    public void writeStartElement(String localName) throws XMLStreamException {
        ++this.numElements;
        if (this.numElements == 1 && log.isDebugEnabled()) {
            log.debug("  localName=" + localName);
        }
        this.delegate.writeStartElement(localName);
    }
}

