/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.deployment;

import java.util.ArrayList;
import java.util.Iterator;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.axis2.clustering.ClusteringAgent;
import org.apache.axis2.clustering.Member;
import org.apache.axis2.clustering.management.GroupManagementAgent;
import org.apache.axis2.clustering.management.NodeManager;
import org.apache.axis2.clustering.state.StateManager;
import org.apache.axis2.deployment.DeploymentException;
import org.apache.axis2.deployment.DescriptionBuilder;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.i18n.Messages;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ClusterBuilder
extends DescriptionBuilder {
    private static final Log log = LogFactory.getLog(ClusterBuilder.class);

    public ClusterBuilder(AxisConfiguration axisConfig) {
        this.axisConfig = axisConfig;
    }

    public void buildCluster(OMElement clusterElement) throws DeploymentException {
        if (!this.isEnabled(clusterElement)) {
            log.info("Clustering has been disabled");
            return;
        }
        log.info("Clustering has been enabled");
        OMAttribute classNameAttr = clusterElement.getAttribute(new QName("class"));
        if (classNameAttr == null) {
            throw new DeploymentException(Messages.getMessage("classAttributeNotFound", "clustering"));
        }
        String className = classNameAttr.getAttributeValue();
        try {
            Class<?> clazz;
            try {
                clazz = Class.forName(className);
            }
            catch (ClassNotFoundException e) {
                throw new DeploymentException(Messages.getMessage("clusterImplNotFound", className));
            }
            ClusteringAgent clusteringAgent = (ClusteringAgent)clazz.newInstance();
            clusteringAgent.setConfigurationContext(this.configCtx);
            this.processParameters(clusterElement.getChildrenWithName(new QName("parameter")), clusteringAgent, null);
            this.loadGroupManagement(clusteringAgent, clusterElement);
            this.loadWellKnownMembers(clusteringAgent, clusterElement);
            this.loadNodeManager(clusterElement, clusteringAgent);
            this.loadStateManager(clusterElement, clusteringAgent);
            this.axisConfig.setClusteringAgent(clusteringAgent);
        }
        catch (InstantiationException e) {
            throw new DeploymentException(Messages.getMessage("cannotLoadClusterImpl"));
        }
        catch (IllegalAccessException e) {
            throw new DeploymentException(e);
        }
    }

    private boolean isEnabled(OMElement element) {
        boolean enabled = true;
        OMAttribute enableAttr = element.getAttribute(new QName("enable"));
        if (enableAttr != null) {
            enabled = Boolean.parseBoolean(enableAttr.getAttributeValue().trim());
        }
        return enabled;
    }

    private void loadGroupManagement(ClusteringAgent clusteringAgent, OMElement clusterElement) throws DeploymentException {
        OMElement lbEle = clusterElement.getFirstChildWithName(new QName("groupManagement"));
        if (lbEle != null) {
            if (!this.isEnabled(lbEle)) {
                log.info("Running in application mode");
                return;
            }
            log.info("Running in group management mode");
            Iterator iter = lbEle.getChildrenWithName(new QName("applicationDomain"));
            while (iter.hasNext()) {
                GroupManagementAgent groupManagementAgent;
                String subDomainName;
                String name;
                OMElement omElement = (OMElement)iter.next();
                String domainName = omElement.getAttributeValue(new QName("domain"));
                if (domainName != null) {
                    domainName = domainName.trim();
                }
                if ((name = omElement.getAttributeValue(new QName("name"))) != null) {
                    domainName = name.trim();
                }
                if ((subDomainName = omElement.getAttributeValue(new QName("subDomain"))) != null) {
                    subDomainName = subDomainName.trim();
                }
                String handlerClass = omElement.getAttributeValue(new QName("agent")).trim();
                String descAttrib = omElement.getAttributeValue(new QName("description"));
                String description = "Description not found";
                if (descAttrib != null) {
                    description = descAttrib.trim();
                }
                int groupMgtPort = -1;
                String groupMgtPortAttrib = omElement.getAttributeValue(new QName("port"));
                if (groupMgtPortAttrib != null) {
                    groupMgtPort = Integer.parseInt(groupMgtPortAttrib.trim());
                }
                try {
                    groupManagementAgent = (GroupManagementAgent)Class.forName(handlerClass).newInstance();
                    groupManagementAgent.setDescription(description);
                    groupManagementAgent.setDomain(domainName);
                    groupManagementAgent.setSubDomain(subDomainName);
                    if (groupMgtPort != -1) {
                        groupManagementAgent.setGroupMgtPort(groupMgtPort);
                    }
                }
                catch (Exception e) {
                    String msg = "Could not instantiate GroupManagementAgent " + handlerClass + " for domain " + domainName;
                    log.error(msg, e);
                    throw new DeploymentException(msg, e);
                }
                clusteringAgent.addGroupManagementAgent(groupManagementAgent, domainName, subDomainName, groupMgtPort);
            }
        }
    }

    private void loadWellKnownMembers(ClusteringAgent clusteringAgent, OMElement clusterElement) {
        String membershipScheme;
        clusteringAgent.setMembers(new ArrayList<Member>());
        Parameter membershipSchemeParam = clusteringAgent.getParameter("membershipScheme");
        if (membershipSchemeParam != null && (membershipScheme = ((String)membershipSchemeParam.getValue()).trim()).equals("wka")) {
            ArrayList<Member> members = new ArrayList<Member>();
            OMElement membersEle = clusterElement.getFirstChildWithName(new QName("members"));
            if (membersEle != null) {
                Iterator iter = membersEle.getChildrenWithLocalName("member");
                while (iter.hasNext()) {
                    OMElement memberEle = (OMElement)iter.next();
                    String hostName = memberEle.getFirstChildWithName(new QName("hostName")).getText().trim();
                    String port = memberEle.getFirstChildWithName(new QName("port")).getText().trim();
                    members.add(new Member(this.replaceVariables(hostName), Integer.parseInt(this.replaceVariables(port))));
                }
            }
            clusteringAgent.setMembers(members);
        }
    }

    private String replaceVariables(String text) {
        int indexOfClosingBrace;
        int indexOfStartingChars = text.indexOf("${");
        if (indexOfStartingChars != -1 && (indexOfClosingBrace = text.indexOf("}")) != -1) {
            String var = text.substring(indexOfStartingChars + 2, indexOfClosingBrace);
            String propValue = System.getProperty(var);
            if (propValue == null) {
                propValue = System.getenv(var);
            }
            if (propValue != null) {
                text = text.substring(0, indexOfStartingChars) + propValue + text.substring(indexOfClosingBrace + 1);
            }
        }
        return text;
    }

    private void loadStateManager(OMElement clusterElement, ClusteringAgent clusteringAgent) throws DeploymentException, InstantiationException, IllegalAccessException {
        OMElement contextManagerEle = clusterElement.getFirstChildWithName(new QName("stateManager"));
        if (contextManagerEle != null) {
            Class<?> clazz;
            if (!this.isEnabled(contextManagerEle)) {
                log.info("Clustering state management has been disabled");
                return;
            }
            log.info("Clustering state management has been enabled");
            OMAttribute classNameAttr = contextManagerEle.getAttribute(new QName("class"));
            if (classNameAttr == null) {
                throw new DeploymentException(Messages.getMessage("classAttributeNotFound", "stateManager"));
            }
            String className = classNameAttr.getAttributeValue();
            try {
                clazz = Class.forName(className);
            }
            catch (ClassNotFoundException e) {
                throw new DeploymentException(Messages.getMessage("clusterImplNotFound", className));
            }
            StateManager stateManager = (StateManager)clazz.newInstance();
            clusteringAgent.setStateManager(stateManager);
            this.processParameters(contextManagerEle.getChildrenWithName(new QName("parameter")), stateManager, null);
            OMElement replicationEle = contextManagerEle.getFirstChildWithName(new QName("replication"));
            if (replicationEle != null) {
                OMElement defaultsEle = replicationEle.getFirstChildWithName(new QName("defaults"));
                if (defaultsEle != null) {
                    ArrayList<String> defaults = new ArrayList<String>();
                    Iterator iter = defaultsEle.getChildrenWithName(new QName("exclude"));
                    while (iter.hasNext()) {
                        OMElement excludeEle = (OMElement)iter.next();
                        OMAttribute nameAtt = excludeEle.getAttribute(new QName("name"));
                        defaults.add(nameAtt.getAttributeValue());
                    }
                    stateManager.setReplicationExcludePatterns("defaults", defaults);
                }
                Iterator iter = replicationEle.getChildrenWithName(new QName("context"));
                while (iter.hasNext()) {
                    OMElement contextEle = (OMElement)iter.next();
                    String ctxClassName = contextEle.getAttribute(new QName("class")).getAttributeValue();
                    ArrayList<String> excludes = new ArrayList<String>();
                    Iterator iter2 = contextEle.getChildrenWithName(new QName("exclude"));
                    while (iter2.hasNext()) {
                        OMElement excludeEle = (OMElement)iter2.next();
                        OMAttribute nameAtt = excludeEle.getAttribute(new QName("name"));
                        excludes.add(nameAtt.getAttributeValue());
                    }
                    stateManager.setReplicationExcludePatterns(ctxClassName, excludes);
                }
            }
        }
    }

    private void loadNodeManager(OMElement clusterElement, ClusteringAgent clusteringAgent) throws DeploymentException, InstantiationException, IllegalAccessException {
        OMElement configManagerEle = clusterElement.getFirstChildWithName(new QName("nodeManager"));
        if (configManagerEle != null) {
            Class<?> clazz;
            if (!this.isEnabled(configManagerEle)) {
                log.info("Clustering configuration management has been disabled");
                return;
            }
            log.info("Clustering configuration management has been enabled");
            OMAttribute classNameAttr = configManagerEle.getAttribute(new QName("class"));
            if (classNameAttr == null) {
                throw new DeploymentException(Messages.getMessage("classAttributeNotFound", "nodeManager"));
            }
            String className = classNameAttr.getAttributeValue();
            try {
                clazz = Class.forName(className);
            }
            catch (ClassNotFoundException e) {
                throw new DeploymentException(Messages.getMessage("clusterImplNotFound", className));
            }
            NodeManager nodeManager = (NodeManager)clazz.newInstance();
            clusteringAgent.setNodeManager(nodeManager);
            nodeManager.setConfigurationContext(this.configCtx);
            this.processParameters(configManagerEle.getChildrenWithName(new QName("parameter")), nodeManager, null);
        }
    }
}

