/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.deployment.repository.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNamespace;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.deployment.DeploymentConstants;
import org.apache.axis2.deployment.DeploymentException;
import org.apache.axis2.deployment.DescriptionBuilder;
import org.apache.axis2.deployment.ModuleBuilder;
import org.apache.axis2.deployment.ServiceBuilder;
import org.apache.axis2.deployment.ServiceGroupBuilder;
import org.apache.axis2.deployment.repository.util.DeploymentFileData;
import org.apache.axis2.deployment.resolver.AARBasedWSDLLocator;
import org.apache.axis2.deployment.resolver.AARFileBasedURIResolver;
import org.apache.axis2.deployment.resolver.WarBasedWSDLLocator;
import org.apache.axis2.deployment.resolver.WarFileBasedURIResolver;
import org.apache.axis2.description.AxisModule;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.AxisServiceGroup;
import org.apache.axis2.description.WSDL11ToAllAxisServicesBuilder;
import org.apache.axis2.description.WSDL11ToAxisServiceBuilder;
import org.apache.axis2.description.WSDL20ToAllAxisServicesBuilder;
import org.apache.axis2.description.WSDLToAxisServiceBuilder;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.i18n.Messages;
import org.apache.axis2.util.XMLUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ArchiveReader
implements DeploymentConstants {
    private static final Log log = LogFactory.getLog(ArchiveReader.class);

    public ArrayList<AxisService> buildServiceGroup(InputStream zin, DeploymentFileData currentFile, AxisServiceGroup axisServiceGroup, HashMap<String, AxisService> wsdlServices, ConfigurationContext configCtx) throws XMLStreamException, AxisFault {
        DescriptionBuilder builder = new DescriptionBuilder(zin, configCtx);
        OMElement rootElement = builder.buildOM();
        String elementName = rootElement.getLocalName();
        if ("service".equals(elementName)) {
            AxisService axisService = null;
            String serviceName = DescriptionBuilder.getShortFileName(currentFile.getName());
            if (serviceName != null) {
                axisService = wsdlServices.get(serviceName);
            }
            if (axisService == null) {
                axisService = wsdlServices.get(DescriptionBuilder.getShortFileName(currentFile.getName()));
            }
            if (axisService == null) {
                axisService = new AxisService(serviceName);
            } else {
                axisService.setWsdlFound(true);
                axisService.setCustomWsdl(true);
            }
            axisService.setParent(axisServiceGroup);
            axisService.setClassLoader(currentFile.getClassLoader());
            ServiceBuilder serviceBuilder = new ServiceBuilder(configCtx, axisService);
            serviceBuilder.setWsdlServiceMap(wsdlServices);
            AxisService service = serviceBuilder.populateService(rootElement);
            ArrayList<AxisService> serviceList = new ArrayList<AxisService>();
            serviceList.add(service);
            return serviceList;
        }
        if ("serviceGroup".equals(elementName)) {
            ServiceGroupBuilder groupBuilder = new ServiceGroupBuilder(rootElement, wsdlServices, configCtx);
            return groupBuilder.populateServiceGroup(axisServiceGroup);
        }
        throw new AxisFault("Invalid services.xml found");
    }

    public ArrayList<AxisService> processServiceGroup(String filename, DeploymentFileData currentFile, AxisServiceGroup axisServiceGroup, boolean extractService, HashMap<String, AxisService> wsdlServices, ConfigurationContext configCtx) throws AxisFault {
        if (!extractService) {
            ZipInputStream zin = null;
            FileInputStream fin = null;
            try {
                ZipEntry entry;
                fin = new FileInputStream(filename);
                zin = new ZipInputStream(fin);
                while ((entry = zin.getNextEntry()) != null) {
                    if (!entry.getName().equalsIgnoreCase("META-INF/services.xml")) continue;
                    axisServiceGroup.setServiceGroupName(DescriptionBuilder.getShortFileName(currentFile.getName()));
                    ArrayList<AxisService> arrayList = this.buildServiceGroup(zin, currentFile, axisServiceGroup, wsdlServices, configCtx);
                    return arrayList;
                }
                try {
                    throw new DeploymentException(Messages.getMessage("servicexmlnotfound", filename));
                }
                catch (Exception e) {
                    throw new DeploymentException(e);
                }
            }
            finally {
                if (zin != null) {
                    try {
                        zin.close();
                    }
                    catch (IOException e) {
                        log.info(Messages.getMessage("errorininputstreamclose"));
                    }
                }
                if (fin != null) {
                    try {
                        fin.close();
                    }
                    catch (IOException e) {
                        log.info(Messages.getMessage("errorininputstreamclose"));
                    }
                }
            }
        }
        File file = new File(filename, "META-INF/services.xml");
        if (!file.exists()) {
            file = new File(filename, "META-INF/services.xml".toLowerCase());
        }
        if (file.exists()) {
            FileInputStream in = null;
            try {
                in = new FileInputStream(file);
                axisServiceGroup.setServiceGroupName(currentFile.getName());
                ArrayList<AxisService> e = this.buildServiceGroup(in, currentFile, axisServiceGroup, wsdlServices, configCtx);
                return e;
            }
            catch (FileNotFoundException e) {
                throw new DeploymentException(Messages.getMessage("fileNotFound", e.getMessage()));
            }
            catch (XMLStreamException e) {
                throw new DeploymentException(Messages.getMessage("StreamException", e.getMessage()));
            }
            finally {
                if (in != null) {
                    try {
                        ((InputStream)in).close();
                    }
                    catch (IOException e) {
                        log.info(Messages.getMessage("errorininputstreamclose"));
                    }
                }
            }
        }
        throw new DeploymentException(Messages.getMessage("servicexmlnotfound"));
    }

    private List<AxisService> processWSDLFile(WSDLToAxisServiceBuilder axisServiceBuilder, File serviceArchiveFile, boolean isArchive, InputStream in, String baseURI) throws DeploymentException {
        block13: {
            try {
                if (serviceArchiveFile != null && isArchive) {
                    axisServiceBuilder.setCustomResolver(new AARFileBasedURIResolver(serviceArchiveFile));
                    if (axisServiceBuilder instanceof WSDL11ToAllAxisServicesBuilder) {
                        ((WSDL11ToAllAxisServicesBuilder)axisServiceBuilder).setCustomWSDLResolver(new AARBasedWSDLLocator(baseURI, serviceArchiveFile, in));
                        ((WSDL11ToAllAxisServicesBuilder)axisServiceBuilder).setDocumentBaseUri(serviceArchiveFile.getCanonicalFile().toURI().toString());
                    } else if (axisServiceBuilder instanceof WSDL20ToAllAxisServicesBuilder) {
                        ((WSDL20ToAllAxisServicesBuilder)axisServiceBuilder).setCustomWSDLResolver(new AARBasedWSDLLocator(baseURI, serviceArchiveFile, in));
                        axisServiceBuilder.setBaseUri("jar:file://" + serviceArchiveFile.toURI() + "!/" + baseURI);
                    }
                } else if (serviceArchiveFile != null) {
                    axisServiceBuilder.setBaseUri(serviceArchiveFile.getParentFile().toURI().toString());
                    if (axisServiceBuilder instanceof WSDL11ToAllAxisServicesBuilder) {
                        ((WSDL11ToAllAxisServicesBuilder)axisServiceBuilder).setDocumentBaseUri(serviceArchiveFile.getCanonicalFile().toURI().toString());
                    }
                }
                if (axisServiceBuilder instanceof WSDL11ToAllAxisServicesBuilder) {
                    return ((WSDL11ToAllAxisServicesBuilder)axisServiceBuilder).populateAllServices();
                }
                if (axisServiceBuilder instanceof WSDL20ToAllAxisServicesBuilder) {
                    return ((WSDL20ToAllAxisServicesBuilder)axisServiceBuilder).populateAllServices();
                }
            }
            catch (AxisFault axisFault) {
                log.info("Trouble processing wsdl file :" + axisFault.getMessage());
                if (log.isDebugEnabled()) {
                    log.debug(axisFault);
                }
            }
            catch (IOException ioex) {
                log.info("Trouble processing wsdl file :" + ioex.getMessage());
                if (!log.isDebugEnabled()) break block13;
                log.debug(ioex);
            }
        }
        return null;
    }

    public HashMap<String, AxisService> processWSDLs(DeploymentFileData file) throws DeploymentException {
        File serviceFile = file.getFile();
        HashMap<String, AxisService> servicesMap = new HashMap<String, AxisService>();
        boolean isDirectory = serviceFile.isDirectory();
        if (isDirectory) {
            try {
                File metaInfFolder = new File(serviceFile, "META-INF");
                if (!metaInfFolder.exists() && !(metaInfFolder = new File(serviceFile, "META-INF".toLowerCase())).exists()) {
                    throw new DeploymentException(Messages.getMessage("noMetaInf", serviceFile.getName()));
                }
                this.processFilesInFolder(metaInfFolder, servicesMap);
            }
            catch (FileNotFoundException e) {
                throw new DeploymentException(e);
            }
            catch (IOException e) {
                throw new DeploymentException(e);
            }
            catch (XMLStreamException e) {
                throw new DeploymentException(e);
            }
        }
        try {
            ZipEntry entry;
            FileInputStream fin = new FileInputStream(serviceFile);
            ZipInputStream zin = new ZipInputStream(fin);
            byte[] buf = new byte[1024];
            while ((entry = zin.getNextEntry()) != null) {
                List<AxisService> services;
                WSDLToAxisServiceBuilder wsdlToAxisServiceBuilder;
                int read;
                String entryName = entry.getName().toLowerCase();
                if (!entryName.startsWith("META-INF".toLowerCase()) || !entryName.endsWith(".wsdl")) continue;
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                if (entryName.indexOf("/") != entryName.lastIndexOf("/") || entryName.indexOf("wsdl_") != -1) continue;
                while ((read = zin.read(buf)) > 0) {
                    out.write(buf, 0, read);
                }
                ByteArrayInputStream in = new ByteArrayInputStream(out.toByteArray());
                OMNamespace documentElementNS = ((OMElement)XMLUtils.toOM(in)).getNamespace();
                if (documentElementNS == null) continue;
                if ("http://www.w3.org/ns/wsdl".equals(documentElementNS.getNamespaceURI())) {
                    wsdlToAxisServiceBuilder = new WSDL20ToAllAxisServicesBuilder(new ByteArrayInputStream(out.toByteArray()));
                    wsdlToAxisServiceBuilder.setBaseUri(entryName);
                } else if ("http://schemas.xmlsoap.org/wsdl/".equals(documentElementNS.getNamespaceURI())) {
                    wsdlToAxisServiceBuilder = new WSDL11ToAllAxisServicesBuilder(new ByteArrayInputStream(out.toByteArray()));
                    ((WSDL11ToAxisServiceBuilder)wsdlToAxisServiceBuilder).setDocumentBaseUri(entryName);
                } else {
                    throw new DeploymentException(Messages.getMessage("invalidWSDLFound"));
                }
                if ((services = this.processWSDLFile(wsdlToAxisServiceBuilder, serviceFile, true, new ByteArrayInputStream(out.toByteArray()), entry.getName())) == null) continue;
                for (AxisService axisService : services) {
                    if (axisService == null) continue;
                    servicesMap.put(axisService.getName(), axisService);
                }
            }
            try {
                zin.close();
            }
            catch (IOException e) {
                log.info(e);
            }
            try {
                fin.close();
            }
            catch (IOException e) {
                log.info(e);
            }
        }
        catch (FileNotFoundException e) {
            throw new DeploymentException(e);
        }
        catch (IOException e) {
            throw new DeploymentException(e);
        }
        catch (XMLStreamException e) {
            throw new DeploymentException(e);
        }
        return servicesMap;
    }

    public List<AxisService> getAxisServiceFromWsdl(InputStream in, ClassLoader loader, String wsdlUrl) throws Exception {
        OMElement element = (OMElement)XMLUtils.toOM(in);
        OMNamespace documentElementNS = element.getNamespace();
        if (documentElementNS != null) {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            element.serialize(out);
            if ("http://schemas.xmlsoap.org/wsdl/".equals(documentElementNS.getNamespaceURI())) {
                WSDL11ToAllAxisServicesBuilder wsdlToAxisServiceBuilder = new WSDL11ToAllAxisServicesBuilder(new ByteArrayInputStream(out.toByteArray()));
                wsdlToAxisServiceBuilder.setCustomWSDLResolver(new WarBasedWSDLLocator(wsdlUrl, loader, new ByteArrayInputStream(out.toByteArray())));
                wsdlToAxisServiceBuilder.setCustomResolver(new WarFileBasedURIResolver(loader));
                return wsdlToAxisServiceBuilder.populateAllServices();
            }
            if ("http://www.w3.org/ns/wsdl".equals(documentElementNS.getNamespaceURI())) {
                WSDL20ToAllAxisServicesBuilder wsdlToAxisServiceBuilder = new WSDL20ToAllAxisServicesBuilder(new ByteArrayInputStream(out.toByteArray()));
                wsdlToAxisServiceBuilder.setCustomWSDLResolver(new WarBasedWSDLLocator(wsdlUrl, loader, new ByteArrayInputStream(out.toByteArray())));
                wsdlToAxisServiceBuilder.setCustomResolver(new WarFileBasedURIResolver(loader));
                return wsdlToAxisServiceBuilder.populateAllServices();
            }
            throw new DeploymentException(Messages.getMessage("invalidWSDLFound"));
        }
        return null;
    }

    public void processFilesInFolder(File folder, HashMap<String, AxisService> servicesMap) throws FileNotFoundException, XMLStreamException, DeploymentException {
        File[] files = folder.listFiles();
        for (int i = 0; i < files.length; ++i) {
            File file1 = files[i];
            if (!file1.getName().toLowerCase().endsWith(".wsdl")) continue;
            FileInputStream in = new FileInputStream(file1);
            OMNamespace documentElementNS = ((OMElement)XMLUtils.toOM(in)).getNamespace();
            if (documentElementNS != null) {
                WSDLToAxisServiceBuilder wsdlToAxisServiceBuilder;
                FileInputStream in2;
                if ("http://www.w3.org/ns/wsdl".equals(documentElementNS.getNamespaceURI())) {
                    in2 = new FileInputStream(file1);
                    wsdlToAxisServiceBuilder = new WSDL20ToAllAxisServicesBuilder(in2);
                } else if ("http://schemas.xmlsoap.org/wsdl/".equals(documentElementNS.getNamespaceURI())) {
                    in2 = new FileInputStream(file1);
                    wsdlToAxisServiceBuilder = new WSDL11ToAllAxisServicesBuilder(in2);
                    ((WSDL11ToAxisServiceBuilder)wsdlToAxisServiceBuilder).setDocumentBaseUri(file1.toURI().toString());
                } else {
                    throw new DeploymentException(Messages.getMessage("invalidWSDLFound"));
                }
                FileInputStream in3 = new FileInputStream(file1);
                List<AxisService> services = this.processWSDLFile(wsdlToAxisServiceBuilder, file1, false, in2, file1.toURI().toString());
                if (services != null) {
                    for (AxisService axisService : services) {
                        if (axisService == null) continue;
                        servicesMap.put(axisService.getName(), axisService);
                    }
                }
                try {
                    in2.close();
                    in3.close();
                }
                catch (IOException e) {
                    log.info(e);
                }
            }
            try {
                ((InputStream)in).close();
                continue;
            }
            catch (IOException e) {
                log.info(e);
            }
        }
    }

    public void readModuleArchive(DeploymentFileData deploymentFile, AxisModule module, boolean explodedDir, AxisConfiguration axisConfig) throws DeploymentException {
        block16: {
            boolean moduleXMLFound = false;
            String shortFileName = DescriptionBuilder.getShortFileName(deploymentFile.getName());
            if (!explodedDir) {
                try {
                    ZipEntry entry;
                    FileInputStream fin = new FileInputStream(deploymentFile.getAbsolutePath());
                    ZipInputStream zin = new ZipInputStream(fin);
                    while ((entry = zin.getNextEntry()) != null) {
                        if (!entry.getName().equalsIgnoreCase("META-INF/module.xml")) continue;
                        moduleXMLFound = true;
                        ModuleBuilder builder = new ModuleBuilder(zin, module, axisConfig);
                        module.setArchiveName(shortFileName);
                        builder.populateModule();
                        break;
                    }
                    zin.close();
                    fin.close();
                    if (!moduleXMLFound) {
                        throw new DeploymentException(Messages.getMessage("modulexmlnotfound", deploymentFile.getAbsolutePath()));
                    }
                    break block16;
                }
                catch (Exception e) {
                    throw new DeploymentException(e);
                }
            }
            File file = new File(deploymentFile.getAbsolutePath(), "META-INF/module.xml");
            if (file.exists() || (file = new File(deploymentFile.getAbsolutePath(), "META-INF/module.xml".toLowerCase())).exists()) {
                FileInputStream in = null;
                try {
                    in = new FileInputStream(file);
                    ModuleBuilder builder = new ModuleBuilder(in, module, axisConfig);
                    module.setArchiveName(shortFileName);
                    builder.populateModule();
                }
                catch (FileNotFoundException e) {
                    throw new DeploymentException(Messages.getMessage("fileNotFound", e.getMessage()));
                }
                finally {
                    if (in != null) {
                        try {
                            ((InputStream)in).close();
                        }
                        catch (IOException e) {
                            log.info(Messages.getMessage("errorininputstreamclose"));
                        }
                    }
                }
            }
            throw new DeploymentException(Messages.getMessage("modulexmlnotfound", deploymentFile.getAbsolutePath()));
        }
    }
}

