/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.jaxws;

import java.io.BufferedWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.axis2.jaxws.i18n.Messages;
import org.apache.axis2.jaxws.utility.JavaUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class WebServiceExceptionLogger {
    private static final Log log = LogFactory.getLog(WebServiceExceptionLogger.class);

    public static void log(Method method, Throwable throwable, boolean logFully, Class serviceImplClass, Object serviceInstance, Object[] args) {
        if (!log.isDebugEnabled() && !log.isErrorEnabled()) {
            return;
        }
        Object rootT = null;
        if (throwable instanceof InvocationTargetException) {
            rootT = ((InvocationTargetException)throwable).getTargetException();
        }
        String name = rootT.getClass().getName();
        String stack = WebServiceExceptionLogger.stackToString((Throwable)rootT);
        Class checkedException = JavaUtils.getCheckedException((Throwable)rootT, method);
        if (checkedException == null && log.isErrorEnabled()) {
            String text = "";
            text = logFully ? Messages.getMessage("failureLogger", name, ((Throwable)rootT).toString()) : Messages.getMessage("failureLogger", name, stack);
            log.error(text);
        }
        if (log.isDebugEnabled()) {
            log.debug("Exception invoking a method of " + serviceImplClass.toString() + " of instance " + serviceInstance.toString());
            log.debug("Exception type thrown: " + throwable.getClass().getName());
            if (rootT != null) {
                log.debug("Root Exception type thrown: " + rootT.getClass().getName());
            }
            if (checkedException != null) {
                log.debug("The exception is an instance of checked exception: " + checkedException.getName());
            }
            if (((Throwable)rootT).toString().contains("org.apache.xerces.dom.ElementNSImpl incompatible")) {
                log.debug("This exception may be due to a missing @XmlSeeAlso in the client's jaxws or jaxb classes.");
            }
            log.debug("Method = " + method.toGenericString());
            for (int i = 0; i < args.length; ++i) {
                String value = args[i] == null ? "null" : args[i].getClass().toString();
                log.debug(" Argument[" + i + "] is " + value);
            }
        }
    }

    private static String stackToString(Throwable e) {
        StringWriter sw = new StringWriter();
        BufferedWriter bw = new BufferedWriter(sw);
        PrintWriter pw = new PrintWriter(bw);
        e.printStackTrace(pw);
        pw.close();
        String text = sw.getBuffer().toString();
        text = text.substring(text.indexOf("at"));
        return text;
    }
}

