/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.jaxws.addressing.util;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.soap.SOAPHeader;
import org.apache.axis2.jaxws.ExceptionFactory;
import org.apache.axis2.jaxws.i18n.Messages;
import org.apache.axis2.util.XMLUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Element;

public class ReferenceParameterList
extends AbstractList<Element> {
    private static final Log log = LogFactory.getLog(ReferenceParameterList.class);
    private static final Element[] EMPTY_ARRAY = new Element[0];
    private String namespace = "http://www.w3.org/2005/08/addressing";
    private SOAPHeader header;
    private Element[] referenceParameters;

    public ReferenceParameterList() {
    }

    public ReferenceParameterList(SOAPHeader header) {
        this.header = header;
    }

    @Override
    public Element get(int index) {
        if (this.referenceParameters == null) {
            this.initialize();
        }
        return this.referenceParameters[index];
    }

    @Override
    public int size() {
        if (this.referenceParameters == null) {
            this.initialize();
        }
        return this.referenceParameters.length;
    }

    private void initialize() {
        if (this.header == null) {
            if (log.isTraceEnabled()) {
                log.trace("initialize: No SOAP header to check for reference parameters.");
            }
            this.referenceParameters = EMPTY_ARRAY;
        } else {
            if (log.isTraceEnabled()) {
                log.trace("initialize: Checking SOAP header for reference parameters.");
            }
            ArrayList<Element> list = new ArrayList<Element>();
            Iterator headerBlocks = this.header.getChildElements();
            while (headerBlocks.hasNext()) {
                OMElement headerElement = (OMElement)headerBlocks.next();
                OMAttribute isRefParamAttr = headerElement.getAttribute(new QName(this.namespace, "IsReferenceParameter"));
                if (log.isTraceEnabled()) {
                    log.trace("initialize: Checking header element: " + headerElement.getQName());
                }
                if (isRefParamAttr == null || !"true".equals(isRefParamAttr.getAttributeValue()) && !"1".equals(isRefParamAttr.getAttributeValue())) continue;
                try {
                    Element element = XMLUtils.toDOM(headerElement);
                    list.add(element);
                }
                catch (Exception e) {
                    throw ExceptionFactory.makeWebServiceException(Messages.getMessage("referenceParameterConstructionErr"), e);
                }
                if (!log.isTraceEnabled()) continue;
                log.trace("initialize: Header: " + headerElement.getQName() + " has IsReferenceParameter attribute. Adding to toEPR.");
            }
            this.referenceParameters = list.toArray(EMPTY_ARRAY);
        }
    }
}

