/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.jaxws.binding;

import java.util.HashSet;
import java.util.Set;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFactory;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.soap.AddressingFeature;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.jaxws.ExceptionFactory;
import org.apache.axis2.jaxws.binding.BindingImpl;
import org.apache.axis2.jaxws.binding.BindingUtils;
import org.apache.axis2.jaxws.description.EndpointDescription;
import org.apache.axis2.jaxws.i18n.Messages;
import org.apache.axis2.jaxws.utility.SAAJFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SOAPBinding
extends BindingImpl
implements javax.xml.ws.soap.SOAPBinding {
    private boolean mtomEnabled = false;
    private int mtomThreshold = 0;
    private boolean respectBindingEnabled = false;
    private boolean addressingConfigured = false;
    private boolean addressingEnabled = false;
    private boolean addressingRequired = false;
    private AddressingFeature.Responses addressingResponses = AddressingFeature.Responses.ALL;
    private static Log log = LogFactory.getLog(SOAPBinding.class);
    private EndpointReference epr;
    private String addressingNamespace;

    public SOAPBinding(EndpointDescription endpointDesc) {
        super(endpointDesc);
    }

    public int getMTOMThreshold() {
        return this.mtomThreshold;
    }

    public void setMTOMThreshold(int threshold) {
        this.mtomThreshold = threshold;
    }

    public boolean isRespectBindingEnabled() {
        return this.respectBindingEnabled;
    }

    public void setRespectBindingEnabled(boolean enabled) {
        this.respectBindingEnabled = enabled;
    }

    public boolean isAddressingConfigured() {
        return this.addressingConfigured;
    }

    public void setAddressingConfigured(boolean configured) {
        this.addressingConfigured = configured;
    }

    public boolean isAddressingEnabled() {
        return this.addressingEnabled;
    }

    public void setAddressingEnabled(boolean enabled) {
        this.addressingEnabled = enabled;
    }

    public boolean isAddressingRequired() {
        return this.addressingRequired;
    }

    public void setAddressingRequired(boolean required) {
        this.addressingRequired = required;
    }

    public AddressingFeature.Responses getAddressingResponses() {
        return this.addressingResponses;
    }

    public void setAddressingResponses(AddressingFeature.Responses responses) {
        this.addressingResponses = responses;
    }

    public MessageFactory getMessageFactory() {
        block4: {
            String bindingNamespace = null;
            try {
                bindingNamespace = BindingUtils.isSOAP12Binding(this.bindingId) ? "http://www.w3.org/2003/05/soap-envelope" : "http://schemas.xmlsoap.org/soap/envelope/";
                return SAAJFactory.createMessageFactory(bindingNamespace);
            }
            catch (WebServiceException e) {
                if (log.isDebugEnabled()) {
                    log.debug("WebServiceException calling SAAJFactory.createMessageFactory(\"" + bindingNamespace + "\")");
                }
            }
            catch (SOAPException e) {
                if (!log.isDebugEnabled()) break block4;
                log.debug("SOAPException calling SAAJFactory.createMessageFactory(\"" + bindingNamespace + "\")");
            }
        }
        return null;
    }

    public Set<String> getRoles() {
        if (this.roles == null) {
            this.roles = this.addDefaultRoles(null);
        }
        return this.roles;
    }

    public SOAPFactory getSOAPFactory() {
        block4: {
            String bindingNamespace = null;
            try {
                bindingNamespace = this.bindingId.equalsIgnoreCase("http://www.w3.org/2003/05/soap/bindings/HTTP/") || this.bindingId.equalsIgnoreCase("http://www.w3.org/2003/05/soap/bindings/HTTP/?mtom=true") ? "http://www.w3.org/2003/05/soap-envelope" : "http://schemas.xmlsoap.org/soap/envelope/";
                return SAAJFactory.createSOAPFactory(bindingNamespace);
            }
            catch (WebServiceException e) {
                if (log.isDebugEnabled()) {
                    log.debug("WebServiceException calling SAAJFactory.createSOAPFactory(\"" + bindingNamespace + "\")");
                }
            }
            catch (SOAPException e) {
                if (!log.isDebugEnabled()) break block4;
                log.debug("SOAPException calling SAAJFactory.createSOAPFactory(\"" + bindingNamespace + "\")");
            }
        }
        return null;
    }

    public boolean isMTOMEnabled() {
        return this.mtomEnabled;
    }

    public void setMTOMEnabled(boolean flag) {
        this.mtomEnabled = flag;
    }

    public void setRoles(Set<String> set) {
        if (set != null && !set.isEmpty() && set.contains("http://www.w3.org/2003/05/soap-envelope/role/none")) {
            throw ExceptionFactory.makeWebServiceException(Messages.getMessage("roleValidatioErr"));
        }
        this.roles = this.addDefaultRoles(set);
    }

    private Set<String> addDefaultRoles(Set<String> set) {
        Set<String> returnSet = set;
        if (returnSet == null) {
            returnSet = new HashSet<String>();
        }
        if ("http://www.w3.org/2003/05/soap/bindings/HTTP/".equals(this.bindingId) || "http://www.w3.org/2003/05/soap/bindings/HTTP/?mtom=true".equals(this.bindingId)) {
            if (returnSet.isEmpty() || !returnSet.contains("http://www.w3.org/2003/05/soap-envelope/role/next")) {
                returnSet.add("http://www.w3.org/2003/05/soap-envelope/role/next");
            }
        } else if (returnSet.isEmpty() || !returnSet.contains("http://schemas.xmlsoap.org/soap/actor/next")) {
            returnSet.add("http://schemas.xmlsoap.org/soap/actor/next");
        }
        return returnSet;
    }

    @Override
    public String getAddressingNamespace() {
        return this.addressingNamespace;
    }

    @Override
    public EndpointReference getAxis2EndpointReference() {
        return this.epr;
    }

    @Override
    public void setAddressingNamespace(String addressingNamespace) {
        this.addressingNamespace = addressingNamespace;
    }

    @Override
    public void setAxis2EndpointReference(EndpointReference epr) {
        this.epr = epr;
    }
}

