/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.jaxws.client.async;

import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.xml.ws.Response;
import org.apache.axis2.java.security.AccessController;
import org.apache.axis2.jaxws.ExceptionFactory;
import org.apache.axis2.jaxws.core.MessageContext;
import org.apache.axis2.jaxws.description.EndpointDescription;
import org.apache.axis2.jaxws.handler.AttachmentsAdapter;
import org.apache.axis2.jaxws.handler.HandlerChainProcessor;
import org.apache.axis2.jaxws.handler.HandlerInvokerUtils;
import org.apache.axis2.jaxws.handler.SOAPHeadersAdapter;
import org.apache.axis2.jaxws.handler.TransportHeadersAdapter;
import org.apache.axis2.jaxws.i18n.Messages;
import org.apache.axis2.jaxws.message.attachments.AttachmentUtils;
import org.apache.axis2.jaxws.spi.migrator.ApplicationContextMigratorUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AsyncResponse
implements Response {
    private static final Log log = LogFactory.getLog(AsyncResponse.class);
    private boolean cancelled;
    private Throwable fault;
    private MessageContext faultMessageContext;
    private MessageContext response;
    private EndpointDescription endpointDescription;
    private Map<String, Object> responseContext;
    private CountDownLatch latch;
    private boolean cacheValid = false;
    private Object cachedObject = null;
    private Object responseObject = null;
    private ExecutionException savedException = null;

    protected AsyncResponse(EndpointDescription ed) {
        this.endpointDescription = ed;
        this.latch = new CountDownLatch(1);
    }

    protected void onError(Throwable flt, MessageContext mc, ClassLoader cl) {
        ClassLoader contextCL = (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return Thread.currentThread().getContextClassLoader();
            }
        });
        this.onError(flt, mc);
        this.checkClassLoader(cl, contextCL);
    }

    protected void onError(Throwable flt, MessageContext faultCtx) {
        block10: {
            if (log.isDebugEnabled()) {
                log.debug("AsyncResponse received a fault.");
            }
            Throwable t = null;
            try {
                this.fault = flt;
                this.faultMessageContext = faultCtx;
                if (this.faultMessageContext != null) {
                    this.faultMessageContext.setEndpointDescription(this.endpointDescription);
                } else if (log.isDebugEnabled()) {
                    log.debug("The faultMessageContext is not available because the error likely occurred on the client and is not the result of a SOAP Fault");
                }
                this.cacheValid = false;
                this.cachedObject = null;
                t = this.processFaultResponse();
            }
            catch (Throwable unexpected) {
                if (log.isDebugEnabled()) {
                    log.debug("A secondary exception occurred during onError processing: " + unexpected);
                }
                t = unexpected;
            }
            this.savedException = new ExecutionException(t);
            try {
                this.latch.countDown();
                if (log.isDebugEnabled()) {
                    log.debug("New latch count = [" + this.latch.getCount() + "]");
                }
            }
            catch (Throwable unexpected) {
                if (!log.isDebugEnabled()) break block10;
                log.debug("A secondary exception occurred during onError processing after the fault is processed: " + unexpected);
            }
        }
    }

    private void checkClassLoader(ClassLoader cl, ClassLoader contextCL) {
        if (log.isDebugEnabled()) {
            log.debug("AsyncResponse ClassLoader is:");
            log.debug(cl.toString());
        }
        if (cl.equals(contextCL)) {
            if (log.isDebugEnabled()) {
                log.debug("AsyncResponse ClassLoader matches Context ClassLoader");
            }
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug("Context ClassLoader is:");
            log.debug(contextCL.toString());
        }
        ClassLoader parent = this.getParentClassLoader(contextCL);
        while (parent != null) {
            if (parent.equals(cl)) {
                return;
            }
            if (log.isDebugEnabled()) {
                log.debug("AsyncResponse ClassLoader is an ancestor of the Context ClassLoader");
            }
            parent = this.getParentClassLoader(parent);
        }
        throw ExceptionFactory.makeWebServiceException(Messages.getMessage("threadClsLoaderErr", contextCL.getClass().toString(), cl.getClass().toString()));
    }

    ClassLoader getParentClassLoader(final ClassLoader cl) {
        return (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return cl.getParent();
            }
        });
    }

    protected void onComplete(MessageContext mc, ClassLoader cl) {
        ClassLoader contextCL = (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return Thread.currentThread().getContextClassLoader();
            }
        });
        this.onComplete(mc);
        this.checkClassLoader(cl, contextCL);
    }

    protected void onComplete(MessageContext mc) {
        if (log.isDebugEnabled()) {
            log.debug("AsyncResponse received a MessageContext.");
        }
        if (this.response != mc) {
            this.cachedObject = null;
            this.cacheValid = false;
        }
        this.response = mc;
        this.response.setEndpointDescription(this.endpointDescription);
        if (this.response.getAxisMessageContext().getAttachmentMap() != null) {
            AttachmentUtils.findCachedAttachment(this.response.getAxisMessageContext().getAttachmentMap());
        }
        try {
            this.responseObject = this.processResponse();
        }
        catch (ExecutionException e) {
            this.savedException = e;
            if (log.isDebugEnabled()) {
                log.debug("An error occurred while processing the response: " + e.getCause());
            }
            this.latch.countDown();
        }
        this.latch.countDown();
        if (log.isDebugEnabled()) {
            log.debug("New latch count = [" + this.latch.getCount() + "]");
        }
    }

    public boolean cancel(boolean mayInterruptIfRunning) {
        if (this.cancelled || this.latch.getCount() == 0L) {
            if (log.isDebugEnabled()) {
                log.debug("Cancellation attempt failed.");
            }
            return false;
        }
        this.cancelled = true;
        return this.cancelled;
    }

    public Object get() throws InterruptedException, ExecutionException {
        if (this.cancelled) {
            throw new CancellationException(Messages.getMessage("getErr"));
        }
        if (log.isDebugEnabled()) {
            log.debug("Waiting for async response delivery.");
        }
        this.latch.await();
        if (this.savedException != null) {
            throw this.savedException;
        }
        return this.responseObject;
    }

    public Object get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        if (this.cancelled) {
            throw new CancellationException(Messages.getMessage("getErr"));
        }
        if (log.isDebugEnabled()) {
            log.debug("Waiting for async response delivery with time out.");
            log.debug("timeout = " + timeout);
            log.debug("units   = " + (Object)((Object)unit));
        }
        this.latch.await(timeout, unit);
        if (this.savedException != null) {
            throw this.savedException;
        }
        if (this.latch.getCount() > 0L) {
            throw new TimeoutException(Messages.getMessage("getErr1"));
        }
        return this.responseObject;
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    public boolean isDone() {
        return this.latch.getCount() == 0L;
    }

    public Map getContext() {
        return this.responseContext;
    }

    private Object processResponse() throws ExecutionException {
        if (this.response == null) {
            this.latch.countDown();
            throw new ExecutionException(ExceptionFactory.makeWebServiceException(Messages.getMessage("processRespErr")));
        }
        if (this.cacheValid) {
            if (log.isDebugEnabled()) {
                log.debug("Return object cached from last get()");
            }
            return this.cachedObject;
        }
        Object obj = null;
        try {
            TransportHeadersAdapter.install(this.response);
            AttachmentsAdapter.install(this.response);
            SOAPHeadersAdapter.install(this.response);
            HandlerInvokerUtils.invokeInboundHandlers(this.response.getMEPContext(), this.response.getInvocationContext().getHandlers(), HandlerChainProcessor.MEP.RESPONSE, false);
            if (log.isDebugEnabled()) {
                log.debug("Unmarshalling the async response message.");
            }
            obj = this.getResponseValueObject(this.response);
            if (log.isDebugEnabled() && obj != null) {
                log.debug("Unmarshalled response object of type: " + obj.getClass());
            }
            this.cacheValid = true;
            this.cachedObject = obj;
            this.responseContext = new HashMap<String, Object>();
            ApplicationContextMigratorUtil.performMigrationFromMessageContext("org.apache.axis2.jaxws.spi.ApplicationContextMigrators", this.responseContext, this.response);
        }
        catch (Throwable t) {
            throw new ExecutionException(ExceptionFactory.makeWebServiceException(t));
        }
        return obj;
    }

    private Throwable processFaultResponse() {
        if (this.faultMessageContext != null) {
            Throwable throwable = null;
            if (this.faultMessageContext.getMessage() != null) {
                try {
                    if (log.isDebugEnabled()) {
                        log.debug("Invoking the JAX-WS handler chain for the fault response.");
                    }
                    HandlerInvokerUtils.invokeInboundHandlers(this.faultMessageContext.getMEPContext(), this.faultMessageContext.getInvocationContext().getHandlers(), HandlerChainProcessor.MEP.RESPONSE, false);
                }
                catch (Throwable t) {
                    if (log.isDebugEnabled()) {
                        log.debug("An error occurred (" + t.getClass() + " while processing " + "the fault response handler chain.");
                    }
                    throwable = t;
                }
            }
            if (throwable == null) {
                throwable = this.getFaultResponse(this.faultMessageContext);
            }
            if (throwable != null) {
                return throwable;
            }
            return ExceptionFactory.makeWebServiceException(this.fault);
        }
        return ExceptionFactory.makeWebServiceException(this.fault);
    }

    public abstract Object getResponseValueObject(MessageContext var1);

    public abstract Throwable getFaultResponse(MessageContext var1);
}

