/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.jaxws.dispatchers;

import java.util.Iterator;
import javax.xml.namespace.QName;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.SOAPHeaderBlock;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.engine.AbstractDispatcher;
import org.apache.axis2.engine.Handler;
import org.apache.axis2.i18n.Messages;
import org.apache.axis2.jaxws.dispatchers.MustUnderstandUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MustUnderstandValidationDispatcher
extends AbstractDispatcher {
    private static final Log log = LogFactory.getLog(MustUnderstandValidationDispatcher.class);

    @Override
    public AxisOperation findOperation(AxisService service, MessageContext messageContext) throws AxisFault {
        return null;
    }

    @Override
    public AxisService findService(MessageContext messageContext) throws AxisFault {
        return null;
    }

    @Override
    public void initDispatcher() {
    }

    @Override
    public Handler.InvocationResponse invoke(MessageContext msgctx) throws AxisFault {
        AxisService axisService = msgctx.getAxisService();
        AxisOperation axisOperation = msgctx.getAxisOperation();
        if (log.isDebugEnabled()) {
            log.debug("JAXWS MustUnderstandValidationDispatcher.invoke on AxisService " + axisService + "; AxisOperation " + axisOperation);
        }
        if (axisService != null && axisOperation == null) {
            this.checkMustUnderstand(msgctx);
        }
        return Handler.InvocationResponse.CONTINUE;
    }

    private boolean checkMustUnderstand(MessageContext msgContext) throws AxisFault {
        boolean checksPass = true;
        SOAPEnvelope envelope = msgContext.getEnvelope();
        if (envelope.getHeader() == null) {
            return checksPass;
        }
        MustUnderstandUtils.markUnderstoodHeaderParameters(msgContext);
        Iterator headerBlocks = envelope.getHeader().getHeadersToProcess(null);
        while (headerBlocks.hasNext()) {
            SOAPHeaderBlock headerBlock = (SOAPHeaderBlock)headerBlocks.next();
            if (headerBlock.isProcessed() || !headerBlock.getMustUnderstand()) continue;
            QName faultQName = headerBlock.getVersion().getMustUnderstandFaultCode();
            throw new AxisFault(Messages.getMessage("mustunderstandfailed", headerBlock.getNamespace().getNamespaceURI(), headerBlock.getLocalName()), faultQName);
        }
        return checksPass;
    }
}

