/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.jaxws.message.databinding.impl;

import javax.xml.bind.JAXBException;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.ws.WebServiceException;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMSourcedElement;
import org.apache.axis2.datasource.jaxb.JAXBDSContext;
import org.apache.axis2.datasource.jaxb.JAXBDataSource;
import org.apache.axis2.jaxws.ExceptionFactory;
import org.apache.axis2.jaxws.i18n.Messages;
import org.apache.axis2.jaxws.message.Block;
import org.apache.axis2.jaxws.message.databinding.JAXBBlockContext;
import org.apache.axis2.jaxws.message.databinding.impl.JAXBBlockImpl;
import org.apache.axis2.jaxws.message.factory.BlockFactory;
import org.apache.axis2.jaxws.message.factory.JAXBBlockFactory;
import org.apache.axis2.jaxws.message.impl.BlockFactoryImpl;
import org.apache.axis2.jaxws.utility.XMLRootElementUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JAXBBlockFactoryImpl
extends BlockFactoryImpl
implements JAXBBlockFactory {
    private static final Log log = LogFactory.getLog(JAXBBlockFactoryImpl.class);

    @Override
    public Block createFrom(OMElement omElement, Object context, QName qName) throws XMLStreamException, WebServiceException {
        block13: {
            if (context == null) {
                throw ExceptionFactory.makeWebServiceException(new JAXBException(Messages.getMessage("JAXBBlockFactoryErr1", "null")));
            }
            if (!(context instanceof JAXBBlockContext)) {
                throw ExceptionFactory.makeWebServiceException(new JAXBException(Messages.getMessage("JAXBBlockFactoryErr1", context.getClass().getName())));
            }
            if (qName == null) {
                qName = omElement.getQName();
            }
            if (omElement instanceof OMSourcedElement) {
                if (((OMSourcedElement)omElement).getDataSource() instanceof JAXBDataSource) {
                    JAXBDataSource ds = (JAXBDataSource)((OMSourcedElement)omElement).getDataSource();
                    JAXBDSContext dsContext = ds.getContext();
                    try {
                        if (dsContext.getJAXBContext() == ((JAXBBlockContext)context).getJAXBContext()) {
                            Object jaxb = ds.getObject();
                            return new JAXBBlockImpl(jaxb, (JAXBBlockContext)context, qName, (BlockFactory)this);
                        }
                        break block13;
                    }
                    catch (JAXBException e) {
                        if (log.isDebugEnabled()) {
                            log.debug("Falling back to using normal unmarshalling approach. " + e.getMessage());
                        }
                        break block13;
                    }
                }
                if (((OMSourcedElement)omElement).getDataSource() instanceof JAXBBlockImpl) {
                    JAXBBlockImpl block = (JAXBBlockImpl)((OMSourcedElement)omElement).getDataSource();
                    JAXBBlockContext blockContext = (JAXBBlockContext)block.getBusinessContext();
                    try {
                        if (blockContext.getJAXBContext() == ((JAXBBlockContext)context).getJAXBContext()) {
                            Object jaxb = block.getObject();
                            return new JAXBBlockImpl(jaxb, (JAXBBlockContext)context, qName, (BlockFactory)this);
                        }
                    }
                    catch (JAXBException e) {
                        if (!log.isDebugEnabled()) break block13;
                        log.debug("Falling back to using normal unmarshalling approach. " + e.getMessage());
                    }
                }
            }
        }
        return new JAXBBlockImpl(omElement, (JAXBBlockContext)context, qName, (BlockFactory)this);
    }

    @Override
    public Block createFrom(Object businessObject, Object context, QName qName) throws WebServiceException {
        if (context == null) {
            throw ExceptionFactory.makeWebServiceException(new JAXBException(Messages.getMessage("JAXBBlockFactoryErr1", "null")));
        }
        if (!(context instanceof JAXBBlockContext)) {
            throw ExceptionFactory.makeWebServiceException(new JAXBException(Messages.getMessage("JAXBBlockFactoryErr1", context.getClass().getName())));
        }
        if (qName == null) {
            qName = XMLRootElementUtil.getXmlRootElementQNameFromObject(businessObject);
        }
        try {
            return new JAXBBlockImpl(businessObject, (JAXBBlockContext)context, qName, (BlockFactory)this);
        }
        catch (JAXBException e) {
            throw ExceptionFactory.makeWebServiceException(e);
        }
    }

    @Override
    public boolean isElement() {
        return true;
    }
}

