/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.jaxws.message.impl;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.jws.soap.SOAPBinding;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.ws.WebServiceException;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.impl.OMContainerEx;
import org.apache.axiom.om.impl.llom.factory.OMLinkedListImplFactory;
import org.apache.axiom.soap.RolePlayer;
import org.apache.axiom.soap.SOAPBody;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.SOAPFactory;
import org.apache.axiom.soap.SOAPFault;
import org.apache.axiom.soap.SOAPFaultDetail;
import org.apache.axiom.soap.SOAPHeader;
import org.apache.axiom.soap.SOAPHeaderBlock;
import org.apache.axiom.soap.impl.llom.soap11.SOAP11Factory;
import org.apache.axiom.soap.impl.llom.soap12.SOAP12Factory;
import org.apache.axis2.jaxws.ExceptionFactory;
import org.apache.axis2.jaxws.i18n.Messages;
import org.apache.axis2.jaxws.message.Block;
import org.apache.axis2.jaxws.message.Message;
import org.apache.axis2.jaxws.message.Protocol;
import org.apache.axis2.jaxws.message.XMLFault;
import org.apache.axis2.jaxws.message.factory.BlockFactory;
import org.apache.axis2.jaxws.message.factory.OMBlockFactory;
import org.apache.axis2.jaxws.message.impl.XMLSpine;
import org.apache.axis2.jaxws.message.util.MessageUtils;
import org.apache.axis2.jaxws.message.util.Reader2Writer;
import org.apache.axis2.jaxws.message.util.XMLFaultUtils;
import org.apache.axis2.jaxws.registry.FactoryRegistry;
import org.apache.axis2.jaxws.utility.JavaUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class XMLSpineImpl
implements XMLSpine {
    private static Log log = LogFactory.getLog(XMLSpineImpl.class);
    private static OMBlockFactory obf = (OMBlockFactory)FactoryRegistry.getFactory(OMBlockFactory.class);
    private Protocol protocol = Protocol.unknown;
    private SOAPBinding.Style style = SOAPBinding.Style.DOCUMENT;
    private int indirection = 0;
    private SOAPEnvelope root = null;
    private SOAPFactory soapFactory = null;
    private boolean consumed = false;
    private Message parent = null;

    public XMLSpineImpl(Protocol protocol, SOAPBinding.Style style, int indirection, OMElement payload) {
        this.protocol = protocol;
        this.style = style;
        this.indirection = indirection;
        this.soapFactory = XMLSpineImpl._getFactory(protocol);
        this.root = XMLSpineImpl._createEmptyEnvelope(style, this.soapFactory);
        if (payload != null) {
            this.root.getBody().addChild(payload);
        }
    }

    public XMLSpineImpl(SOAPEnvelope envelope, SOAPBinding.Style style, int indirection, Protocol protocol) throws WebServiceException {
        this.style = style;
        this.indirection = indirection;
        this.protocol = protocol;
        this.init(envelope);
        if (protocol == null) {
            if (this.root.getNamespace().getNamespaceURI().equals("http://schemas.xmlsoap.org/soap/envelope/")) {
                this.protocol = Protocol.soap11;
            } else if (this.root.getNamespace().getNamespaceURI().equals("http://www.w3.org/2003/05/soap-envelope")) {
                this.protocol = Protocol.soap12;
            }
        }
    }

    private void init(SOAPEnvelope envelope) throws WebServiceException {
        SOAPBody body;
        this.root = envelope;
        this.soapFactory = MessageUtils.getSOAPFactory(this.root);
        SOAPHeader header = this.root.getHeader();
        if (header == null) {
            header = this.soapFactory.createSOAPHeader(this.root);
        }
        if ((body = this.root.getBody()) == null) {
            body = this.soapFactory.createSOAPBody(this.root);
        }
    }

    @Override
    public Protocol getProtocol() {
        return this.protocol;
    }

    public Message getParent() {
        return this.parent;
    }

    @Override
    public void setParent(Message p) {
        this.parent = p;
    }

    @Override
    public void outputTo(XMLStreamWriter writer, boolean consume) throws XMLStreamException, WebServiceException {
        Reader2Writer r2w = new Reader2Writer(this.getXMLStreamReader(consume));
        r2w.outputTo(writer);
    }

    @Override
    public XMLStreamReader getXMLStreamReader(boolean consume) throws WebServiceException {
        if (consume) {
            if (this.root.getBuilder() != null && !this.root.getBuilder().isCompleted()) {
                return this.root.getXMLStreamReaderWithoutCaching();
            }
            return this.root.getXMLStreamReader();
        }
        return this.root.getXMLStreamReader();
    }

    @Override
    public XMLFault getXMLFault() throws WebServiceException {
        if (!this.isFault()) {
            return null;
        }
        int numDetailBlocks = this.getNumDetailBlocks();
        Block[] blocks = null;
        if (numDetailBlocks > 0) {
            blocks = new Block[numDetailBlocks];
            SOAPFaultDetail detail = this.root.getBody().getFault().getDetail();
            for (int i = 0; i < numDetailBlocks; ++i) {
                OMElement om = XMLSpineImpl._getChildOMElement(detail, i);
                blocks[i] = this._getBlockFromOMElement(om, null, obf, false);
            }
        }
        XMLFault xmlFault = XMLFaultUtils.createXMLFault(this.root.getBody().getFault(), blocks);
        return xmlFault;
    }

    private int getNumDetailBlocks() throws WebServiceException {
        if (this.isFault()) {
            SOAPFault fault = this.root.getBody().getFault();
            return XMLSpineImpl._getNumChildElements(fault.getDetail());
        }
        return 0;
    }

    @Override
    public void setXMLFault(XMLFault xmlFault) throws WebServiceException {
        SOAPBody body = this.root.getBody();
        this.getNumDetailBlocks();
        this.getNumBodyBlocks();
        OMNode child = body.getFirstOMChild();
        while (child != null) {
            child.detach();
            child = body.getFirstOMChild();
        }
        SOAPFault soapFault = XMLFaultUtils.createSOAPFault(xmlFault, body, false);
    }

    @Override
    public boolean isConsumed() {
        return this.consumed;
    }

    @Override
    public OMElement getAsOMElement() throws WebServiceException {
        return this.root;
    }

    @Override
    public int getNumBodyBlocks() throws WebServiceException {
        return XMLSpineImpl._getNumChildElements(this._getBodyBlockParent());
    }

    @Override
    public List<QName> getBodyBlockQNames() throws WebServiceException {
        int numBlocks = this.getNumBodyBlocks();
        ArrayList<QName> qNames = new ArrayList<QName>();
        for (int i = 0; i < numBlocks; ++i) {
            OMElement omElement = XMLSpineImpl._getChildOMElement(this._getBodyBlockParent(), i);
            if (omElement == null) continue;
            qNames.add(omElement.getQName());
        }
        return qNames;
    }

    @Override
    public Block getBodyBlock(int index, Object context, BlockFactory blockFactory) throws WebServiceException {
        if (log.isDebugEnabled()) {
            log.debug("getBodyBlock: Get the " + index + "block using the block factory, " + blockFactory);
        }
        this.getNumBodyBlocks();
        OMElement omElement = XMLSpineImpl._getChildOMElement(this._getBodyBlockParent(), index);
        if (omElement == null) {
            if (log.isDebugEnabled()) {
                log.debug("getBodyBlock: The block was not found ");
            }
            return null;
        }
        if (log.isDebugEnabled()) {
            log.debug("getBodyBlock: Found omElement " + omElement.getQName());
        }
        return this._getBlockFromOMElement(omElement, context, blockFactory, false);
    }

    @Override
    public Block getBodyBlock(Object context, BlockFactory blockFactory) throws WebServiceException {
        OMElement omElement;
        if (log.isDebugEnabled()) {
            log.debug("getBodyBlock PERFORMANT: Get the block using the block factory, " + blockFactory);
        }
        if ((omElement = XMLSpineImpl._getChildOMElement(this._getBodyBlockParent(), 0)) == null) {
            if (log.isDebugEnabled()) {
                log.debug("getBodyBlock: The block was not found ");
            }
            return null;
        }
        if (log.isDebugEnabled()) {
            log.debug("getBodyBlock: Found omElement " + omElement.getQName());
        }
        return this._getBlockFromOMElement(omElement, context, blockFactory, true);
    }

    @Override
    public void setBodyBlock(int index, Block block) throws WebServiceException {
        this.getNumBodyBlocks();
        block.setParent(this.getParent());
        OMElement bElement = this._getBodyBlockParent();
        OMElement om = XMLSpineImpl._getChildOMElement(bElement, index);
        QName qName = block.getQName();
        OMNamespace ns = this.soapFactory.createOMNamespace(qName.getNamespaceURI(), qName.getPrefix());
        OMElement newOM = XMLSpineImpl._createOMElementFromBlock(qName.getLocalPart(), ns, block, this.soapFactory, false);
        if (om == null) {
            bElement.addChild(newOM);
        } else {
            om.insertSiblingBefore(newOM);
            om.detach();
        }
    }

    @Override
    public void setBodyBlock(Block block) throws WebServiceException {
        block5: {
            this.getNumBodyBlocks();
            block.setParent(this.getParent());
            OMElement bElement = this._getBodyBlockParent();
            Iterator it = bElement.getChildren();
            while (it.hasNext()) {
                it.next();
                it.remove();
            }
            if (block.isElementData()) {
                QName qName = block.getQName();
                OMNamespace ns = this.soapFactory.createOMNamespace(qName.getNamespaceURI(), qName.getPrefix());
                OMElement newOM = XMLSpineImpl._createOMElementFromBlock(qName.getLocalPart(), ns, block, this.soapFactory, false);
                bElement.addChild(newOM);
            } else {
                try {
                    QName qName = block.getQName();
                    OMNamespace ns = this.soapFactory.createOMNamespace(qName.getNamespaceURI(), qName.getPrefix());
                    OMElement newOM = XMLSpineImpl._createOMElementFromBlock(qName.getLocalPart(), ns, block, this.soapFactory, false);
                    bElement.addChild(newOM);
                }
                catch (Throwable t) {
                    if (!log.isDebugEnabled()) break block5;
                    log.debug("An attempt was made to pass a Source or String that does not have an xml element. Processing continues with an empty payload.");
                }
            }
        }
    }

    @Override
    public void removeBodyBlock(int index) throws WebServiceException {
        this.getNumBodyBlocks();
        OMElement om = XMLSpineImpl._getChildOMElement(this._getBodyBlockParent(), index);
        if (om != null) {
            om.detach();
        }
    }

    @Override
    public int getNumHeaderBlocks() throws WebServiceException {
        return XMLSpineImpl._getNumChildElements(this.root.getHeader());
    }

    @Override
    public Block getHeaderBlock(String namespace, String localPart, Object context, BlockFactory blockFactory) throws WebServiceException {
        OMElement om = XMLSpineImpl._getChildOMElement(this.root.getHeader(), namespace, localPart);
        if (om == null) {
            return null;
        }
        return this._getBlockFromOMElement(om, context, blockFactory, false);
    }

    @Override
    public List<Block> getHeaderBlocks(String namespace, String localPart, Object context, BlockFactory blockFactory, RolePlayer rolePlayer) throws WebServiceException {
        ArrayList<Block> blocks = new ArrayList<Block>();
        SOAPHeader header = this.root.getHeader();
        if (header == null) {
            return blocks;
        }
        Iterator it = null;
        it = rolePlayer == null ? header.getChildElements() : header.getHeadersToProcess(rolePlayer);
        while (it.hasNext()) {
            OMElement om = (OMElement)it.next();
            if (!om.getNamespace().getNamespaceURI().equals(namespace) || !om.getLocalName().equals(localPart)) continue;
            Block block = this._getBlockFromOMElement(om, context, blockFactory, false);
            blocks.add(block);
        }
        return blocks;
    }

    @Override
    public Set<QName> getHeaderQNames() {
        HashSet<QName> qnames = new HashSet<QName>();
        SOAPHeader header = this.root.getHeader();
        if (header != null) {
            Iterator it = header.getChildElements();
            while (it != null && it.hasNext()) {
                Object node = it.next();
                if (!(node instanceof OMElement)) continue;
                qnames.add(((OMElement)node).getQName());
            }
        }
        return qnames;
    }

    @Override
    public void setHeaderBlock(String namespace, String localPart, Block block) throws WebServiceException {
        block.setParent(this.getParent());
        OMNamespace ns = this.soapFactory.createOMNamespace(namespace, null);
        OMElement newOM = XMLSpineImpl._createOMElementFromBlock(localPart, ns, block, this.soapFactory, true);
        OMElement om = XMLSpineImpl._getChildOMElement(this.root.getHeader(), namespace, localPart);
        if (om == null) {
            if (this.root.getHeader() == null) {
                this.soapFactory.createSOAPHeader(this.root);
            }
            this.root.getHeader().addChild(newOM);
        } else {
            om.insertSiblingBefore(newOM);
            om.detach();
        }
    }

    @Override
    public void appendHeaderBlock(String namespace, String localPart, Block block) throws WebServiceException {
        block.setParent(this.getParent());
        OMNamespace ns = this.soapFactory.createOMNamespace(namespace, null);
        OMElement newOM = XMLSpineImpl._createOMElementFromBlock(localPart, ns, block, this.soapFactory, true);
        if (this.root.getHeader() == null) {
            this.soapFactory.createSOAPHeader(this.root);
        }
        this.root.getHeader().addChild(newOM);
    }

    @Override
    public void removeHeaderBlock(String namespace, String localPart) throws WebServiceException {
        OMElement om = XMLSpineImpl._getChildOMElement(this.root.getHeader(), namespace, localPart);
        while (om != null) {
            om.detach();
            om = XMLSpineImpl._getChildOMElement(this.root.getHeader(), namespace, localPart);
        }
    }

    @Override
    public String traceString(String indent) {
        return null;
    }

    public String getXMLPartContentType() {
        return "SPINE";
    }

    @Override
    public boolean isFault() throws WebServiceException {
        return XMLFaultUtils.isFault(this.root);
    }

    @Override
    public SOAPBinding.Style getStyle() {
        return this.style;
    }

    @Override
    public QName getOperationElement() {
        OMElement omElement = this._getBodyBlockParent();
        if (omElement instanceof SOAPBody) {
            return null;
        }
        return omElement.getQName();
    }

    @Override
    public void setOperationElement(QName operationQName) {
        OMElement opElement = this._getBodyBlockParent();
        if (!(opElement instanceof SOAPBody)) {
            OMNamespace ns = this.soapFactory.createOMNamespace(operationQName.getNamespaceURI(), operationQName.getPrefix());
            opElement.setLocalName(operationQName.getLocalPart());
            opElement.setNamespace(ns);
            opElement.declareNamespace("http://www.w3.org/2001/XMLSchema-instance", "xsi");
        }
    }

    private Block _getBlockFromOMElement(OMElement om, Object context, BlockFactory blockFactory, boolean setComplete) throws WebServiceException {
        try {
            QName qName = om.getQName();
            OMNamespace ns = om.getNamespace();
            String role = null;
            if (om instanceof SOAPHeaderBlock) {
                role = ((SOAPHeaderBlock)om).getRole();
            }
            Block block = blockFactory.createFrom(om, context, qName);
            block.setParent(this.getParent());
            if (om instanceof SOAPHeaderBlock) {
                block.setProperty("org.apache.axiom.soap.SOAPHeader.ROLE", role);
            }
            block.getBusinessObject(false);
            OMElement newOM = XMLSpineImpl._createOMElementFromBlock(qName.getLocalPart(), ns, block, this.soapFactory, om.getParent() instanceof SOAPHeader);
            om.insertSiblingBefore(newOM);
            if (setComplete) {
                block12: {
                    OMElement root = om;
                    while (root.getParent() instanceof OMElement) {
                        root = (OMElement)root.getParent();
                    }
                    try {
                        if (!root.isComplete() && root.getBuilder() != null && !root.getBuilder().isCompleted()) {
                            while (root.getBuilder().next() != 8) {
                            }
                        }
                    }
                    catch (Exception e) {
                        if (!log.isDebugEnabled()) break block12;
                        log.debug("Builder next error:" + e.getMessage());
                        log.trace(JavaUtils.stackToString(e));
                    }
                }
                OMContainer o = om;
                while (o != null && o instanceof OMContainerEx) {
                    ((OMContainerEx)o).setComplete(true);
                    if (o instanceof OMNode && ((OMNode)((Object)o)).getParent() instanceof OMContainer) {
                        o = ((OMNode)((Object)o)).getParent();
                        continue;
                    }
                    o = null;
                }
            }
            om.detach();
            return block;
        }
        catch (XMLStreamException xse) {
            throw ExceptionFactory.makeWebServiceException(xse);
        }
    }

    private static OMElement _createOMElementFromBlock(String localName, OMNamespace ns, Block b, SOAPFactory soapFactory, boolean isHeaderBlock) {
        if (isHeaderBlock) {
            return soapFactory.createSOAPHeaderBlock(localName, ns, b);
        }
        return soapFactory.createOMElement(b, localName, ns);
    }

    private OMElement _getBodyBlockParent() {
        SOAPBody body = this.root.getBody();
        if (!body.hasFault() && this.indirection == 1) {
            OMElement op = body.getFirstElement();
            if (op == null) {
                OMNamespace ns = this.soapFactory.createOMNamespace("", "");
                op = this.soapFactory.createOMElement("PLACEHOLDER_OPERATION", ns, body);
            }
            return op;
        }
        return body;
    }

    private static SOAPFactory _getFactory(Protocol protocol) {
        OMLinkedListImplFactory soapFactory;
        if (protocol == Protocol.soap11) {
            soapFactory = new SOAP11Factory();
        } else if (protocol == Protocol.soap12) {
            soapFactory = new SOAP12Factory();
        } else if (protocol == Protocol.rest) {
            soapFactory = new SOAP11Factory();
        } else {
            throw ExceptionFactory.makeWebServiceException(Messages.getMessage("RESTIsNotSupported"), null);
        }
        return soapFactory;
    }

    private static SOAPEnvelope _createEmptyEnvelope(SOAPBinding.Style style, SOAPFactory factory) {
        SOAPEnvelope env = factory.createSOAPEnvelope();
        factory.createSOAPBody(env);
        factory.createSOAPHeader(env);
        if (style == SOAPBinding.Style.RPC) {
            OMNamespace ns = factory.createOMNamespace("", "");
            factory.createOMElement("PLACEHOLDER_OPERATION", ns, env.getBody());
        }
        return env;
    }

    private static int _getNumChildElements(OMElement om) throws WebServiceException {
        if (om == null) {
            return 0;
        }
        int num = 0;
        Iterator iterator = om.getChildElements();
        while (iterator.hasNext()) {
            ++num;
            iterator.next();
        }
        return num;
    }

    private static OMElement _getChildOMElement(OMElement om, int index) {
        if (om == null) {
            return null;
        }
        int i = 0;
        for (OMNode child = om.getFirstOMChild(); child != null; child = child.getNextOMSibling()) {
            if (!(child instanceof OMElement)) continue;
            if (i == index) {
                return (OMElement)child;
            }
            ++i;
        }
        return null;
    }

    private static OMElement _getChildOMElement(OMElement om, String namespace, String localPart) {
        if (om == null) {
            return null;
        }
        QName qName = new QName(namespace, localPart);
        Iterator it = om.getChildrenWithName(qName);
        if (it != null && it.hasNext()) {
            return (OMElement)it.next();
        }
        return null;
    }
}

