/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.json;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.util.Iterator;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.util.AXIOMUtil;
import org.apache.axiom.soap.SOAPBody;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.SOAPFactory;
import org.apache.axis2.AxisFault;
import org.apache.axis2.builder.Builder;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.json.JSONStreamBuilder;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.codehaus.jettison.mapped.MappedXMLStreamReader;

public class JSONBuilder
implements Builder {
    private static final QName JsonRoot = new QName("http://org.apache.synapse/json/", "xmlPayload", "sjnr");
    private static final int FiveKB = 5120;
    private static final String JSON_STREAM = "JSON_STREAM";
    private static final String JSON_STRING = "JSON_STRING";

    @Override
    public OMElement processDocument(InputStream inputStream, String contentType, MessageContext messageContext) throws AxisFault {
        OMElement payload;
        SOAPEnvelope envelope = null;
        if (messageContext.getProperty(JSON_STREAM) == null && messageContext.getProperty(JSON_STRING) == null) {
            JSONStreamBuilder builder = new JSONStreamBuilder();
            envelope = (SOAPEnvelope)builder.processDocument(inputStream, contentType, messageContext);
        }
        StringBuilder stringBuilder = new StringBuilder(5120);
        this.insertRoot(stringBuilder);
        if (messageContext.getProperty(JSON_STREAM) != null) {
            BufferedReader buf = new BufferedReader(new InputStreamReader((InputStream)messageContext.getProperty(JSON_STREAM)));
            try {
                String line;
                while ((line = buf.readLine()) != null) {
                    stringBuilder.append(line);
                }
            }
            catch (IOException e) {
                throw AxisFault.makeFault(e);
            }
        } else if (messageContext.getProperty(JSON_STRING) != null) {
            stringBuilder.append((String)messageContext.getProperty(JSON_STRING));
        } else {
            throw new RuntimeException("No JSON data found in the request.");
        }
        this.insertEnd(stringBuilder);
        try {
            payload = this.parse(stringBuilder);
        }
        catch (Exception e) {
            throw new AxisFault("Failed to convert JSON to XML payload. " + e.getMessage());
        }
        if (messageContext.getProperty(JSON_STRING) == null) {
            // empty if block
        }
        if (envelope == null) {
            SOAPFactory factory = OMAbstractFactory.getSOAP12Factory();
            envelope = factory.getDefaultEnvelope();
        }
        boolean preserveRoot = messageContext.getProperty("PRESERVE_JSON_ROOT") != null;
        this.makeSoapBody(envelope.getBody(), payload, !preserveRoot ? false : (Boolean)messageContext.getProperty("PRESERVE_JSON_ROOT"));
        return envelope;
    }

    private void insertRoot(StringBuilder sb) {
        sb.append("{ \"xmlPayload\" : ");
    }

    private void insertEnd(StringBuilder sb) {
        sb.append("}");
    }

    private OMElement parse(StringBuilder sb) throws JSONException, XMLStreamException, IOException {
        StringWriter sw = new StringWriter(5120);
        JSONObject jsonObject = new JSONObject(sb.toString());
        MappedXMLStreamReader reader = new MappedXMLStreamReader(jsonObject);
        XMLOutputFactory factory = XMLOutputFactory.newInstance();
        XMLStreamWriter xmlStreamWriter = factory.createXMLStreamWriter(sw);
        xmlStreamWriter.writeStartDocument();
        block13: while (reader.hasNext()) {
            int x = reader.next();
            switch (x) {
                case 1: {
                    xmlStreamWriter.writeStartElement(reader.getPrefix(), reader.getLocalName(), reader.getNamespaceURI());
                    int namespaceCount = reader.getNamespaceCount();
                    for (int i = namespaceCount - 1; i >= 0; --i) {
                        xmlStreamWriter.writeNamespace(reader.getNamespacePrefix(i), reader.getNamespaceURI(i));
                    }
                    int attributeCount = reader.getAttributeCount();
                    for (int i = 0; i < attributeCount; ++i) {
                        xmlStreamWriter.writeAttribute(reader.getAttributePrefix(i), reader.getAttributeNamespace(i), reader.getAttributeLocalName(i), reader.getAttributeValue(i));
                    }
                    continue block13;
                }
                case 7: {
                    break;
                }
                case 4: {
                    xmlStreamWriter.writeCharacters(reader.getText());
                    break;
                }
                case 12: {
                    xmlStreamWriter.writeCData(reader.getText());
                    break;
                }
                case 2: {
                    xmlStreamWriter.writeEndElement();
                    break;
                }
                case 8: {
                    xmlStreamWriter.writeEndDocument();
                    break;
                }
                case 6: {
                    break;
                }
                case 5: {
                    xmlStreamWriter.writeComment(reader.getText());
                    break;
                }
                case 11: {
                    xmlStreamWriter.writeDTD(reader.getText());
                    break;
                }
                case 3: {
                    xmlStreamWriter.writeProcessingInstruction(reader.getPITarget(), reader.getPIData());
                    break;
                }
                case 9: {
                    xmlStreamWriter.writeEntityRef(reader.getLocalName());
                    break;
                }
                default: {
                    throw new RuntimeException("Error in converting JSON to XML");
                }
            }
        }
        xmlStreamWriter.writeEndDocument();
        xmlStreamWriter.flush();
        xmlStreamWriter.close();
        OMElement element = AXIOMUtil.stringToOM(sw.toString());
        OMNamespace ns = OMAbstractFactory.getOMFactory().createOMNamespace(JsonRoot.getNamespaceURI(), JsonRoot.getPrefix());
        element.setNamespace(ns);
        return element;
    }

    private void makeSoapBody(SOAPBody body, OMElement payload, boolean preserveRoot) {
        if (preserveRoot) {
            body.addChild(payload);
        } else {
            Iterator children = payload.getChildren();
            while (children.hasNext()) {
                Object e = children.next();
                if (!(e instanceof OMElement)) continue;
                children.remove();
                body.addChild((OMNode)e);
            }
        }
    }
}

